<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_auth_list = new po_s_auth_list();

// Run the page
$po_s_auth_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_auth_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_s_auth->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_s_authlist = currentForm = new ew.Form("fpo_s_authlist", "list");
fpo_s_authlist.formKeyCountName = '<?php echo $po_s_auth_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_s_authlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_authlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_authlist.lists["x_company_id"] = <?php echo $po_s_auth_list->company_id->Lookup->toClientList() ?>;
fpo_s_authlist.lists["x_company_id"].options = <?php echo JsonEncode($po_s_auth_list->company_id->lookupOptions()) ?>;
fpo_s_authlist.lists["x_partner_id"] = <?php echo $po_s_auth_list->partner_id->Lookup->toClientList() ?>;
fpo_s_authlist.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_auth_list->partner_id->lookupOptions()) ?>;
fpo_s_authlist.lists["x_a_operator"] = <?php echo $po_s_auth_list->a_operator->Lookup->toClientList() ?>;
fpo_s_authlist.lists["x_a_operator"].options = <?php echo JsonEncode($po_s_auth_list->a_operator->lookupOptions()) ?>;
fpo_s_authlist.autoSuggests["x_a_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_authlist.lists["x_e_mail"] = <?php echo $po_s_auth_list->e_mail->Lookup->toClientList() ?>;
fpo_s_authlist.lists["x_e_mail"].options = <?php echo JsonEncode($po_s_auth_list->e_mail->options(FALSE, TRUE)) ?>;
fpo_s_authlist.lists["x_app_operator"] = <?php echo $po_s_auth_list->app_operator->Lookup->toClientList() ?>;
fpo_s_authlist.lists["x_app_operator"].options = <?php echo JsonEncode($po_s_auth_list->app_operator->lookupOptions()) ?>;
fpo_s_authlist.autoSuggests["x_app_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fpo_s_authlistsrch = currentSearchForm = new ew.Form("fpo_s_authlistsrch");

// Validate function for search
fpo_s_authlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_s_authlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_authlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_authlistsrch.lists["x_company_id"] = <?php echo $po_s_auth_list->company_id->Lookup->toClientList() ?>;
fpo_s_authlistsrch.lists["x_company_id"].options = <?php echo JsonEncode($po_s_auth_list->company_id->lookupOptions()) ?>;
fpo_s_authlistsrch.lists["x_partner_id"] = <?php echo $po_s_auth_list->partner_id->Lookup->toClientList() ?>;
fpo_s_authlistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_auth_list->partner_id->lookupOptions()) ?>;

// Filters
fpo_s_authlistsrch.filterList = <?php echo $po_s_auth_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_s_authlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_s_auth->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_s_auth_list->TotalRecs > 0 && $po_s_auth_list->ExportOptions->visible()) { ?>
<?php $po_s_auth_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_auth_list->ImportOptions->visible()) { ?>
<?php $po_s_auth_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_auth_list->SearchOptions->visible()) { ?>
<?php $po_s_auth_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_auth_list->FilterOptions->visible()) { ?>
<?php $po_s_auth_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_s_auth_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_s_auth->isExport() && !$po_s_auth->CurrentAction) { ?>
<form name="fpo_s_authlistsrch" id="fpo_s_authlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_s_auth_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_s_authlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_s_auth">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_s_auth_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_s_auth->RowType = ROWTYPE_SEARCH;

// Render row
$po_s_auth->resetAttributes();
$po_s_auth_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_s_auth->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $po_s_auth->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_s_auth" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->po->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->po->EditValue ?>"<?php echo $po_s_auth->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($po_s_auth->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label for="x_company_id" class="ew-search-caption ew-label"><?php echo $po_s_auth->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_auth" data-field="x_company_id" data-value-separator="<?php echo $po_s_auth->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_s_auth->company_id->editAttributes() ?>>
		<?php echo $po_s_auth->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_s_auth->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_s_auth->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label for="x_partner_id" class="ew-search-caption ew-label"><?php echo $po_s_auth->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_auth" data-field="x_partner_id" data-value-separator="<?php echo $po_s_auth->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $po_s_auth->partner_id->editAttributes() ?>>
		<?php echo $po_s_auth->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $po_s_auth->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_s_auth_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_s_auth_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_s_auth_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_s_auth_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_s_auth_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_s_auth_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_s_auth_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_s_auth_list->showPageHeader(); ?>
<?php
$po_s_auth_list->showMessage();
?>
<?php if ($po_s_auth_list->TotalRecs > 0 || $po_s_auth->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_s_auth_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_s_auth">
<?php if (!$po_s_auth->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_s_auth->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_auth_list->Pager)) $po_s_auth_list->Pager = new PrevNextPager($po_s_auth_list->StartRec, $po_s_auth_list->DisplayRecs, $po_s_auth_list->TotalRecs, $po_s_auth_list->AutoHidePager) ?>
<?php if ($po_s_auth_list->Pager->RecordCount > 0 && $po_s_auth_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_auth_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_auth_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_auth_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_auth_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_auth_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_auth_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_auth_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_auth_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_auth_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_auth_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_auth_list->TotalRecs > 0 && (!$po_s_auth_list->AutoHidePageSizeSelector || $po_s_auth_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s_auth">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_auth_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_auth_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_auth_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_auth_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_auth_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s_auth->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_auth_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_s_authlist" id="fpo_s_authlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_auth_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_auth_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s_auth">
<div id="gmp_po_s_auth" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_s_auth_list->TotalRecs > 0 || $po_s_auth->isGridEdit()) { ?>
<table id="tbl_po_s_authlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_s_auth_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_s_auth_list->renderListOptions();

// Render list options (header, left)
$po_s_auth_list->ListOptions->render("header", "left");
?>
<?php if ($po_s_auth->id->Visible) { // id ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_s_auth->id->headerCellClass() ?>"><div id="elh_po_s_auth_id" class="po_s_auth_id"><div class="ew-table-header-caption"><?php echo $po_s_auth->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_s_auth->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->id) ?>',2);"><div id="elh_po_s_auth_id" class="po_s_auth_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->po->Visible) { // po ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_s_auth->po->headerCellClass() ?>"><div id="elh_po_s_auth_po" class="po_s_auth_po"><div class="ew-table-header-caption"><?php echo $po_s_auth->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_s_auth->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->po) ?>',2);"><div id="elh_po_s_auth_po" class="po_s_auth_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->company_id->Visible) { // company_id ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_s_auth->company_id->headerCellClass() ?>"><div id="elh_po_s_auth_company_id" class="po_s_auth_company_id"><div class="ew-table-header-caption"><?php echo $po_s_auth->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_s_auth->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->company_id) ?>',2);"><div id="elh_po_s_auth_company_id" class="po_s_auth_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->partner_id->Visible) { // partner_id ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_s_auth->partner_id->headerCellClass() ?>"><div id="elh_po_s_auth_partner_id" class="po_s_auth_partner_id"><div class="ew-table-header-caption"><?php echo $po_s_auth->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_s_auth->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->partner_id) ?>',2);"><div id="elh_po_s_auth_partner_id" class="po_s_auth_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->quantity->Visible) { // quantity ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_s_auth->quantity->headerCellClass() ?>"><div id="elh_po_s_auth_quantity" class="po_s_auth_quantity"><div class="ew-table-header-caption"><?php echo $po_s_auth->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_s_auth->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->quantity) ?>',2);"><div id="elh_po_s_auth_quantity" class="po_s_auth_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->sqm->Visible) { // sqm ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_s_auth->sqm->headerCellClass() ?>"><div id="elh_po_s_auth_sqm" class="po_s_auth_sqm"><div class="ew-table-header-caption"><?php echo $po_s_auth->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_s_auth->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->sqm) ?>',2);"><div id="elh_po_s_auth_sqm" class="po_s_auth_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->cbm->Visible) { // cbm ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $po_s_auth->cbm->headerCellClass() ?>"><div id="elh_po_s_auth_cbm" class="po_s_auth_cbm"><div class="ew-table-header-caption"><?php echo $po_s_auth->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $po_s_auth->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->cbm) ?>',2);"><div id="elh_po_s_auth_cbm" class="po_s_auth_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->amount->Visible) { // amount ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $po_s_auth->amount->headerCellClass() ?>"><div id="elh_po_s_auth_amount" class="po_s_auth_amount"><div class="ew-table-header-caption"><?php echo $po_s_auth->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $po_s_auth->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->amount) ?>',2);"><div id="elh_po_s_auth_amount" class="po_s_auth_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->a_operator->Visible) { // a_operator ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po_s_auth->a_operator->headerCellClass() ?>"><div id="elh_po_s_auth_a_operator" class="po_s_auth_a_operator"><div class="ew-table-header-caption"><?php echo $po_s_auth->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po_s_auth->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->a_operator) ?>',2);"><div id="elh_po_s_auth_a_operator" class="po_s_auth_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->a_operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->a_datetime->Visible) { // a_datetime ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $po_s_auth->a_datetime->headerCellClass() ?>"><div id="elh_po_s_auth_a_datetime" class="po_s_auth_a_datetime"><div class="ew-table-header-caption"><?php echo $po_s_auth->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $po_s_auth->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->a_datetime) ?>',2);"><div id="elh_po_s_auth_a_datetime" class="po_s_auth_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->a_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->e_mail->Visible) { // e_mail ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->e_mail) == "") { ?>
		<th data-name="e_mail" class="<?php echo $po_s_auth->e_mail->headerCellClass() ?>"><div id="elh_po_s_auth_e_mail" class="po_s_auth_e_mail"><div class="ew-table-header-caption"><?php echo $po_s_auth->e_mail->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_mail" class="<?php echo $po_s_auth->e_mail->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->e_mail) ?>',2);"><div id="elh_po_s_auth_e_mail" class="po_s_auth_e_mail">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->e_mail->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->e_mail->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->e_mail->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->app_operator->Visible) { // app_operator ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->app_operator) == "") { ?>
		<th data-name="app_operator" class="<?php echo $po_s_auth->app_operator->headerCellClass() ?>"><div id="elh_po_s_auth_app_operator" class="po_s_auth_app_operator"><div class="ew-table-header-caption"><?php echo $po_s_auth->app_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_operator" class="<?php echo $po_s_auth->app_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->app_operator) ?>',2);"><div id="elh_po_s_auth_app_operator" class="po_s_auth_app_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->app_operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->app_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->app_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_auth->app_datetime->Visible) { // app_datetime ?>
	<?php if ($po_s_auth->sortUrl($po_s_auth->app_datetime) == "") { ?>
		<th data-name="app_datetime" class="<?php echo $po_s_auth->app_datetime->headerCellClass() ?>"><div id="elh_po_s_auth_app_datetime" class="po_s_auth_app_datetime"><div class="ew-table-header-caption"><?php echo $po_s_auth->app_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_datetime" class="<?php echo $po_s_auth->app_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_auth->SortUrl($po_s_auth->app_datetime) ?>',2);"><div id="elh_po_s_auth_app_datetime" class="po_s_auth_app_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_auth->app_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_auth->app_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_auth->app_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_s_auth_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_s_auth->ExportAll && $po_s_auth->isExport()) {
	$po_s_auth_list->StopRec = $po_s_auth_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_s_auth_list->TotalRecs > $po_s_auth_list->StartRec + $po_s_auth_list->DisplayRecs - 1)
		$po_s_auth_list->StopRec = $po_s_auth_list->StartRec + $po_s_auth_list->DisplayRecs - 1;
	else
		$po_s_auth_list->StopRec = $po_s_auth_list->TotalRecs;
}
$po_s_auth_list->RecCnt = $po_s_auth_list->StartRec - 1;
if ($po_s_auth_list->Recordset && !$po_s_auth_list->Recordset->EOF) {
	$po_s_auth_list->Recordset->moveFirst();
	$selectLimit = $po_s_auth_list->UseSelectLimit;
	if (!$selectLimit && $po_s_auth_list->StartRec > 1)
		$po_s_auth_list->Recordset->move($po_s_auth_list->StartRec - 1);
} elseif (!$po_s_auth->AllowAddDeleteRow && $po_s_auth_list->StopRec == 0) {
	$po_s_auth_list->StopRec = $po_s_auth->GridAddRowCount;
}

// Initialize aggregate
$po_s_auth->RowType = ROWTYPE_AGGREGATEINIT;
$po_s_auth->resetAttributes();
$po_s_auth_list->renderRow();
while ($po_s_auth_list->RecCnt < $po_s_auth_list->StopRec) {
	$po_s_auth_list->RecCnt++;
	if ($po_s_auth_list->RecCnt >= $po_s_auth_list->StartRec) {
		$po_s_auth_list->RowCnt++;

		// Set up key count
		$po_s_auth_list->KeyCount = $po_s_auth_list->RowIndex;

		// Init row class and style
		$po_s_auth->resetAttributes();
		$po_s_auth->CssClass = "";
		if ($po_s_auth->isGridAdd()) {
		} else {
			$po_s_auth_list->loadRowValues($po_s_auth_list->Recordset); // Load row values
		}
		$po_s_auth->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_s_auth->RowAttrs = array_merge($po_s_auth->RowAttrs, array('data-rowindex'=>$po_s_auth_list->RowCnt, 'id'=>'r' . $po_s_auth_list->RowCnt . '_po_s_auth', 'data-rowtype'=>$po_s_auth->RowType));

		// Render row
		$po_s_auth_list->renderRow();

		// Render list options
		$po_s_auth_list->renderListOptions();
?>
	<tr<?php echo $po_s_auth->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_s_auth_list->ListOptions->render("body", "left", $po_s_auth_list->RowCnt);
?>
	<?php if ($po_s_auth->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_s_auth->id->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_id" class="po_s_auth_id">
<span<?php echo $po_s_auth->id->viewAttributes() ?>>
<?php echo $po_s_auth->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_s_auth->po->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_po" class="po_s_auth_po">
<span<?php echo $po_s_auth->po->viewAttributes() ?>>
<?php echo $po_s_auth->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_s_auth->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_company_id" class="po_s_auth_company_id">
<span<?php echo $po_s_auth->company_id->viewAttributes() ?>>
<?php echo $po_s_auth->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_s_auth->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_partner_id" class="po_s_auth_partner_id">
<span<?php echo $po_s_auth->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_s_auth->partner_id->getViewValue())) && $po_s_auth->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $po_s_auth->partner_id->linkAttributes() ?>><?php echo $po_s_auth->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_s_auth->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_s_auth->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_quantity" class="po_s_auth_quantity">
<span<?php echo $po_s_auth->quantity->viewAttributes() ?>>
<?php echo $po_s_auth->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_s_auth->sqm->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_sqm" class="po_s_auth_sqm">
<span<?php echo $po_s_auth->sqm->viewAttributes() ?>>
<?php echo $po_s_auth->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $po_s_auth->cbm->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_cbm" class="po_s_auth_cbm">
<span<?php echo $po_s_auth->cbm->viewAttributes() ?>>
<?php echo $po_s_auth->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $po_s_auth->amount->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_amount" class="po_s_auth_amount">
<span<?php echo $po_s_auth->amount->viewAttributes() ?>>
<?php echo $po_s_auth->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po_s_auth->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_a_operator" class="po_s_auth_a_operator">
<span<?php echo $po_s_auth->a_operator->viewAttributes() ?>>
<?php echo $po_s_auth->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $po_s_auth->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_a_datetime" class="po_s_auth_a_datetime">
<span<?php echo $po_s_auth->a_datetime->viewAttributes() ?>>
<?php echo $po_s_auth->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->e_mail->Visible) { // e_mail ?>
		<td data-name="e_mail"<?php echo $po_s_auth->e_mail->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_e_mail" class="po_s_auth_e_mail">
<span<?php echo $po_s_auth->e_mail->viewAttributes() ?>>
<?php echo $po_s_auth->e_mail->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->app_operator->Visible) { // app_operator ?>
		<td data-name="app_operator"<?php echo $po_s_auth->app_operator->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_app_operator" class="po_s_auth_app_operator">
<span<?php echo $po_s_auth->app_operator->viewAttributes() ?>>
<?php echo $po_s_auth->app_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_auth->app_datetime->Visible) { // app_datetime ?>
		<td data-name="app_datetime"<?php echo $po_s_auth->app_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_s_auth_list->RowCnt ?>_po_s_auth_app_datetime" class="po_s_auth_app_datetime">
<span<?php echo $po_s_auth->app_datetime->viewAttributes() ?>>
<?php echo $po_s_auth->app_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_s_auth_list->ListOptions->render("body", "right", $po_s_auth_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_s_auth->isGridAdd())
		$po_s_auth_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$po_s_auth->RowType = ROWTYPE_AGGREGATE;
$po_s_auth->resetAttributes();
$po_s_auth_list->renderRow();
?>
<?php if ($po_s_auth_list->TotalRecs > 0 && !$po_s_auth->isGridAdd() && !$po_s_auth->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$po_s_auth_list->renderListOptions();

// Render list options (footer, left)
$po_s_auth_list->ListOptions->render("footer", "left");
?>
	<?php if ($po_s_auth->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $po_s_auth->id->footerCellClass() ?>"><span id="elf_po_s_auth_id" class="po_s_auth_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $po_s_auth->po->footerCellClass() ?>"><span id="elf_po_s_auth_po" class="po_s_auth_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $po_s_auth->company_id->footerCellClass() ?>"><span id="elf_po_s_auth_company_id" class="po_s_auth_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $po_s_auth->partner_id->footerCellClass() ?>"><span id="elf_po_s_auth_partner_id" class="po_s_auth_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $po_s_auth->quantity->footerCellClass() ?>"><span id="elf_po_s_auth_quantity" class="po_s_auth_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_auth->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $po_s_auth->sqm->footerCellClass() ?>"><span id="elf_po_s_auth_sqm" class="po_s_auth_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_auth->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->cbm->Visible) { // cbm ?>
		<td data-name="cbm" class="<?php echo $po_s_auth->cbm->footerCellClass() ?>"><span id="elf_po_s_auth_cbm" class="po_s_auth_cbm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_auth->cbm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $po_s_auth->amount->footerCellClass() ?>"><span id="elf_po_s_auth_amount" class="po_s_auth_amount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator" class="<?php echo $po_s_auth->a_operator->footerCellClass() ?>"><span id="elf_po_s_auth_a_operator" class="po_s_auth_a_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime" class="<?php echo $po_s_auth->a_datetime->footerCellClass() ?>"><span id="elf_po_s_auth_a_datetime" class="po_s_auth_a_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->e_mail->Visible) { // e_mail ?>
		<td data-name="e_mail" class="<?php echo $po_s_auth->e_mail->footerCellClass() ?>"><span id="elf_po_s_auth_e_mail" class="po_s_auth_e_mail">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->app_operator->Visible) { // app_operator ?>
		<td data-name="app_operator" class="<?php echo $po_s_auth->app_operator->footerCellClass() ?>"><span id="elf_po_s_auth_app_operator" class="po_s_auth_app_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_auth->app_datetime->Visible) { // app_datetime ?>
		<td data-name="app_datetime" class="<?php echo $po_s_auth->app_datetime->footerCellClass() ?>"><span id="elf_po_s_auth_app_datetime" class="po_s_auth_app_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$po_s_auth_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_s_auth->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_s_auth_list->Recordset)
	$po_s_auth_list->Recordset->Close();
?>
<?php if (!$po_s_auth->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_s_auth->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_auth_list->Pager)) $po_s_auth_list->Pager = new PrevNextPager($po_s_auth_list->StartRec, $po_s_auth_list->DisplayRecs, $po_s_auth_list->TotalRecs, $po_s_auth_list->AutoHidePager) ?>
<?php if ($po_s_auth_list->Pager->RecordCount > 0 && $po_s_auth_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_auth_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_auth_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_auth_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_auth_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_auth_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_auth_list->pageUrl() ?>start=<?php echo $po_s_auth_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_auth_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_auth_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_auth_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_auth_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_auth_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_auth_list->TotalRecs > 0 && (!$po_s_auth_list->AutoHidePageSizeSelector || $po_s_auth_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s_auth">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_auth_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_auth_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_auth_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_auth_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_auth_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s_auth->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_auth_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_s_auth_list->TotalRecs == 0 && !$po_s_auth->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_s_auth_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_s_auth_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_s_auth->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_s_auth->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_s_auth", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_s_auth_list->terminate();
?>