<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_auth_search = new po_s_auth_search();

// Run the page
$po_s_auth_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_auth_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_s_auth_search->IsModal) { ?>
var fpo_s_authsearch = currentAdvancedSearchForm = new ew.Form("fpo_s_authsearch", "search");
<?php } else { ?>
var fpo_s_authsearch = currentForm = new ew.Form("fpo_s_authsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_s_authsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_authsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_authsearch.lists["x_company_id"] = <?php echo $po_s_auth_search->company_id->Lookup->toClientList() ?>;
fpo_s_authsearch.lists["x_company_id"].options = <?php echo JsonEncode($po_s_auth_search->company_id->lookupOptions()) ?>;
fpo_s_authsearch.lists["x_partner_id"] = <?php echo $po_s_auth_search->partner_id->Lookup->toClientList() ?>;
fpo_s_authsearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_auth_search->partner_id->lookupOptions()) ?>;
fpo_s_authsearch.lists["x_a_operator"] = <?php echo $po_s_auth_search->a_operator->Lookup->toClientList() ?>;
fpo_s_authsearch.lists["x_a_operator"].options = <?php echo JsonEncode($po_s_auth_search->a_operator->lookupOptions()) ?>;
fpo_s_authsearch.autoSuggests["x_a_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_authsearch.lists["x_e_mail"] = <?php echo $po_s_auth_search->e_mail->Lookup->toClientList() ?>;
fpo_s_authsearch.lists["x_e_mail"].options = <?php echo JsonEncode($po_s_auth_search->e_mail->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpo_s_authsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->cbm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_auth->a_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_s_auth_search->showPageHeader(); ?>
<?php
$po_s_auth_search->showMessage();
?>
<form name="fpo_s_authsearch" id="fpo_s_authsearch" class="<?php echo $po_s_auth_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_auth_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_auth_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s_auth">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_s_auth_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s_auth->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_id"><?php echo $po_s_auth->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->id->cellAttributes() ?>>
			<span id="el_po_s_auth_id">
<input type="text" data-table="po_s_auth" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_s_auth->id->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->id->EditValue ?>"<?php echo $po_s_auth->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_po"><?php echo $po_s_auth->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->po->cellAttributes() ?>>
			<span id="el_po_s_auth_po">
<input type="text" data-table="po_s_auth" data-field="x_po" data-page="1" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->po->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->po->EditValue ?>"<?php echo $po_s_auth->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_company_id"><?php echo $po_s_auth->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->company_id->cellAttributes() ?>>
			<span id="el_po_s_auth_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_auth" data-field="x_company_id" data-page="1" data-value-separator="<?php echo $po_s_auth->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_s_auth->company_id->editAttributes() ?>>
		<?php echo $po_s_auth->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_s_auth->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label for="x_partner_id" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_partner_id"><?php echo $po_s_auth->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->partner_id->cellAttributes() ?>>
			<span id="el_po_s_auth_partner_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_auth" data-field="x_partner_id" data-page="1" data-value-separator="<?php echo $po_s_auth->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $po_s_auth->partner_id->editAttributes() ?>>
		<?php echo $po_s_auth->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $po_s_auth->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_quantity"><?php echo $po_s_auth->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->quantity->cellAttributes() ?>>
			<span id="el_po_s_auth_quantity">
<input type="text" data-table="po_s_auth" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->quantity->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->quantity->EditValue ?>"<?php echo $po_s_auth->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_sqm"><?php echo $po_s_auth->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->sqm->cellAttributes() ?>>
			<span id="el_po_s_auth_sqm">
<input type="text" data-table="po_s_auth" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->sqm->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->sqm->EditValue ?>"<?php echo $po_s_auth->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_cbm"><?php echo $po_s_auth->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->cbm->cellAttributes() ?>>
			<span id="el_po_s_auth_cbm">
<input type="text" data-table="po_s_auth" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->cbm->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->cbm->EditValue ?>"<?php echo $po_s_auth->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_amount"><?php echo $po_s_auth->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->amount->cellAttributes() ?>>
			<span id="el_po_s_auth_amount">
<input type="text" data-table="po_s_auth" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->amount->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->amount->EditValue ?>"<?php echo $po_s_auth->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_a_operator"><?php echo $po_s_auth->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->a_operator->cellAttributes() ?>>
			<span id="el_po_s_auth_a_operator">
<?php
$wrkonchange = "" . trim(@$po_s_auth->a_operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s_auth->a_operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_a_operator" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_a_operator" id="sv_x_a_operator" value="<?php echo RemoveHtml($po_s_auth->a_operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s_auth->a_operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s_auth->a_operator->getPlaceHolder()) ?>"<?php echo $po_s_auth->a_operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_s_auth" data-field="x_a_operator" data-page="1" data-value-separator="<?php echo $po_s_auth->a_operator->displayValueSeparatorAttribute() ?>" name="x_a_operator" id="x_a_operator" value="<?php echo HtmlEncode($po_s_auth->a_operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_s_authsearch.createAutoSuggest({"id":"x_a_operator","forceSelect":false});
</script>
<?php echo $po_s_auth->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_a_datetime"><?php echo $po_s_auth->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->a_datetime->cellAttributes() ?>>
			<span id="el_po_s_auth_a_datetime">
<input type="text" data-table="po_s_auth" data-field="x_a_datetime" data-page="1" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po_s_auth->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po_s_auth->a_datetime->EditValue ?>"<?php echo $po_s_auth->a_datetime->editAttributes() ?>>
<?php if (!$po_s_auth->a_datetime->ReadOnly && !$po_s_auth->a_datetime->Disabled && !isset($po_s_auth->a_datetime->EditAttrs["readonly"]) && !isset($po_s_auth->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_s_authsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_auth->e_mail->Visible) { // e_mail ?>
	<div id="r_e_mail" class="form-group row">
		<label for="x_e_mail" class="<?php echo $po_s_auth_search->LeftColumnClass ?>"><span id="elh_po_s_auth_e_mail"><?php echo $po_s_auth->e_mail->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_mail" id="z_e_mail" value="="></span>
		</label>
		<div class="<?php echo $po_s_auth_search->RightColumnClass ?>"><div<?php echo $po_s_auth->e_mail->cellAttributes() ?>>
			<span id="el_po_s_auth_e_mail">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_auth" data-field="x_e_mail" data-page="1" data-value-separator="<?php echo $po_s_auth->e_mail->displayValueSeparatorAttribute() ?>" id="x_e_mail" name="x_e_mail"<?php echo $po_s_auth->e_mail->editAttributes() ?>>
		<?php echo $po_s_auth->e_mail->selectOptionListHtml("x_e_mail") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_s_auth_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_s_auth_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_s_auth_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_s_auth_search->terminate();
?>