<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_pending_list = new po_s_pending_list();

// Run the page
$po_s_pending_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_pending_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_s_pending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_s_pendinglist = currentForm = new ew.Form("fpo_s_pendinglist", "list");
fpo_s_pendinglist.formKeyCountName = '<?php echo $po_s_pending_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_s_pendinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_pendinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_pendinglist.lists["x_po_id"] = <?php echo $po_s_pending_list->po_id->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_po_id"].options = <?php echo JsonEncode($po_s_pending_list->po_id->lookupOptions()) ?>;
fpo_s_pendinglist.lists["x_company_id"] = <?php echo $po_s_pending_list->company_id->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_company_id"].options = <?php echo JsonEncode($po_s_pending_list->company_id->lookupOptions()) ?>;
fpo_s_pendinglist.lists["x_partner_id"] = <?php echo $po_s_pending_list->partner_id->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_pending_list->partner_id->lookupOptions()) ?>;
fpo_s_pendinglist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_pendinglist.lists["x_grp"] = <?php echo $po_s_pending_list->grp->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_grp"].options = <?php echo JsonEncode($po_s_pending_list->grp->lookupOptions()) ?>;
fpo_s_pendinglist.lists["x_product"] = <?php echo $po_s_pending_list->product->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_product"].options = <?php echo JsonEncode($po_s_pending_list->product->lookupOptions()) ?>;
fpo_s_pendinglist.lists["x_ref"] = <?php echo $po_s_pending_list->ref->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_ref"].options = <?php echo JsonEncode($po_s_pending_list->ref->lookupOptions()) ?>;
fpo_s_pendinglist.autoSuggests["x_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_pendinglist.lists["x_packing_type"] = <?php echo $po_s_pending_list->packing_type->Lookup->toClientList() ?>;
fpo_s_pendinglist.lists["x_packing_type"].options = <?php echo JsonEncode($po_s_pending_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fpo_s_pendinglistsrch = currentSearchForm = new ew.Form("fpo_s_pendinglistsrch");

// Validate function for search
fpo_s_pendinglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_pending_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->pending_qty->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_s_pendinglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_pendinglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_pendinglistsrch.lists["x_po_id"] = <?php echo $po_s_pending_list->po_id->Lookup->toClientList() ?>;
fpo_s_pendinglistsrch.lists["x_po_id"].options = <?php echo JsonEncode($po_s_pending_list->po_id->lookupOptions()) ?>;
fpo_s_pendinglistsrch.lists["x_partner_id"] = <?php echo $po_s_pending_list->partner_id->Lookup->toClientList() ?>;
fpo_s_pendinglistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_pending_list->partner_id->lookupOptions()) ?>;
fpo_s_pendinglistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_pendinglistsrch.lists["x_ref"] = <?php echo $po_s_pending_list->ref->Lookup->toClientList() ?>;
fpo_s_pendinglistsrch.lists["x_ref"].options = <?php echo JsonEncode($po_s_pending_list->ref->lookupOptions()) ?>;
fpo_s_pendinglistsrch.autoSuggests["x_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpo_s_pendinglistsrch.filterList = <?php echo $po_s_pending_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_s_pendinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_s_pending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_s_pending_list->TotalRecs > 0 && $po_s_pending_list->ExportOptions->visible()) { ?>
<?php $po_s_pending_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_pending_list->ImportOptions->visible()) { ?>
<?php $po_s_pending_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_pending_list->SearchOptions->visible()) { ?>
<?php $po_s_pending_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_pending_list->FilterOptions->visible()) { ?>
<?php $po_s_pending_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_s_pending_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_s_pending->isExport() && !$po_s_pending->CurrentAction) { ?>
<form name="fpo_s_pendinglistsrch" id="fpo_s_pendinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_s_pending_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_s_pendinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_s_pending">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_s_pending_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_s_pending->RowType = ROWTYPE_SEARCH;

// Render row
$po_s_pending->resetAttributes();
$po_s_pending_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_s_pending->po_id->Visible) { // po_id ?>
	<div id="xsc_po_id" class="ew-cell form-group">
		<label for="x_po_id" class="ew-search-caption ew-label"><?php echo $po_s_pending->po_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po_id" id="z_po_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_po_id" data-value-separator="<?php echo $po_s_pending->po_id->displayValueSeparatorAttribute() ?>" id="x_po_id" name="x_po_id"<?php echo $po_s_pending->po_id->editAttributes() ?>>
		<?php echo $po_s_pending->po_id->selectOptionListHtml("x_po_id") ?>
	</select>
</div>
<?php echo $po_s_pending->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
		<span class="ew-search-cond btw1_po_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po_id style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_po_id" data-value-separator="<?php echo $po_s_pending->po_id->displayValueSeparatorAttribute() ?>" id="y_po_id" name="y_po_id"<?php echo $po_s_pending->po_id->editAttributes() ?>>
		<?php echo $po_s_pending->po_id->selectOptionListHtml("y_po_id") ?>
	</select>
</div>
<?php echo $po_s_pending->po_id->Lookup->getParamTag("p_y_po_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_s_pending->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_s_pending->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_s_pending->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s_pending->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_s_pending->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s_pending->partner_id->getPlaceHolder()) ?>"<?php echo $po_s_pending->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_s_pending->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($po_s_pending->partner_id->ReadOnly || $po_s_pending->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_s_pending" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_s_pending->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_s_pending->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_s_pendinglistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_s_pending->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_s_pending->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_s_pending->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_s_pending->ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s_pending->ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_ref" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ref" id="sv_x_ref" value="<?php echo RemoveHtml($po_s_pending->ref->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s_pending->ref->getPlaceHolder()) ?>"<?php echo $po_s_pending->ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_s_pending->ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ref',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($po_s_pending->ref->ReadOnly || $po_s_pending->ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_s_pending" data-field="x_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_s_pending->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="<?php echo HtmlEncode($po_s_pending->ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_s_pendinglistsrch.createAutoSuggest({"id":"x_ref","forceSelect":false});
</script>
<?php echo $po_s_pending->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($po_s_pending->pending_qty->Visible) { // pending_qty ?>
	<div id="xsc_pending_qty" class="ew-cell form-group">
		<label for="x_pending_qty" class="ew-search-caption ew-label"><?php echo $po_s_pending->pending_qty->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pending_qty" id="z_pending_qty" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="po_s_pending" data-field="x_pending_qty" name="x_pending_qty" id="x_pending_qty" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->pending_qty->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->pending_qty->EditValue ?>"<?php echo $po_s_pending->pending_qty->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pending_qty style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pending_qty style="d-none"">
<input type="text" data-table="po_s_pending" data-field="x_pending_qty" name="y_pending_qty" id="y_pending_qty" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->pending_qty->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->pending_qty->EditValue2 ?>"<?php echo $po_s_pending->pending_qty->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_s_pending_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_s_pending_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_s_pending_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_s_pending_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_s_pending_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_s_pending_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_s_pending_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_s_pending_list->showPageHeader(); ?>
<?php
$po_s_pending_list->showMessage();
?>
<?php if ($po_s_pending_list->TotalRecs > 0 || $po_s_pending->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_s_pending_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_s_pending">
<?php if (!$po_s_pending->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_s_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_pending_list->Pager)) $po_s_pending_list->Pager = new PrevNextPager($po_s_pending_list->StartRec, $po_s_pending_list->DisplayRecs, $po_s_pending_list->TotalRecs, $po_s_pending_list->AutoHidePager) ?>
<?php if ($po_s_pending_list->Pager->RecordCount > 0 && $po_s_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_pending_list->TotalRecs > 0 && (!$po_s_pending_list->AutoHidePageSizeSelector || $po_s_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_s_pendinglist" id="fpo_s_pendinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_pending_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_pending_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s_pending">
<div id="gmp_po_s_pending" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_s_pending_list->TotalRecs > 0 || $po_s_pending->isGridEdit()) { ?>
<table id="tbl_po_s_pendinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_s_pending_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_s_pending_list->renderListOptions();

// Render list options (header, left)
$po_s_pending_list->ListOptions->render("header", "left");
?>
<?php if ($po_s_pending->cart_id->Visible) { // cart_id ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->cart_id) == "") { ?>
		<th data-name="cart_id" class="<?php echo $po_s_pending->cart_id->headerCellClass() ?>"><div id="elh_po_s_pending_cart_id" class="po_s_pending_cart_id"><div class="ew-table-header-caption"><?php echo $po_s_pending->cart_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_id" class="<?php echo $po_s_pending->cart_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->cart_id) ?>',2);"><div id="elh_po_s_pending_cart_id" class="po_s_pending_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->cart_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->cart_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->cart_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->po_id->Visible) { // po_id ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $po_s_pending->po_id->headerCellClass() ?>"><div id="elh_po_s_pending_po_id" class="po_s_pending_po_id"><div class="ew-table-header-caption"><?php echo $po_s_pending->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $po_s_pending->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->po_id) ?>',2);"><div id="elh_po_s_pending_po_id" class="po_s_pending_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->company_id->Visible) { // company_id ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_s_pending->company_id->headerCellClass() ?>"><div id="elh_po_s_pending_company_id" class="po_s_pending_company_id"><div class="ew-table-header-caption"><?php echo $po_s_pending->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_s_pending->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->company_id) ?>',2);"><div id="elh_po_s_pending_company_id" class="po_s_pending_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->partner_id->Visible) { // partner_id ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_s_pending->partner_id->headerCellClass() ?>"><div id="elh_po_s_pending_partner_id" class="po_s_pending_partner_id"><div class="ew-table-header-caption"><?php echo $po_s_pending->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_s_pending->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->partner_id) ?>',2);"><div id="elh_po_s_pending_partner_id" class="po_s_pending_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->remarks->Visible) { // remarks ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $po_s_pending->remarks->headerCellClass() ?>"><div id="elh_po_s_pending_remarks" class="po_s_pending_remarks"><div class="ew-table-header-caption"><?php echo $po_s_pending->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $po_s_pending->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->remarks) ?>',2);"><div id="elh_po_s_pending_remarks" class="po_s_pending_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->grp->Visible) { // grp ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $po_s_pending->grp->headerCellClass() ?>"><div id="elh_po_s_pending_grp" class="po_s_pending_grp"><div class="ew-table-header-caption"><?php echo $po_s_pending->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $po_s_pending->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->grp) ?>',2);"><div id="elh_po_s_pending_grp" class="po_s_pending_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->product->Visible) { // product ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->product) == "") { ?>
		<th data-name="product" class="<?php echo $po_s_pending->product->headerCellClass() ?>"><div id="elh_po_s_pending_product" class="po_s_pending_product"><div class="ew-table-header-caption"><?php echo $po_s_pending->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $po_s_pending->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->product) ?>',2);"><div id="elh_po_s_pending_product" class="po_s_pending_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->ref->Visible) { // ref ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $po_s_pending->ref->headerCellClass() ?>"><div id="elh_po_s_pending_ref" class="po_s_pending_ref"><div class="ew-table-header-caption"><?php echo $po_s_pending->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $po_s_pending->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->ref) ?>',2);"><div id="elh_po_s_pending_ref" class="po_s_pending_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->order_quantity->Visible) { // order_quantity ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->order_quantity) == "") { ?>
		<th data-name="order_quantity" class="<?php echo $po_s_pending->order_quantity->headerCellClass() ?>"><div id="elh_po_s_pending_order_quantity" class="po_s_pending_order_quantity"><div class="ew-table-header-caption"><?php echo $po_s_pending->order_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_quantity" class="<?php echo $po_s_pending->order_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->order_quantity) ?>',2);"><div id="elh_po_s_pending_order_quantity" class="po_s_pending_order_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->order_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->order_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->order_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->purchase->Visible) { // purchase ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->purchase) == "") { ?>
		<th data-name="purchase" class="<?php echo $po_s_pending->purchase->headerCellClass() ?>"><div id="elh_po_s_pending_purchase" class="po_s_pending_purchase"><div class="ew-table-header-caption"><?php echo $po_s_pending->purchase->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purchase" class="<?php echo $po_s_pending->purchase->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->purchase) ?>',2);"><div id="elh_po_s_pending_purchase" class="po_s_pending_purchase">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->purchase->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->purchase->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->purchase->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->pending_qty->Visible) { // pending_qty ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->pending_qty) == "") { ?>
		<th data-name="pending_qty" class="<?php echo $po_s_pending->pending_qty->headerCellClass() ?>"><div id="elh_po_s_pending_pending_qty" class="po_s_pending_pending_qty"><div class="ew-table-header-caption"><?php echo $po_s_pending->pending_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_qty" class="<?php echo $po_s_pending->pending_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->pending_qty) ?>',2);"><div id="elh_po_s_pending_pending_qty" class="po_s_pending_pending_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->pending_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->pending_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->pending_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->order_date->Visible) { // order_date ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $po_s_pending->order_date->headerCellClass() ?>"><div id="elh_po_s_pending_order_date" class="po_s_pending_order_date"><div class="ew-table-header-caption"><?php echo $po_s_pending->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $po_s_pending->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->order_date) ?>',2);"><div id="elh_po_s_pending_order_date" class="po_s_pending_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_s_pending->despatch_date->headerCellClass() ?>"><div id="elh_po_s_pending_despatch_date" class="po_s_pending_despatch_date"><div class="ew-table-header-caption"><?php echo $po_s_pending->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_s_pending->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->despatch_date) ?>',2);"><div id="elh_po_s_pending_despatch_date" class="po_s_pending_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $po_s_pending->avg_quantity->headerCellClass() ?>"><div id="elh_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity"><div class="ew-table-header-caption"><?php echo $po_s_pending->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $po_s_pending->avg_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->avg_quantity) ?>',2);"><div id="elh_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->packing_type->Visible) { // packing_type ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $po_s_pending->packing_type->headerCellClass() ?>"><div id="elh_po_s_pending_packing_type" class="po_s_pending_packing_type"><div class="ew-table-header-caption"><?php echo $po_s_pending->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $po_s_pending->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->packing_type) ?>',2);"><div id="elh_po_s_pending_packing_type" class="po_s_pending_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->status->Visible) { // status ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->status) == "") { ?>
		<th data-name="status" class="<?php echo $po_s_pending->status->headerCellClass() ?>"><div id="elh_po_s_pending_status" class="po_s_pending_status"><div class="ew-table-header-caption"><?php echo $po_s_pending->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $po_s_pending->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->status) ?>',2);"><div id="elh_po_s_pending_status" class="po_s_pending_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s_pending->p_qty->Visible) { // p_qty ?>
	<?php if ($po_s_pending->sortUrl($po_s_pending->p_qty) == "") { ?>
		<th data-name="p_qty" class="<?php echo $po_s_pending->p_qty->headerCellClass() ?>"><div id="elh_po_s_pending_p_qty" class="po_s_pending_p_qty"><div class="ew-table-header-caption"><?php echo $po_s_pending->p_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_qty" class="<?php echo $po_s_pending->p_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s_pending->SortUrl($po_s_pending->p_qty) ?>',2);"><div id="elh_po_s_pending_p_qty" class="po_s_pending_p_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s_pending->p_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s_pending->p_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s_pending->p_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_s_pending_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_s_pending->ExportAll && $po_s_pending->isExport()) {
	$po_s_pending_list->StopRec = $po_s_pending_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_s_pending_list->TotalRecs > $po_s_pending_list->StartRec + $po_s_pending_list->DisplayRecs - 1)
		$po_s_pending_list->StopRec = $po_s_pending_list->StartRec + $po_s_pending_list->DisplayRecs - 1;
	else
		$po_s_pending_list->StopRec = $po_s_pending_list->TotalRecs;
}
$po_s_pending_list->RecCnt = $po_s_pending_list->StartRec - 1;
if ($po_s_pending_list->Recordset && !$po_s_pending_list->Recordset->EOF) {
	$po_s_pending_list->Recordset->moveFirst();
	$selectLimit = $po_s_pending_list->UseSelectLimit;
	if (!$selectLimit && $po_s_pending_list->StartRec > 1)
		$po_s_pending_list->Recordset->move($po_s_pending_list->StartRec - 1);
} elseif (!$po_s_pending->AllowAddDeleteRow && $po_s_pending_list->StopRec == 0) {
	$po_s_pending_list->StopRec = $po_s_pending->GridAddRowCount;
}

// Initialize aggregate
$po_s_pending->RowType = ROWTYPE_AGGREGATEINIT;
$po_s_pending->resetAttributes();
$po_s_pending_list->renderRow();
while ($po_s_pending_list->RecCnt < $po_s_pending_list->StopRec) {
	$po_s_pending_list->RecCnt++;
	if ($po_s_pending_list->RecCnt >= $po_s_pending_list->StartRec) {
		$po_s_pending_list->RowCnt++;

		// Set up key count
		$po_s_pending_list->KeyCount = $po_s_pending_list->RowIndex;

		// Init row class and style
		$po_s_pending->resetAttributes();
		$po_s_pending->CssClass = "";
		if ($po_s_pending->isGridAdd()) {
		} else {
			$po_s_pending_list->loadRowValues($po_s_pending_list->Recordset); // Load row values
		}
		$po_s_pending->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_s_pending->RowAttrs = array_merge($po_s_pending->RowAttrs, array('data-rowindex'=>$po_s_pending_list->RowCnt, 'id'=>'r' . $po_s_pending_list->RowCnt . '_po_s_pending', 'data-rowtype'=>$po_s_pending->RowType));

		// Render row
		$po_s_pending_list->renderRow();

		// Render list options
		$po_s_pending_list->renderListOptions();
?>
	<tr<?php echo $po_s_pending->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_s_pending_list->ListOptions->render("body", "left", $po_s_pending_list->RowCnt);
?>
	<?php if ($po_s_pending->cart_id->Visible) { // cart_id ?>
		<td data-name="cart_id"<?php echo $po_s_pending->cart_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_cart_id" class="po_s_pending_cart_id">
<span<?php echo $po_s_pending->cart_id->viewAttributes() ?>>
<?php echo $po_s_pending->cart_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $po_s_pending->po_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_po_id" class="po_s_pending_po_id">
<span<?php echo $po_s_pending->po_id->viewAttributes() ?>>
<?php echo $po_s_pending->po_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_s_pending->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_company_id" class="po_s_pending_company_id">
<span<?php echo $po_s_pending->company_id->viewAttributes() ?>>
<?php echo $po_s_pending->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_s_pending->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_partner_id" class="po_s_pending_partner_id">
<span<?php echo $po_s_pending->partner_id->viewAttributes() ?>>
<?php echo $po_s_pending->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $po_s_pending->remarks->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_remarks" class="po_s_pending_remarks">
<span<?php echo $po_s_pending->remarks->viewAttributes() ?>>
<?php echo $po_s_pending->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $po_s_pending->grp->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_grp" class="po_s_pending_grp">
<span<?php echo $po_s_pending->grp->viewAttributes() ?>>
<?php echo $po_s_pending->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->product->Visible) { // product ?>
		<td data-name="product"<?php echo $po_s_pending->product->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_product" class="po_s_pending_product">
<span<?php echo $po_s_pending->product->viewAttributes() ?>>
<?php echo $po_s_pending->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $po_s_pending->ref->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_ref" class="po_s_pending_ref">
<span<?php echo $po_s_pending->ref->viewAttributes() ?>>
<?php echo $po_s_pending->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity"<?php echo $po_s_pending->order_quantity->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_order_quantity" class="po_s_pending_order_quantity">
<span<?php echo $po_s_pending->order_quantity->viewAttributes() ?>>
<?php echo $po_s_pending->order_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->purchase->Visible) { // purchase ?>
		<td data-name="purchase"<?php echo $po_s_pending->purchase->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_purchase" class="po_s_pending_purchase">
<span<?php echo $po_s_pending->purchase->viewAttributes() ?>>
<?php echo $po_s_pending->purchase->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->pending_qty->Visible) { // pending_qty ?>
		<td data-name="pending_qty"<?php echo $po_s_pending->pending_qty->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_pending_qty" class="po_s_pending_pending_qty">
<span<?php echo $po_s_pending->pending_qty->viewAttributes() ?>>
<?php echo $po_s_pending->pending_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $po_s_pending->order_date->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_order_date" class="po_s_pending_order_date">
<span<?php echo $po_s_pending->order_date->viewAttributes() ?>>
<?php echo $po_s_pending->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_s_pending->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_despatch_date" class="po_s_pending_despatch_date">
<span<?php echo $po_s_pending->despatch_date->viewAttributes() ?>>
<?php echo $po_s_pending->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $po_s_pending->avg_quantity->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity">
<span<?php echo $po_s_pending->avg_quantity->viewAttributes() ?>>
<?php echo $po_s_pending->avg_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $po_s_pending->packing_type->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_packing_type" class="po_s_pending_packing_type">
<span<?php echo $po_s_pending->packing_type->viewAttributes() ?>>
<?php echo $po_s_pending->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->status->Visible) { // status ?>
		<td data-name="status"<?php echo $po_s_pending->status->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_status" class="po_s_pending_status">
<span<?php echo $po_s_pending->status->viewAttributes() ?>>
<?php echo $po_s_pending->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s_pending->p_qty->Visible) { // p_qty ?>
		<td data-name="p_qty"<?php echo $po_s_pending->p_qty->cellAttributes() ?>>
<span id="el<?php echo $po_s_pending_list->RowCnt ?>_po_s_pending_p_qty" class="po_s_pending_p_qty">
<span<?php echo $po_s_pending->p_qty->viewAttributes() ?>>
<?php echo $po_s_pending->p_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_s_pending_list->ListOptions->render("body", "right", $po_s_pending_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_s_pending->isGridAdd())
		$po_s_pending_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$po_s_pending->RowType = ROWTYPE_AGGREGATE;
$po_s_pending->resetAttributes();
$po_s_pending_list->renderRow();
?>
<?php if ($po_s_pending_list->TotalRecs > 0 && !$po_s_pending->isGridAdd() && !$po_s_pending->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$po_s_pending_list->renderListOptions();

// Render list options (footer, left)
$po_s_pending_list->ListOptions->render("footer", "left");
?>
	<?php if ($po_s_pending->cart_id->Visible) { // cart_id ?>
		<td data-name="cart_id" class="<?php echo $po_s_pending->cart_id->footerCellClass() ?>"><span id="elf_po_s_pending_cart_id" class="po_s_pending_cart_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->po_id->Visible) { // po_id ?>
		<td data-name="po_id" class="<?php echo $po_s_pending->po_id->footerCellClass() ?>"><span id="elf_po_s_pending_po_id" class="po_s_pending_po_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $po_s_pending->company_id->footerCellClass() ?>"><span id="elf_po_s_pending_company_id" class="po_s_pending_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $po_s_pending->partner_id->footerCellClass() ?>"><span id="elf_po_s_pending_partner_id" class="po_s_pending_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $po_s_pending->remarks->footerCellClass() ?>"><span id="elf_po_s_pending_remarks" class="po_s_pending_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $po_s_pending->grp->footerCellClass() ?>"><span id="elf_po_s_pending_grp" class="po_s_pending_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $po_s_pending->product->footerCellClass() ?>"><span id="elf_po_s_pending_product" class="po_s_pending_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $po_s_pending->ref->footerCellClass() ?>"><span id="elf_po_s_pending_ref" class="po_s_pending_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity" class="<?php echo $po_s_pending->order_quantity->footerCellClass() ?>"><span id="elf_po_s_pending_order_quantity" class="po_s_pending_order_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_pending->order_quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->purchase->Visible) { // purchase ?>
		<td data-name="purchase" class="<?php echo $po_s_pending->purchase->footerCellClass() ?>"><span id="elf_po_s_pending_purchase" class="po_s_pending_purchase">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_pending->purchase->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->pending_qty->Visible) { // pending_qty ?>
		<td data-name="pending_qty" class="<?php echo $po_s_pending->pending_qty->footerCellClass() ?>"><span id="elf_po_s_pending_pending_qty" class="po_s_pending_pending_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_pending->pending_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->order_date->Visible) { // order_date ?>
		<td data-name="order_date" class="<?php echo $po_s_pending->order_date->footerCellClass() ?>"><span id="elf_po_s_pending_order_date" class="po_s_pending_order_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date" class="<?php echo $po_s_pending->despatch_date->footerCellClass() ?>"><span id="elf_po_s_pending_despatch_date" class="po_s_pending_despatch_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity" class="<?php echo $po_s_pending->avg_quantity->footerCellClass() ?>"><span id="elf_po_s_pending_avg_quantity" class="po_s_pending_avg_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $po_s_pending->avg_quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $po_s_pending->packing_type->footerCellClass() ?>"><span id="elf_po_s_pending_packing_type" class="po_s_pending_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $po_s_pending->status->footerCellClass() ?>"><span id="elf_po_s_pending_status" class="po_s_pending_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_s_pending->p_qty->Visible) { // p_qty ?>
		<td data-name="p_qty" class="<?php echo $po_s_pending->p_qty->footerCellClass() ?>"><span id="elf_po_s_pending_p_qty" class="po_s_pending_p_qty">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$po_s_pending_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_s_pending->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_s_pending_list->Recordset)
	$po_s_pending_list->Recordset->Close();
?>
<?php if (!$po_s_pending->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_s_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_pending_list->Pager)) $po_s_pending_list->Pager = new PrevNextPager($po_s_pending_list->StartRec, $po_s_pending_list->DisplayRecs, $po_s_pending_list->TotalRecs, $po_s_pending_list->AutoHidePager) ?>
<?php if ($po_s_pending_list->Pager->RecordCount > 0 && $po_s_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_pending_list->pageUrl() ?>start=<?php echo $po_s_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_pending_list->TotalRecs > 0 && (!$po_s_pending_list->AutoHidePageSizeSelector || $po_s_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_pending_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_s_pending_list->TotalRecs == 0 && !$po_s_pending->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_s_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_s_pending_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_s_pending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_s_pending->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_s_pending", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_s_pending_list->terminate();
?>