<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_pending_search = new po_s_pending_search();

// Run the page
$po_s_pending_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_pending_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_s_pending_search->IsModal) { ?>
var fpo_s_pendingsearch = currentAdvancedSearchForm = new ew.Form("fpo_s_pendingsearch", "search");
<?php } else { ?>
var fpo_s_pendingsearch = currentForm = new ew.Form("fpo_s_pendingsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_s_pendingsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_s_pendingsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_s_pendingsearch.lists["x_po_id"] = <?php echo $po_s_pending_search->po_id->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_po_id"].options = <?php echo JsonEncode($po_s_pending_search->po_id->lookupOptions()) ?>;
fpo_s_pendingsearch.lists["x_company_id"] = <?php echo $po_s_pending_search->company_id->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_company_id"].options = <?php echo JsonEncode($po_s_pending_search->company_id->lookupOptions()) ?>;
fpo_s_pendingsearch.lists["x_partner_id"] = <?php echo $po_s_pending_search->partner_id->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_pending_search->partner_id->lookupOptions()) ?>;
fpo_s_pendingsearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_pendingsearch.lists["x_grp"] = <?php echo $po_s_pending_search->grp->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_grp"].options = <?php echo JsonEncode($po_s_pending_search->grp->lookupOptions()) ?>;
fpo_s_pendingsearch.lists["x_s_grp"] = <?php echo $po_s_pending_search->s_grp->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_s_grp"].options = <?php echo JsonEncode($po_s_pending_search->s_grp->lookupOptions()) ?>;
fpo_s_pendingsearch.lists["x_product"] = <?php echo $po_s_pending_search->product->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_product"].options = <?php echo JsonEncode($po_s_pending_search->product->lookupOptions()) ?>;
fpo_s_pendingsearch.lists["x_ref"] = <?php echo $po_s_pending_search->ref->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_ref"].options = <?php echo JsonEncode($po_s_pending_search->ref->lookupOptions()) ?>;
fpo_s_pendingsearch.autoSuggests["x_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_s_pendingsearch.lists["x_packing_type"] = <?php echo $po_s_pending_search->packing_type->Lookup->toClientList() ?>;
fpo_s_pendingsearch.lists["x_packing_type"].options = <?php echo JsonEncode($po_s_pending_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_s_pendingsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_cart_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->cart_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->order_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_purchase");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->purchase->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->pending_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->avg_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_p_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s_pending->p_qty->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_s_pending_search->showPageHeader(); ?>
<?php
$po_s_pending_search->showMessage();
?>
<form name="fpo_s_pendingsearch" id="fpo_s_pendingsearch" class="<?php echo $po_s_pending_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_pending_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_pending_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s_pending">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_s_pending_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s_pending->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label for="x_cart_id" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_cart_id"><?php echo $po_s_pending->cart_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_id" id="z_cart_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->cart_id->cellAttributes() ?>>
			<span id="el_po_s_pending_cart_id">
<input type="text" data-table="po_s_pending" data-field="x_cart_id" name="x_cart_id" id="x_cart_id" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->cart_id->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->cart_id->EditValue ?>"<?php echo $po_s_pending->cart_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label for="x_po_id" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_po_id"><?php echo $po_s_pending->po_id->caption() ?></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->po_id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po_id" id="z_po_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($po_s_pending->po_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_po_s_pending_po_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_po_id" data-value-separator="<?php echo $po_s_pending->po_id->displayValueSeparatorAttribute() ?>" id="x_po_id" name="x_po_id"<?php echo $po_s_pending->po_id->editAttributes() ?>>
		<?php echo $po_s_pending->po_id->selectOptionListHtml("x_po_id") ?>
	</select>
</div>
<?php echo $po_s_pending->po_id->Lookup->getParamTag("p_x_po_id") ?>
</span>
			<span class="ew-search-cond btw1_po_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_po_s_pending_po_id" class="btw1_po_id d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_po_id" data-value-separator="<?php echo $po_s_pending->po_id->displayValueSeparatorAttribute() ?>" id="y_po_id" name="y_po_id"<?php echo $po_s_pending->po_id->editAttributes() ?>>
		<?php echo $po_s_pending->po_id->selectOptionListHtml("y_po_id") ?>
	</select>
</div>
<?php echo $po_s_pending->po_id->Lookup->getParamTag("p_y_po_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_company_id"><?php echo $po_s_pending->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->company_id->cellAttributes() ?>>
			<span id="el_po_s_pending_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_company_id" data-value-separator="<?php echo $po_s_pending->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_s_pending->company_id->editAttributes() ?>>
		<?php echo $po_s_pending->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_s_pending->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_partner_id"><?php echo $po_s_pending->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->partner_id->cellAttributes() ?>>
			<span id="el_po_s_pending_partner_id">
<?php
$wrkonchange = "" . trim(@$po_s_pending->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s_pending->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_s_pending->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s_pending->partner_id->getPlaceHolder()) ?>"<?php echo $po_s_pending->partner_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_s_pending->partner_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_partner_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($po_s_pending->partner_id->ReadOnly || $po_s_pending->partner_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_s_pending" data-field="x_partner_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_s_pending->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_s_pending->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_s_pendingsearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_s_pending->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label for="x_partner_order_no" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_partner_order_no"><?php echo $po_s_pending->partner_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->partner_order_no->cellAttributes() ?>>
			<span id="el_po_s_pending_partner_order_no">
<input type="text" data-table="po_s_pending" data-field="x_partner_order_no" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s_pending->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->partner_order_no->EditValue ?>"<?php echo $po_s_pending->partner_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_remarks"><?php echo $po_s_pending->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->remarks->cellAttributes() ?>>
			<span id="el_po_s_pending_remarks">
<input type="text" data-table="po_s_pending" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($po_s_pending->remarks->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->remarks->EditValue ?>"<?php echo $po_s_pending->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_grp"><?php echo $po_s_pending->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->grp->cellAttributes() ?>>
			<span id="el_po_s_pending_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_grp" data-value-separator="<?php echo $po_s_pending->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_s_pending->grp->editAttributes() ?>>
		<?php echo $po_s_pending->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_s_pending->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_s_grp"><?php echo $po_s_pending->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->s_grp->cellAttributes() ?>>
			<span id="el_po_s_pending_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_s_grp" data-value-separator="<?php echo $po_s_pending->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $po_s_pending->s_grp->editAttributes() ?>>
		<?php echo $po_s_pending->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $po_s_pending->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_product"><?php echo $po_s_pending->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->product->cellAttributes() ?>>
			<span id="el_po_s_pending_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_product" data-value-separator="<?php echo $po_s_pending->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po_s_pending->product->editAttributes() ?>>
		<?php echo $po_s_pending->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $po_s_pending->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_ref"><?php echo $po_s_pending->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->ref->cellAttributes() ?>>
			<span id="el_po_s_pending_ref">
<?php
$wrkonchange = "" . trim(@$po_s_pending->ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s_pending->ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_ref" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ref" id="sv_x_ref" value="<?php echo RemoveHtml($po_s_pending->ref->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s_pending->ref->getPlaceHolder()) ?>"<?php echo $po_s_pending->ref->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_s_pending->ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ref',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($po_s_pending->ref->ReadOnly || $po_s_pending->ref->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_s_pending" data-field="x_ref" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_s_pending->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="<?php echo HtmlEncode($po_s_pending->ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_s_pendingsearch.createAutoSuggest({"id":"x_ref","forceSelect":false});
</script>
<?php echo $po_s_pending->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_product_code"><?php echo $po_s_pending->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->product_code->cellAttributes() ?>>
			<span id="el_po_s_pending_product_code">
<input type="text" data-table="po_s_pending" data-field="x_product_code" name="x_product_code" id="x_product_code" placeholder="<?php echo HtmlEncode($po_s_pending->product_code->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->product_code->EditValue ?>"<?php echo $po_s_pending->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->order_quantity->Visible) { // order_quantity ?>
	<div id="r_order_quantity" class="form-group row">
		<label for="x_order_quantity" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_order_quantity"><?php echo $po_s_pending->order_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_quantity" id="z_order_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->order_quantity->cellAttributes() ?>>
			<span id="el_po_s_pending_order_quantity">
<input type="text" data-table="po_s_pending" data-field="x_order_quantity" name="x_order_quantity" id="x_order_quantity" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->order_quantity->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->order_quantity->EditValue ?>"<?php echo $po_s_pending->order_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->purchase->Visible) { // purchase ?>
	<div id="r_purchase" class="form-group row">
		<label for="x_purchase" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_purchase"><?php echo $po_s_pending->purchase->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_purchase" id="z_purchase" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->purchase->cellAttributes() ?>>
			<span id="el_po_s_pending_purchase">
<input type="text" data-table="po_s_pending" data-field="x_purchase" name="x_purchase" id="x_purchase" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->purchase->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->purchase->EditValue ?>"<?php echo $po_s_pending->purchase->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->pending_qty->Visible) { // pending_qty ?>
	<div id="r_pending_qty" class="form-group row">
		<label for="x_pending_qty" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_pending_qty"><?php echo $po_s_pending->pending_qty->caption() ?></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->pending_qty->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending_qty" id="z_pending_qty" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($po_s_pending->pending_qty->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_po_s_pending_pending_qty">
<input type="text" data-table="po_s_pending" data-field="x_pending_qty" name="x_pending_qty" id="x_pending_qty" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->pending_qty->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->pending_qty->EditValue ?>"<?php echo $po_s_pending->pending_qty->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending_qty d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_po_s_pending_pending_qty" class="btw1_pending_qty d-none">
<input type="text" data-table="po_s_pending" data-field="x_pending_qty" name="y_pending_qty" id="y_pending_qty" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->pending_qty->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->pending_qty->EditValue2 ?>"<?php echo $po_s_pending->pending_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_order_date"><?php echo $po_s_pending->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->order_date->cellAttributes() ?>>
			<span id="el_po_s_pending_order_date">
<input type="text" data-table="po_s_pending" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($po_s_pending->order_date->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->order_date->EditValue ?>"<?php echo $po_s_pending->order_date->editAttributes() ?>>
<?php if (!$po_s_pending->order_date->ReadOnly && !$po_s_pending->order_date->Disabled && !isset($po_s_pending->order_date->EditAttrs["readonly"]) && !isset($po_s_pending->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_s_pendingsearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_despatch_date"><?php echo $po_s_pending->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->despatch_date->cellAttributes() ?>>
			<span id="el_po_s_pending_despatch_date">
<input type="text" data-table="po_s_pending" data-field="x_despatch_date" data-format="7" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_s_pending->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->despatch_date->EditValue ?>"<?php echo $po_s_pending->despatch_date->editAttributes() ?>>
<?php if (!$po_s_pending->despatch_date->ReadOnly && !$po_s_pending->despatch_date->Disabled && !isset($po_s_pending->despatch_date->EditAttrs["readonly"]) && !isset($po_s_pending->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_s_pendingsearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label for="x_avg_quantity" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_avg_quantity"><?php echo $po_s_pending->avg_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->avg_quantity->cellAttributes() ?>>
			<span id="el_po_s_pending_avg_quantity">
<input type="text" data-table="po_s_pending" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->avg_quantity->EditValue ?>"<?php echo $po_s_pending->avg_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_packing_type"><?php echo $po_s_pending->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->packing_type->cellAttributes() ?>>
			<span id="el_po_s_pending_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s_pending" data-field="x_packing_type" data-value-separator="<?php echo $po_s_pending->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $po_s_pending->packing_type->editAttributes() ?>>
		<?php echo $po_s_pending->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $po_s_pending->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_status"><?php echo $po_s_pending->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->status->cellAttributes() ?>>
			<span id="el_po_s_pending_status">
<input type="text" data-table="po_s_pending" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->status->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->status->EditValue ?>"<?php echo $po_s_pending->status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->p_qty->Visible) { // p_qty ?>
	<div id="r_p_qty" class="form-group row">
		<label for="x_p_qty" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_p_qty"><?php echo $po_s_pending->p_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_p_qty" id="z_p_qty" value="="></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->p_qty->cellAttributes() ?>>
			<span id="el_po_s_pending_p_qty">
<input type="text" data-table="po_s_pending" data-field="x_p_qty" name="x_p_qty" id="x_p_qty" size="30" placeholder="<?php echo HtmlEncode($po_s_pending->p_qty->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->p_qty->EditValue ?>"<?php echo $po_s_pending->p_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s_pending->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $po_s_pending_search->LeftColumnClass ?>"><span id="elh_po_s_pending_p_remarks"><?php echo $po_s_pending->p_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_pending_search->RightColumnClass ?>"><div<?php echo $po_s_pending->p_remarks->cellAttributes() ?>>
			<span id="el_po_s_pending_p_remarks">
<input type="text" data-table="po_s_pending" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" size="35" placeholder="<?php echo HtmlEncode($po_s_pending->p_remarks->getPlaceHolder()) ?>" value="<?php echo $po_s_pending->p_remarks->EditValue ?>"<?php echo $po_s_pending->p_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_s_pending_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_s_pending_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_s_pending_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_s_pending_search->terminate();
?>