<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_add = new po_s_add();

// Run the page
$po_s_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpo_sadd = currentForm = new ew.Form("fpo_sadd", "add");

// Validate form
fpo_sadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_s_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->po->caption(), $po_s->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->company_id->caption(), $po_s->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->partner_id->caption(), $po_s->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->copy->Required) { ?>
			elm = this.getElements("x" + infix + "_copy");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->copy->caption(), $po_s->copy->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->cart_id->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->cart_id->caption(), $po_s->cart_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->quantity->caption(), $po_s->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->sqm->caption(), $po_s->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_s->sqm->errorMessage()) ?>");
		<?php if ($po_s_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->amount->caption(), $po_s->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->cbm->caption(), $po_s->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_s->cbm->errorMessage()) ?>");
		<?php if ($po_s_add->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->gst->caption(), $po_s->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->partner_order_no->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_order_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->partner_order_no->caption(), $po_s->partner_order_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->partner_order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->partner_order_date->caption(), $po_s->partner_order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_partner_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_s->partner_order_date->errorMessage()) ?>");
		<?php if ($po_s_add->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->despatch_date->caption(), $po_s->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_s->despatch_date->errorMessage()) ?>");
		<?php if ($po_s_add->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->despatch_week->caption(), $po_s->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->fob_date->Required) { ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->fob_date->caption(), $po_s->fob_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_s->fob_date->errorMessage()) ?>");
		<?php if ($po_s_add->part_dispatch->Required) { ?>
			elm = this.getElements("x" + infix + "_part_dispatch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->part_dispatch->caption(), $po_s->part_dispatch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->payment_terms->caption(), $po_s->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->transport_type->Required) { ?>
			elm = this.getElements("x" + infix + "_transport_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->transport_type->caption(), $po_s->transport_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->partner_shipping_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_shipping_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->partner_shipping_id->caption(), $po_s->partner_shipping_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->remarks->caption(), $po_s->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->operator->caption(), $po_s->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->datetime->caption(), $po_s->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->buyer_instruction->caption(), $po_s->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->d_09_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_09_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->d_09_head->caption(), $po_s->d_09_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->description_09->caption(), $po_s->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->d_10_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_10_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->d_10_head->caption(), $po_s->d_10_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->description_10->caption(), $po_s->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->d_11_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_11_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->d_11_head->caption(), $po_s->d_11_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->description_11->Required) { ?>
			elm = this.getElements("x" + infix + "_description_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->description_11->caption(), $po_s->description_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->d_12_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_12_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->d_12_head->caption(), $po_s->d_12_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->description_12->Required) { ?>
			elm = this.getElements("x" + infix + "_description_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->description_12->caption(), $po_s->description_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_s->production_plan->caption(), $po_s->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_s_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $po_s->uploads->caption(), $po_s->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_sadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_sadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_sadd.multiPage = new ew.MultiPage("fpo_sadd");

// Dynamic selection lists
fpo_sadd.lists["x_company_id"] = <?php echo $po_s_add->company_id->Lookup->toClientList() ?>;
fpo_sadd.lists["x_company_id"].options = <?php echo JsonEncode($po_s_add->company_id->lookupOptions()) ?>;
fpo_sadd.lists["x_partner_id"] = <?php echo $po_s_add->partner_id->Lookup->toClientList() ?>;
fpo_sadd.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_add->partner_id->lookupOptions()) ?>;
fpo_sadd.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_sadd.lists["x_copy"] = <?php echo $po_s_add->copy->Lookup->toClientList() ?>;
fpo_sadd.lists["x_copy"].options = <?php echo JsonEncode($po_s_add->copy->lookupOptions()) ?>;
fpo_sadd.lists["x_cart_id[]"] = <?php echo $po_s_add->cart_id->Lookup->toClientList() ?>;
fpo_sadd.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_s_add->cart_id->lookupOptions()) ?>;
fpo_sadd.lists["x_gst"] = <?php echo $po_s_add->gst->Lookup->toClientList() ?>;
fpo_sadd.lists["x_gst"].options = <?php echo JsonEncode($po_s_add->gst->lookupOptions()) ?>;
fpo_sadd.lists["x_despatch_week"] = <?php echo $po_s_add->despatch_week->Lookup->toClientList() ?>;
fpo_sadd.lists["x_despatch_week"].options = <?php echo JsonEncode($po_s_add->despatch_week->lookupOptions()) ?>;
fpo_sadd.lists["x_part_dispatch"] = <?php echo $po_s_add->part_dispatch->Lookup->toClientList() ?>;
fpo_sadd.lists["x_part_dispatch"].options = <?php echo JsonEncode($po_s_add->part_dispatch->options(FALSE, TRUE)) ?>;
fpo_sadd.lists["x_payment_terms"] = <?php echo $po_s_add->payment_terms->Lookup->toClientList() ?>;
fpo_sadd.lists["x_payment_terms"].options = <?php echo JsonEncode($po_s_add->payment_terms->lookupOptions()) ?>;
fpo_sadd.lists["x_transport_type"] = <?php echo $po_s_add->transport_type->Lookup->toClientList() ?>;
fpo_sadd.lists["x_transport_type"].options = <?php echo JsonEncode($po_s_add->transport_type->lookupOptions()) ?>;
fpo_sadd.lists["x_partner_shipping_id"] = <?php echo $po_s_add->partner_shipping_id->Lookup->toClientList() ?>;
fpo_sadd.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_s_add->partner_shipping_id->lookupOptions()) ?>;
fpo_sadd.lists["x_operator"] = <?php echo $po_s_add->operator->Lookup->toClientList() ?>;
fpo_sadd.lists["x_operator"].options = <?php echo JsonEncode($po_s_add->operator->lookupOptions()) ?>;
fpo_sadd.lists["x_d_09_head"] = <?php echo $po_s_add->d_09_head->Lookup->toClientList() ?>;
fpo_sadd.lists["x_d_09_head"].options = <?php echo JsonEncode($po_s_add->d_09_head->lookupOptions()) ?>;
fpo_sadd.lists["x_d_10_head"] = <?php echo $po_s_add->d_10_head->Lookup->toClientList() ?>;
fpo_sadd.lists["x_d_10_head"].options = <?php echo JsonEncode($po_s_add->d_10_head->lookupOptions()) ?>;
fpo_sadd.lists["x_d_11_head"] = <?php echo $po_s_add->d_11_head->Lookup->toClientList() ?>;
fpo_sadd.lists["x_d_11_head"].options = <?php echo JsonEncode($po_s_add->d_11_head->lookupOptions()) ?>;
fpo_sadd.lists["x_d_12_head"] = <?php echo $po_s_add->d_12_head->Lookup->toClientList() ?>;
fpo_sadd.lists["x_d_12_head"].options = <?php echo JsonEncode($po_s_add->d_12_head->lookupOptions()) ?>;
fpo_sadd.lists["x_production_plan"] = <?php echo $po_s_add->production_plan->Lookup->toClientList() ?>;
fpo_sadd.lists["x_production_plan"].options = <?php echo JsonEncode($po_s_add->production_plan->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_s_add->showPageHeader(); ?>
<?php
$po_s_add->showMessage();
?>
<form name="fpo_sadd" id="fpo_sadd" class="<?php echo $po_s_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_s_add->IsModal ?>">
<?php if ($po_s_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($po_s->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_s_po" for="x_po" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->po->caption() ?><?php echo ($po_s->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->po->cellAttributes() ?>>
<span id="el_po_s_po">
<input type="text" data-table="po_s" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_s->po->getPlaceHolder()) ?>" value="<?php echo $po_s->po->EditValue ?>"<?php echo $po_s->po->editAttributes() ?>>
</span>
<?php echo $po_s->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_po_s_company_id" for="x_company_id" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->company_id->caption() ?><?php echo ($po_s->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->company_id->cellAttributes() ?>>
<span id="el_po_s_company_id">
<?php $po_s->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_s->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_company_id" data-page="0" data-value-separator="<?php echo $po_s->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_s->company_id->editAttributes() ?>>
		<?php echo $po_s->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_s->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $po_s->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_po_s_partner_id" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->partner_id->caption() ?><?php echo ($po_s->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->partner_id->cellAttributes() ?>>
<span id="el_po_s_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>"<?php echo $po_s->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_s" data-field="x_partner_id" data-page="0" data-value-separator="<?php echo $po_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_s->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_sadd.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $po_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php echo $po_s->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->copy->Visible) { // copy ?>
	<div id="r_copy" class="form-group row">
		<label id="elh_po_s_copy" for="x_copy" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->copy->caption() ?><?php echo ($po_s->copy->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->copy->cellAttributes() ?>>
<span id="el_po_s_copy">
<?php $po_s->copy->EditAttrs["onchange"] = "ew.autoFill(this);" . @$po_s->copy->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_copy" data-page="0" data-value-separator="<?php echo $po_s->copy->displayValueSeparatorAttribute() ?>" id="x_copy" name="x_copy"<?php echo $po_s->copy->editAttributes() ?>>
		<?php echo $po_s->copy->selectOptionListHtml("x_copy") ?>
	</select>
</div>
<?php echo $po_s->copy->Lookup->getParamTag("p_x_copy") ?>
</span>
<?php echo $po_s->copy->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label id="elh_po_s_cart_id" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->cart_id->caption() ?><?php echo ($po_s->cart_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->cart_id->cellAttributes() ?>>
<span id="el_po_s_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po_s" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po_s->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po_s->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po_s->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po_s->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
<?php echo $po_s->cart_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_s_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $po_s_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_add->MultiPages->isActive("1")) ?>" href="#tab_po_s1"><?php echo $po_s->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_s_add->MultiPages->Parent ?>" id="tab_po_s1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_po_s_quantity" for="x_quantity" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->quantity->caption() ?><?php echo ($po_s->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->quantity->cellAttributes() ?>>
<span id="el_po_s_quantity">
<input type="text" data-table="po_s" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_s->quantity->getPlaceHolder()) ?>" value="<?php echo $po_s->quantity->EditValue ?>"<?php echo $po_s->quantity->editAttributes() ?>>
</span>
<?php echo $po_s->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_po_s_sqm" for="x_sqm" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->sqm->caption() ?><?php echo ($po_s->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->sqm->cellAttributes() ?>>
<span id="el_po_s_sqm">
<input type="text" data-table="po_s" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_s->sqm->getPlaceHolder()) ?>" value="<?php echo $po_s->sqm->EditValue ?>"<?php echo $po_s->sqm->editAttributes() ?>>
</span>
<?php echo $po_s->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_po_s_amount" for="x_amount" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->amount->caption() ?><?php echo ($po_s->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->amount->cellAttributes() ?>>
<span id="el_po_s_amount">
<input type="text" data-table="po_s" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_s->amount->getPlaceHolder()) ?>" value="<?php echo $po_s->amount->EditValue ?>"<?php echo $po_s->amount->editAttributes() ?>>
</span>
<?php echo $po_s->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_po_s_cbm" for="x_cbm" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->cbm->caption() ?><?php echo ($po_s->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->cbm->cellAttributes() ?>>
<span id="el_po_s_cbm">
<input type="text" data-table="po_s" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_s->cbm->getPlaceHolder()) ?>" value="<?php echo $po_s->cbm->EditValue ?>"<?php echo $po_s->cbm->editAttributes() ?>>
</span>
<?php echo $po_s->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label id="elh_po_s_gst" for="x_gst" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->gst->caption() ?><?php echo ($po_s->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->gst->cellAttributes() ?>>
<span id="el_po_s_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_gst" data-page="1" data-value-separator="<?php echo $po_s->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $po_s->gst->editAttributes() ?>>
		<?php echo $po_s->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $po_s->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
<?php echo $po_s->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $po_s_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_add->MultiPages->isActive("2")) ?>" href="#tab_po_s2"><?php echo $po_s->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_s_add->MultiPages->Parent ?>" id="tab_po_s2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_s->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label id="elh_po_s_partner_order_no" for="x_partner_order_no" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->partner_order_no->caption() ?><?php echo ($po_s->partner_order_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->partner_order_no->cellAttributes() ?>>
<span id="el_po_s_partner_order_no">
<input type="text" data-table="po_s" data-field="x_partner_order_no" data-page="2" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $po_s->partner_order_no->EditValue ?>"<?php echo $po_s->partner_order_no->editAttributes() ?>>
</span>
<?php echo $po_s->partner_order_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->partner_order_date->Visible) { // partner_order_date ?>
	<div id="r_partner_order_date" class="form-group row">
		<label id="elh_po_s_partner_order_date" for="x_partner_order_date" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->partner_order_date->caption() ?><?php echo ($po_s->partner_order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->partner_order_date->cellAttributes() ?>>
<span id="el_po_s_partner_order_date">
<input type="text" data-table="po_s" data-field="x_partner_order_date" data-page="2" name="x_partner_order_date" id="x_partner_order_date" placeholder="<?php echo HtmlEncode($po_s->partner_order_date->getPlaceHolder()) ?>" value="<?php echo $po_s->partner_order_date->EditValue ?>"<?php echo $po_s->partner_order_date->editAttributes() ?>>
<?php if (!$po_s->partner_order_date->ReadOnly && !$po_s->partner_order_date->Disabled && !isset($po_s->partner_order_date->EditAttrs["readonly"]) && !isset($po_s->partner_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_sadd", "x_partner_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_s->partner_order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_po_s_despatch_date" for="x_despatch_date" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->despatch_date->caption() ?><?php echo ($po_s->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->despatch_date->cellAttributes() ?>>
<span id="el_po_s_despatch_date">
<input type="text" data-table="po_s" data-field="x_despatch_date" data-page="2" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_s->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_s->despatch_date->EditValue ?>"<?php echo $po_s->despatch_date->editAttributes() ?>>
<?php if (!$po_s->despatch_date->ReadOnly && !$po_s->despatch_date->Disabled && !isset($po_s->despatch_date->EditAttrs["readonly"]) && !isset($po_s->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_sadd", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_s->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_po_s_despatch_week" for="x_despatch_week" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->despatch_week->caption() ?><?php echo ($po_s->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->despatch_week->cellAttributes() ?>>
<span id="el_po_s_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_s->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_s->despatch_week->editAttributes() ?>>
		<?php echo $po_s->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_s->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $po_s->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->fob_date->Visible) { // fob_date ?>
	<div id="r_fob_date" class="form-group row">
		<label id="elh_po_s_fob_date" for="x_fob_date" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->fob_date->caption() ?><?php echo ($po_s->fob_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->fob_date->cellAttributes() ?>>
<span id="el_po_s_fob_date">
<input type="text" data-table="po_s" data-field="x_fob_date" data-page="2" name="x_fob_date" id="x_fob_date" placeholder="<?php echo HtmlEncode($po_s->fob_date->getPlaceHolder()) ?>" value="<?php echo $po_s->fob_date->EditValue ?>"<?php echo $po_s->fob_date->editAttributes() ?>>
<?php if (!$po_s->fob_date->ReadOnly && !$po_s->fob_date->Disabled && !isset($po_s->fob_date->EditAttrs["readonly"]) && !isset($po_s->fob_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_sadd", "x_fob_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_s->fob_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->part_dispatch->Visible) { // part_dispatch ?>
	<div id="r_part_dispatch" class="form-group row">
		<label id="elh_po_s_part_dispatch" for="x_part_dispatch" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->part_dispatch->caption() ?><?php echo ($po_s->part_dispatch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->part_dispatch->cellAttributes() ?>>
<span id="el_po_s_part_dispatch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_part_dispatch" data-page="2" data-value-separator="<?php echo $po_s->part_dispatch->displayValueSeparatorAttribute() ?>" id="x_part_dispatch" name="x_part_dispatch"<?php echo $po_s->part_dispatch->editAttributes() ?>>
		<?php echo $po_s->part_dispatch->selectOptionListHtml("x_part_dispatch") ?>
	</select>
</div>
</span>
<?php echo $po_s->part_dispatch->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_po_s_payment_terms" for="x_payment_terms" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->payment_terms->caption() ?><?php echo ($po_s->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->payment_terms->cellAttributes() ?>>
<span id="el_po_s_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_payment_terms" data-page="2" data-value-separator="<?php echo $po_s->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po_s->payment_terms->editAttributes() ?>>
		<?php echo $po_s->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$po_s->payment_terms->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_payment_terms" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->payment_terms->caption() ?>" data-title="<?php echo $po_s->payment_terms->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_payment_terms',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
<?php echo $po_s->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->transport_type->Visible) { // transport_type ?>
	<div id="r_transport_type" class="form-group row">
		<label id="elh_po_s_transport_type" for="x_transport_type" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->transport_type->caption() ?><?php echo ($po_s->transport_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->transport_type->cellAttributes() ?>>
<span id="el_po_s_transport_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_transport_type" data-page="2" data-value-separator="<?php echo $po_s->transport_type->displayValueSeparatorAttribute() ?>" id="x_transport_type" name="x_transport_type"<?php echo $po_s->transport_type->editAttributes() ?>>
		<?php echo $po_s->transport_type->selectOptionListHtml("x_transport_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$po_s->transport_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_transport_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->transport_type->caption() ?>" data-title="<?php echo $po_s->transport_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_transport_type',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->transport_type->Lookup->getParamTag("p_x_transport_type") ?>
</span>
<?php echo $po_s->transport_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<div id="r_partner_shipping_id" class="form-group row">
		<label id="elh_po_s_partner_shipping_id" for="x_partner_shipping_id" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->partner_shipping_id->caption() ?><?php echo ($po_s->partner_shipping_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->partner_shipping_id->cellAttributes() ?>>
<span id="el_po_s_partner_shipping_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_partner_shipping_id" data-page="2" data-value-separator="<?php echo $po_s->partner_shipping_id->displayValueSeparatorAttribute() ?>" id="x_partner_shipping_id" name="x_partner_shipping_id"<?php echo $po_s->partner_shipping_id->editAttributes() ?>>
		<?php echo $po_s->partner_shipping_id->selectOptionListHtml("x_partner_shipping_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "shipping_address") && !$po_s->partner_shipping_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_partner_shipping_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->partner_shipping_id->caption() ?>" data-title="<?php echo $po_s->partner_shipping_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_partner_shipping_id',url:'shipping_addressaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->partner_shipping_id->Lookup->getParamTag("p_x_partner_shipping_id") ?>
</span>
<?php echo $po_s->partner_shipping_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_po_s_remarks" for="x_remarks" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->remarks->caption() ?><?php echo ($po_s->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->remarks->cellAttributes() ?>>
<span id="el_po_s_remarks">
<textarea data-table="po_s" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_s->remarks->getPlaceHolder()) ?>"<?php echo $po_s->remarks->editAttributes() ?>><?php echo $po_s->remarks->EditValue ?></textarea>
</span>
<?php echo $po_s->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_po_s_buyer_instruction" for="x_buyer_instruction" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->buyer_instruction->caption() ?><?php echo ($po_s->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->buyer_instruction->cellAttributes() ?>>
<span id="el_po_s_buyer_instruction">
<textarea data-table="po_s" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_s->buyer_instruction->getPlaceHolder()) ?>"<?php echo $po_s->buyer_instruction->editAttributes() ?>><?php echo $po_s->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $po_s->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_po_s_production_plan" for="x_production_plan" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->production_plan->caption() ?><?php echo ($po_s->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->production_plan->cellAttributes() ?>>
<span id="el_po_s_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_s->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_s->production_plan->editAttributes() ?>>
		<?php echo $po_s->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
<?php echo $po_s->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_po_s_uploads" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->uploads->caption() ?><?php echo ($po_s->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->uploads->cellAttributes() ?>>
<span id="el_po_s_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $po_s->uploads->title() ? $po_s->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($po_s->uploads->ReadOnly || $po_s->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="po_s" data-field="x_uploads" data-page="2" name="x_uploads" id="x_uploads"<?php echo $po_s->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $po_s->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $po_s->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $po_s->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $po_s->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $po_s_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_add->MultiPages->isActive("3")) ?>" href="#tab_po_s3"><?php echo $po_s->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $po_s_add->MultiPages->Parent ?>" id="tab_po_s3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_s->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label id="elh_po_s_d_09_head" for="x_d_09_head" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->d_09_head->caption() ?><?php echo ($po_s->d_09_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->d_09_head->cellAttributes() ?>>
<span id="el_po_s_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_09_head" data-page="3" data-value-separator="<?php echo $po_s->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po_s->d_09_head->editAttributes() ?>>
		<?php echo $po_s->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_s->d_09_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_09_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->d_09_head->caption() ?>" data-title="<?php echo $po_s->d_09_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_09_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
<?php echo $po_s->d_09_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_po_s_description_09" for="x_description_09" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->description_09->caption() ?><?php echo ($po_s->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->description_09->cellAttributes() ?>>
<span id="el_po_s_description_09">
<input type="text" data-table="po_s" data-field="x_description_09" data-page="3" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_09->getPlaceHolder()) ?>" value="<?php echo $po_s->description_09->EditValue ?>"<?php echo $po_s->description_09->editAttributes() ?>>
</span>
<?php echo $po_s->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label id="elh_po_s_d_10_head" for="x_d_10_head" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->d_10_head->caption() ?><?php echo ($po_s->d_10_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->d_10_head->cellAttributes() ?>>
<span id="el_po_s_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_10_head" data-page="3" data-value-separator="<?php echo $po_s->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po_s->d_10_head->editAttributes() ?>>
		<?php echo $po_s->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_s->d_10_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_10_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->d_10_head->caption() ?>" data-title="<?php echo $po_s->d_10_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_10_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
<?php echo $po_s->d_10_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_po_s_description_10" for="x_description_10" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->description_10->caption() ?><?php echo ($po_s->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->description_10->cellAttributes() ?>>
<span id="el_po_s_description_10">
<input type="text" data-table="po_s" data-field="x_description_10" data-page="3" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_10->getPlaceHolder()) ?>" value="<?php echo $po_s->description_10->EditValue ?>"<?php echo $po_s->description_10->editAttributes() ?>>
</span>
<?php echo $po_s->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label id="elh_po_s_d_11_head" for="x_d_11_head" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->d_11_head->caption() ?><?php echo ($po_s->d_11_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->d_11_head->cellAttributes() ?>>
<span id="el_po_s_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_11_head" data-page="3" data-value-separator="<?php echo $po_s->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po_s->d_11_head->editAttributes() ?>>
		<?php echo $po_s->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_s->d_11_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_11_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->d_11_head->caption() ?>" data-title="<?php echo $po_s->d_11_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_11_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
<?php echo $po_s->d_11_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label id="elh_po_s_description_11" for="x_description_11" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->description_11->caption() ?><?php echo ($po_s->description_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->description_11->cellAttributes() ?>>
<span id="el_po_s_description_11">
<input type="text" data-table="po_s" data-field="x_description_11" data-page="3" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_11->getPlaceHolder()) ?>" value="<?php echo $po_s->description_11->EditValue ?>"<?php echo $po_s->description_11->editAttributes() ?>>
</span>
<?php echo $po_s->description_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label id="elh_po_s_d_12_head" for="x_d_12_head" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->d_12_head->caption() ?><?php echo ($po_s->d_12_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->d_12_head->cellAttributes() ?>>
<span id="el_po_s_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_12_head" data-page="3" data-value-separator="<?php echo $po_s->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po_s->d_12_head->editAttributes() ?>>
		<?php echo $po_s->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_s->d_12_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_12_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_s->d_12_head->caption() ?>" data-title="<?php echo $po_s->d_12_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_12_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_s->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
<?php echo $po_s->d_12_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label id="elh_po_s_description_12" for="x_description_12" class="<?php echo $po_s_add->LeftColumnClass ?>"><?php echo $po_s->description_12->caption() ?><?php echo ($po_s->description_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_s_add->RightColumnClass ?>"><div<?php echo $po_s->description_12->cellAttributes() ?>>
<span id="el_po_s_description_12">
<input type="text" data-table="po_s" data-field="x_description_12" data-page="3" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_12->getPlaceHolder()) ?>" value="<?php echo $po_s->description_12->EditValue ?>"<?php echo $po_s->description_12->editAttributes() ?>>
</span>
<?php echo $po_s->description_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_s_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_s_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_s_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_s_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var order_type =$("#r_order_type input[type='radio']:checked").val();
		if(order_type ==1){
 	     $("#r_cart_id input[type='checkbox']:checked").prop('checked',false);
		 $("#r_cart_id").hide();
	 	 $("#r_cart_id").hide();
		 $("#r_buyer_product_ref").show();
		 $("#r_grp").show();
		 $("#r_s_grp").show();
		 $("#r_product").show();
		 $("#r_rid").show();
		 $("#r_price").show();
		 $("#r_currency").show();
		 $("#r_sample").show();
		 $("#r_description_03").show();
		 $("#r_description_01").show();
		 $("#r_description_02").show();
		 $("#r_description_07").show();
		 $("#r_shape").show();
		 $("#r_w_cm").show();
		 $("#r_l_cm").show();
		 $("#r_h_cm").show();
		 $("#r_buyer_size").show();
		 $("#r_description_04").show();
		 $("#r_description_05").show();
		 $("#r_description_06").show();
		 $("#r_description_08").show();
		 $("#r_description_17").show();
		 $("#r_description_18").show();
		 $("#r_description_19").show();
		 $("#r_description_20").show();
		 $("#r_quantity input[type='text']").removeAttr('readonly');
		} else {
		 $("#r_buyer_product_ref").hide();
		 $("#r_grp").hide();
		 $("#r_s_grp").hide();
		 $("#r_product").hide();
		 $("#r_rid").hide();
		 $("#r_price").hide();
		 $("#r_currency").hide();		 
		 $("#r_sample").hide();
		 $("#r_description_03").hide();
		 $("#r_description_01").hide();
		 $("#r_description_02").hide();
		 $("#r_description_07").hide();
		 $("#r_shape").hide();
		 $("#r_w_cm").hide();
		 $("#r_l_cm").hide();
		 $("#r_h_cm").hide();
		 $("#r_buyer_size").hide();
		 $("#r_description_04").hide();
		 $("#r_description_05").hide();
		 $("#r_description_06").hide();
		 $("#r_description_08").hide();
		 $("#r_description_17").hide();
		 $("#r_description_18").hide();
		 $("#r_description_19").hide();
		 $("#r_description_20").hide();
		 $("#r_cart_id").show();
		 $("#r_quantity input[type='text']").attr('readonly','readonly');
		}
		var checked = getURL('CAID');
		$.getJSON("apcajax.php?povaluecbm_s="+checked,function(data){
		if (checked.length > 0)
		{
		var msg = ('Cart Selection <BR><BR>Total Quantity: '+ data.qty + '<BR>Total Amount: ' + parseFloat(data.amt).toFixed(2) + '<BR>Total CBM: ' + parseFloat(data.cbm).toFixed(2)  + '<BR>Total SQM: ' + parseFloat(data.sqm).toFixed(2));
		$("#elh_po_s_cart_id").html(msg);
		$("#x_quantity").val(data.qty);
		$("#x_cbm").val(parseFloat(data.cbm).toFixed(2));
		$("#x_amount").val(parseFloat(data.amt).toFixed(2));
		$("#x_sqm").val(parseFloat(data.sqm).toFixed(2));
		} else {
		$("#elh_po_s_cart_id").html('Cart Selection');
		$("#x_quantity").val('');
		$("#x_cbm").val('');
		$("#x_amount").val('');
		$("#x_sqm").val('');
		}		
		});	
</script>
<?php include_once "footer.php" ?>
<?php
$po_s_add->terminate();
?>