<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_setup_add = new po_setup_add();

// Run the page
$po_setup_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_setup_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpo_setupadd = currentForm = new ew.Form("fpo_setupadd", "add");

// Validate form
fpo_setupadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_setup_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->id->caption(), $po_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->id->errorMessage()) ?>");
		<?php if ($po_setup_add->gst_included->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_included");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->gst_included->caption(), $po_setup->gst_included->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_b_transfer->Required) { ?>
			elm = this.getElements("x" + infix + "_po_b_transfer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_b_transfer->caption(), $po_setup->po_b_transfer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_b_sample_auto_auth->Required) { ?>
			elm = this.getElements("x" + infix + "_po_b_sample_auto_auth");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_b_sample_auto_auth->caption(), $po_setup->po_b_sample_auto_auth->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_s_sample_auto_auth->Required) { ?>
			elm = this.getElements("x" + infix + "_po_s_sample_auto_auth");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_s_sample_auto_auth->caption(), $po_setup->po_s_sample_auto_auth->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_po_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_cbm->caption(), $po_setup->po_cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_buyer_uid->Required) { ?>
			elm = this.getElements("x" + infix + "_po_buyer_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_buyer_uid->caption(), $po_setup->po_buyer_uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_gst->Required) { ?>
			elm = this.getElements("x" + infix + "_po_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_gst->caption(), $po_setup->po_gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_po_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_sqm->caption(), $po_setup->po_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_prod_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_prod_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_prod_price->caption(), $po_setup->po_prod_price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->po_size->Required) { ?>
			elm = this.getElements("x" + infix + "_po_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_size->caption(), $po_setup->po_size->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_size");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->po_size->errorMessage()) ?>");
		<?php if ($po_setup_add->po_bom->Required) { ?>
			elm = this.getElements("x" + infix + "_po_bom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_bom->caption(), $po_setup->po_bom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_bom");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->po_bom->errorMessage()) ?>");
		<?php if ($po_setup_add->po_process->Required) { ?>
			elm = this.getElements("x" + infix + "_po_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_process->caption(), $po_setup->po_process->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_process");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->po_process->errorMessage()) ?>");
		<?php if ($po_setup_add->po_buyer_code_prod->Required) { ?>
			elm = this.getElements("x" + infix + "_po_buyer_code_prod");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_buyer_code_prod->caption(), $po_setup->po_buyer_code_prod->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_buyer_code_prod");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->po_buyer_code_prod->errorMessage()) ?>");
		<?php if ($po_setup_add->mr_live_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_mr_live_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->mr_live_datetime->caption(), $po_setup->mr_live_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mr_live_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->mr_live_datetime->errorMessage()) ?>");
		<?php if ($po_setup_add->po_b_unauthorize->Required) { ?>
			elm = this.getElements("x" + infix + "_po_b_unauthorize[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->po_b_unauthorize->caption(), $po_setup->po_b_unauthorize->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->cart_b_password->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_b_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->cart_b_password->caption(), $po_setup->cart_b_password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->cart_s_password->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_s_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->cart_s_password->caption(), $po_setup->cart_s_password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_setup_add->jc_po_yesno->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_po_yesno");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_setup->jc_po_yesno->caption(), $po_setup->jc_po_yesno->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_po_yesno");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_setup->jc_po_yesno->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_setupadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_setupadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_setupadd.lists["x_gst_included"] = <?php echo $po_setup_add->gst_included->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_gst_included"].options = <?php echo JsonEncode($po_setup_add->gst_included->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_b_transfer"] = <?php echo $po_setup_add->po_b_transfer->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_b_transfer"].options = <?php echo JsonEncode($po_setup_add->po_b_transfer->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_b_sample_auto_auth"] = <?php echo $po_setup_add->po_b_sample_auto_auth->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_b_sample_auto_auth"].options = <?php echo JsonEncode($po_setup_add->po_b_sample_auto_auth->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_s_sample_auto_auth"] = <?php echo $po_setup_add->po_s_sample_auto_auth->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_s_sample_auto_auth"].options = <?php echo JsonEncode($po_setup_add->po_s_sample_auto_auth->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_cbm"] = <?php echo $po_setup_add->po_cbm->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_cbm"].options = <?php echo JsonEncode($po_setup_add->po_cbm->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_buyer_uid"] = <?php echo $po_setup_add->po_buyer_uid->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_buyer_uid"].options = <?php echo JsonEncode($po_setup_add->po_buyer_uid->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_gst"] = <?php echo $po_setup_add->po_gst->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_gst"].options = <?php echo JsonEncode($po_setup_add->po_gst->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_sqm"] = <?php echo $po_setup_add->po_sqm->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_sqm"].options = <?php echo JsonEncode($po_setup_add->po_sqm->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_prod_price"] = <?php echo $po_setup_add->po_prod_price->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_prod_price"].options = <?php echo JsonEncode($po_setup_add->po_prod_price->options(FALSE, TRUE)) ?>;
fpo_setupadd.lists["x_po_b_unauthorize[]"] = <?php echo $po_setup_add->po_b_unauthorize->Lookup->toClientList() ?>;
fpo_setupadd.lists["x_po_b_unauthorize[]"].options = <?php echo JsonEncode($po_setup_add->po_b_unauthorize->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_setup_add->showPageHeader(); ?>
<?php
$po_setup_add->showMessage();
?>
<form name="fpo_setupadd" id="fpo_setupadd" class="<?php echo $po_setup_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_setup_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_setup_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_setup">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_setup_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($po_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_po_setup_id" for="x_id" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->id->caption() ?><?php echo ($po_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->id->cellAttributes() ?>>
<span id="el_po_setup_id">
<input type="text" data-table="po_setup" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($po_setup->id->getPlaceHolder()) ?>" value="<?php echo $po_setup->id->EditValue ?>"<?php echo $po_setup->id->editAttributes() ?>>
</span>
<?php echo $po_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->gst_included->Visible) { // gst_included ?>
	<div id="r_gst_included" class="form-group row">
		<label id="elh_po_setup_gst_included" for="x_gst_included" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->gst_included->caption() ?><?php echo ($po_setup->gst_included->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->gst_included->cellAttributes() ?>>
<span id="el_po_setup_gst_included">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_gst_included" data-value-separator="<?php echo $po_setup->gst_included->displayValueSeparatorAttribute() ?>" id="x_gst_included" name="x_gst_included"<?php echo $po_setup->gst_included->editAttributes() ?>>
		<?php echo $po_setup->gst_included->selectOptionListHtml("x_gst_included") ?>
	</select>
</div>
</span>
<?php echo $po_setup->gst_included->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_b_transfer->Visible) { // po_b_transfer ?>
	<div id="r_po_b_transfer" class="form-group row">
		<label id="elh_po_setup_po_b_transfer" for="x_po_b_transfer" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_b_transfer->caption() ?><?php echo ($po_setup->po_b_transfer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_b_transfer->cellAttributes() ?>>
<span id="el_po_setup_po_b_transfer">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_b_transfer" data-value-separator="<?php echo $po_setup->po_b_transfer->displayValueSeparatorAttribute() ?>" id="x_po_b_transfer" name="x_po_b_transfer"<?php echo $po_setup->po_b_transfer->editAttributes() ?>>
		<?php echo $po_setup->po_b_transfer->selectOptionListHtml("x_po_b_transfer") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_b_transfer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_b_sample_auto_auth->Visible) { // po_b_sample_auto_auth ?>
	<div id="r_po_b_sample_auto_auth" class="form-group row">
		<label id="elh_po_setup_po_b_sample_auto_auth" for="x_po_b_sample_auto_auth" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_b_sample_auto_auth->caption() ?><?php echo ($po_setup->po_b_sample_auto_auth->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_b_sample_auto_auth->cellAttributes() ?>>
<span id="el_po_setup_po_b_sample_auto_auth">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_b_sample_auto_auth" data-value-separator="<?php echo $po_setup->po_b_sample_auto_auth->displayValueSeparatorAttribute() ?>" id="x_po_b_sample_auto_auth" name="x_po_b_sample_auto_auth"<?php echo $po_setup->po_b_sample_auto_auth->editAttributes() ?>>
		<?php echo $po_setup->po_b_sample_auto_auth->selectOptionListHtml("x_po_b_sample_auto_auth") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_b_sample_auto_auth->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_s_sample_auto_auth->Visible) { // po_s_sample_auto_auth ?>
	<div id="r_po_s_sample_auto_auth" class="form-group row">
		<label id="elh_po_setup_po_s_sample_auto_auth" for="x_po_s_sample_auto_auth" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_s_sample_auto_auth->caption() ?><?php echo ($po_setup->po_s_sample_auto_auth->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_s_sample_auto_auth->cellAttributes() ?>>
<span id="el_po_setup_po_s_sample_auto_auth">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_s_sample_auto_auth" data-value-separator="<?php echo $po_setup->po_s_sample_auto_auth->displayValueSeparatorAttribute() ?>" id="x_po_s_sample_auto_auth" name="x_po_s_sample_auto_auth"<?php echo $po_setup->po_s_sample_auto_auth->editAttributes() ?>>
		<?php echo $po_setup->po_s_sample_auto_auth->selectOptionListHtml("x_po_s_sample_auto_auth") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_s_sample_auto_auth->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_cbm->Visible) { // po_cbm ?>
	<div id="r_po_cbm" class="form-group row">
		<label id="elh_po_setup_po_cbm" for="x_po_cbm" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_cbm->caption() ?><?php echo ($po_setup->po_cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_cbm->cellAttributes() ?>>
<span id="el_po_setup_po_cbm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_cbm" data-value-separator="<?php echo $po_setup->po_cbm->displayValueSeparatorAttribute() ?>" id="x_po_cbm" name="x_po_cbm"<?php echo $po_setup->po_cbm->editAttributes() ?>>
		<?php echo $po_setup->po_cbm->selectOptionListHtml("x_po_cbm") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_buyer_uid->Visible) { // po_buyer_uid ?>
	<div id="r_po_buyer_uid" class="form-group row">
		<label id="elh_po_setup_po_buyer_uid" for="x_po_buyer_uid" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_buyer_uid->caption() ?><?php echo ($po_setup->po_buyer_uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_buyer_uid->cellAttributes() ?>>
<span id="el_po_setup_po_buyer_uid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_buyer_uid" data-value-separator="<?php echo $po_setup->po_buyer_uid->displayValueSeparatorAttribute() ?>" id="x_po_buyer_uid" name="x_po_buyer_uid"<?php echo $po_setup->po_buyer_uid->editAttributes() ?>>
		<?php echo $po_setup->po_buyer_uid->selectOptionListHtml("x_po_buyer_uid") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_buyer_uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_gst->Visible) { // po_gst ?>
	<div id="r_po_gst" class="form-group row">
		<label id="elh_po_setup_po_gst" for="x_po_gst" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_gst->caption() ?><?php echo ($po_setup->po_gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_gst->cellAttributes() ?>>
<span id="el_po_setup_po_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_gst" data-value-separator="<?php echo $po_setup->po_gst->displayValueSeparatorAttribute() ?>" id="x_po_gst" name="x_po_gst"<?php echo $po_setup->po_gst->editAttributes() ?>>
		<?php echo $po_setup->po_gst->selectOptionListHtml("x_po_gst") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_sqm->Visible) { // po_sqm ?>
	<div id="r_po_sqm" class="form-group row">
		<label id="elh_po_setup_po_sqm" for="x_po_sqm" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_sqm->caption() ?><?php echo ($po_setup->po_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_sqm->cellAttributes() ?>>
<span id="el_po_setup_po_sqm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_sqm" data-value-separator="<?php echo $po_setup->po_sqm->displayValueSeparatorAttribute() ?>" id="x_po_sqm" name="x_po_sqm"<?php echo $po_setup->po_sqm->editAttributes() ?>>
		<?php echo $po_setup->po_sqm->selectOptionListHtml("x_po_sqm") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_prod_price->Visible) { // po_prod_price ?>
	<div id="r_po_prod_price" class="form-group row">
		<label id="elh_po_setup_po_prod_price" for="x_po_prod_price" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_prod_price->caption() ?><?php echo ($po_setup->po_prod_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_prod_price->cellAttributes() ?>>
<span id="el_po_setup_po_prod_price">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_prod_price" data-value-separator="<?php echo $po_setup->po_prod_price->displayValueSeparatorAttribute() ?>" id="x_po_prod_price" name="x_po_prod_price"<?php echo $po_setup->po_prod_price->editAttributes() ?>>
		<?php echo $po_setup->po_prod_price->selectOptionListHtml("x_po_prod_price") ?>
	</select>
</div>
</span>
<?php echo $po_setup->po_prod_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_size->Visible) { // po_size ?>
	<div id="r_po_size" class="form-group row">
		<label id="elh_po_setup_po_size" for="x_po_size" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_size->caption() ?><?php echo ($po_setup->po_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_size->cellAttributes() ?>>
<span id="el_po_setup_po_size">
<input type="text" data-table="po_setup" data-field="x_po_size" name="x_po_size" id="x_po_size" size="30" placeholder="<?php echo HtmlEncode($po_setup->po_size->getPlaceHolder()) ?>" value="<?php echo $po_setup->po_size->EditValue ?>"<?php echo $po_setup->po_size->editAttributes() ?>>
</span>
<?php echo $po_setup->po_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_bom->Visible) { // po_bom ?>
	<div id="r_po_bom" class="form-group row">
		<label id="elh_po_setup_po_bom" for="x_po_bom" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_bom->caption() ?><?php echo ($po_setup->po_bom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_bom->cellAttributes() ?>>
<span id="el_po_setup_po_bom">
<input type="text" data-table="po_setup" data-field="x_po_bom" name="x_po_bom" id="x_po_bom" size="30" placeholder="<?php echo HtmlEncode($po_setup->po_bom->getPlaceHolder()) ?>" value="<?php echo $po_setup->po_bom->EditValue ?>"<?php echo $po_setup->po_bom->editAttributes() ?>>
</span>
<?php echo $po_setup->po_bom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_process->Visible) { // po_process ?>
	<div id="r_po_process" class="form-group row">
		<label id="elh_po_setup_po_process" for="x_po_process" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_process->caption() ?><?php echo ($po_setup->po_process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_process->cellAttributes() ?>>
<span id="el_po_setup_po_process">
<input type="text" data-table="po_setup" data-field="x_po_process" name="x_po_process" id="x_po_process" size="30" placeholder="<?php echo HtmlEncode($po_setup->po_process->getPlaceHolder()) ?>" value="<?php echo $po_setup->po_process->EditValue ?>"<?php echo $po_setup->po_process->editAttributes() ?>>
</span>
<?php echo $po_setup->po_process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_buyer_code_prod->Visible) { // po_buyer_code_prod ?>
	<div id="r_po_buyer_code_prod" class="form-group row">
		<label id="elh_po_setup_po_buyer_code_prod" for="x_po_buyer_code_prod" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_buyer_code_prod->caption() ?><?php echo ($po_setup->po_buyer_code_prod->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_buyer_code_prod->cellAttributes() ?>>
<span id="el_po_setup_po_buyer_code_prod">
<input type="text" data-table="po_setup" data-field="x_po_buyer_code_prod" name="x_po_buyer_code_prod" id="x_po_buyer_code_prod" size="30" placeholder="<?php echo HtmlEncode($po_setup->po_buyer_code_prod->getPlaceHolder()) ?>" value="<?php echo $po_setup->po_buyer_code_prod->EditValue ?>"<?php echo $po_setup->po_buyer_code_prod->editAttributes() ?>>
</span>
<?php echo $po_setup->po_buyer_code_prod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->mr_live_datetime->Visible) { // mr_live_datetime ?>
	<div id="r_mr_live_datetime" class="form-group row">
		<label id="elh_po_setup_mr_live_datetime" for="x_mr_live_datetime" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->mr_live_datetime->caption() ?><?php echo ($po_setup->mr_live_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->mr_live_datetime->cellAttributes() ?>>
<span id="el_po_setup_mr_live_datetime">
<input type="text" data-table="po_setup" data-field="x_mr_live_datetime" name="x_mr_live_datetime" id="x_mr_live_datetime" placeholder="<?php echo HtmlEncode($po_setup->mr_live_datetime->getPlaceHolder()) ?>" value="<?php echo $po_setup->mr_live_datetime->EditValue ?>"<?php echo $po_setup->mr_live_datetime->editAttributes() ?>>
<?php if (!$po_setup->mr_live_datetime->ReadOnly && !$po_setup->mr_live_datetime->Disabled && !isset($po_setup->mr_live_datetime->EditAttrs["readonly"]) && !isset($po_setup->mr_live_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_setupadd", "x_mr_live_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_setup->mr_live_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->po_b_unauthorize->Visible) { // po_b_unauthorize ?>
	<div id="r_po_b_unauthorize" class="form-group row">
		<label id="elh_po_setup_po_b_unauthorize" for="x_po_b_unauthorize" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->po_b_unauthorize->caption() ?><?php echo ($po_setup->po_b_unauthorize->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->po_b_unauthorize->cellAttributes() ?>>
<span id="el_po_setup_po_b_unauthorize">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_setup" data-field="x_po_b_unauthorize" data-value-separator="<?php echo $po_setup->po_b_unauthorize->displayValueSeparatorAttribute() ?>" id="x_po_b_unauthorize[]" name="x_po_b_unauthorize[]" multiple="multiple"<?php echo $po_setup->po_b_unauthorize->editAttributes() ?>>
		<?php echo $po_setup->po_b_unauthorize->selectOptionListHtml("x_po_b_unauthorize[]") ?>
	</select>
</div>
<?php echo $po_setup->po_b_unauthorize->Lookup->getParamTag("p_x_po_b_unauthorize") ?>
</span>
<?php echo $po_setup->po_b_unauthorize->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->cart_b_password->Visible) { // cart_b_password ?>
	<div id="r_cart_b_password" class="form-group row">
		<label id="elh_po_setup_cart_b_password" for="x_cart_b_password" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->cart_b_password->caption() ?><?php echo ($po_setup->cart_b_password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->cart_b_password->cellAttributes() ?>>
<span id="el_po_setup_cart_b_password">
<input type="text" data-table="po_setup" data-field="x_cart_b_password" name="x_cart_b_password" id="x_cart_b_password" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($po_setup->cart_b_password->getPlaceHolder()) ?>" value="<?php echo $po_setup->cart_b_password->EditValue ?>"<?php echo $po_setup->cart_b_password->editAttributes() ?>>
</span>
<?php echo $po_setup->cart_b_password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->cart_s_password->Visible) { // cart_s_password ?>
	<div id="r_cart_s_password" class="form-group row">
		<label id="elh_po_setup_cart_s_password" for="x_cart_s_password" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->cart_s_password->caption() ?><?php echo ($po_setup->cart_s_password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->cart_s_password->cellAttributes() ?>>
<span id="el_po_setup_cart_s_password">
<input type="text" data-table="po_setup" data-field="x_cart_s_password" name="x_cart_s_password" id="x_cart_s_password" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($po_setup->cart_s_password->getPlaceHolder()) ?>" value="<?php echo $po_setup->cart_s_password->EditValue ?>"<?php echo $po_setup->cart_s_password->editAttributes() ?>>
</span>
<?php echo $po_setup->cart_s_password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_setup->jc_po_yesno->Visible) { // jc_po_yesno ?>
	<div id="r_jc_po_yesno" class="form-group row">
		<label id="elh_po_setup_jc_po_yesno" for="x_jc_po_yesno" class="<?php echo $po_setup_add->LeftColumnClass ?>"><?php echo $po_setup->jc_po_yesno->caption() ?><?php echo ($po_setup->jc_po_yesno->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_setup_add->RightColumnClass ?>"><div<?php echo $po_setup->jc_po_yesno->cellAttributes() ?>>
<span id="el_po_setup_jc_po_yesno">
<input type="text" data-table="po_setup" data-field="x_jc_po_yesno" name="x_jc_po_yesno" id="x_jc_po_yesno" size="30" placeholder="<?php echo HtmlEncode($po_setup->jc_po_yesno->getPlaceHolder()) ?>" value="<?php echo $po_setup->jc_po_yesno->EditValue ?>"<?php echo $po_setup->jc_po_yesno->editAttributes() ?>>
</span>
<?php echo $po_setup->jc_po_yesno->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_setup_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_setup_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_setup_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_setup_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_setup_add->terminate();
?>