<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_setup_list = new po_setup_list();

// Run the page
$po_setup_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_setup_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_setuplist = currentForm = new ew.Form("fpo_setuplist", "list");
fpo_setuplist.formKeyCountName = '<?php echo $po_setup_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_setuplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_setuplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_setuplist.lists["x_gst_included"] = <?php echo $po_setup_list->gst_included->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_gst_included"].options = <?php echo JsonEncode($po_setup_list->gst_included->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_b_transfer"] = <?php echo $po_setup_list->po_b_transfer->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_b_transfer"].options = <?php echo JsonEncode($po_setup_list->po_b_transfer->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_b_sample_auto_auth"] = <?php echo $po_setup_list->po_b_sample_auto_auth->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_b_sample_auto_auth"].options = <?php echo JsonEncode($po_setup_list->po_b_sample_auto_auth->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_s_sample_auto_auth"] = <?php echo $po_setup_list->po_s_sample_auto_auth->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_s_sample_auto_auth"].options = <?php echo JsonEncode($po_setup_list->po_s_sample_auto_auth->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_cbm"] = <?php echo $po_setup_list->po_cbm->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_cbm"].options = <?php echo JsonEncode($po_setup_list->po_cbm->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_buyer_uid"] = <?php echo $po_setup_list->po_buyer_uid->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_buyer_uid"].options = <?php echo JsonEncode($po_setup_list->po_buyer_uid->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_gst"] = <?php echo $po_setup_list->po_gst->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_gst"].options = <?php echo JsonEncode($po_setup_list->po_gst->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_sqm"] = <?php echo $po_setup_list->po_sqm->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_sqm"].options = <?php echo JsonEncode($po_setup_list->po_sqm->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_prod_price"] = <?php echo $po_setup_list->po_prod_price->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_prod_price"].options = <?php echo JsonEncode($po_setup_list->po_prod_price->options(FALSE, TRUE)) ?>;
fpo_setuplist.lists["x_po_b_unauthorize[]"] = <?php echo $po_setup_list->po_b_unauthorize->Lookup->toClientList() ?>;
fpo_setuplist.lists["x_po_b_unauthorize[]"].options = <?php echo JsonEncode($po_setup_list->po_b_unauthorize->lookupOptions()) ?>;

// Form object for search
var fpo_setuplistsrch = currentSearchForm = new ew.Form("fpo_setuplistsrch");

// Filters
fpo_setuplistsrch.filterList = <?php echo $po_setup_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_setuplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_setup_list->TotalRecs > 0 && $po_setup_list->ExportOptions->visible()) { ?>
<?php $po_setup_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_setup_list->ImportOptions->visible()) { ?>
<?php $po_setup_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_setup_list->SearchOptions->visible()) { ?>
<?php $po_setup_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_setup_list->FilterOptions->visible()) { ?>
<?php $po_setup_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_setup_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_setup->isExport() && !$po_setup->CurrentAction) { ?>
<form name="fpo_setuplistsrch" id="fpo_setuplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_setup_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_setuplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_setup">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_setup_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_setup_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_setup_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_setup_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_setup_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_setup_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_setup_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_setup_list->showPageHeader(); ?>
<?php
$po_setup_list->showMessage();
?>
<?php if ($po_setup_list->TotalRecs > 0 || $po_setup->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_setup_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_setup">
<?php if (!$po_setup->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_setup_list->Pager)) $po_setup_list->Pager = new PrevNextPager($po_setup_list->StartRec, $po_setup_list->DisplayRecs, $po_setup_list->TotalRecs, $po_setup_list->AutoHidePager) ?>
<?php if ($po_setup_list->Pager->RecordCount > 0 && $po_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_setup_list->TotalRecs > 0 && (!$po_setup_list->AutoHidePageSizeSelector || $po_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_setuplist" id="fpo_setuplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_setup_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_setup_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_setup">
<div id="gmp_po_setup" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_setup_list->TotalRecs > 0 || $po_setup->isGridEdit()) { ?>
<table id="tbl_po_setuplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_setup_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_setup_list->renderListOptions();

// Render list options (header, left)
$po_setup_list->ListOptions->render("header", "left");
?>
<?php if ($po_setup->id->Visible) { // id ?>
	<?php if ($po_setup->sortUrl($po_setup->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_setup->id->headerCellClass() ?>"><div id="elh_po_setup_id" class="po_setup_id"><div class="ew-table-header-caption"><?php echo $po_setup->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_setup->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->id) ?>',2);"><div id="elh_po_setup_id" class="po_setup_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->gst_included->Visible) { // gst_included ?>
	<?php if ($po_setup->sortUrl($po_setup->gst_included) == "") { ?>
		<th data-name="gst_included" class="<?php echo $po_setup->gst_included->headerCellClass() ?>"><div id="elh_po_setup_gst_included" class="po_setup_gst_included"><div class="ew-table-header-caption"><?php echo $po_setup->gst_included->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst_included" class="<?php echo $po_setup->gst_included->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->gst_included) ?>',2);"><div id="elh_po_setup_gst_included" class="po_setup_gst_included">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->gst_included->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->gst_included->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->gst_included->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_b_transfer->Visible) { // po_b_transfer ?>
	<?php if ($po_setup->sortUrl($po_setup->po_b_transfer) == "") { ?>
		<th data-name="po_b_transfer" class="<?php echo $po_setup->po_b_transfer->headerCellClass() ?>"><div id="elh_po_setup_po_b_transfer" class="po_setup_po_b_transfer"><div class="ew-table-header-caption"><?php echo $po_setup->po_b_transfer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_b_transfer" class="<?php echo $po_setup->po_b_transfer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_b_transfer) ?>',2);"><div id="elh_po_setup_po_b_transfer" class="po_setup_po_b_transfer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_b_transfer->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_b_transfer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_b_transfer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_b_sample_auto_auth->Visible) { // po_b_sample_auto_auth ?>
	<?php if ($po_setup->sortUrl($po_setup->po_b_sample_auto_auth) == "") { ?>
		<th data-name="po_b_sample_auto_auth" class="<?php echo $po_setup->po_b_sample_auto_auth->headerCellClass() ?>"><div id="elh_po_setup_po_b_sample_auto_auth" class="po_setup_po_b_sample_auto_auth"><div class="ew-table-header-caption"><?php echo $po_setup->po_b_sample_auto_auth->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_b_sample_auto_auth" class="<?php echo $po_setup->po_b_sample_auto_auth->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_b_sample_auto_auth) ?>',2);"><div id="elh_po_setup_po_b_sample_auto_auth" class="po_setup_po_b_sample_auto_auth">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_b_sample_auto_auth->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_b_sample_auto_auth->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_b_sample_auto_auth->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_s_sample_auto_auth->Visible) { // po_s_sample_auto_auth ?>
	<?php if ($po_setup->sortUrl($po_setup->po_s_sample_auto_auth) == "") { ?>
		<th data-name="po_s_sample_auto_auth" class="<?php echo $po_setup->po_s_sample_auto_auth->headerCellClass() ?>"><div id="elh_po_setup_po_s_sample_auto_auth" class="po_setup_po_s_sample_auto_auth"><div class="ew-table-header-caption"><?php echo $po_setup->po_s_sample_auto_auth->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_s_sample_auto_auth" class="<?php echo $po_setup->po_s_sample_auto_auth->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_s_sample_auto_auth) ?>',2);"><div id="elh_po_setup_po_s_sample_auto_auth" class="po_setup_po_s_sample_auto_auth">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_s_sample_auto_auth->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_s_sample_auto_auth->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_s_sample_auto_auth->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_cbm->Visible) { // po_cbm ?>
	<?php if ($po_setup->sortUrl($po_setup->po_cbm) == "") { ?>
		<th data-name="po_cbm" class="<?php echo $po_setup->po_cbm->headerCellClass() ?>"><div id="elh_po_setup_po_cbm" class="po_setup_po_cbm"><div class="ew-table-header-caption"><?php echo $po_setup->po_cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_cbm" class="<?php echo $po_setup->po_cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_cbm) ?>',2);"><div id="elh_po_setup_po_cbm" class="po_setup_po_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_buyer_uid->Visible) { // po_buyer_uid ?>
	<?php if ($po_setup->sortUrl($po_setup->po_buyer_uid) == "") { ?>
		<th data-name="po_buyer_uid" class="<?php echo $po_setup->po_buyer_uid->headerCellClass() ?>"><div id="elh_po_setup_po_buyer_uid" class="po_setup_po_buyer_uid"><div class="ew-table-header-caption"><?php echo $po_setup->po_buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_buyer_uid" class="<?php echo $po_setup->po_buyer_uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_buyer_uid) ?>',2);"><div id="elh_po_setup_po_buyer_uid" class="po_setup_po_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_buyer_uid->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_gst->Visible) { // po_gst ?>
	<?php if ($po_setup->sortUrl($po_setup->po_gst) == "") { ?>
		<th data-name="po_gst" class="<?php echo $po_setup->po_gst->headerCellClass() ?>"><div id="elh_po_setup_po_gst" class="po_setup_po_gst"><div class="ew-table-header-caption"><?php echo $po_setup->po_gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_gst" class="<?php echo $po_setup->po_gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_gst) ?>',2);"><div id="elh_po_setup_po_gst" class="po_setup_po_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_sqm->Visible) { // po_sqm ?>
	<?php if ($po_setup->sortUrl($po_setup->po_sqm) == "") { ?>
		<th data-name="po_sqm" class="<?php echo $po_setup->po_sqm->headerCellClass() ?>"><div id="elh_po_setup_po_sqm" class="po_setup_po_sqm"><div class="ew-table-header-caption"><?php echo $po_setup->po_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_sqm" class="<?php echo $po_setup->po_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_sqm) ?>',2);"><div id="elh_po_setup_po_sqm" class="po_setup_po_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_prod_price->Visible) { // po_prod_price ?>
	<?php if ($po_setup->sortUrl($po_setup->po_prod_price) == "") { ?>
		<th data-name="po_prod_price" class="<?php echo $po_setup->po_prod_price->headerCellClass() ?>"><div id="elh_po_setup_po_prod_price" class="po_setup_po_prod_price"><div class="ew-table-header-caption"><?php echo $po_setup->po_prod_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_prod_price" class="<?php echo $po_setup->po_prod_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_prod_price) ?>',2);"><div id="elh_po_setup_po_prod_price" class="po_setup_po_prod_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_prod_price->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_prod_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_prod_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_size->Visible) { // po_size ?>
	<?php if ($po_setup->sortUrl($po_setup->po_size) == "") { ?>
		<th data-name="po_size" class="<?php echo $po_setup->po_size->headerCellClass() ?>"><div id="elh_po_setup_po_size" class="po_setup_po_size"><div class="ew-table-header-caption"><?php echo $po_setup->po_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_size" class="<?php echo $po_setup->po_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_size) ?>',2);"><div id="elh_po_setup_po_size" class="po_setup_po_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_size->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_bom->Visible) { // po_bom ?>
	<?php if ($po_setup->sortUrl($po_setup->po_bom) == "") { ?>
		<th data-name="po_bom" class="<?php echo $po_setup->po_bom->headerCellClass() ?>"><div id="elh_po_setup_po_bom" class="po_setup_po_bom"><div class="ew-table-header-caption"><?php echo $po_setup->po_bom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_bom" class="<?php echo $po_setup->po_bom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_bom) ?>',2);"><div id="elh_po_setup_po_bom" class="po_setup_po_bom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_bom->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_bom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_bom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_process->Visible) { // po_process ?>
	<?php if ($po_setup->sortUrl($po_setup->po_process) == "") { ?>
		<th data-name="po_process" class="<?php echo $po_setup->po_process->headerCellClass() ?>"><div id="elh_po_setup_po_process" class="po_setup_po_process"><div class="ew-table-header-caption"><?php echo $po_setup->po_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_process" class="<?php echo $po_setup->po_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_process) ?>',2);"><div id="elh_po_setup_po_process" class="po_setup_po_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_buyer_code_prod->Visible) { // po_buyer_code_prod ?>
	<?php if ($po_setup->sortUrl($po_setup->po_buyer_code_prod) == "") { ?>
		<th data-name="po_buyer_code_prod" class="<?php echo $po_setup->po_buyer_code_prod->headerCellClass() ?>"><div id="elh_po_setup_po_buyer_code_prod" class="po_setup_po_buyer_code_prod"><div class="ew-table-header-caption"><?php echo $po_setup->po_buyer_code_prod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_buyer_code_prod" class="<?php echo $po_setup->po_buyer_code_prod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_buyer_code_prod) ?>',2);"><div id="elh_po_setup_po_buyer_code_prod" class="po_setup_po_buyer_code_prod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_buyer_code_prod->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_buyer_code_prod->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_buyer_code_prod->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->mr_live_datetime->Visible) { // mr_live_datetime ?>
	<?php if ($po_setup->sortUrl($po_setup->mr_live_datetime) == "") { ?>
		<th data-name="mr_live_datetime" class="<?php echo $po_setup->mr_live_datetime->headerCellClass() ?>"><div id="elh_po_setup_mr_live_datetime" class="po_setup_mr_live_datetime"><div class="ew-table-header-caption"><?php echo $po_setup->mr_live_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mr_live_datetime" class="<?php echo $po_setup->mr_live_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->mr_live_datetime) ?>',2);"><div id="elh_po_setup_mr_live_datetime" class="po_setup_mr_live_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->mr_live_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->mr_live_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->mr_live_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->po_b_unauthorize->Visible) { // po_b_unauthorize ?>
	<?php if ($po_setup->sortUrl($po_setup->po_b_unauthorize) == "") { ?>
		<th data-name="po_b_unauthorize" class="<?php echo $po_setup->po_b_unauthorize->headerCellClass() ?>"><div id="elh_po_setup_po_b_unauthorize" class="po_setup_po_b_unauthorize"><div class="ew-table-header-caption"><?php echo $po_setup->po_b_unauthorize->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_b_unauthorize" class="<?php echo $po_setup->po_b_unauthorize->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->po_b_unauthorize) ?>',2);"><div id="elh_po_setup_po_b_unauthorize" class="po_setup_po_b_unauthorize">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->po_b_unauthorize->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->po_b_unauthorize->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->po_b_unauthorize->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->cart_b_password->Visible) { // cart_b_password ?>
	<?php if ($po_setup->sortUrl($po_setup->cart_b_password) == "") { ?>
		<th data-name="cart_b_password" class="<?php echo $po_setup->cart_b_password->headerCellClass() ?>"><div id="elh_po_setup_cart_b_password" class="po_setup_cart_b_password"><div class="ew-table-header-caption"><?php echo $po_setup->cart_b_password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_b_password" class="<?php echo $po_setup->cart_b_password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->cart_b_password) ?>',2);"><div id="elh_po_setup_cart_b_password" class="po_setup_cart_b_password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->cart_b_password->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_setup->cart_b_password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->cart_b_password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->cart_s_password->Visible) { // cart_s_password ?>
	<?php if ($po_setup->sortUrl($po_setup->cart_s_password) == "") { ?>
		<th data-name="cart_s_password" class="<?php echo $po_setup->cart_s_password->headerCellClass() ?>"><div id="elh_po_setup_cart_s_password" class="po_setup_cart_s_password"><div class="ew-table-header-caption"><?php echo $po_setup->cart_s_password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_s_password" class="<?php echo $po_setup->cart_s_password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->cart_s_password) ?>',2);"><div id="elh_po_setup_cart_s_password" class="po_setup_cart_s_password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->cart_s_password->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_setup->cart_s_password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->cart_s_password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_setup->jc_po_yesno->Visible) { // jc_po_yesno ?>
	<?php if ($po_setup->sortUrl($po_setup->jc_po_yesno) == "") { ?>
		<th data-name="jc_po_yesno" class="<?php echo $po_setup->jc_po_yesno->headerCellClass() ?>"><div id="elh_po_setup_jc_po_yesno" class="po_setup_jc_po_yesno"><div class="ew-table-header-caption"><?php echo $po_setup->jc_po_yesno->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_po_yesno" class="<?php echo $po_setup->jc_po_yesno->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_setup->SortUrl($po_setup->jc_po_yesno) ?>',2);"><div id="elh_po_setup_jc_po_yesno" class="po_setup_jc_po_yesno">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_setup->jc_po_yesno->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_setup->jc_po_yesno->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_setup->jc_po_yesno->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_setup_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_setup->ExportAll && $po_setup->isExport()) {
	$po_setup_list->StopRec = $po_setup_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_setup_list->TotalRecs > $po_setup_list->StartRec + $po_setup_list->DisplayRecs - 1)
		$po_setup_list->StopRec = $po_setup_list->StartRec + $po_setup_list->DisplayRecs - 1;
	else
		$po_setup_list->StopRec = $po_setup_list->TotalRecs;
}
$po_setup_list->RecCnt = $po_setup_list->StartRec - 1;
if ($po_setup_list->Recordset && !$po_setup_list->Recordset->EOF) {
	$po_setup_list->Recordset->moveFirst();
	$selectLimit = $po_setup_list->UseSelectLimit;
	if (!$selectLimit && $po_setup_list->StartRec > 1)
		$po_setup_list->Recordset->move($po_setup_list->StartRec - 1);
} elseif (!$po_setup->AllowAddDeleteRow && $po_setup_list->StopRec == 0) {
	$po_setup_list->StopRec = $po_setup->GridAddRowCount;
}

// Initialize aggregate
$po_setup->RowType = ROWTYPE_AGGREGATEINIT;
$po_setup->resetAttributes();
$po_setup_list->renderRow();
while ($po_setup_list->RecCnt < $po_setup_list->StopRec) {
	$po_setup_list->RecCnt++;
	if ($po_setup_list->RecCnt >= $po_setup_list->StartRec) {
		$po_setup_list->RowCnt++;

		// Set up key count
		$po_setup_list->KeyCount = $po_setup_list->RowIndex;

		// Init row class and style
		$po_setup->resetAttributes();
		$po_setup->CssClass = "";
		if ($po_setup->isGridAdd()) {
		} else {
			$po_setup_list->loadRowValues($po_setup_list->Recordset); // Load row values
		}
		$po_setup->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_setup->RowAttrs = array_merge($po_setup->RowAttrs, array('data-rowindex'=>$po_setup_list->RowCnt, 'id'=>'r' . $po_setup_list->RowCnt . '_po_setup', 'data-rowtype'=>$po_setup->RowType));

		// Render row
		$po_setup_list->renderRow();

		// Render list options
		$po_setup_list->renderListOptions();
?>
	<tr<?php echo $po_setup->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_setup_list->ListOptions->render("body", "left", $po_setup_list->RowCnt);
?>
	<?php if ($po_setup->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_setup->id->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_id" class="po_setup_id">
<span<?php echo $po_setup->id->viewAttributes() ?>>
<?php echo $po_setup->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->gst_included->Visible) { // gst_included ?>
		<td data-name="gst_included"<?php echo $po_setup->gst_included->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_gst_included" class="po_setup_gst_included">
<span<?php echo $po_setup->gst_included->viewAttributes() ?>>
<?php echo $po_setup->gst_included->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_b_transfer->Visible) { // po_b_transfer ?>
		<td data-name="po_b_transfer"<?php echo $po_setup->po_b_transfer->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_b_transfer" class="po_setup_po_b_transfer">
<span<?php echo $po_setup->po_b_transfer->viewAttributes() ?>>
<?php echo $po_setup->po_b_transfer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_b_sample_auto_auth->Visible) { // po_b_sample_auto_auth ?>
		<td data-name="po_b_sample_auto_auth"<?php echo $po_setup->po_b_sample_auto_auth->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_b_sample_auto_auth" class="po_setup_po_b_sample_auto_auth">
<span<?php echo $po_setup->po_b_sample_auto_auth->viewAttributes() ?>>
<?php echo $po_setup->po_b_sample_auto_auth->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_s_sample_auto_auth->Visible) { // po_s_sample_auto_auth ?>
		<td data-name="po_s_sample_auto_auth"<?php echo $po_setup->po_s_sample_auto_auth->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_s_sample_auto_auth" class="po_setup_po_s_sample_auto_auth">
<span<?php echo $po_setup->po_s_sample_auto_auth->viewAttributes() ?>>
<?php echo $po_setup->po_s_sample_auto_auth->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_cbm->Visible) { // po_cbm ?>
		<td data-name="po_cbm"<?php echo $po_setup->po_cbm->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_cbm" class="po_setup_po_cbm">
<span<?php echo $po_setup->po_cbm->viewAttributes() ?>>
<?php echo $po_setup->po_cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_buyer_uid->Visible) { // po_buyer_uid ?>
		<td data-name="po_buyer_uid"<?php echo $po_setup->po_buyer_uid->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_buyer_uid" class="po_setup_po_buyer_uid">
<span<?php echo $po_setup->po_buyer_uid->viewAttributes() ?>>
<?php echo $po_setup->po_buyer_uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_gst->Visible) { // po_gst ?>
		<td data-name="po_gst"<?php echo $po_setup->po_gst->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_gst" class="po_setup_po_gst">
<span<?php echo $po_setup->po_gst->viewAttributes() ?>>
<?php echo $po_setup->po_gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_sqm->Visible) { // po_sqm ?>
		<td data-name="po_sqm"<?php echo $po_setup->po_sqm->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_sqm" class="po_setup_po_sqm">
<span<?php echo $po_setup->po_sqm->viewAttributes() ?>>
<?php echo $po_setup->po_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_prod_price->Visible) { // po_prod_price ?>
		<td data-name="po_prod_price"<?php echo $po_setup->po_prod_price->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_prod_price" class="po_setup_po_prod_price">
<span<?php echo $po_setup->po_prod_price->viewAttributes() ?>>
<?php echo $po_setup->po_prod_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_size->Visible) { // po_size ?>
		<td data-name="po_size"<?php echo $po_setup->po_size->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_size" class="po_setup_po_size">
<span<?php echo $po_setup->po_size->viewAttributes() ?>>
<?php echo $po_setup->po_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_bom->Visible) { // po_bom ?>
		<td data-name="po_bom"<?php echo $po_setup->po_bom->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_bom" class="po_setup_po_bom">
<span<?php echo $po_setup->po_bom->viewAttributes() ?>>
<?php echo $po_setup->po_bom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_process->Visible) { // po_process ?>
		<td data-name="po_process"<?php echo $po_setup->po_process->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_process" class="po_setup_po_process">
<span<?php echo $po_setup->po_process->viewAttributes() ?>>
<?php echo $po_setup->po_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_buyer_code_prod->Visible) { // po_buyer_code_prod ?>
		<td data-name="po_buyer_code_prod"<?php echo $po_setup->po_buyer_code_prod->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_buyer_code_prod" class="po_setup_po_buyer_code_prod">
<span<?php echo $po_setup->po_buyer_code_prod->viewAttributes() ?>>
<?php echo $po_setup->po_buyer_code_prod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->mr_live_datetime->Visible) { // mr_live_datetime ?>
		<td data-name="mr_live_datetime"<?php echo $po_setup->mr_live_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_mr_live_datetime" class="po_setup_mr_live_datetime">
<span<?php echo $po_setup->mr_live_datetime->viewAttributes() ?>>
<?php echo $po_setup->mr_live_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->po_b_unauthorize->Visible) { // po_b_unauthorize ?>
		<td data-name="po_b_unauthorize"<?php echo $po_setup->po_b_unauthorize->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_po_b_unauthorize" class="po_setup_po_b_unauthorize">
<span<?php echo $po_setup->po_b_unauthorize->viewAttributes() ?>>
<?php echo $po_setup->po_b_unauthorize->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->cart_b_password->Visible) { // cart_b_password ?>
		<td data-name="cart_b_password"<?php echo $po_setup->cart_b_password->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_cart_b_password" class="po_setup_cart_b_password">
<span<?php echo $po_setup->cart_b_password->viewAttributes() ?>>
<?php echo $po_setup->cart_b_password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->cart_s_password->Visible) { // cart_s_password ?>
		<td data-name="cart_s_password"<?php echo $po_setup->cart_s_password->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_cart_s_password" class="po_setup_cart_s_password">
<span<?php echo $po_setup->cart_s_password->viewAttributes() ?>>
<?php echo $po_setup->cart_s_password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_setup->jc_po_yesno->Visible) { // jc_po_yesno ?>
		<td data-name="jc_po_yesno"<?php echo $po_setup->jc_po_yesno->cellAttributes() ?>>
<span id="el<?php echo $po_setup_list->RowCnt ?>_po_setup_jc_po_yesno" class="po_setup_jc_po_yesno">
<span<?php echo $po_setup->jc_po_yesno->viewAttributes() ?>>
<?php echo $po_setup->jc_po_yesno->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_setup_list->ListOptions->render("body", "right", $po_setup_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_setup->isGridAdd())
		$po_setup_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_setup->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_setup_list->Recordset)
	$po_setup_list->Recordset->Close();
?>
<?php if (!$po_setup->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_setup_list->Pager)) $po_setup_list->Pager = new PrevNextPager($po_setup_list->StartRec, $po_setup_list->DisplayRecs, $po_setup_list->TotalRecs, $po_setup_list->AutoHidePager) ?>
<?php if ($po_setup_list->Pager->RecordCount > 0 && $po_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_setup_list->pageUrl() ?>start=<?php echo $po_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_setup_list->TotalRecs > 0 && (!$po_setup_list->AutoHidePageSizeSelector || $po_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_setup_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_setup_list->TotalRecs == 0 && !$po_setup->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_setup_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_setup->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_setup", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_setup_list->terminate();
?>