<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_list = new po_s_list();

// Run the page
$po_s_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_s->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_slist = currentForm = new ew.Form("fpo_slist", "list");
fpo_slist.formKeyCountName = '<?php echo $po_s_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_slist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_slist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_slist.lists["x_company_id"] = <?php echo $po_s_list->company_id->Lookup->toClientList() ?>;
fpo_slist.lists["x_company_id"].options = <?php echo JsonEncode($po_s_list->company_id->lookupOptions()) ?>;
fpo_slist.lists["x_partner_id"] = <?php echo $po_s_list->partner_id->Lookup->toClientList() ?>;
fpo_slist.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_list->partner_id->lookupOptions()) ?>;
fpo_slist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_slist.lists["x_copy"] = <?php echo $po_s_list->copy->Lookup->toClientList() ?>;
fpo_slist.lists["x_copy"].options = <?php echo JsonEncode($po_s_list->copy->lookupOptions()) ?>;
fpo_slist.lists["x_gst"] = <?php echo $po_s_list->gst->Lookup->toClientList() ?>;
fpo_slist.lists["x_gst"].options = <?php echo JsonEncode($po_s_list->gst->lookupOptions()) ?>;
fpo_slist.lists["x_despatch_week"] = <?php echo $po_s_list->despatch_week->Lookup->toClientList() ?>;
fpo_slist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_s_list->despatch_week->lookupOptions()) ?>;
fpo_slist.lists["x_payment_terms"] = <?php echo $po_s_list->payment_terms->Lookup->toClientList() ?>;
fpo_slist.lists["x_payment_terms"].options = <?php echo JsonEncode($po_s_list->payment_terms->lookupOptions()) ?>;
fpo_slist.lists["x_transport_type"] = <?php echo $po_s_list->transport_type->Lookup->toClientList() ?>;
fpo_slist.lists["x_transport_type"].options = <?php echo JsonEncode($po_s_list->transport_type->lookupOptions()) ?>;
fpo_slist.lists["x_partner_shipping_id"] = <?php echo $po_s_list->partner_shipping_id->Lookup->toClientList() ?>;
fpo_slist.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_s_list->partner_shipping_id->lookupOptions()) ?>;
fpo_slist.lists["x_operator"] = <?php echo $po_s_list->operator->Lookup->toClientList() ?>;
fpo_slist.lists["x_operator"].options = <?php echo JsonEncode($po_s_list->operator->lookupOptions()) ?>;
fpo_slist.lists["x_a_operator"] = <?php echo $po_s_list->a_operator->Lookup->toClientList() ?>;
fpo_slist.lists["x_a_operator"].options = <?php echo JsonEncode($po_s_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fpo_slistsrch = currentSearchForm = new ew.Form("fpo_slistsrch");

// Validate function for search
fpo_slistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_slistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_slistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_slistsrch.lists["x_partner_id"] = <?php echo $po_s_list->partner_id->Lookup->toClientList() ?>;
fpo_slistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_list->partner_id->lookupOptions()) ?>;
fpo_slistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpo_slistsrch.filterList = <?php echo $po_s_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_slistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_s->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_s_list->TotalRecs > 0 && $po_s_list->ExportOptions->visible()) { ?>
<?php $po_s_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_list->ImportOptions->visible()) { ?>
<?php $po_s_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_list->SearchOptions->visible()) { ?>
<?php $po_s_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_s_list->FilterOptions->visible()) { ?>
<?php $po_s_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_s_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_s->isExport() && !$po_s->CurrentAction) { ?>
<form name="fpo_slistsrch" id="fpo_slistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_s_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_slistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_s">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_s_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_s->RowType = ROWTYPE_SEARCH;

// Render row
$po_s->resetAttributes();
$po_s_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_s->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $po_s->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_s" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_s->po->getPlaceHolder()) ?>" value="<?php echo $po_s->po->EditValue ?>"<?php echo $po_s->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($po_s->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_s->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>"<?php echo $po_s->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_s" data-field="x_partner_id" data-value-separator="<?php echo $po_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_s->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_slistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_s_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_s_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_s_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_s_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_s_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_s_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_s_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_s_list->showPageHeader(); ?>
<?php
$po_s_list->showMessage();
?>
<?php if ($po_s_list->TotalRecs > 0 || $po_s->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_s_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_s">
<?php if (!$po_s->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_list->Pager)) $po_s_list->Pager = new PrevNextPager($po_s_list->StartRec, $po_s_list->DisplayRecs, $po_s_list->TotalRecs, $po_s_list->AutoHidePager) ?>
<?php if ($po_s_list->Pager->RecordCount > 0 && $po_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_list->TotalRecs > 0 && (!$po_s_list->AutoHidePageSizeSelector || $po_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_slist" id="fpo_slist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s">
<div id="gmp_po_s" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_s_list->TotalRecs > 0 || $po_s->isGridEdit()) { ?>
<table id="tbl_po_slist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_s_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_s_list->renderListOptions();

// Render list options (header, left)
$po_s_list->ListOptions->render("header", "left");
?>
<?php if ($po_s->id->Visible) { // id ?>
	<?php if ($po_s->sortUrl($po_s->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_s->id->headerCellClass() ?>"><div id="elh_po_s_id" class="po_s_id"><div class="ew-table-header-caption"><?php echo $po_s->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_s->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->id) ?>',2);"><div id="elh_po_s_id" class="po_s_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->po->Visible) { // po ?>
	<?php if ($po_s->sortUrl($po_s->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_s->po->headerCellClass() ?>"><div id="elh_po_s_po" class="po_s_po"><div class="ew-table-header-caption"><?php echo $po_s->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_s->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->po) ?>',2);"><div id="elh_po_s_po" class="po_s_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->company_id->Visible) { // company_id ?>
	<?php if ($po_s->sortUrl($po_s->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_s->company_id->headerCellClass() ?>"><div id="elh_po_s_company_id" class="po_s_company_id"><div class="ew-table-header-caption"><?php echo $po_s->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_s->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->company_id) ?>',2);"><div id="elh_po_s_company_id" class="po_s_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->partner_id->Visible) { // partner_id ?>
	<?php if ($po_s->sortUrl($po_s->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_s->partner_id->headerCellClass() ?>"><div id="elh_po_s_partner_id" class="po_s_partner_id"><div class="ew-table-header-caption"><?php echo $po_s->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_s->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->partner_id) ?>',2);"><div id="elh_po_s_partner_id" class="po_s_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_s->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->copy->Visible) { // copy ?>
	<?php if ($po_s->sortUrl($po_s->copy) == "") { ?>
		<th data-name="copy" class="<?php echo $po_s->copy->headerCellClass() ?>"><div id="elh_po_s_copy" class="po_s_copy"><div class="ew-table-header-caption"><?php echo $po_s->copy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="copy" class="<?php echo $po_s->copy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->copy) ?>',2);"><div id="elh_po_s_copy" class="po_s_copy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->copy->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->copy->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->copy->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->quantity->Visible) { // quantity ?>
	<?php if ($po_s->sortUrl($po_s->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_s->quantity->headerCellClass() ?>"><div id="elh_po_s_quantity" class="po_s_quantity"><div class="ew-table-header-caption"><?php echo $po_s->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_s->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->quantity) ?>',2);"><div id="elh_po_s_quantity" class="po_s_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->sqm->Visible) { // sqm ?>
	<?php if ($po_s->sortUrl($po_s->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_s->sqm->headerCellClass() ?>"><div id="elh_po_s_sqm" class="po_s_sqm"><div class="ew-table-header-caption"><?php echo $po_s->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_s->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->sqm) ?>',2);"><div id="elh_po_s_sqm" class="po_s_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->amount->Visible) { // amount ?>
	<?php if ($po_s->sortUrl($po_s->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $po_s->amount->headerCellClass() ?>"><div id="elh_po_s_amount" class="po_s_amount"><div class="ew-table-header-caption"><?php echo $po_s->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $po_s->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->amount) ?>',2);"><div id="elh_po_s_amount" class="po_s_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->cbm->Visible) { // cbm ?>
	<?php if ($po_s->sortUrl($po_s->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $po_s->cbm->headerCellClass() ?>"><div id="elh_po_s_cbm" class="po_s_cbm"><div class="ew-table-header-caption"><?php echo $po_s->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $po_s->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->cbm) ?>',2);"><div id="elh_po_s_cbm" class="po_s_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->gst->Visible) { // gst ?>
	<?php if ($po_s->sortUrl($po_s->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $po_s->gst->headerCellClass() ?>"><div id="elh_po_s_gst" class="po_s_gst"><div class="ew-table-header-caption"><?php echo $po_s->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $po_s->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->gst) ?>',2);"><div id="elh_po_s_gst" class="po_s_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_s->sortUrl($po_s->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_s->despatch_date->headerCellClass() ?>"><div id="elh_po_s_despatch_date" class="po_s_despatch_date"><div class="ew-table-header-caption"><?php echo $po_s->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_s->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->despatch_date) ?>',2);"><div id="elh_po_s_despatch_date" class="po_s_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_s->sortUrl($po_s->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_s->despatch_week->headerCellClass() ?>"><div id="elh_po_s_despatch_week" class="po_s_despatch_week"><div class="ew-table-header-caption"><?php echo $po_s->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_s->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->despatch_week) ?>',2);"><div id="elh_po_s_despatch_week" class="po_s_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->fob_date->Visible) { // fob_date ?>
	<?php if ($po_s->sortUrl($po_s->fob_date) == "") { ?>
		<th data-name="fob_date" class="<?php echo $po_s->fob_date->headerCellClass() ?>"><div id="elh_po_s_fob_date" class="po_s_fob_date"><div class="ew-table-header-caption"><?php echo $po_s->fob_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fob_date" class="<?php echo $po_s->fob_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->fob_date) ?>',2);"><div id="elh_po_s_fob_date" class="po_s_fob_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->fob_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->fob_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->fob_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->payment_terms->Visible) { // payment_terms ?>
	<?php if ($po_s->sortUrl($po_s->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $po_s->payment_terms->headerCellClass() ?>"><div id="elh_po_s_payment_terms" class="po_s_payment_terms"><div class="ew-table-header-caption"><?php echo $po_s->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $po_s->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->payment_terms) ?>',2);"><div id="elh_po_s_payment_terms" class="po_s_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->transport_type->Visible) { // transport_type ?>
	<?php if ($po_s->sortUrl($po_s->transport_type) == "") { ?>
		<th data-name="transport_type" class="<?php echo $po_s->transport_type->headerCellClass() ?>"><div id="elh_po_s_transport_type" class="po_s_transport_type"><div class="ew-table-header-caption"><?php echo $po_s->transport_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transport_type" class="<?php echo $po_s->transport_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->transport_type) ?>',2);"><div id="elh_po_s_transport_type" class="po_s_transport_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->transport_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->transport_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->transport_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<?php if ($po_s->sortUrl($po_s->partner_shipping_id) == "") { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_s->partner_shipping_id->headerCellClass() ?>"><div id="elh_po_s_partner_shipping_id" class="po_s_partner_shipping_id"><div class="ew-table-header-caption"><?php echo $po_s->partner_shipping_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_s->partner_shipping_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->partner_shipping_id) ?>',2);"><div id="elh_po_s_partner_shipping_id" class="po_s_partner_shipping_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->partner_shipping_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->partner_shipping_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->partner_shipping_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->operator->Visible) { // operator ?>
	<?php if ($po_s->sortUrl($po_s->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $po_s->operator->headerCellClass() ?>"><div id="elh_po_s_operator" class="po_s_operator"><div class="ew-table-header-caption"><?php echo $po_s->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $po_s->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->operator) ?>',2);"><div id="elh_po_s_operator" class="po_s_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->datetime->Visible) { // datetime ?>
	<?php if ($po_s->sortUrl($po_s->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $po_s->datetime->headerCellClass() ?>"><div id="elh_po_s_datetime" class="po_s_datetime"><div class="ew-table-header-caption"><?php echo $po_s->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $po_s->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->datetime) ?>',2);"><div id="elh_po_s_datetime" class="po_s_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->a_operator->Visible) { // a_operator ?>
	<?php if ($po_s->sortUrl($po_s->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po_s->a_operator->headerCellClass() ?>"><div id="elh_po_s_a_operator" class="po_s_a_operator"><div class="ew-table-header-caption"><?php echo $po_s->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po_s->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->a_operator) ?>',2);"><div id="elh_po_s_a_operator" class="po_s_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_s->a_datetime->Visible) { // a_datetime ?>
	<?php if ($po_s->sortUrl($po_s->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $po_s->a_datetime->headerCellClass() ?>"><div id="elh_po_s_a_datetime" class="po_s_a_datetime"><div class="ew-table-header-caption"><?php echo $po_s->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $po_s->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_s->SortUrl($po_s->a_datetime) ?>',2);"><div id="elh_po_s_a_datetime" class="po_s_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_s->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_s->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_s->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_s_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_s->ExportAll && $po_s->isExport()) {
	$po_s_list->StopRec = $po_s_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_s_list->TotalRecs > $po_s_list->StartRec + $po_s_list->DisplayRecs - 1)
		$po_s_list->StopRec = $po_s_list->StartRec + $po_s_list->DisplayRecs - 1;
	else
		$po_s_list->StopRec = $po_s_list->TotalRecs;
}
$po_s_list->RecCnt = $po_s_list->StartRec - 1;
if ($po_s_list->Recordset && !$po_s_list->Recordset->EOF) {
	$po_s_list->Recordset->moveFirst();
	$selectLimit = $po_s_list->UseSelectLimit;
	if (!$selectLimit && $po_s_list->StartRec > 1)
		$po_s_list->Recordset->move($po_s_list->StartRec - 1);
} elseif (!$po_s->AllowAddDeleteRow && $po_s_list->StopRec == 0) {
	$po_s_list->StopRec = $po_s->GridAddRowCount;
}

// Initialize aggregate
$po_s->RowType = ROWTYPE_AGGREGATEINIT;
$po_s->resetAttributes();
$po_s_list->renderRow();
while ($po_s_list->RecCnt < $po_s_list->StopRec) {
	$po_s_list->RecCnt++;
	if ($po_s_list->RecCnt >= $po_s_list->StartRec) {
		$po_s_list->RowCnt++;

		// Set up key count
		$po_s_list->KeyCount = $po_s_list->RowIndex;

		// Init row class and style
		$po_s->resetAttributes();
		$po_s->CssClass = "";
		if ($po_s->isGridAdd()) {
		} else {
			$po_s_list->loadRowValues($po_s_list->Recordset); // Load row values
		}
		$po_s->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_s->RowAttrs = array_merge($po_s->RowAttrs, array('data-rowindex'=>$po_s_list->RowCnt, 'id'=>'r' . $po_s_list->RowCnt . '_po_s', 'data-rowtype'=>$po_s->RowType));

		// Render row
		$po_s_list->renderRow();

		// Render list options
		$po_s_list->renderListOptions();
?>
	<tr<?php echo $po_s->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_s_list->ListOptions->render("body", "left", $po_s_list->RowCnt);
?>
	<?php if ($po_s->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_s->id->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_id" class="po_s_id">
<span<?php echo $po_s->id->viewAttributes() ?>>
<?php echo $po_s->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_s->po->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_po" class="po_s_po">
<span<?php echo $po_s->po->viewAttributes() ?>>
<?php if ((!EmptyString($po_s->po->getViewValue())) && $po_s->po->linkAttributes() <> "") { ?>
<a<?php echo $po_s->po->linkAttributes() ?>><?php echo $po_s->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_s->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_s->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_company_id" class="po_s_company_id">
<span<?php echo $po_s->company_id->viewAttributes() ?>>
<?php echo $po_s->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_s->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_partner_id" class="po_s_partner_id">
<span<?php echo $po_s->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_s->partner_id->getViewValue())) && $po_s->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $po_s->partner_id->linkAttributes() ?>><?php echo $po_s->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_s->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->copy->Visible) { // copy ?>
		<td data-name="copy"<?php echo $po_s->copy->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_copy" class="po_s_copy">
<span<?php echo $po_s->copy->viewAttributes() ?>>
<?php echo $po_s->copy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_s->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_quantity" class="po_s_quantity">
<span<?php echo $po_s->quantity->viewAttributes() ?>>
<?php echo $po_s->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_s->sqm->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_sqm" class="po_s_sqm">
<span<?php echo $po_s->sqm->viewAttributes() ?>>
<?php echo $po_s->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $po_s->amount->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_amount" class="po_s_amount">
<span<?php echo $po_s->amount->viewAttributes() ?>>
<?php echo $po_s->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $po_s->cbm->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_cbm" class="po_s_cbm">
<span<?php echo $po_s->cbm->viewAttributes() ?>>
<?php echo $po_s->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $po_s->gst->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_gst" class="po_s_gst">
<span<?php echo $po_s->gst->viewAttributes() ?>>
<?php echo $po_s->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_s->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_despatch_date" class="po_s_despatch_date">
<span<?php echo $po_s->despatch_date->viewAttributes() ?>>
<?php echo $po_s->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_s->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_despatch_week" class="po_s_despatch_week">
<span<?php echo $po_s->despatch_week->viewAttributes() ?>>
<?php echo $po_s->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->fob_date->Visible) { // fob_date ?>
		<td data-name="fob_date"<?php echo $po_s->fob_date->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_fob_date" class="po_s_fob_date">
<span<?php echo $po_s->fob_date->viewAttributes() ?>>
<?php echo $po_s->fob_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $po_s->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_payment_terms" class="po_s_payment_terms">
<span<?php echo $po_s->payment_terms->viewAttributes() ?>>
<?php if ((!EmptyString($po_s->payment_terms->getViewValue())) && $po_s->payment_terms->linkAttributes() <> "") { ?>
<a<?php echo $po_s->payment_terms->linkAttributes() ?>><?php echo $po_s->payment_terms->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_s->payment_terms->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->transport_type->Visible) { // transport_type ?>
		<td data-name="transport_type"<?php echo $po_s->transport_type->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_transport_type" class="po_s_transport_type">
<span<?php echo $po_s->transport_type->viewAttributes() ?>>
<?php if ((!EmptyString($po_s->transport_type->getViewValue())) && $po_s->transport_type->linkAttributes() <> "") { ?>
<a<?php echo $po_s->transport_type->linkAttributes() ?>><?php echo $po_s->transport_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_s->transport_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->partner_shipping_id->Visible) { // partner_shipping_id ?>
		<td data-name="partner_shipping_id"<?php echo $po_s->partner_shipping_id->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_partner_shipping_id" class="po_s_partner_shipping_id">
<span<?php echo $po_s->partner_shipping_id->viewAttributes() ?>>
<?php echo $po_s->partner_shipping_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $po_s->operator->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_operator" class="po_s_operator">
<span<?php echo $po_s->operator->viewAttributes() ?>>
<?php echo $po_s->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $po_s->datetime->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_datetime" class="po_s_datetime">
<span<?php echo $po_s->datetime->viewAttributes() ?>>
<?php echo $po_s->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po_s->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_a_operator" class="po_s_a_operator">
<span<?php echo $po_s->a_operator->viewAttributes() ?>>
<?php echo $po_s->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_s->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $po_s->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_s_list->RowCnt ?>_po_s_a_datetime" class="po_s_a_datetime">
<span<?php echo $po_s->a_datetime->viewAttributes() ?>>
<?php echo $po_s->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_s_list->ListOptions->render("body", "right", $po_s_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_s->isGridAdd())
		$po_s_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_s->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_s_list->Recordset)
	$po_s_list->Recordset->Close();
?>
<?php if (!$po_s->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_s->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_s_list->Pager)) $po_s_list->Pager = new PrevNextPager($po_s_list->StartRec, $po_s_list->DisplayRecs, $po_s_list->TotalRecs, $po_s_list->AutoHidePager) ?>
<?php if ($po_s_list->Pager->RecordCount > 0 && $po_s_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_s_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_s_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_s_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_s_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_s_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_s_list->pageUrl() ?>start=<?php echo $po_s_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_s_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_s_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_s_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_s_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_s_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_s_list->TotalRecs > 0 && (!$po_s_list->AutoHidePageSizeSelector || $po_s_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_s">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_s_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_s_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_s_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_s_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_s_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_s->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_s_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_s_list->TotalRecs == 0 && !$po_s->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_s_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_s_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_s->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_s->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_s", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_s_list->terminate();
?>