<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_s_search = new po_s_search();

// Run the page
$po_s_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_s_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_s_search->IsModal) { ?>
var fpo_ssearch = currentAdvancedSearchForm = new ew.Form("fpo_ssearch", "search");
<?php } else { ?>
var fpo_ssearch = currentForm = new ew.Form("fpo_ssearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_ssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_ssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_ssearch.multiPage = new ew.MultiPage("fpo_ssearch");

// Dynamic selection lists
fpo_ssearch.lists["x_company_id"] = <?php echo $po_s_search->company_id->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_company_id"].options = <?php echo JsonEncode($po_s_search->company_id->lookupOptions()) ?>;
fpo_ssearch.lists["x_partner_id"] = <?php echo $po_s_search->partner_id->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_s_search->partner_id->lookupOptions()) ?>;
fpo_ssearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_ssearch.lists["x_copy"] = <?php echo $po_s_search->copy->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_copy"].options = <?php echo JsonEncode($po_s_search->copy->lookupOptions()) ?>;
fpo_ssearch.lists["x_cart_id[]"] = <?php echo $po_s_search->cart_id->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_s_search->cart_id->lookupOptions()) ?>;
fpo_ssearch.lists["x_gst"] = <?php echo $po_s_search->gst->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_gst"].options = <?php echo JsonEncode($po_s_search->gst->lookupOptions()) ?>;
fpo_ssearch.lists["x_despatch_week"] = <?php echo $po_s_search->despatch_week->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_despatch_week"].options = <?php echo JsonEncode($po_s_search->despatch_week->lookupOptions()) ?>;
fpo_ssearch.lists["x_payment_terms"] = <?php echo $po_s_search->payment_terms->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_payment_terms"].options = <?php echo JsonEncode($po_s_search->payment_terms->lookupOptions()) ?>;
fpo_ssearch.lists["x_transport_type"] = <?php echo $po_s_search->transport_type->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_transport_type"].options = <?php echo JsonEncode($po_s_search->transport_type->lookupOptions()) ?>;
fpo_ssearch.lists["x_partner_shipping_id"] = <?php echo $po_s_search->partner_shipping_id->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_s_search->partner_shipping_id->lookupOptions()) ?>;
fpo_ssearch.lists["x_operator"] = <?php echo $po_s_search->operator->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_operator"].options = <?php echo JsonEncode($po_s_search->operator->lookupOptions()) ?>;
fpo_ssearch.lists["x_a_operator"] = <?php echo $po_s_search->a_operator->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_a_operator"].options = <?php echo JsonEncode($po_s_search->a_operator->lookupOptions()) ?>;
fpo_ssearch.lists["x_d_09_head"] = <?php echo $po_s_search->d_09_head->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_d_09_head"].options = <?php echo JsonEncode($po_s_search->d_09_head->lookupOptions()) ?>;
fpo_ssearch.lists["x_d_10_head"] = <?php echo $po_s_search->d_10_head->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_d_10_head"].options = <?php echo JsonEncode($po_s_search->d_10_head->lookupOptions()) ?>;
fpo_ssearch.lists["x_d_11_head"] = <?php echo $po_s_search->d_11_head->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_d_11_head"].options = <?php echo JsonEncode($po_s_search->d_11_head->lookupOptions()) ?>;
fpo_ssearch.lists["x_d_12_head"] = <?php echo $po_s_search->d_12_head->Lookup->toClientList() ?>;
fpo_ssearch.lists["x_d_12_head"].options = <?php echo JsonEncode($po_s_search->d_12_head->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_ssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_s->cbm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_s_search->showPageHeader(); ?>
<?php
$po_s_search->showMessage();
?>
<form name="fpo_ssearch" id="fpo_ssearch" class="<?php echo $po_s_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_s_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_s_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_s">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_s_search->IsModal ?>">
<?php if ($po_s_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($po_s->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_id"><?php echo $po_s->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->id->cellAttributes() ?>>
			<span id="el_po_s_id">
<input type="text" data-table="po_s" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_s->id->getPlaceHolder()) ?>" value="<?php echo $po_s->id->EditValue ?>"<?php echo $po_s->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_po"><?php echo $po_s->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->po->cellAttributes() ?>>
			<span id="el_po_s_po">
<input type="text" data-table="po_s" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_s->po->getPlaceHolder()) ?>" value="<?php echo $po_s->po->EditValue ?>"<?php echo $po_s->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_company_id"><?php echo $po_s->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->company_id->cellAttributes() ?>>
			<span id="el_po_s_company_id">
<?php $po_s->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_s->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_company_id" data-page="0" data-value-separator="<?php echo $po_s->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_s->company_id->editAttributes() ?>>
		<?php echo $po_s->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_s->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_partner_id"><?php echo $po_s->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->partner_id->cellAttributes() ?>>
			<span id="el_po_s_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_s->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_s->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_s->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_s->partner_id->getPlaceHolder()) ?>"<?php echo $po_s->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_s" data-field="x_partner_id" data-page="0" data-value-separator="<?php echo $po_s->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_s->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_ssearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_s->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->copy->Visible) { // copy ?>
	<div id="r_copy" class="form-group row">
		<label for="x_copy" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_copy"><?php echo $po_s->copy->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_copy" id="z_copy" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->copy->cellAttributes() ?>>
			<span id="el_po_s_copy">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_copy" data-page="0" data-value-separator="<?php echo $po_s->copy->displayValueSeparatorAttribute() ?>" id="x_copy" name="x_copy"<?php echo $po_s->copy->editAttributes() ?>>
		<?php echo $po_s->copy->selectOptionListHtml("x_copy") ?>
	</select>
</div>
<?php echo $po_s->copy->Lookup->getParamTag("p_x_copy") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_cart_id"><?php echo $po_s->cart_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cart_id" id="z_cart_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->cart_id->cellAttributes() ?>>
			<span id="el_po_s_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po_s" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po_s->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po_s->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po_s->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po_s->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_s_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $po_s_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_search->MultiPages->isActive("1")) ?>" href="#tab_po_s1"><?php echo $po_s->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_s_search->MultiPages->Parent ?>" id="tab_po_s1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_quantity"><?php echo $po_s->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->quantity->cellAttributes() ?>>
			<span id="el_po_s_quantity">
<input type="text" data-table="po_s" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_s->quantity->getPlaceHolder()) ?>" value="<?php echo $po_s->quantity->EditValue ?>"<?php echo $po_s->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_sqm"><?php echo $po_s->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->sqm->cellAttributes() ?>>
			<span id="el_po_s_sqm">
<input type="text" data-table="po_s" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_s->sqm->getPlaceHolder()) ?>" value="<?php echo $po_s->sqm->EditValue ?>"<?php echo $po_s->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_amount"><?php echo $po_s->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->amount->cellAttributes() ?>>
			<span id="el_po_s_amount">
<input type="text" data-table="po_s" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_s->amount->getPlaceHolder()) ?>" value="<?php echo $po_s->amount->EditValue ?>"<?php echo $po_s->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_cbm"><?php echo $po_s->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->cbm->cellAttributes() ?>>
			<span id="el_po_s_cbm">
<input type="text" data-table="po_s" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_s->cbm->getPlaceHolder()) ?>" value="<?php echo $po_s->cbm->EditValue ?>"<?php echo $po_s->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_gst"><?php echo $po_s->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst" id="z_gst" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->gst->cellAttributes() ?>>
			<span id="el_po_s_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_gst" data-page="1" data-value-separator="<?php echo $po_s->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $po_s->gst->editAttributes() ?>>
		<?php echo $po_s->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $po_s->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_s_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_search->MultiPages->isActive("2")) ?>" href="#tab_po_s2"><?php echo $po_s->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_s_search->MultiPages->Parent ?>" id="tab_po_s2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_despatch_week"><?php echo $po_s->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->despatch_week->cellAttributes() ?>>
			<span id="el_po_s_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_s->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_s->despatch_week->editAttributes() ?>>
		<?php echo $po_s->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_s->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_payment_terms"><?php echo $po_s->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->payment_terms->cellAttributes() ?>>
			<span id="el_po_s_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_payment_terms" data-page="2" data-value-separator="<?php echo $po_s->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po_s->payment_terms->editAttributes() ?>>
		<?php echo $po_s->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
</div>
<?php echo $po_s->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->transport_type->Visible) { // transport_type ?>
	<div id="r_transport_type" class="form-group row">
		<label for="x_transport_type" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_transport_type"><?php echo $po_s->transport_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_transport_type" id="z_transport_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->transport_type->cellAttributes() ?>>
			<span id="el_po_s_transport_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_transport_type" data-page="2" data-value-separator="<?php echo $po_s->transport_type->displayValueSeparatorAttribute() ?>" id="x_transport_type" name="x_transport_type"<?php echo $po_s->transport_type->editAttributes() ?>>
		<?php echo $po_s->transport_type->selectOptionListHtml("x_transport_type") ?>
	</select>
</div>
<?php echo $po_s->transport_type->Lookup->getParamTag("p_x_transport_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<div id="r_partner_shipping_id" class="form-group row">
		<label for="x_partner_shipping_id" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_partner_shipping_id"><?php echo $po_s->partner_shipping_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_shipping_id" id="z_partner_shipping_id" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->partner_shipping_id->cellAttributes() ?>>
			<span id="el_po_s_partner_shipping_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_partner_shipping_id" data-page="2" data-value-separator="<?php echo $po_s->partner_shipping_id->displayValueSeparatorAttribute() ?>" id="x_partner_shipping_id" name="x_partner_shipping_id"<?php echo $po_s->partner_shipping_id->editAttributes() ?>>
		<?php echo $po_s->partner_shipping_id->selectOptionListHtml("x_partner_shipping_id") ?>
	</select>
</div>
<?php echo $po_s->partner_shipping_id->Lookup->getParamTag("p_x_partner_shipping_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_remarks"><?php echo $po_s->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->remarks->cellAttributes() ?>>
			<span id="el_po_s_remarks">
<input type="text" data-table="po_s" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($po_s->remarks->getPlaceHolder()) ?>" value="<?php echo $po_s->remarks->EditValue ?>"<?php echo $po_s->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_buyer_instruction"><?php echo $po_s->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->buyer_instruction->cellAttributes() ?>>
			<span id="el_po_s_buyer_instruction">
<input type="text" data-table="po_s" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($po_s->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $po_s->buyer_instruction->EditValue ?>"<?php echo $po_s->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_s_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_search->MultiPages->isActive("3")) ?>" href="#tab_po_s3"><?php echo $po_s->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $po_s_search->MultiPages->Parent ?>" id="tab_po_s3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label for="x_d_09_head" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_d_09_head"><?php echo $po_s->d_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_09_head" id="z_d_09_head" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->d_09_head->cellAttributes() ?>>
			<span id="el_po_s_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_09_head" data-page="3" data-value-separator="<?php echo $po_s->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po_s->d_09_head->editAttributes() ?>>
		<?php echo $po_s->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
</div>
<?php echo $po_s->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label for="x_description_09" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_description_09"><?php echo $po_s->description_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_09" id="z_description_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->description_09->cellAttributes() ?>>
			<span id="el_po_s_description_09">
<input type="text" data-table="po_s" data-field="x_description_09" data-page="3" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_09->getPlaceHolder()) ?>" value="<?php echo $po_s->description_09->EditValue ?>"<?php echo $po_s->description_09->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label for="x_d_10_head" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_d_10_head"><?php echo $po_s->d_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_10_head" id="z_d_10_head" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->d_10_head->cellAttributes() ?>>
			<span id="el_po_s_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_10_head" data-page="3" data-value-separator="<?php echo $po_s->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po_s->d_10_head->editAttributes() ?>>
		<?php echo $po_s->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
</div>
<?php echo $po_s->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label for="x_description_10" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_description_10"><?php echo $po_s->description_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_10" id="z_description_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->description_10->cellAttributes() ?>>
			<span id="el_po_s_description_10">
<input type="text" data-table="po_s" data-field="x_description_10" data-page="3" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_10->getPlaceHolder()) ?>" value="<?php echo $po_s->description_10->EditValue ?>"<?php echo $po_s->description_10->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label for="x_d_11_head" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_d_11_head"><?php echo $po_s->d_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_11_head" id="z_d_11_head" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->d_11_head->cellAttributes() ?>>
			<span id="el_po_s_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_11_head" data-page="3" data-value-separator="<?php echo $po_s->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po_s->d_11_head->editAttributes() ?>>
		<?php echo $po_s->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
</div>
<?php echo $po_s->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label for="x_description_11" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_description_11"><?php echo $po_s->description_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_11" id="z_description_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->description_11->cellAttributes() ?>>
			<span id="el_po_s_description_11">
<input type="text" data-table="po_s" data-field="x_description_11" data-page="3" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_11->getPlaceHolder()) ?>" value="<?php echo $po_s->description_11->EditValue ?>"<?php echo $po_s->description_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label for="x_d_12_head" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_d_12_head"><?php echo $po_s->d_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_12_head" id="z_d_12_head" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->d_12_head->cellAttributes() ?>>
			<span id="el_po_s_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_d_12_head" data-page="3" data-value-separator="<?php echo $po_s->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po_s->d_12_head->editAttributes() ?>>
		<?php echo $po_s->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
</div>
<?php echo $po_s->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label for="x_description_12" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_description_12"><?php echo $po_s->description_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_12" id="z_description_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->description_12->cellAttributes() ?>>
			<span id="el_po_s_description_12">
<input type="text" data-table="po_s" data-field="x_description_12" data-page="3" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_s->description_12->getPlaceHolder()) ?>" value="<?php echo $po_s->description_12->EditValue ?>"<?php echo $po_s->description_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_s_search->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_s_search->MultiPages->isActive("4")) ?>" href="#tab_po_s4"><?php echo $po_s->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_s_search->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $po_s_search->MultiPages->Parent ?>" id="tab_po_s4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_s->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_operator"><?php echo $po_s->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->operator->cellAttributes() ?>>
			<span id="el_po_s_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_operator" data-page="4" data-value-separator="<?php echo $po_s->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $po_s->operator->editAttributes() ?>>
		<?php echo $po_s->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $po_s->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_datetime"><?php echo $po_s->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->datetime->cellAttributes() ?>>
			<span id="el_po_s_datetime">
<input type="text" data-table="po_s" data-field="x_datetime" data-page="4" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($po_s->datetime->getPlaceHolder()) ?>" value="<?php echo $po_s->datetime->EditValue ?>"<?php echo $po_s->datetime->editAttributes() ?>>
<?php if (!$po_s->datetime->ReadOnly && !$po_s->datetime->Disabled && !isset($po_s->datetime->EditAttrs["readonly"]) && !isset($po_s->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_ssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_a_operator"><?php echo $po_s->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->a_operator->cellAttributes() ?>>
			<span id="el_po_s_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_s" data-field="x_a_operator" data-page="4" data-value-separator="<?php echo $po_s->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $po_s->a_operator->editAttributes() ?>>
		<?php echo $po_s->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $po_s->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_s->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_s_search->LeftColumnClass ?>"><span id="elh_po_s_a_datetime"><?php echo $po_s->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_s_search->RightColumnClass ?>"><div<?php echo $po_s->a_datetime->cellAttributes() ?>>
			<span id="el_po_s_a_datetime">
<input type="text" data-table="po_s" data-field="x_a_datetime" data-page="4" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po_s->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po_s->a_datetime->EditValue ?>"<?php echo $po_s->a_datetime->editAttributes() ?>>
<?php if (!$po_s->a_datetime->ReadOnly && !$po_s->a_datetime->Disabled && !isset($po_s->a_datetime->EditAttrs["readonly"]) && !isset($po_s->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_ssearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_s_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_s_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_s_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_s_search->terminate();
?>