<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_status_add = new po_status_add();

// Run the page
$po_status_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_status_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpo_statusadd = currentForm = new ew.Form("fpo_statusadd", "add");

// Validate form
fpo_statusadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_status_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->po->caption(), $po_status->po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_status->po->errorMessage()) ?>");
		<?php if ($po_status_add->delivery_date->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->delivery_date->caption(), $po_status->delivery_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delivery_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_status->delivery_date->errorMessage()) ?>");
		<?php if ($po_status_add->reminder_date->Required) { ?>
			elm = this.getElements("x" + infix + "_reminder_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->reminder_date->caption(), $po_status->reminder_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_reminder_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_status->reminder_date->errorMessage()) ?>");
		<?php if ($po_status_add->reminder_for->Required) { ?>
			elm = this.getElements("x" + infix + "_reminder_for");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->reminder_for->caption(), $po_status->reminder_for->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_add->po_current_status->Required) { ?>
			elm = this.getElements("x" + infix + "_po_current_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->po_current_status->caption(), $po_status->po_current_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_add->pp_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->pp_operator->caption(), $po_status->pp_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_add->pp_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->pp_datetime->caption(), $po_status->pp_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_statusadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_statusadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_status_add->showPageHeader(); ?>
<?php
$po_status_add->showMessage();
?>
<form name="fpo_statusadd" id="fpo_statusadd" class="<?php echo $po_status_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_status_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_status_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_status">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_status_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($po_status->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_status_po" for="x_po" class="<?php echo $po_status_add->LeftColumnClass ?>"><?php echo $po_status->po->caption() ?><?php echo ($po_status->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_add->RightColumnClass ?>"><div<?php echo $po_status->po->cellAttributes() ?>>
<span id="el_po_status_po">
<input type="text" data-table="po_status" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_status->po->getPlaceHolder()) ?>" value="<?php echo $po_status->po->EditValue ?>"<?php echo $po_status->po->editAttributes() ?>>
</span>
<?php echo $po_status->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->delivery_date->Visible) { // delivery_date ?>
	<div id="r_delivery_date" class="form-group row">
		<label id="elh_po_status_delivery_date" for="x_delivery_date" class="<?php echo $po_status_add->LeftColumnClass ?>"><?php echo $po_status->delivery_date->caption() ?><?php echo ($po_status->delivery_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_add->RightColumnClass ?>"><div<?php echo $po_status->delivery_date->cellAttributes() ?>>
<span id="el_po_status_delivery_date">
<input type="text" data-table="po_status" data-field="x_delivery_date" name="x_delivery_date" id="x_delivery_date" placeholder="<?php echo HtmlEncode($po_status->delivery_date->getPlaceHolder()) ?>" value="<?php echo $po_status->delivery_date->EditValue ?>"<?php echo $po_status->delivery_date->editAttributes() ?>>
<?php if (!$po_status->delivery_date->ReadOnly && !$po_status->delivery_date->Disabled && !isset($po_status->delivery_date->EditAttrs["readonly"]) && !isset($po_status->delivery_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_statusadd", "x_delivery_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_status->delivery_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->reminder_date->Visible) { // reminder_date ?>
	<div id="r_reminder_date" class="form-group row">
		<label id="elh_po_status_reminder_date" for="x_reminder_date" class="<?php echo $po_status_add->LeftColumnClass ?>"><?php echo $po_status->reminder_date->caption() ?><?php echo ($po_status->reminder_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_add->RightColumnClass ?>"><div<?php echo $po_status->reminder_date->cellAttributes() ?>>
<span id="el_po_status_reminder_date">
<input type="text" data-table="po_status" data-field="x_reminder_date" name="x_reminder_date" id="x_reminder_date" placeholder="<?php echo HtmlEncode($po_status->reminder_date->getPlaceHolder()) ?>" value="<?php echo $po_status->reminder_date->EditValue ?>"<?php echo $po_status->reminder_date->editAttributes() ?>>
<?php if (!$po_status->reminder_date->ReadOnly && !$po_status->reminder_date->Disabled && !isset($po_status->reminder_date->EditAttrs["readonly"]) && !isset($po_status->reminder_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_statusadd", "x_reminder_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_status->reminder_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->reminder_for->Visible) { // reminder_for ?>
	<div id="r_reminder_for" class="form-group row">
		<label id="elh_po_status_reminder_for" for="x_reminder_for" class="<?php echo $po_status_add->LeftColumnClass ?>"><?php echo $po_status->reminder_for->caption() ?><?php echo ($po_status->reminder_for->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_add->RightColumnClass ?>"><div<?php echo $po_status->reminder_for->cellAttributes() ?>>
<span id="el_po_status_reminder_for">
<textarea data-table="po_status" data-field="x_reminder_for" name="x_reminder_for" id="x_reminder_for" cols="35" rows="4" placeholder="<?php echo HtmlEncode($po_status->reminder_for->getPlaceHolder()) ?>"<?php echo $po_status->reminder_for->editAttributes() ?>><?php echo $po_status->reminder_for->EditValue ?></textarea>
</span>
<?php echo $po_status->reminder_for->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->po_current_status->Visible) { // po_current_status ?>
	<div id="r_po_current_status" class="form-group row">
		<label id="elh_po_status_po_current_status" for="x_po_current_status" class="<?php echo $po_status_add->LeftColumnClass ?>"><?php echo $po_status->po_current_status->caption() ?><?php echo ($po_status->po_current_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_add->RightColumnClass ?>"><div<?php echo $po_status->po_current_status->cellAttributes() ?>>
<span id="el_po_status_po_current_status">
<textarea data-table="po_status" data-field="x_po_current_status" name="x_po_current_status" id="x_po_current_status" cols="35" rows="4" placeholder="<?php echo HtmlEncode($po_status->po_current_status->getPlaceHolder()) ?>"<?php echo $po_status->po_current_status->editAttributes() ?>><?php echo $po_status->po_current_status->EditValue ?></textarea>
</span>
<?php echo $po_status->po_current_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_status_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_status_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_status_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_status_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_status_add->terminate();
?>