<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_status_edit = new po_status_edit();

// Run the page
$po_status_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_status_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpo_statusedit = currentForm = new ew.Form("fpo_statusedit", "edit");

// Validate form
fpo_statusedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_status_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->id->caption(), $po_status->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->po->caption(), $po_status->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->delivery_date->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->delivery_date->caption(), $po_status->delivery_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->reminder_date->Required) { ?>
			elm = this.getElements("x" + infix + "_reminder_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->reminder_date->caption(), $po_status->reminder_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->reminder_for->Required) { ?>
			elm = this.getElements("x" + infix + "_reminder_for");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->reminder_for->caption(), $po_status->reminder_for->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->po_current_status->Required) { ?>
			elm = this.getElements("x" + infix + "_po_current_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->po_current_status->caption(), $po_status->po_current_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->pp_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->pp_operator->caption(), $po_status->pp_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_status_edit->pp_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_status->pp_datetime->caption(), $po_status->pp_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_statusedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_statusedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_status_edit->showPageHeader(); ?>
<?php
$po_status_edit->showMessage();
?>
<form name="fpo_statusedit" id="fpo_statusedit" class="<?php echo $po_status_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_status_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_status_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_status">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$po_status_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_status->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_po_status_id" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->id->caption() ?><?php echo ($po_status->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->id->cellAttributes() ?>>
<span id="el_po_status_id">
<span<?php echo $po_status->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_status->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_status" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($po_status->id->CurrentValue) ?>">
<?php echo $po_status->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_status_po" for="x_po" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->po->caption() ?><?php echo ($po_status->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->po->cellAttributes() ?>>
<span id="el_po_status_po">
<span<?php echo $po_status->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_status->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_status" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($po_status->po->CurrentValue) ?>">
<?php echo $po_status->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->delivery_date->Visible) { // delivery_date ?>
	<div id="r_delivery_date" class="form-group row">
		<label id="elh_po_status_delivery_date" for="x_delivery_date" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->delivery_date->caption() ?><?php echo ($po_status->delivery_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->delivery_date->cellAttributes() ?>>
<span id="el_po_status_delivery_date">
<span<?php echo $po_status->delivery_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_status->delivery_date->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_status" data-field="x_delivery_date" name="x_delivery_date" id="x_delivery_date" value="<?php echo HtmlEncode($po_status->delivery_date->CurrentValue) ?>">
<?php echo $po_status->delivery_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->reminder_date->Visible) { // reminder_date ?>
	<div id="r_reminder_date" class="form-group row">
		<label id="elh_po_status_reminder_date" for="x_reminder_date" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->reminder_date->caption() ?><?php echo ($po_status->reminder_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->reminder_date->cellAttributes() ?>>
<span id="el_po_status_reminder_date">
<span<?php echo $po_status->reminder_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_status->reminder_date->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_status" data-field="x_reminder_date" name="x_reminder_date" id="x_reminder_date" value="<?php echo HtmlEncode($po_status->reminder_date->CurrentValue) ?>">
<?php echo $po_status->reminder_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->reminder_for->Visible) { // reminder_for ?>
	<div id="r_reminder_for" class="form-group row">
		<label id="elh_po_status_reminder_for" for="x_reminder_for" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->reminder_for->caption() ?><?php echo ($po_status->reminder_for->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->reminder_for->cellAttributes() ?>>
<span id="el_po_status_reminder_for">
<span<?php echo $po_status->reminder_for->viewAttributes() ?>>
<?php echo $po_status->reminder_for->EditValue ?></span>
</span>
<input type="hidden" data-table="po_status" data-field="x_reminder_for" name="x_reminder_for" id="x_reminder_for" value="<?php echo HtmlEncode($po_status->reminder_for->CurrentValue) ?>">
<?php echo $po_status->reminder_for->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_status->po_current_status->Visible) { // po_current_status ?>
	<div id="r_po_current_status" class="form-group row">
		<label id="elh_po_status_po_current_status" for="x_po_current_status" class="<?php echo $po_status_edit->LeftColumnClass ?>"><?php echo $po_status->po_current_status->caption() ?><?php echo ($po_status->po_current_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_status_edit->RightColumnClass ?>"><div<?php echo $po_status->po_current_status->cellAttributes() ?>>
<span id="el_po_status_po_current_status">
<textarea data-table="po_status" data-field="x_po_current_status" name="x_po_current_status" id="x_po_current_status" cols="35" rows="4" placeholder="<?php echo HtmlEncode($po_status->po_current_status->getPlaceHolder()) ?>"<?php echo $po_status->po_current_status->editAttributes() ?>><?php echo $po_status->po_current_status->EditValue ?></textarea>
</span>
<?php echo $po_status->po_current_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_status_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_status_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_status_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_status_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_status_edit->terminate();
?>