<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_add = new po_add();

// Run the page
$po_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpoadd = currentForm = new ew.Form("fpoadd", "add");

// Validate form
fpoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_add->order_type->Required) { ?>
			elm = this.getElements("x" + infix + "_order_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->order_type->caption(), $po->order_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_id->caption(), $po->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_order_no->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_order_no->caption(), $po->buyer_order_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_order_date->caption(), $po->buyer_order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->buyer_order_date->errorMessage()) ?>");
		<?php if ($po_add->cart_id->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->cart_id->caption(), $po->cart_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_product_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_product_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_product_ref->caption(), $po->buyer_product_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->grp->caption(), $po->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->s_grp->caption(), $po->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->product->caption(), $po->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->rid->caption(), $po->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->despatch_date->caption(), $po->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->despatch_date->errorMessage()) ?>");
		<?php if ($po_add->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->despatch_week->caption(), $po->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->fob_date->Required) { ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->fob_date->caption(), $po->fob_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->fob_date->errorMessage()) ?>");
		<?php if ($po_add->part_dispatch->Required) { ?>
			elm = this.getElements("x" + infix + "_part_dispatch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->part_dispatch->caption(), $po->part_dispatch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->payment_terms->caption(), $po->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->transport_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_transport_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->transport_terms->caption(), $po->transport_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_shipping__id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_shipping__id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_shipping__id->caption(), $po->buyer_shipping__id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_shipping__id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->buyer_shipping__id->errorMessage()) ?>");
		<?php if ($po_add->description_04->Required) { ?>
			elm = this.getElements("x" + infix + "_description_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_04->caption(), $po->description_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_03->Required) { ?>
			elm = this.getElements("x" + infix + "_description_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_03->caption(), $po->description_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_01->caption(), $po->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_01->errorMessage()) ?>");
		<?php if ($po_add->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_02->caption(), $po->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_02->errorMessage()) ?>");
		<?php if ($po_add->description_07->Required) { ?>
			elm = this.getElements("x" + infix + "_description_07");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_07->caption(), $po->description_07->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_07");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_07->errorMessage()) ?>");
		<?php if ($po_add->description_20->Required) { ?>
			elm = this.getElements("x" + infix + "_description_20");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_20->caption(), $po->description_20->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_17->Required) { ?>
			elm = this.getElements("x" + infix + "_description_17");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_17->caption(), $po->description_17->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_17");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_17->errorMessage()) ?>");
		<?php if ($po_add->description_18->Required) { ?>
			elm = this.getElements("x" + infix + "_description_18");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_18->caption(), $po->description_18->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_18");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_18->errorMessage()) ?>");
		<?php if ($po_add->description_19->Required) { ?>
			elm = this.getElements("x" + infix + "_description_19");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_19->caption(), $po->description_19->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_19");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_19->errorMessage()) ?>");
		<?php if ($po_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->quantity->caption(), $po->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->price->caption(), $po->price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->currency->caption(), $po->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->amount->caption(), $po->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->amount->errorMessage()) ?>");
		<?php if ($po_add->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->cbm->caption(), $po->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->cbm->errorMessage()) ?>");
		<?php if ($po_add->buyer_size->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_size->caption(), $po->buyer_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_05->Required) { ?>
			elm = this.getElements("x" + infix + "_description_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_05->caption(), $po->description_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_06->Required) { ?>
			elm = this.getElements("x" + infix + "_description_06");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_06->caption(), $po->description_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_08->Required) { ?>
			elm = this.getElements("x" + infix + "_description_08");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_08->caption(), $po->description_08->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_08");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po->description_08->errorMessage()) ?>");
		<?php if ($po_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->remarks->caption(), $po->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->operator->caption(), $po->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->datetime->caption(), $po->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->buyer_instruction->caption(), $po->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->d_09_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_09_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->d_09_head->caption(), $po->d_09_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_09->caption(), $po->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->d_10_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_10_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->d_10_head->caption(), $po->d_10_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_10->caption(), $po->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->d_11_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_11_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->d_11_head->caption(), $po->d_11_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_11->Required) { ?>
			elm = this.getElements("x" + infix + "_description_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_11->caption(), $po->description_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->d_12_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_12_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->d_12_head->caption(), $po->d_12_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_add->description_12->Required) { ?>
			elm = this.getElements("x" + infix + "_description_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po->description_12->caption(), $po->description_12->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpoadd.multiPage = new ew.MultiPage("fpoadd");

// Dynamic selection lists
fpoadd.lists["x_order_type"] = <?php echo $po_add->order_type->Lookup->toClientList() ?>;
fpoadd.lists["x_order_type"].options = <?php echo JsonEncode($po_add->order_type->options(FALSE, TRUE)) ?>;
fpoadd.lists["x_buyer_id"] = <?php echo $po_add->buyer_id->Lookup->toClientList() ?>;
fpoadd.lists["x_buyer_id"].options = <?php echo JsonEncode($po_add->buyer_id->lookupOptions()) ?>;
fpoadd.lists["x_cart_id[]"] = <?php echo $po_add->cart_id->Lookup->toClientList() ?>;
fpoadd.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_add->cart_id->lookupOptions()) ?>;
fpoadd.lists["x_grp"] = <?php echo $po_add->grp->Lookup->toClientList() ?>;
fpoadd.lists["x_grp"].options = <?php echo JsonEncode($po_add->grp->lookupOptions()) ?>;
fpoadd.lists["x_s_grp"] = <?php echo $po_add->s_grp->Lookup->toClientList() ?>;
fpoadd.lists["x_s_grp"].options = <?php echo JsonEncode($po_add->s_grp->lookupOptions()) ?>;
fpoadd.lists["x_product"] = <?php echo $po_add->product->Lookup->toClientList() ?>;
fpoadd.lists["x_product"].options = <?php echo JsonEncode($po_add->product->lookupOptions()) ?>;
fpoadd.lists["x_rid"] = <?php echo $po_add->rid->Lookup->toClientList() ?>;
fpoadd.lists["x_rid"].options = <?php echo JsonEncode($po_add->rid->lookupOptions()) ?>;
fpoadd.lists["x_despatch_week"] = <?php echo $po_add->despatch_week->Lookup->toClientList() ?>;
fpoadd.lists["x_despatch_week"].options = <?php echo JsonEncode($po_add->despatch_week->lookupOptions()) ?>;
fpoadd.lists["x_part_dispatch"] = <?php echo $po_add->part_dispatch->Lookup->toClientList() ?>;
fpoadd.lists["x_part_dispatch"].options = <?php echo JsonEncode($po_add->part_dispatch->options(FALSE, TRUE)) ?>;
fpoadd.lists["x_payment_terms"] = <?php echo $po_add->payment_terms->Lookup->toClientList() ?>;
fpoadd.lists["x_payment_terms"].options = <?php echo JsonEncode($po_add->payment_terms->lookupOptions()) ?>;
fpoadd.lists["x_description_04"] = <?php echo $po_add->description_04->Lookup->toClientList() ?>;
fpoadd.lists["x_description_04"].options = <?php echo JsonEncode($po_add->description_04->options(FALSE, TRUE)) ?>;
fpoadd.lists["x_description_03"] = <?php echo $po_add->description_03->Lookup->toClientList() ?>;
fpoadd.lists["x_description_03"].options = <?php echo JsonEncode($po_add->description_03->options(FALSE, TRUE)) ?>;
fpoadd.lists["x_description_20"] = <?php echo $po_add->description_20->Lookup->toClientList() ?>;
fpoadd.lists["x_description_20"].options = <?php echo JsonEncode($po_add->description_20->options(FALSE, TRUE)) ?>;
fpoadd.lists["x_currency"] = <?php echo $po_add->currency->Lookup->toClientList() ?>;
fpoadd.lists["x_currency"].options = <?php echo JsonEncode($po_add->currency->lookupOptions()) ?>;
fpoadd.lists["x_description_05"] = <?php echo $po_add->description_05->Lookup->toClientList() ?>;
fpoadd.lists["x_description_05"].options = <?php echo JsonEncode($po_add->description_05->lookupOptions()) ?>;
fpoadd.lists["x_description_06"] = <?php echo $po_add->description_06->Lookup->toClientList() ?>;
fpoadd.lists["x_description_06"].options = <?php echo JsonEncode($po_add->description_06->lookupOptions()) ?>;
fpoadd.lists["x_operator"] = <?php echo $po_add->operator->Lookup->toClientList() ?>;
fpoadd.lists["x_operator"].options = <?php echo JsonEncode($po_add->operator->lookupOptions()) ?>;
fpoadd.lists["x_d_09_head"] = <?php echo $po_add->d_09_head->Lookup->toClientList() ?>;
fpoadd.lists["x_d_09_head"].options = <?php echo JsonEncode($po_add->d_09_head->lookupOptions()) ?>;
fpoadd.lists["x_d_10_head"] = <?php echo $po_add->d_10_head->Lookup->toClientList() ?>;
fpoadd.lists["x_d_10_head"].options = <?php echo JsonEncode($po_add->d_10_head->lookupOptions()) ?>;
fpoadd.lists["x_d_11_head"] = <?php echo $po_add->d_11_head->Lookup->toClientList() ?>;
fpoadd.lists["x_d_11_head"].options = <?php echo JsonEncode($po_add->d_11_head->lookupOptions()) ?>;
fpoadd.lists["x_d_12_head"] = <?php echo $po_add->d_12_head->Lookup->toClientList() ?>;
fpoadd.lists["x_d_12_head"].options = <?php echo JsonEncode($po_add->d_12_head->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_add->showPageHeader(); ?>
<?php
$po_add->showMessage();
?>
<form name="fpoadd" id="fpoadd" class="<?php echo $po_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_add->IsModal ?>">
<?php if ($po_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($po->order_type->Visible) { // order_type ?>
	<div id="r_order_type" class="form-group row">
		<label id="elh_po_order_type" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->order_type->caption() ?><?php echo ($po->order_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->order_type->cellAttributes() ?>>
<span id="el_po_order_type">
<div id="tp_x_order_type" class="ew-template"><input type="radio" class="form-check-input" data-table="po" data-field="x_order_type" data-page="0" data-value-separator="<?php echo $po->order_type->displayValueSeparatorAttribute() ?>" name="x_order_type" id="x_order_type" value="{value}"<?php echo $po->order_type->editAttributes() ?>></div>
<div id="dsl_x_order_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po->order_type->radioButtonListHtml(FALSE, "x_order_type", 0) ?>
</div></div>
</span>
<?php echo $po->order_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label id="elh_po_cart_id" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->cart_id->caption() ?><?php echo ($po->cart_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->cart_id->cellAttributes() ?>>
<span id="el_po_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
<?php echo $po->cart_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_po_grp" for="x_grp" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->grp->caption() ?><?php echo ($po->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->grp->cellAttributes() ?>>
<span id="el_po_grp">
<?php $po->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po->grp->editAttributes() ?>>
		<?php echo $po->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $po->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_po_s_grp" for="x_s_grp" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->s_grp->caption() ?><?php echo ($po->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->s_grp->cellAttributes() ?>>
<span id="el_po_s_grp">
<?php $po->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $po->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $po->s_grp->editAttributes() ?>>
		<?php echo $po->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $po->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $po->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_po_product" for="x_product" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->product->caption() ?><?php echo ($po->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->product->cellAttributes() ?>>
<span id="el_po_product">
<?php $po->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_product" data-page="0" data-value-separator="<?php echo $po->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po->product->editAttributes() ?>>
		<?php echo $po->product->selectOptionListHtml("x_product") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "product") && !$po->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->product->caption() ?>" data-title="<?php echo $po->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product',url:'productaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $po->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_po_rid" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->rid->caption() ?><?php echo ($po->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->rid->cellAttributes() ?>>
<span id="el_po_rid">
<?php $po->rid->EditAttrs["onclick"] = "ew.autoFill(this); " . @$po->rid->EditAttrs["onclick"]; ?>
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="po" data-field="x_rid" data-page="0" data-value-separator="<?php echo $po->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $po->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po->rid->radioButtonListHtml(FALSE, "x_rid", 0) ?>
</div></div>
<?php echo $po->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $po->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $po_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_add->MultiPages->isActive("1")) ?>" href="#tab_po1"><?php echo $po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_add->MultiPages->Parent ?>" id="tab_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_po_buyer_id" for="x_buyer_id" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_id->caption() ?><?php echo ($po->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_id->cellAttributes() ?>>
<span id="el_po_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_buyer_id" data-page="1" data-value-separator="<?php echo $po->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po->buyer_id->editAttributes() ?>>
		<?php echo $po->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$po->buyer_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->buyer_id->caption() ?>" data-title="<?php echo $po->buyer_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer_id',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
<?php echo $po->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label id="elh_po_buyer_order_no" for="x_buyer_order_no" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_order_no->caption() ?><?php echo ($po->buyer_order_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_order_no->cellAttributes() ?>>
<span id="el_po_buyer_order_no">
<input type="text" data-table="po" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po->buyer_order_no->EditValue ?>"<?php echo $po->buyer_order_no->editAttributes() ?>>
</span>
<?php echo $po->buyer_order_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label id="elh_po_buyer_order_date" for="x_buyer_order_date" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_order_date->caption() ?><?php echo ($po->buyer_order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_order_date->cellAttributes() ?>>
<span id="el_po_buyer_order_date">
<input type="text" data-table="po" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po->buyer_order_date->EditValue ?>"<?php echo $po->buyer_order_date->editAttributes() ?>>
<?php if (!$po->buyer_order_date->ReadOnly && !$po->buyer_order_date->Disabled && !isset($po->buyer_order_date->EditAttrs["readonly"]) && !isset($po->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpoadd", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po->buyer_order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label id="elh_po_buyer_product_ref" for="x_buyer_product_ref" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_product_ref->caption() ?><?php echo ($po->buyer_product_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_product_ref->cellAttributes() ?>>
<span id="el_po_buyer_product_ref">
<input type="text" data-table="po" data-field="x_buyer_product_ref" data-page="1" name="x_buyer_product_ref" id="x_buyer_product_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->buyer_product_ref->getPlaceHolder()) ?>" value="<?php echo $po->buyer_product_ref->EditValue ?>"<?php echo $po->buyer_product_ref->editAttributes() ?>>
</span>
<?php echo $po->buyer_product_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_po_despatch_date" for="x_despatch_date" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->despatch_date->caption() ?><?php echo ($po->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->despatch_date->cellAttributes() ?>>
<span id="el_po_despatch_date">
<input type="text" data-table="po" data-field="x_despatch_date" data-page="1" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po->despatch_date->EditValue ?>"<?php echo $po->despatch_date->editAttributes() ?>>
<?php if (!$po->despatch_date->ReadOnly && !$po->despatch_date->Disabled && !isset($po->despatch_date->EditAttrs["readonly"]) && !isset($po->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpoadd", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_po_despatch_week" for="x_despatch_week" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->despatch_week->caption() ?><?php echo ($po->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->despatch_week->cellAttributes() ?>>
<span id="el_po_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_despatch_week" data-page="1" data-value-separator="<?php echo $po->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po->despatch_week->editAttributes() ?>>
		<?php echo $po->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $po->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->fob_date->Visible) { // fob_date ?>
	<div id="r_fob_date" class="form-group row">
		<label id="elh_po_fob_date" for="x_fob_date" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->fob_date->caption() ?><?php echo ($po->fob_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->fob_date->cellAttributes() ?>>
<span id="el_po_fob_date">
<input type="text" data-table="po" data-field="x_fob_date" data-page="1" name="x_fob_date" id="x_fob_date" placeholder="<?php echo HtmlEncode($po->fob_date->getPlaceHolder()) ?>" value="<?php echo $po->fob_date->EditValue ?>"<?php echo $po->fob_date->editAttributes() ?>>
<?php if (!$po->fob_date->ReadOnly && !$po->fob_date->Disabled && !isset($po->fob_date->EditAttrs["readonly"]) && !isset($po->fob_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpoadd", "x_fob_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po->fob_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->part_dispatch->Visible) { // part_dispatch ?>
	<div id="r_part_dispatch" class="form-group row">
		<label id="elh_po_part_dispatch" for="x_part_dispatch" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->part_dispatch->caption() ?><?php echo ($po->part_dispatch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->part_dispatch->cellAttributes() ?>>
<span id="el_po_part_dispatch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_part_dispatch" data-page="1" data-value-separator="<?php echo $po->part_dispatch->displayValueSeparatorAttribute() ?>" id="x_part_dispatch" name="x_part_dispatch"<?php echo $po->part_dispatch->editAttributes() ?>>
		<?php echo $po->part_dispatch->selectOptionListHtml("x_part_dispatch") ?>
	</select>
</div>
</span>
<?php echo $po->part_dispatch->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_po_payment_terms" for="x_payment_terms" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->payment_terms->caption() ?><?php echo ($po->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->payment_terms->cellAttributes() ?>>
<span id="el_po_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_payment_terms" data-page="1" data-value-separator="<?php echo $po->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po->payment_terms->editAttributes() ?>>
		<?php echo $po->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$po->payment_terms->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_payment_terms" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->payment_terms->caption() ?>" data-title="<?php echo $po->payment_terms->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_payment_terms',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
<?php echo $po->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->transport_terms->Visible) { // transport_terms ?>
	<div id="r_transport_terms" class="form-group row">
		<label id="elh_po_transport_terms" for="x_transport_terms" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->transport_terms->caption() ?><?php echo ($po->transport_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->transport_terms->cellAttributes() ?>>
<span id="el_po_transport_terms">
<input type="text" data-table="po" data-field="x_transport_terms" data-page="1" name="x_transport_terms" id="x_transport_terms" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($po->transport_terms->getPlaceHolder()) ?>" value="<?php echo $po->transport_terms->EditValue ?>"<?php echo $po->transport_terms->editAttributes() ?>>
</span>
<?php echo $po->transport_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_shipping__id->Visible) { // buyer_shipping _id ?>
	<div id="r_buyer_shipping__id" class="form-group row">
		<label id="elh_po_buyer_shipping__id" for="x_buyer_shipping__id" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_shipping__id->caption() ?><?php echo ($po->buyer_shipping__id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_shipping__id->cellAttributes() ?>>
<span id="el_po_buyer_shipping__id">
<input type="text" data-table="po" data-field="x_buyer_shipping__id" data-page="1" name="x_buyer_shipping__id" id="x_buyer_shipping__id" size="30" placeholder="<?php echo HtmlEncode($po->buyer_shipping__id->getPlaceHolder()) ?>" value="<?php echo $po->buyer_shipping__id->EditValue ?>"<?php echo $po->buyer_shipping__id->editAttributes() ?>>
</span>
<?php echo $po->buyer_shipping__id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_po_currency" for="x_currency" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->currency->caption() ?><?php echo ($po->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->currency->cellAttributes() ?>>
<span id="el_po_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_currency" data-page="1" data-value-separator="<?php echo $po->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $po->currency->editAttributes() ?>>
		<?php echo $po->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $po->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $po->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_po_remarks" for="x_remarks" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->remarks->caption() ?><?php echo ($po->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->remarks->cellAttributes() ?>>
<span id="el_po_remarks">
<textarea data-table="po" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po->remarks->getPlaceHolder()) ?>"<?php echo $po->remarks->editAttributes() ?>><?php echo $po->remarks->EditValue ?></textarea>
</span>
<?php echo $po->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_po_buyer_instruction" for="x_buyer_instruction" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_instruction->caption() ?><?php echo ($po->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_instruction->cellAttributes() ?>>
<span id="el_po_buyer_instruction">
<textarea data-table="po" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po->buyer_instruction->getPlaceHolder()) ?>"<?php echo $po->buyer_instruction->editAttributes() ?>><?php echo $po->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $po->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $po_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_add->MultiPages->isActive("2")) ?>" href="#tab_po2"><?php echo $po->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_add->MultiPages->Parent ?>" id="tab_po2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label id="elh_po_description_04" for="x_description_04" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_04->caption() ?><?php echo ($po->description_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_04->cellAttributes() ?>>
<span id="el_po_description_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_04" data-page="2" data-value-separator="<?php echo $po->description_04->displayValueSeparatorAttribute() ?>" id="x_description_04" name="x_description_04"<?php echo $po->description_04->editAttributes() ?>>
		<?php echo $po->description_04->selectOptionListHtml("x_description_04") ?>
	</select>
</div>
</span>
<?php echo $po->description_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label id="elh_po_description_03" for="x_description_03" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_03->caption() ?><?php echo ($po->description_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_03->cellAttributes() ?>>
<span id="el_po_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_03" data-page="2" data-value-separator="<?php echo $po->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po->description_03->editAttributes() ?>>
		<?php echo $po->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
</div>
</span>
<?php echo $po->description_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_po_description_01" for="x_description_01" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_01->caption() ?><?php echo ($po->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_01->cellAttributes() ?>>
<span id="el_po_description_01">
<input type="text" data-table="po" data-field="x_description_01" data-page="2" name="x_description_01" id="x_description_01" size="30" placeholder="<?php echo HtmlEncode($po->description_01->getPlaceHolder()) ?>" value="<?php echo $po->description_01->EditValue ?>"<?php echo $po->description_01->editAttributes() ?>>
</span>
<?php echo $po->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_po_description_02" for="x_description_02" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_02->caption() ?><?php echo ($po->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_02->cellAttributes() ?>>
<span id="el_po_description_02">
<input type="text" data-table="po" data-field="x_description_02" data-page="2" name="x_description_02" id="x_description_02" size="30" placeholder="<?php echo HtmlEncode($po->description_02->getPlaceHolder()) ?>" value="<?php echo $po->description_02->EditValue ?>"<?php echo $po->description_02->editAttributes() ?>>
</span>
<?php echo $po->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label id="elh_po_description_07" for="x_description_07" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_07->caption() ?><?php echo ($po->description_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_07->cellAttributes() ?>>
<span id="el_po_description_07">
<input type="text" data-table="po" data-field="x_description_07" data-page="2" name="x_description_07" id="x_description_07" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->description_07->getPlaceHolder()) ?>" value="<?php echo $po->description_07->EditValue ?>"<?php echo $po->description_07->editAttributes() ?>>
</span>
<?php echo $po->description_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_20->Visible) { // description_20 ?>
	<div id="r_description_20" class="form-group row">
		<label id="elh_po_description_20" for="x_description_20" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_20->caption() ?><?php echo ($po->description_20->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_20->cellAttributes() ?>>
<span id="el_po_description_20">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_20" data-page="2" data-value-separator="<?php echo $po->description_20->displayValueSeparatorAttribute() ?>" id="x_description_20" name="x_description_20"<?php echo $po->description_20->editAttributes() ?>>
		<?php echo $po->description_20->selectOptionListHtml("x_description_20") ?>
	</select>
</div>
</span>
<?php echo $po->description_20->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_17->Visible) { // description_17 ?>
	<div id="r_description_17" class="form-group row">
		<label id="elh_po_description_17" for="x_description_17" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_17->caption() ?><?php echo ($po->description_17->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_17->cellAttributes() ?>>
<span id="el_po_description_17">
<input type="text" data-table="po" data-field="x_description_17" data-page="2" name="x_description_17" id="x_description_17" size="30" placeholder="<?php echo HtmlEncode($po->description_17->getPlaceHolder()) ?>" value="<?php echo $po->description_17->EditValue ?>"<?php echo $po->description_17->editAttributes() ?>>
</span>
<?php echo $po->description_17->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_18->Visible) { // description_18 ?>
	<div id="r_description_18" class="form-group row">
		<label id="elh_po_description_18" for="x_description_18" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_18->caption() ?><?php echo ($po->description_18->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_18->cellAttributes() ?>>
<span id="el_po_description_18">
<input type="text" data-table="po" data-field="x_description_18" data-page="2" name="x_description_18" id="x_description_18" size="30" placeholder="<?php echo HtmlEncode($po->description_18->getPlaceHolder()) ?>" value="<?php echo $po->description_18->EditValue ?>"<?php echo $po->description_18->editAttributes() ?>>
</span>
<?php echo $po->description_18->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_19->Visible) { // description_19 ?>
	<div id="r_description_19" class="form-group row">
		<label id="elh_po_description_19" for="x_description_19" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_19->caption() ?><?php echo ($po->description_19->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_19->cellAttributes() ?>>
<span id="el_po_description_19">
<input type="text" data-table="po" data-field="x_description_19" data-page="2" name="x_description_19" id="x_description_19" size="30" placeholder="<?php echo HtmlEncode($po->description_19->getPlaceHolder()) ?>" value="<?php echo $po->description_19->EditValue ?>"<?php echo $po->description_19->editAttributes() ?>>
</span>
<?php echo $po->description_19->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_po_quantity" for="x_quantity" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->quantity->caption() ?><?php echo ($po->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->quantity->cellAttributes() ?>>
<span id="el_po_quantity">
<input type="text" data-table="po" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po->quantity->getPlaceHolder()) ?>" value="<?php echo $po->quantity->EditValue ?>"<?php echo $po->quantity->editAttributes() ?>>
</span>
<?php echo $po->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_po_price" for="x_price" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->price->caption() ?><?php echo ($po->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->price->cellAttributes() ?>>
<span id="el_po_price">
<input type="text" data-table="po" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po->price->getPlaceHolder()) ?>" value="<?php echo $po->price->EditValue ?>"<?php echo $po->price->editAttributes() ?>>
</span>
<?php echo $po->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_po_amount" for="x_amount" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->amount->caption() ?><?php echo ($po->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->amount->cellAttributes() ?>>
<span id="el_po_amount">
<input type="text" data-table="po" data-field="x_amount" data-page="2" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po->amount->getPlaceHolder()) ?>" value="<?php echo $po->amount->EditValue ?>"<?php echo $po->amount->editAttributes() ?>>
</span>
<?php echo $po->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_po_cbm" for="x_cbm" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->cbm->caption() ?><?php echo ($po->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->cbm->cellAttributes() ?>>
<span id="el_po_cbm">
<input type="text" data-table="po" data-field="x_cbm" data-page="2" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po->cbm->getPlaceHolder()) ?>" value="<?php echo $po->cbm->EditValue ?>"<?php echo $po->cbm->editAttributes() ?>>
</span>
<?php echo $po->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_size->Visible) { // buyer_size ?>
	<div id="r_buyer_size" class="form-group row">
		<label id="elh_po_buyer_size" for="x_buyer_size" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->buyer_size->caption() ?><?php echo ($po->buyer_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->buyer_size->cellAttributes() ?>>
<span id="el_po_buyer_size">
<input type="text" data-table="po" data-field="x_buyer_size" data-page="2" name="x_buyer_size" id="x_buyer_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->buyer_size->getPlaceHolder()) ?>" value="<?php echo $po->buyer_size->EditValue ?>"<?php echo $po->buyer_size->editAttributes() ?>>
</span>
<?php echo $po->buyer_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label id="elh_po_description_05" for="x_description_05" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_05->caption() ?><?php echo ($po->description_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_05->cellAttributes() ?>>
<span id="el_po_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_05" data-page="2" data-value-separator="<?php echo $po->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po->description_05->editAttributes() ?>>
		<?php echo $po->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_05") && !$po->description_05->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_05" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->description_05->caption() ?>" data-title="<?php echo $po->description_05->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_05',url:'d_05addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
<?php echo $po->description_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label id="elh_po_description_06" for="x_description_06" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_06->caption() ?><?php echo ($po->description_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_06->cellAttributes() ?>>
<span id="el_po_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_06" data-page="2" data-value-separator="<?php echo $po->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po->description_06->editAttributes() ?>>
		<?php echo $po->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_06") && !$po->description_06->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_06" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->description_06->caption() ?>" data-title="<?php echo $po->description_06->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_06',url:'d_06addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
<?php echo $po->description_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label id="elh_po_description_08" for="x_description_08" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_08->caption() ?><?php echo ($po->description_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_08->cellAttributes() ?>>
<span id="el_po_description_08">
<input type="text" data-table="po" data-field="x_description_08" data-page="2" name="x_description_08" id="x_description_08" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->description_08->getPlaceHolder()) ?>" value="<?php echo $po->description_08->EditValue ?>"<?php echo $po->description_08->editAttributes() ?>>
</span>
<?php echo $po->description_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $po_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_add->MultiPages->isActive("3")) ?>" href="#tab_po3"><?php echo $po->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $po_add->MultiPages->Parent ?>" id="tab_po3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label id="elh_po_d_09_head" for="x_d_09_head" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->d_09_head->caption() ?><?php echo ($po->d_09_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->d_09_head->cellAttributes() ?>>
<span id="el_po_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_09_head" data-page="3" data-value-separator="<?php echo $po->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po->d_09_head->editAttributes() ?>>
		<?php echo $po->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po->d_09_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_09_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->d_09_head->caption() ?>" data-title="<?php echo $po->d_09_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_09_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
<?php echo $po->d_09_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_po_description_09" for="x_description_09" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_09->caption() ?><?php echo ($po->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_09->cellAttributes() ?>>
<span id="el_po_description_09">
<input type="text" data-table="po" data-field="x_description_09" data-page="3" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_09->getPlaceHolder()) ?>" value="<?php echo $po->description_09->EditValue ?>"<?php echo $po->description_09->editAttributes() ?>>
</span>
<?php echo $po->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label id="elh_po_d_10_head" for="x_d_10_head" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->d_10_head->caption() ?><?php echo ($po->d_10_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->d_10_head->cellAttributes() ?>>
<span id="el_po_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_10_head" data-page="3" data-value-separator="<?php echo $po->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po->d_10_head->editAttributes() ?>>
		<?php echo $po->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po->d_10_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_10_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->d_10_head->caption() ?>" data-title="<?php echo $po->d_10_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_10_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
<?php echo $po->d_10_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_po_description_10" for="x_description_10" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_10->caption() ?><?php echo ($po->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_10->cellAttributes() ?>>
<span id="el_po_description_10">
<input type="text" data-table="po" data-field="x_description_10" data-page="3" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_10->getPlaceHolder()) ?>" value="<?php echo $po->description_10->EditValue ?>"<?php echo $po->description_10->editAttributes() ?>>
</span>
<?php echo $po->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label id="elh_po_d_11_head" for="x_d_11_head" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->d_11_head->caption() ?><?php echo ($po->d_11_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->d_11_head->cellAttributes() ?>>
<span id="el_po_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_11_head" data-page="3" data-value-separator="<?php echo $po->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po->d_11_head->editAttributes() ?>>
		<?php echo $po->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po->d_11_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_11_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->d_11_head->caption() ?>" data-title="<?php echo $po->d_11_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_11_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
<?php echo $po->d_11_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label id="elh_po_description_11" for="x_description_11" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_11->caption() ?><?php echo ($po->description_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_11->cellAttributes() ?>>
<span id="el_po_description_11">
<input type="text" data-table="po" data-field="x_description_11" data-page="3" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_11->getPlaceHolder()) ?>" value="<?php echo $po->description_11->EditValue ?>"<?php echo $po->description_11->editAttributes() ?>>
</span>
<?php echo $po->description_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label id="elh_po_d_12_head" for="x_d_12_head" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->d_12_head->caption() ?><?php echo ($po->d_12_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->d_12_head->cellAttributes() ?>>
<span id="el_po_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_12_head" data-page="3" data-value-separator="<?php echo $po->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po->d_12_head->editAttributes() ?>>
		<?php echo $po->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po->d_12_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_12_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po->d_12_head->caption() ?>" data-title="<?php echo $po->d_12_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_12_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
<?php echo $po->d_12_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label id="elh_po_description_12" for="x_description_12" class="<?php echo $po_add->LeftColumnClass ?>"><?php echo $po->description_12->caption() ?><?php echo ($po->description_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_add->RightColumnClass ?>"><div<?php echo $po->description_12->cellAttributes() ?>>
<span id="el_po_description_12">
<input type="text" data-table="po" data-field="x_description_12" data-page="3" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_12->getPlaceHolder()) ?>" value="<?php echo $po->description_12->EditValue ?>"<?php echo $po->description_12->editAttributes() ?>>
</span>
<?php echo $po->description_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_add->terminate();
?>