<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_list = new po_list();

// Run the page
$po_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpolist = currentForm = new ew.Form("fpolist", "list");
fpolist.formKeyCountName = '<?php echo $po_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpolist.lists["x_order_type"] = <?php echo $po_list->order_type->Lookup->toClientList() ?>;
fpolist.lists["x_order_type"].options = <?php echo JsonEncode($po_list->order_type->options(FALSE, TRUE)) ?>;
fpolist.lists["x_buyer_id"] = <?php echo $po_list->buyer_id->Lookup->toClientList() ?>;
fpolist.lists["x_buyer_id"].options = <?php echo JsonEncode($po_list->buyer_id->lookupOptions()) ?>;
fpolist.lists["x_grp"] = <?php echo $po_list->grp->Lookup->toClientList() ?>;
fpolist.lists["x_grp"].options = <?php echo JsonEncode($po_list->grp->lookupOptions()) ?>;
fpolist.lists["x_s_grp"] = <?php echo $po_list->s_grp->Lookup->toClientList() ?>;
fpolist.lists["x_s_grp"].options = <?php echo JsonEncode($po_list->s_grp->lookupOptions()) ?>;
fpolist.lists["x_product"] = <?php echo $po_list->product->Lookup->toClientList() ?>;
fpolist.lists["x_product"].options = <?php echo JsonEncode($po_list->product->lookupOptions()) ?>;
fpolist.lists["x_rid"] = <?php echo $po_list->rid->Lookup->toClientList() ?>;
fpolist.lists["x_rid"].options = <?php echo JsonEncode($po_list->rid->lookupOptions()) ?>;
fpolist.lists["x_despatch_week"] = <?php echo $po_list->despatch_week->Lookup->toClientList() ?>;
fpolist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_list->despatch_week->lookupOptions()) ?>;
fpolist.lists["x_payment_terms"] = <?php echo $po_list->payment_terms->Lookup->toClientList() ?>;
fpolist.lists["x_payment_terms"].options = <?php echo JsonEncode($po_list->payment_terms->lookupOptions()) ?>;
fpolist.lists["x_description_04"] = <?php echo $po_list->description_04->Lookup->toClientList() ?>;
fpolist.lists["x_description_04"].options = <?php echo JsonEncode($po_list->description_04->options(FALSE, TRUE)) ?>;
fpolist.lists["x_description_03"] = <?php echo $po_list->description_03->Lookup->toClientList() ?>;
fpolist.lists["x_description_03"].options = <?php echo JsonEncode($po_list->description_03->options(FALSE, TRUE)) ?>;
fpolist.lists["x_description_20"] = <?php echo $po_list->description_20->Lookup->toClientList() ?>;
fpolist.lists["x_description_20"].options = <?php echo JsonEncode($po_list->description_20->options(FALSE, TRUE)) ?>;
fpolist.lists["x_a_operator"] = <?php echo $po_list->a_operator->Lookup->toClientList() ?>;
fpolist.lists["x_a_operator"].options = <?php echo JsonEncode($po_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fpolistsrch = currentSearchForm = new ew.Form("fpolistsrch");

// Filters
fpolistsrch.filterList = <?php echo $po_list->getFilterList() ?>;

// Init search panel as collapsed
fpolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_list->TotalRecs > 0 && $po_list->ExportOptions->visible()) { ?>
<?php $po_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_list->ImportOptions->visible()) { ?>
<?php $po_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_list->SearchOptions->visible()) { ?>
<?php $po_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_list->FilterOptions->visible()) { ?>
<?php $po_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po->isExport() && !$po->CurrentAction) { ?>
<form name="fpolistsrch" id="fpolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_list->showPageHeader(); ?>
<?php
$po_list->showMessage();
?>
<?php if ($po_list->TotalRecs > 0 || $po->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po">
<?php if (!$po->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_list->Pager)) $po_list->Pager = new PrevNextPager($po_list->StartRec, $po_list->DisplayRecs, $po_list->TotalRecs, $po_list->AutoHidePager) ?>
<?php if ($po_list->Pager->RecordCount > 0 && $po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_list->TotalRecs > 0 && (!$po_list->AutoHidePageSizeSelector || $po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpolist" id="fpolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po">
<div id="gmp_po" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_list->TotalRecs > 0 || $po->isGridEdit()) { ?>
<table id="tbl_polist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_list->renderListOptions();

// Render list options (header, left)
$po_list->ListOptions->render("header", "left");
?>
<?php if ($po->id->Visible) { // id ?>
	<?php if ($po->sortUrl($po->id) == "") { ?>
		<th data-name="id" class="<?php echo $po->id->headerCellClass() ?>"><div id="elh_po_id" class="po_id"><div class="ew-table-header-caption"><?php echo $po->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->id) ?>',2);"><div id="elh_po_id" class="po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->order_type->Visible) { // order_type ?>
	<?php if ($po->sortUrl($po->order_type) == "") { ?>
		<th data-name="order_type" class="<?php echo $po->order_type->headerCellClass() ?>"><div id="elh_po_order_type" class="po_order_type"><div class="ew-table-header-caption"><?php echo $po->order_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_type" class="<?php echo $po->order_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->order_type) ?>',2);"><div id="elh_po_order_type" class="po_order_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->order_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->order_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->order_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po->sortUrl($po->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po->buyer_id->headerCellClass() ?>"><div id="elh_po_buyer_id" class="po_buyer_id"><div class="ew-table-header-caption"><?php echo $po->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->buyer_id) ?>',2);"><div id="elh_po_buyer_id" class="po_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->grp->Visible) { // grp ?>
	<?php if ($po->sortUrl($po->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $po->grp->headerCellClass() ?>"><div id="elh_po_grp" class="po_grp"><div class="ew-table-header-caption"><?php echo $po->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $po->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->grp) ?>',2);"><div id="elh_po_grp" class="po_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->s_grp->Visible) { // s_grp ?>
	<?php if ($po->sortUrl($po->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $po->s_grp->headerCellClass() ?>"><div id="elh_po_s_grp" class="po_s_grp"><div class="ew-table-header-caption"><?php echo $po->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $po->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->s_grp) ?>',2);"><div id="elh_po_s_grp" class="po_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->product->Visible) { // product ?>
	<?php if ($po->sortUrl($po->product) == "") { ?>
		<th data-name="product" class="<?php echo $po->product->headerCellClass() ?>"><div id="elh_po_product" class="po_product"><div class="ew-table-header-caption"><?php echo $po->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $po->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->product) ?>',2);"><div id="elh_po_product" class="po_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->rid->Visible) { // rid ?>
	<?php if ($po->sortUrl($po->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $po->rid->headerCellClass() ?>"><div id="elh_po_rid" class="po_rid"><div class="ew-table-header-caption"><?php echo $po->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $po->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->rid) ?>',2);"><div id="elh_po_rid" class="po_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po->sortUrl($po->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po->despatch_date->headerCellClass() ?>"><div id="elh_po_despatch_date" class="po_despatch_date"><div class="ew-table-header-caption"><?php echo $po->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->despatch_date) ?>',2);"><div id="elh_po_despatch_date" class="po_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po->sortUrl($po->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po->despatch_week->headerCellClass() ?>"><div id="elh_po_despatch_week" class="po_despatch_week"><div class="ew-table-header-caption"><?php echo $po->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->despatch_week) ?>',2);"><div id="elh_po_despatch_week" class="po_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->fob_date->Visible) { // fob_date ?>
	<?php if ($po->sortUrl($po->fob_date) == "") { ?>
		<th data-name="fob_date" class="<?php echo $po->fob_date->headerCellClass() ?>"><div id="elh_po_fob_date" class="po_fob_date"><div class="ew-table-header-caption"><?php echo $po->fob_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fob_date" class="<?php echo $po->fob_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->fob_date) ?>',2);"><div id="elh_po_fob_date" class="po_fob_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->fob_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->fob_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->fob_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->payment_terms->Visible) { // payment_terms ?>
	<?php if ($po->sortUrl($po->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $po->payment_terms->headerCellClass() ?>"><div id="elh_po_payment_terms" class="po_payment_terms"><div class="ew-table-header-caption"><?php echo $po->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $po->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->payment_terms) ?>',2);"><div id="elh_po_payment_terms" class="po_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->transport_terms->Visible) { // transport_terms ?>
	<?php if ($po->sortUrl($po->transport_terms) == "") { ?>
		<th data-name="transport_terms" class="<?php echo $po->transport_terms->headerCellClass() ?>"><div id="elh_po_transport_terms" class="po_transport_terms"><div class="ew-table-header-caption"><?php echo $po->transport_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transport_terms" class="<?php echo $po->transport_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->transport_terms) ?>',2);"><div id="elh_po_transport_terms" class="po_transport_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->transport_terms->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po->transport_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->transport_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->buyer_shipping__id->Visible) { // buyer_shipping _id ?>
	<?php if ($po->sortUrl($po->buyer_shipping__id) == "") { ?>
		<th data-name="buyer_shipping__id" class="<?php echo $po->buyer_shipping__id->headerCellClass() ?>"><div id="elh_po_buyer_shipping__id" class="po_buyer_shipping__id"><div class="ew-table-header-caption"><?php echo $po->buyer_shipping__id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_shipping__id" class="<?php echo $po->buyer_shipping__id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->buyer_shipping__id) ?>',2);"><div id="elh_po_buyer_shipping__id" class="po_buyer_shipping__id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->buyer_shipping__id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->buyer_shipping__id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->buyer_shipping__id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_04->Visible) { // description_04 ?>
	<?php if ($po->sortUrl($po->description_04) == "") { ?>
		<th data-name="description_04" class="<?php echo $po->description_04->headerCellClass() ?>"><div id="elh_po_description_04" class="po_description_04"><div class="ew-table-header-caption"><?php echo $po->description_04->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_04" class="<?php echo $po->description_04->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_04) ?>',2);"><div id="elh_po_description_04" class="po_description_04">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_04->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_04->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_04->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_03->Visible) { // description_03 ?>
	<?php if ($po->sortUrl($po->description_03) == "") { ?>
		<th data-name="description_03" class="<?php echo $po->description_03->headerCellClass() ?>"><div id="elh_po_description_03" class="po_description_03"><div class="ew-table-header-caption"><?php echo $po->description_03->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_03" class="<?php echo $po->description_03->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_03) ?>',2);"><div id="elh_po_description_03" class="po_description_03">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_03->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_03->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_03->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_20->Visible) { // description_20 ?>
	<?php if ($po->sortUrl($po->description_20) == "") { ?>
		<th data-name="description_20" class="<?php echo $po->description_20->headerCellClass() ?>"><div id="elh_po_description_20" class="po_description_20"><div class="ew-table-header-caption"><?php echo $po->description_20->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_20" class="<?php echo $po->description_20->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_20) ?>',2);"><div id="elh_po_description_20" class="po_description_20">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_20->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_20->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_20->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_17->Visible) { // description_17 ?>
	<?php if ($po->sortUrl($po->description_17) == "") { ?>
		<th data-name="description_17" class="<?php echo $po->description_17->headerCellClass() ?>"><div id="elh_po_description_17" class="po_description_17"><div class="ew-table-header-caption"><?php echo $po->description_17->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_17" class="<?php echo $po->description_17->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_17) ?>',2);"><div id="elh_po_description_17" class="po_description_17">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_17->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_17->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_17->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_18->Visible) { // description_18 ?>
	<?php if ($po->sortUrl($po->description_18) == "") { ?>
		<th data-name="description_18" class="<?php echo $po->description_18->headerCellClass() ?>"><div id="elh_po_description_18" class="po_description_18"><div class="ew-table-header-caption"><?php echo $po->description_18->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_18" class="<?php echo $po->description_18->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_18) ?>',2);"><div id="elh_po_description_18" class="po_description_18">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_18->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_18->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_18->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->description_19->Visible) { // description_19 ?>
	<?php if ($po->sortUrl($po->description_19) == "") { ?>
		<th data-name="description_19" class="<?php echo $po->description_19->headerCellClass() ?>"><div id="elh_po_description_19" class="po_description_19"><div class="ew-table-header-caption"><?php echo $po->description_19->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_19" class="<?php echo $po->description_19->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->description_19) ?>',2);"><div id="elh_po_description_19" class="po_description_19">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->description_19->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->description_19->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->description_19->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->quantity->Visible) { // quantity ?>
	<?php if ($po->sortUrl($po->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po->quantity->headerCellClass() ?>"><div id="elh_po_quantity" class="po_quantity"><div class="ew-table-header-caption"><?php echo $po->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->quantity) ?>',2);"><div id="elh_po_quantity" class="po_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->price->Visible) { // price ?>
	<?php if ($po->sortUrl($po->price) == "") { ?>
		<th data-name="price" class="<?php echo $po->price->headerCellClass() ?>"><div id="elh_po_price" class="po_price"><div class="ew-table-header-caption"><?php echo $po->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $po->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->price) ?>',2);"><div id="elh_po_price" class="po_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->amount->Visible) { // amount ?>
	<?php if ($po->sortUrl($po->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $po->amount->headerCellClass() ?>"><div id="elh_po_amount" class="po_amount"><div class="ew-table-header-caption"><?php echo $po->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $po->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->amount) ?>',2);"><div id="elh_po_amount" class="po_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->cbm->Visible) { // cbm ?>
	<?php if ($po->sortUrl($po->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $po->cbm->headerCellClass() ?>"><div id="elh_po_cbm" class="po_cbm"><div class="ew-table-header-caption"><?php echo $po->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $po->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->cbm) ?>',2);"><div id="elh_po_cbm" class="po_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->buyer_size->Visible) { // buyer_size ?>
	<?php if ($po->sortUrl($po->buyer_size) == "") { ?>
		<th data-name="buyer_size" class="<?php echo $po->buyer_size->headerCellClass() ?>"><div id="elh_po_buyer_size" class="po_buyer_size"><div class="ew-table-header-caption"><?php echo $po->buyer_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_size" class="<?php echo $po->buyer_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->buyer_size) ?>',2);"><div id="elh_po_buyer_size" class="po_buyer_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->buyer_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po->buyer_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->buyer_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->a_operator->Visible) { // a_operator ?>
	<?php if ($po->sortUrl($po->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po->a_operator->headerCellClass() ?>"><div id="elh_po_a_operator" class="po_a_operator"><div class="ew-table-header-caption"><?php echo $po->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->a_operator) ?>',2);"><div id="elh_po_a_operator" class="po_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->a_datetime->Visible) { // a_datetime ?>
	<?php if ($po->sortUrl($po->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $po->a_datetime->headerCellClass() ?>"><div id="elh_po_a_datetime" class="po_a_datetime"><div class="ew-table-header-caption"><?php echo $po->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $po->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->a_datetime) ?>',2);"><div id="elh_po_a_datetime" class="po_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po->_action->Visible) { // action ?>
	<?php if ($po->sortUrl($po->_action) == "") { ?>
		<th data-name="_action" class="<?php echo $po->_action->headerCellClass() ?>"><div id="elh_po__action" class="po__action"><div class="ew-table-header-caption"><?php echo $po->_action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_action" class="<?php echo $po->_action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po->SortUrl($po->_action) ?>',2);"><div id="elh_po__action" class="po__action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po->_action->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po->_action->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po->_action->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po->ExportAll && $po->isExport()) {
	$po_list->StopRec = $po_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_list->TotalRecs > $po_list->StartRec + $po_list->DisplayRecs - 1)
		$po_list->StopRec = $po_list->StartRec + $po_list->DisplayRecs - 1;
	else
		$po_list->StopRec = $po_list->TotalRecs;
}
$po_list->RecCnt = $po_list->StartRec - 1;
if ($po_list->Recordset && !$po_list->Recordset->EOF) {
	$po_list->Recordset->moveFirst();
	$selectLimit = $po_list->UseSelectLimit;
	if (!$selectLimit && $po_list->StartRec > 1)
		$po_list->Recordset->move($po_list->StartRec - 1);
} elseif (!$po->AllowAddDeleteRow && $po_list->StopRec == 0) {
	$po_list->StopRec = $po->GridAddRowCount;
}

// Initialize aggregate
$po->RowType = ROWTYPE_AGGREGATEINIT;
$po->resetAttributes();
$po_list->renderRow();
while ($po_list->RecCnt < $po_list->StopRec) {
	$po_list->RecCnt++;
	if ($po_list->RecCnt >= $po_list->StartRec) {
		$po_list->RowCnt++;

		// Set up key count
		$po_list->KeyCount = $po_list->RowIndex;

		// Init row class and style
		$po->resetAttributes();
		$po->CssClass = "";
		if ($po->isGridAdd()) {
		} else {
			$po_list->loadRowValues($po_list->Recordset); // Load row values
		}
		$po->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po->RowAttrs = array_merge($po->RowAttrs, array('data-rowindex'=>$po_list->RowCnt, 'id'=>'r' . $po_list->RowCnt . '_po', 'data-rowtype'=>$po->RowType));

		// Render row
		$po_list->renderRow();

		// Render list options
		$po_list->renderListOptions();
?>
	<tr<?php echo $po->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_list->ListOptions->render("body", "left", $po_list->RowCnt);
?>
	<?php if ($po->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po->id->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_id" class="po_id">
<span<?php echo $po->id->viewAttributes() ?>>
<?php echo $po->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->order_type->Visible) { // order_type ?>
		<td data-name="order_type"<?php echo $po->order_type->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_order_type" class="po_order_type">
<span<?php echo $po->order_type->viewAttributes() ?>>
<?php echo $po->order_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_buyer_id" class="po_buyer_id">
<span<?php echo $po->buyer_id->viewAttributes() ?>>
<?php echo $po->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $po->grp->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_grp" class="po_grp">
<span<?php echo $po->grp->viewAttributes() ?>>
<?php echo $po->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $po->s_grp->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_s_grp" class="po_s_grp">
<span<?php echo $po->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($po->s_grp->getViewValue())) && $po->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $po->s_grp->linkAttributes() ?>><?php echo $po->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po->product->Visible) { // product ?>
		<td data-name="product"<?php echo $po->product->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_product" class="po_product">
<span<?php echo $po->product->viewAttributes() ?>>
<?php if ((!EmptyString($po->product->getViewValue())) && $po->product->linkAttributes() <> "") { ?>
<a<?php echo $po->product->linkAttributes() ?>><?php echo $po->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $po->rid->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_rid" class="po_rid">
<span<?php echo $po->rid->viewAttributes() ?>>
<?php if ((!EmptyString($po->rid->getViewValue())) && $po->rid->linkAttributes() <> "") { ?>
<a<?php echo $po->rid->linkAttributes() ?>><?php echo $po->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_despatch_date" class="po_despatch_date">
<span<?php echo $po->despatch_date->viewAttributes() ?>>
<?php echo $po->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_despatch_week" class="po_despatch_week">
<span<?php echo $po->despatch_week->viewAttributes() ?>>
<?php echo $po->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->fob_date->Visible) { // fob_date ?>
		<td data-name="fob_date"<?php echo $po->fob_date->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_fob_date" class="po_fob_date">
<span<?php echo $po->fob_date->viewAttributes() ?>>
<?php echo $po->fob_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $po->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_payment_terms" class="po_payment_terms">
<span<?php echo $po->payment_terms->viewAttributes() ?>>
<?php echo $po->payment_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->transport_terms->Visible) { // transport_terms ?>
		<td data-name="transport_terms"<?php echo $po->transport_terms->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_transport_terms" class="po_transport_terms">
<span<?php echo $po->transport_terms->viewAttributes() ?>>
<?php echo $po->transport_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->buyer_shipping__id->Visible) { // buyer_shipping _id ?>
		<td data-name="buyer_shipping__id"<?php echo $po->buyer_shipping__id->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_buyer_shipping__id" class="po_buyer_shipping__id">
<span<?php echo $po->buyer_shipping__id->viewAttributes() ?>>
<?php echo $po->buyer_shipping__id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_04->Visible) { // description_04 ?>
		<td data-name="description_04"<?php echo $po->description_04->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_04" class="po_description_04">
<span<?php echo $po->description_04->viewAttributes() ?>>
<?php echo $po->description_04->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_03->Visible) { // description_03 ?>
		<td data-name="description_03"<?php echo $po->description_03->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_03" class="po_description_03">
<span<?php echo $po->description_03->viewAttributes() ?>>
<?php echo $po->description_03->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_20->Visible) { // description_20 ?>
		<td data-name="description_20"<?php echo $po->description_20->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_20" class="po_description_20">
<span<?php echo $po->description_20->viewAttributes() ?>>
<?php echo $po->description_20->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_17->Visible) { // description_17 ?>
		<td data-name="description_17"<?php echo $po->description_17->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_17" class="po_description_17">
<span<?php echo $po->description_17->viewAttributes() ?>>
<?php echo $po->description_17->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_18->Visible) { // description_18 ?>
		<td data-name="description_18"<?php echo $po->description_18->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_18" class="po_description_18">
<span<?php echo $po->description_18->viewAttributes() ?>>
<?php echo $po->description_18->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->description_19->Visible) { // description_19 ?>
		<td data-name="description_19"<?php echo $po->description_19->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_description_19" class="po_description_19">
<span<?php echo $po->description_19->viewAttributes() ?>>
<?php echo $po->description_19->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_quantity" class="po_quantity">
<span<?php echo $po->quantity->viewAttributes() ?>>
<?php echo $po->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->price->Visible) { // price ?>
		<td data-name="price"<?php echo $po->price->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_price" class="po_price">
<span<?php echo $po->price->viewAttributes() ?>>
<?php echo $po->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $po->amount->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_amount" class="po_amount">
<span<?php echo $po->amount->viewAttributes() ?>>
<?php echo $po->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $po->cbm->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_cbm" class="po_cbm">
<span<?php echo $po->cbm->viewAttributes() ?>>
<?php echo $po->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->buyer_size->Visible) { // buyer_size ?>
		<td data-name="buyer_size"<?php echo $po->buyer_size->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_buyer_size" class="po_buyer_size">
<span<?php echo $po->buyer_size->viewAttributes() ?>>
<?php echo $po->buyer_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_a_operator" class="po_a_operator">
<span<?php echo $po->a_operator->viewAttributes() ?>>
<?php echo $po->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $po->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po_a_datetime" class="po_a_datetime">
<span<?php echo $po->a_datetime->viewAttributes() ?>>
<?php echo $po->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po->_action->Visible) { // action ?>
		<td data-name="_action"<?php echo $po->_action->cellAttributes() ?>>
<span id="el<?php echo $po_list->RowCnt ?>_po__action" class="po__action">
<span<?php echo $po->_action->viewAttributes() ?>>
<?php if ((!EmptyString($po->_action->getViewValue())) && $po->_action->linkAttributes() <> "") { ?>
<a<?php echo $po->_action->linkAttributes() ?>><?php echo $po->_action->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po->_action->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_list->ListOptions->render("body", "right", $po_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po->isGridAdd())
		$po_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_list->Recordset)
	$po_list->Recordset->Close();
?>
<?php if (!$po->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_list->Pager)) $po_list->Pager = new PrevNextPager($po_list->StartRec, $po_list->DisplayRecs, $po_list->TotalRecs, $po_list->AutoHidePager) ?>
<?php if ($po_list->Pager->RecordCount > 0 && $po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_list->pageUrl() ?>start=<?php echo $po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_list->TotalRecs > 0 && (!$po_list->AutoHidePageSizeSelector || $po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_list->TotalRecs == 0 && !$po->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_list->terminate();
?>