<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$port_add = new port_add();

// Run the page
$port_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$port_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fportadd = currentForm = new ew.Form("fportadd", "add");

// Validate form
fportadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($port_add->port->Required) { ?>
			elm = this.getElements("x" + infix + "_port");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->port->caption(), $port->port->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->code->caption(), $port->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($port->code->errorMessage()) ?>");
		<?php if ($port_add->mode->Required) { ?>
			elm = this.getElements("x" + infix + "_mode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->mode->caption(), $port->mode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->status->caption(), $port->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->operator->caption(), $port->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->datetime->caption(), $port->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportadd.lists["x_mode"] = <?php echo $port_add->mode->Lookup->toClientList() ?>;
fportadd.lists["x_mode"].options = <?php echo JsonEncode($port_add->mode->options(FALSE, TRUE)) ?>;
fportadd.lists["x_status"] = <?php echo $port_add->status->Lookup->toClientList() ?>;
fportadd.lists["x_status"].options = <?php echo JsonEncode($port_add->status->options(FALSE, TRUE)) ?>;
fportadd.lists["x_operator"] = <?php echo $port_add->operator->Lookup->toClientList() ?>;
fportadd.lists["x_operator"].options = <?php echo JsonEncode($port_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $port_add->showPageHeader(); ?>
<?php
$port_add->showMessage();
?>
<form name="fportadd" id="fportadd" class="<?php echo $port_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($port_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $port_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="port">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$port_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($port->port->Visible) { // port ?>
	<div id="r_port" class="form-group row">
		<label id="elh_port_port" for="x_port" class="<?php echo $port_add->LeftColumnClass ?>"><?php echo $port->port->caption() ?><?php echo ($port->port->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $port_add->RightColumnClass ?>"><div<?php echo $port->port->cellAttributes() ?>>
<span id="el_port_port">
<input type="text" data-table="port" data-field="x_port" name="x_port" id="x_port" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($port->port->getPlaceHolder()) ?>" value="<?php echo $port->port->EditValue ?>"<?php echo $port->port->editAttributes() ?>>
</span>
<?php echo $port->port->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($port->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_port_code" for="x_code" class="<?php echo $port_add->LeftColumnClass ?>"><?php echo $port->code->caption() ?><?php echo ($port->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $port_add->RightColumnClass ?>"><div<?php echo $port->code->cellAttributes() ?>>
<span id="el_port_code">
<input type="text" data-table="port" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($port->code->getPlaceHolder()) ?>" value="<?php echo $port->code->EditValue ?>"<?php echo $port->code->editAttributes() ?>>
</span>
<?php echo $port->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($port->mode->Visible) { // mode ?>
	<div id="r_mode" class="form-group row">
		<label id="elh_port_mode" for="x_mode" class="<?php echo $port_add->LeftColumnClass ?>"><?php echo $port->mode->caption() ?><?php echo ($port->mode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $port_add->RightColumnClass ?>"><div<?php echo $port->mode->cellAttributes() ?>>
<span id="el_port_mode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_mode" data-value-separator="<?php echo $port->mode->displayValueSeparatorAttribute() ?>" id="x_mode" name="x_mode"<?php echo $port->mode->editAttributes() ?>>
		<?php echo $port->mode->selectOptionListHtml("x_mode") ?>
	</select>
</div>
</span>
<?php echo $port->mode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($port->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_port_status" for="x_status" class="<?php echo $port_add->LeftColumnClass ?>"><?php echo $port->status->caption() ?><?php echo ($port->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $port_add->RightColumnClass ?>"><div<?php echo $port->status->cellAttributes() ?>>
<span id="el_port_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_status" data-value-separator="<?php echo $port->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $port->status->editAttributes() ?>>
		<?php echo $port->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $port->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$port_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $port_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $port_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$port_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$port_add->terminate();
?>