<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$port_addopt = new port_addopt();

// Run the page
$port_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$port_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fportaddopt = currentForm = new ew.Form("fportaddopt", "addopt");

// Validate form
fportaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($port_addopt->port->Required) { ?>
			elm = this.getElements("x" + infix + "_port");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->port->caption(), $port->port->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->code->caption(), $port->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($port->code->errorMessage()) ?>");
		<?php if ($port_addopt->mode->Required) { ?>
			elm = this.getElements("x" + infix + "_mode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->mode->caption(), $port->mode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->status->caption(), $port->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->operator->caption(), $port->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($port_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $port->datetime->caption(), $port->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportaddopt.lists["x_mode"] = <?php echo $port_addopt->mode->Lookup->toClientList() ?>;
fportaddopt.lists["x_mode"].options = <?php echo JsonEncode($port_addopt->mode->options(FALSE, TRUE)) ?>;
fportaddopt.lists["x_status"] = <?php echo $port_addopt->status->Lookup->toClientList() ?>;
fportaddopt.lists["x_status"].options = <?php echo JsonEncode($port_addopt->status->options(FALSE, TRUE)) ?>;
fportaddopt.lists["x_operator"] = <?php echo $port_addopt->operator->Lookup->toClientList() ?>;
fportaddopt.lists["x_operator"].options = <?php echo JsonEncode($port_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $port_addopt->showPageHeader(); ?>
<?php
$port_addopt->showMessage();
?>
<form name="fportaddopt" id="fportaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($port_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $port_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $port_addopt->TableVar ?>">
<?php if ($port->port->Visible) { // port ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_port"><?php echo $port->port->caption() ?><?php echo ($port->port->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="port" data-field="x_port" name="x_port" id="x_port" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($port->port->getPlaceHolder()) ?>" value="<?php echo $port->port->EditValue ?>"<?php echo $port->port->editAttributes() ?>>
<?php echo $port->port->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($port->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $port->code->caption() ?><?php echo ($port->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="port" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($port->code->getPlaceHolder()) ?>" value="<?php echo $port->code->EditValue ?>"<?php echo $port->code->editAttributes() ?>>
<?php echo $port->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($port->mode->Visible) { // mode ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mode"><?php echo $port->mode->caption() ?><?php echo ($port->mode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_mode" data-value-separator="<?php echo $port->mode->displayValueSeparatorAttribute() ?>" id="x_mode" name="x_mode"<?php echo $port->mode->editAttributes() ?>>
		<?php echo $port->mode->selectOptionListHtml("x_mode") ?>
	</select>
</div>
<?php echo $port->mode->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($port->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $port->status->caption() ?><?php echo ($port->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_status" data-value-separator="<?php echo $port->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $port->status->editAttributes() ?>>
		<?php echo $port->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $port->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($port->operator->Visible) { // operator ?>
	<input type="hidden" data-table="port" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($port->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($port->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="port" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($port->datetime->CurrentValue) ?>">
	<?php if (!$port->datetime->ReadOnly && !$port->datetime->Disabled && !isset($port->datetime->EditAttrs["readonly"]) && !isset($port->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fportaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$port_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$port_addopt->terminate();
?>