<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_info_list = new portal_info_list();

// Run the page
$portal_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$portal_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fportal_infolist = currentForm = new ew.Form("fportal_infolist", "list");
fportal_infolist.formKeyCountName = '<?php echo $portal_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
fportal_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_infolist.lists["x_operator"] = <?php echo $portal_info_list->operator->Lookup->toClientList() ?>;
fportal_infolist.lists["x_operator"].options = <?php echo JsonEncode($portal_info_list->operator->lookupOptions()) ?>;

// Form object for search
var fportal_infolistsrch = currentSearchForm = new ew.Form("fportal_infolistsrch");

// Filters
fportal_infolistsrch.filterList = <?php echo $portal_info_list->getFilterList() ?>;

// Init search panel as collapsed
fportal_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$portal_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($portal_info_list->TotalRecs > 0 && $portal_info_list->ExportOptions->visible()) { ?>
<?php $portal_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_info_list->ImportOptions->visible()) { ?>
<?php $portal_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_info_list->SearchOptions->visible()) { ?>
<?php $portal_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($portal_info_list->FilterOptions->visible()) { ?>
<?php $portal_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$portal_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$portal_info->isExport() && !$portal_info->CurrentAction) { ?>
<form name="fportal_infolistsrch" id="fportal_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($portal_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fportal_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="portal_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($portal_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($portal_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $portal_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($portal_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($portal_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($portal_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($portal_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $portal_info_list->showPageHeader(); ?>
<?php
$portal_info_list->showMessage();
?>
<?php if ($portal_info_list->TotalRecs > 0 || $portal_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($portal_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> portal_info">
<?php if (!$portal_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$portal_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_info_list->Pager)) $portal_info_list->Pager = new PrevNextPager($portal_info_list->StartRec, $portal_info_list->DisplayRecs, $portal_info_list->TotalRecs, $portal_info_list->AutoHidePager) ?>
<?php if ($portal_info_list->Pager->RecordCount > 0 && $portal_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_info_list->TotalRecs > 0 && (!$portal_info_list->AutoHidePageSizeSelector || $portal_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fportal_infolist" id="fportal_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_info">
<div id="gmp_portal_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($portal_info_list->TotalRecs > 0 || $portal_info->isGridEdit()) { ?>
<table id="tbl_portal_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$portal_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$portal_info_list->renderListOptions();

// Render list options (header, left)
$portal_info_list->ListOptions->render("header", "left");
?>
<?php if ($portal_info->id->Visible) { // id ?>
	<?php if ($portal_info->sortUrl($portal_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $portal_info->id->headerCellClass() ?>"><div id="elh_portal_info_id" class="portal_info_id"><div class="ew-table-header-caption"><?php echo $portal_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $portal_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->id) ?>',2);"><div id="elh_portal_info_id" class="portal_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->logo->Visible) { // logo ?>
	<?php if ($portal_info->sortUrl($portal_info->logo) == "") { ?>
		<th data-name="logo" class="<?php echo $portal_info->logo->headerCellClass() ?>"><div id="elh_portal_info_logo" class="portal_info_logo"><div class="ew-table-header-caption"><?php echo $portal_info->logo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="logo" class="<?php echo $portal_info->logo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->logo) ?>',2);"><div id="elh_portal_info_logo" class="portal_info_logo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->logo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->logo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->logo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->mobile_logo->Visible) { // mobile_logo ?>
	<?php if ($portal_info->sortUrl($portal_info->mobile_logo) == "") { ?>
		<th data-name="mobile_logo" class="<?php echo $portal_info->mobile_logo->headerCellClass() ?>"><div id="elh_portal_info_mobile_logo" class="portal_info_mobile_logo"><div class="ew-table-header-caption"><?php echo $portal_info->mobile_logo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_logo" class="<?php echo $portal_info->mobile_logo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->mobile_logo) ?>',2);"><div id="elh_portal_info_mobile_logo" class="portal_info_mobile_logo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->mobile_logo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->mobile_logo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->mobile_logo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->name->Visible) { // name ?>
	<?php if ($portal_info->sortUrl($portal_info->name) == "") { ?>
		<th data-name="name" class="<?php echo $portal_info->name->headerCellClass() ?>"><div id="elh_portal_info_name" class="portal_info_name"><div class="ew-table-header-caption"><?php echo $portal_info->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $portal_info->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->name) ?>',2);"><div id="elh_portal_info_name" class="portal_info_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->_email->Visible) { // email ?>
	<?php if ($portal_info->sortUrl($portal_info->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $portal_info->_email->headerCellClass() ?>"><div id="elh_portal_info__email" class="portal_info__email"><div class="ew-table-header-caption"><?php echo $portal_info->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $portal_info->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->_email) ?>',2);"><div id="elh_portal_info__email" class="portal_info__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->mobile->Visible) { // mobile ?>
	<?php if ($portal_info->sortUrl($portal_info->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $portal_info->mobile->headerCellClass() ?>"><div id="elh_portal_info_mobile" class="portal_info_mobile"><div class="ew-table-header-caption"><?php echo $portal_info->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $portal_info->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->mobile) ?>',2);"><div id="elh_portal_info_mobile" class="portal_info_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->gst->Visible) { // gst ?>
	<?php if ($portal_info->sortUrl($portal_info->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $portal_info->gst->headerCellClass() ?>"><div id="elh_portal_info_gst" class="portal_info_gst"><div class="ew-table-header-caption"><?php echo $portal_info->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $portal_info->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->gst) ?>',2);"><div id="elh_portal_info_gst" class="portal_info_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->gst->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->other->Visible) { // other ?>
	<?php if ($portal_info->sortUrl($portal_info->other) == "") { ?>
		<th data-name="other" class="<?php echo $portal_info->other->headerCellClass() ?>"><div id="elh_portal_info_other" class="portal_info_other"><div class="ew-table-header-caption"><?php echo $portal_info->other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other" class="<?php echo $portal_info->other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->other) ?>',2);"><div id="elh_portal_info_other" class="portal_info_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->other->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->admin_mobile->Visible) { // admin_mobile ?>
	<?php if ($portal_info->sortUrl($portal_info->admin_mobile) == "") { ?>
		<th data-name="admin_mobile" class="<?php echo $portal_info->admin_mobile->headerCellClass() ?>"><div id="elh_portal_info_admin_mobile" class="portal_info_admin_mobile"><div class="ew-table-header-caption"><?php echo $portal_info->admin_mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="admin_mobile" class="<?php echo $portal_info->admin_mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->admin_mobile) ?>',2);"><div id="elh_portal_info_admin_mobile" class="portal_info_admin_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->admin_mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->admin_mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->admin_mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->tag_line->Visible) { // tag_line ?>
	<?php if ($portal_info->sortUrl($portal_info->tag_line) == "") { ?>
		<th data-name="tag_line" class="<?php echo $portal_info->tag_line->headerCellClass() ?>"><div id="elh_portal_info_tag_line" class="portal_info_tag_line"><div class="ew-table-header-caption"><?php echo $portal_info->tag_line->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tag_line" class="<?php echo $portal_info->tag_line->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->tag_line) ?>',2);"><div id="elh_portal_info_tag_line" class="portal_info_tag_line">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->tag_line->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_info->tag_line->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->tag_line->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->operator->Visible) { // operator ?>
	<?php if ($portal_info->sortUrl($portal_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $portal_info->operator->headerCellClass() ?>"><div id="elh_portal_info_operator" class="portal_info_operator"><div class="ew-table-header-caption"><?php echo $portal_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $portal_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->operator) ?>',2);"><div id="elh_portal_info_operator" class="portal_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_info->datetime->Visible) { // datetime ?>
	<?php if ($portal_info->sortUrl($portal_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $portal_info->datetime->headerCellClass() ?>"><div id="elh_portal_info_datetime" class="portal_info_datetime"><div class="ew-table-header-caption"><?php echo $portal_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $portal_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_info->SortUrl($portal_info->datetime) ?>',2);"><div id="elh_portal_info_datetime" class="portal_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$portal_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($portal_info->ExportAll && $portal_info->isExport()) {
	$portal_info_list->StopRec = $portal_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($portal_info_list->TotalRecs > $portal_info_list->StartRec + $portal_info_list->DisplayRecs - 1)
		$portal_info_list->StopRec = $portal_info_list->StartRec + $portal_info_list->DisplayRecs - 1;
	else
		$portal_info_list->StopRec = $portal_info_list->TotalRecs;
}
$portal_info_list->RecCnt = $portal_info_list->StartRec - 1;
if ($portal_info_list->Recordset && !$portal_info_list->Recordset->EOF) {
	$portal_info_list->Recordset->moveFirst();
	$selectLimit = $portal_info_list->UseSelectLimit;
	if (!$selectLimit && $portal_info_list->StartRec > 1)
		$portal_info_list->Recordset->move($portal_info_list->StartRec - 1);
} elseif (!$portal_info->AllowAddDeleteRow && $portal_info_list->StopRec == 0) {
	$portal_info_list->StopRec = $portal_info->GridAddRowCount;
}

// Initialize aggregate
$portal_info->RowType = ROWTYPE_AGGREGATEINIT;
$portal_info->resetAttributes();
$portal_info_list->renderRow();
while ($portal_info_list->RecCnt < $portal_info_list->StopRec) {
	$portal_info_list->RecCnt++;
	if ($portal_info_list->RecCnt >= $portal_info_list->StartRec) {
		$portal_info_list->RowCnt++;

		// Set up key count
		$portal_info_list->KeyCount = $portal_info_list->RowIndex;

		// Init row class and style
		$portal_info->resetAttributes();
		$portal_info->CssClass = "";
		if ($portal_info->isGridAdd()) {
		} else {
			$portal_info_list->loadRowValues($portal_info_list->Recordset); // Load row values
		}
		$portal_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$portal_info->RowAttrs = array_merge($portal_info->RowAttrs, array('data-rowindex'=>$portal_info_list->RowCnt, 'id'=>'r' . $portal_info_list->RowCnt . '_portal_info', 'data-rowtype'=>$portal_info->RowType));

		// Render row
		$portal_info_list->renderRow();

		// Render list options
		$portal_info_list->renderListOptions();
?>
	<tr<?php echo $portal_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$portal_info_list->ListOptions->render("body", "left", $portal_info_list->RowCnt);
?>
	<?php if ($portal_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $portal_info->id->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_id" class="portal_info_id">
<span<?php echo $portal_info->id->viewAttributes() ?>>
<?php echo $portal_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->logo->Visible) { // logo ?>
		<td data-name="logo"<?php echo $portal_info->logo->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_logo" class="portal_info_logo">
<span<?php echo $portal_info->logo->viewAttributes() ?>>
<?php echo GetFileViewTag($portal_info->logo, $portal_info->logo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->mobile_logo->Visible) { // mobile_logo ?>
		<td data-name="mobile_logo"<?php echo $portal_info->mobile_logo->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_mobile_logo" class="portal_info_mobile_logo">
<span<?php echo $portal_info->mobile_logo->viewAttributes() ?>>
<?php echo GetFileViewTag($portal_info->mobile_logo, $portal_info->mobile_logo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->name->Visible) { // name ?>
		<td data-name="name"<?php echo $portal_info->name->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_name" class="portal_info_name">
<span<?php echo $portal_info->name->viewAttributes() ?>>
<?php echo $portal_info->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $portal_info->_email->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info__email" class="portal_info__email">
<span<?php echo $portal_info->_email->viewAttributes() ?>>
<?php echo $portal_info->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $portal_info->mobile->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_mobile" class="portal_info_mobile">
<span<?php echo $portal_info->mobile->viewAttributes() ?>>
<?php echo $portal_info->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $portal_info->gst->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_gst" class="portal_info_gst">
<span<?php echo $portal_info->gst->viewAttributes() ?>>
<?php echo $portal_info->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->other->Visible) { // other ?>
		<td data-name="other"<?php echo $portal_info->other->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_other" class="portal_info_other">
<span<?php echo $portal_info->other->viewAttributes() ?>>
<?php echo $portal_info->other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->admin_mobile->Visible) { // admin_mobile ?>
		<td data-name="admin_mobile"<?php echo $portal_info->admin_mobile->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_admin_mobile" class="portal_info_admin_mobile">
<span<?php echo $portal_info->admin_mobile->viewAttributes() ?>>
<?php echo $portal_info->admin_mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->tag_line->Visible) { // tag_line ?>
		<td data-name="tag_line"<?php echo $portal_info->tag_line->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_tag_line" class="portal_info_tag_line">
<span<?php echo $portal_info->tag_line->viewAttributes() ?>>
<?php echo $portal_info->tag_line->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $portal_info->operator->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_operator" class="portal_info_operator">
<span<?php echo $portal_info->operator->viewAttributes() ?>>
<?php echo $portal_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $portal_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $portal_info_list->RowCnt ?>_portal_info_datetime" class="portal_info_datetime">
<span<?php echo $portal_info->datetime->viewAttributes() ?>>
<?php echo $portal_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$portal_info_list->ListOptions->render("body", "right", $portal_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$portal_info->isGridAdd())
		$portal_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$portal_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($portal_info_list->Recordset)
	$portal_info_list->Recordset->Close();
?>
<?php if (!$portal_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$portal_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_info_list->Pager)) $portal_info_list->Pager = new PrevNextPager($portal_info_list->StartRec, $portal_info_list->DisplayRecs, $portal_info_list->TotalRecs, $portal_info_list->AutoHidePager) ?>
<?php if ($portal_info_list->Pager->RecordCount > 0 && $portal_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_info_list->pageUrl() ?>start=<?php echo $portal_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_info_list->TotalRecs > 0 && (!$portal_info_list->AutoHidePageSizeSelector || $portal_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($portal_info_list->TotalRecs == 0 && !$portal_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $portal_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$portal_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$portal_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$portal_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_portal_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$portal_info_list->terminate();
?>