<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_info_search = new portal_info_search();

// Run the page
$portal_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($portal_info_search->IsModal) { ?>
var fportal_infosearch = currentAdvancedSearchForm = new ew.Form("fportal_infosearch", "search");
<?php } else { ?>
var fportal_infosearch = currentForm = new ew.Form("fportal_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
fportal_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_infosearch.lists["x_operator"] = <?php echo $portal_info_search->operator->Lookup->toClientList() ?>;
fportal_infosearch.lists["x_operator"].options = <?php echo JsonEncode($portal_info_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fportal_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($portal_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($portal_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_info_search->showPageHeader(); ?>
<?php
$portal_info_search->showMessage();
?>
<form name="fportal_infosearch" id="fportal_infosearch" class="<?php echo $portal_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$portal_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($portal_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_id"><?php echo $portal_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->id->cellAttributes() ?>>
			<span id="el_portal_info_id">
<input type="text" data-table="portal_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($portal_info->id->getPlaceHolder()) ?>" value="<?php echo $portal_info->id->EditValue ?>"<?php echo $portal_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->logo->Visible) { // logo ?>
	<div id="r_logo" class="form-group row">
		<label class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_logo"><?php echo $portal_info->logo->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_logo" id="z_logo" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->logo->cellAttributes() ?>>
			<span id="el_portal_info_logo">
<input type="text" data-table="portal_info" data-field="x_logo" name="x_logo" id="x_logo" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($portal_info->logo->getPlaceHolder()) ?>" value="<?php echo $portal_info->logo->EditValue ?>"<?php echo $portal_info->logo->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->mobile_logo->Visible) { // mobile_logo ?>
	<div id="r_mobile_logo" class="form-group row">
		<label class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_mobile_logo"><?php echo $portal_info->mobile_logo->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile_logo" id="z_mobile_logo" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->mobile_logo->cellAttributes() ?>>
			<span id="el_portal_info_mobile_logo">
<input type="text" data-table="portal_info" data-field="x_mobile_logo" name="x_mobile_logo" id="x_mobile_logo" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($portal_info->mobile_logo->getPlaceHolder()) ?>" value="<?php echo $portal_info->mobile_logo->EditValue ?>"<?php echo $portal_info->mobile_logo->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_name"><?php echo $portal_info->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->name->cellAttributes() ?>>
			<span id="el_portal_info_name">
<input type="text" data-table="portal_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($portal_info->name->getPlaceHolder()) ?>" value="<?php echo $portal_info->name->EditValue ?>"<?php echo $portal_info->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_address"><?php echo $portal_info->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->address->cellAttributes() ?>>
			<span id="el_portal_info_address">
<input type="text" data-table="portal_info" data-field="x_address" name="x_address" id="x_address" size="35" placeholder="<?php echo HtmlEncode($portal_info->address->getPlaceHolder()) ?>" value="<?php echo $portal_info->address->EditValue ?>"<?php echo $portal_info->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info__email"><?php echo $portal_info->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->_email->cellAttributes() ?>>
			<span id="el_portal_info__email">
<input type="text" data-table="portal_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($portal_info->_email->getPlaceHolder()) ?>" value="<?php echo $portal_info->_email->EditValue ?>"<?php echo $portal_info->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_mobile"><?php echo $portal_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->mobile->cellAttributes() ?>>
			<span id="el_portal_info_mobile">
<input type="text" data-table="portal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($portal_info->mobile->getPlaceHolder()) ?>" value="<?php echo $portal_info->mobile->EditValue ?>"<?php echo $portal_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_gst"><?php echo $portal_info->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gst" id="z_gst" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->gst->cellAttributes() ?>>
			<span id="el_portal_info_gst">
<input type="text" data-table="portal_info" data-field="x_gst" name="x_gst" id="x_gst" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($portal_info->gst->getPlaceHolder()) ?>" value="<?php echo $portal_info->gst->EditValue ?>"<?php echo $portal_info->gst->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->other->Visible) { // other ?>
	<div id="r_other" class="form-group row">
		<label for="x_other" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_other"><?php echo $portal_info->other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other" id="z_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->other->cellAttributes() ?>>
			<span id="el_portal_info_other">
<input type="text" data-table="portal_info" data-field="x_other" name="x_other" id="x_other" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($portal_info->other->getPlaceHolder()) ?>" value="<?php echo $portal_info->other->EditValue ?>"<?php echo $portal_info->other->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->admin_mobile->Visible) { // admin_mobile ?>
	<div id="r_admin_mobile" class="form-group row">
		<label for="x_admin_mobile" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_admin_mobile"><?php echo $portal_info->admin_mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_admin_mobile" id="z_admin_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->admin_mobile->cellAttributes() ?>>
			<span id="el_portal_info_admin_mobile">
<input type="text" data-table="portal_info" data-field="x_admin_mobile" name="x_admin_mobile" id="x_admin_mobile" size="30" maxlength="44" placeholder="<?php echo HtmlEncode($portal_info->admin_mobile->getPlaceHolder()) ?>" value="<?php echo $portal_info->admin_mobile->EditValue ?>"<?php echo $portal_info->admin_mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->header->Visible) { // header ?>
	<div id="r_header" class="form-group row">
		<label class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_header"><?php echo $portal_info->header->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_header" id="z_header" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->header->cellAttributes() ?>>
			<span id="el_portal_info_header">
<input type="text" data-table="portal_info" data-field="x_header" name="x_header" id="x_header" size="35" placeholder="<?php echo HtmlEncode($portal_info->header->getPlaceHolder()) ?>" value="<?php echo $portal_info->header->EditValue ?>"<?php echo $portal_info->header->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->footer->Visible) { // footer ?>
	<div id="r_footer" class="form-group row">
		<label class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_footer"><?php echo $portal_info->footer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_footer" id="z_footer" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->footer->cellAttributes() ?>>
			<span id="el_portal_info_footer">
<input type="text" data-table="portal_info" data-field="x_footer" name="x_footer" id="x_footer" size="35" placeholder="<?php echo HtmlEncode($portal_info->footer->getPlaceHolder()) ?>" value="<?php echo $portal_info->footer->EditValue ?>"<?php echo $portal_info->footer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->tag_line->Visible) { // tag_line ?>
	<div id="r_tag_line" class="form-group row">
		<label for="x_tag_line" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_tag_line"><?php echo $portal_info->tag_line->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tag_line" id="z_tag_line" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->tag_line->cellAttributes() ?>>
			<span id="el_portal_info_tag_line">
<input type="text" data-table="portal_info" data-field="x_tag_line" name="x_tag_line" id="x_tag_line" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($portal_info->tag_line->getPlaceHolder()) ?>" value="<?php echo $portal_info->tag_line->EditValue ?>"<?php echo $portal_info->tag_line->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_operator"><?php echo $portal_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->operator->cellAttributes() ?>>
			<span id="el_portal_info_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="portal_info" data-field="x_operator" data-value-separator="<?php echo $portal_info->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $portal_info->operator->editAttributes() ?>>
		<?php echo $portal_info->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $portal_info->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $portal_info_search->LeftColumnClass ?>"><span id="elh_portal_info_datetime"><?php echo $portal_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $portal_info_search->RightColumnClass ?>"><div<?php echo $portal_info->datetime->cellAttributes() ?>>
			<span id="el_portal_info_datetime">
<input type="text" data-table="portal_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($portal_info->datetime->getPlaceHolder()) ?>" value="<?php echo $portal_info->datetime->EditValue ?>"<?php echo $portal_info->datetime->editAttributes() ?>>
<?php if (!$portal_info->datetime->ReadOnly && !$portal_info->datetime->Disabled && !isset($portal_info->datetime->EditAttrs["readonly"]) && !isset($portal_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fportal_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_info_search->terminate();
?>