<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_list_delete = new portal_list_delete();

// Run the page
$portal_list_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_list_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fportal_listdelete = currentForm = new ew.Form("fportal_listdelete", "delete");

// Form_CustomValidate event
fportal_listdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_listdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_listdelete.lists["x_category"] = <?php echo $portal_list_delete->category->Lookup->toClientList() ?>;
fportal_listdelete.lists["x_category"].options = <?php echo JsonEncode($portal_list_delete->category->lookupOptions()) ?>;
fportal_listdelete.autoSuggests["x_category"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_list_delete->showPageHeader(); ?>
<?php
$portal_list_delete->showMessage();
?>
<form name="fportal_listdelete" id="fportal_listdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_list_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_list_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_list">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($portal_list_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($portal_list->id->Visible) { // id ?>
		<th class="<?php echo $portal_list->id->headerCellClass() ?>"><span id="elh_portal_list_id" class="portal_list_id"><?php echo $portal_list->id->caption() ?></span></th>
<?php } ?>
<?php if ($portal_list->url->Visible) { // url ?>
		<th class="<?php echo $portal_list->url->headerCellClass() ?>"><span id="elh_portal_list_url" class="portal_list_url"><?php echo $portal_list->url->caption() ?></span></th>
<?php } ?>
<?php if ($portal_list->db->Visible) { // db ?>
		<th class="<?php echo $portal_list->db->headerCellClass() ?>"><span id="elh_portal_list_db" class="portal_list_db"><?php echo $portal_list->db->caption() ?></span></th>
<?php } ?>
<?php if ($portal_list->category->Visible) { // category ?>
		<th class="<?php echo $portal_list->category->headerCellClass() ?>"><span id="elh_portal_list_category" class="portal_list_category"><?php echo $portal_list->category->caption() ?></span></th>
<?php } ?>
<?php if ($portal_list->status->Visible) { // status ?>
		<th class="<?php echo $portal_list->status->headerCellClass() ?>"><span id="elh_portal_list_status" class="portal_list_status"><?php echo $portal_list->status->caption() ?></span></th>
<?php } ?>
<?php if ($portal_list->php_version->Visible) { // php_version ?>
		<th class="<?php echo $portal_list->php_version->headerCellClass() ?>"><span id="elh_portal_list_php_version" class="portal_list_php_version"><?php echo $portal_list->php_version->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$portal_list_delete->RecCnt = 0;
$i = 0;
while (!$portal_list_delete->Recordset->EOF) {
	$portal_list_delete->RecCnt++;
	$portal_list_delete->RowCnt++;

	// Set row properties
	$portal_list->resetAttributes();
	$portal_list->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$portal_list_delete->loadRowValues($portal_list_delete->Recordset);

	// Render row
	$portal_list_delete->renderRow();
?>
	<tr<?php echo $portal_list->rowAttributes() ?>>
<?php if ($portal_list->id->Visible) { // id ?>
		<td<?php echo $portal_list->id->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_id" class="portal_list_id">
<span<?php echo $portal_list->id->viewAttributes() ?>>
<?php echo $portal_list->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($portal_list->url->Visible) { // url ?>
		<td<?php echo $portal_list->url->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_url" class="portal_list_url">
<span<?php echo $portal_list->url->viewAttributes() ?>>
<?php echo $portal_list->url->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($portal_list->db->Visible) { // db ?>
		<td<?php echo $portal_list->db->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_db" class="portal_list_db">
<span<?php echo $portal_list->db->viewAttributes() ?>>
<?php echo $portal_list->db->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($portal_list->category->Visible) { // category ?>
		<td<?php echo $portal_list->category->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_category" class="portal_list_category">
<span<?php echo $portal_list->category->viewAttributes() ?>>
<?php echo $portal_list->category->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($portal_list->status->Visible) { // status ?>
		<td<?php echo $portal_list->status->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_status" class="portal_list_status">
<span<?php echo $portal_list->status->viewAttributes() ?>>
<?php echo $portal_list->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($portal_list->php_version->Visible) { // php_version ?>
		<td<?php echo $portal_list->php_version->cellAttributes() ?>>
<span id="el<?php echo $portal_list_delete->RowCnt ?>_portal_list_php_version" class="portal_list_php_version">
<span<?php echo $portal_list->php_version->viewAttributes() ?>>
<?php echo $portal_list->php_version->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$portal_list_delete->Recordset->moveNext();
}
$portal_list_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $portal_list_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$portal_list_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_list_delete->terminate();
?>