<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_list_edit = new portal_list_edit();

// Run the page
$portal_list_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_list_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fportal_listedit = currentForm = new ew.Form("fportal_listedit", "edit");

// Validate form
fportal_listedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($portal_list_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->id->caption(), $portal_list->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_list_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->url->caption(), $portal_list->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_list_edit->db->Required) { ?>
			elm = this.getElements("x" + infix + "_db");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->db->caption(), $portal_list->db->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_list_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->category->caption(), $portal_list->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_list_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->status->caption(), $portal_list->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_list->status->errorMessage()) ?>");
		<?php if ($portal_list_edit->php_version->Required) { ?>
			elm = this.getElements("x" + infix + "_php_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_list->php_version->caption(), $portal_list->php_version->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportal_listedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_listedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_listedit.lists["x_category"] = <?php echo $portal_list_edit->category->Lookup->toClientList() ?>;
fportal_listedit.lists["x_category"].options = <?php echo JsonEncode($portal_list_edit->category->lookupOptions()) ?>;
fportal_listedit.autoSuggests["x_category"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_list_edit->showPageHeader(); ?>
<?php
$portal_list_edit->showMessage();
?>
<form name="fportal_listedit" id="fportal_listedit" class="<?php echo $portal_list_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_list_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_list_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_list">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$portal_list_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($portal_list->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_portal_list_id" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->id->caption() ?><?php echo ($portal_list->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->id->cellAttributes() ?>>
<span id="el_portal_list_id">
<span<?php echo $portal_list->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($portal_list->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="portal_list" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($portal_list->id->CurrentValue) ?>">
<?php echo $portal_list->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_list->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_portal_list_url" for="x_url" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->url->caption() ?><?php echo ($portal_list->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->url->cellAttributes() ?>>
<span id="el_portal_list_url">
<input type="text" data-table="portal_list" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($portal_list->url->getPlaceHolder()) ?>" value="<?php echo $portal_list->url->EditValue ?>"<?php echo $portal_list->url->editAttributes() ?>>
</span>
<?php echo $portal_list->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_list->db->Visible) { // db ?>
	<div id="r_db" class="form-group row">
		<label id="elh_portal_list_db" for="x_db" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->db->caption() ?><?php echo ($portal_list->db->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->db->cellAttributes() ?>>
<span id="el_portal_list_db">
<input type="text" data-table="portal_list" data-field="x_db" name="x_db" id="x_db" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($portal_list->db->getPlaceHolder()) ?>" value="<?php echo $portal_list->db->EditValue ?>"<?php echo $portal_list->db->editAttributes() ?>>
</span>
<?php echo $portal_list->db->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_list->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_portal_list_category" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->category->caption() ?><?php echo ($portal_list->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->category->cellAttributes() ?>>
<span id="el_portal_list_category">
<?php
$wrkonchange = "" . trim(@$portal_list->category->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$portal_list->category->EditAttrs["onchange"] = "";
?>
<span id="as_x_category" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_category" id="sv_x_category" value="<?php echo RemoveHtml($portal_list->category->EditValue) ?>" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_list->category->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($portal_list->category->getPlaceHolder()) ?>"<?php echo $portal_list->category->editAttributes() ?>>
</span>
<input type="hidden" data-table="portal_list" data-field="x_category" data-value-separator="<?php echo $portal_list->category->displayValueSeparatorAttribute() ?>" name="x_category" id="x_category" value="<?php echo HtmlEncode($portal_list->category->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fportal_listedit.createAutoSuggest({"id":"x_category","forceSelect":false});
</script>
<?php echo $portal_list->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $portal_list->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_list->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_portal_list_status" for="x_status" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->status->caption() ?><?php echo ($portal_list->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->status->cellAttributes() ?>>
<span id="el_portal_list_status">
<input type="text" data-table="portal_list" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($portal_list->status->getPlaceHolder()) ?>" value="<?php echo $portal_list->status->EditValue ?>"<?php echo $portal_list->status->editAttributes() ?>>
</span>
<?php echo $portal_list->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_list->php_version->Visible) { // php_version ?>
	<div id="r_php_version" class="form-group row">
		<label id="elh_portal_list_php_version" for="x_php_version" class="<?php echo $portal_list_edit->LeftColumnClass ?>"><?php echo $portal_list->php_version->caption() ?><?php echo ($portal_list->php_version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_list_edit->RightColumnClass ?>"><div<?php echo $portal_list->php_version->cellAttributes() ?>>
<span id="el_portal_list_php_version">
<input type="text" data-table="portal_list" data-field="x_php_version" name="x_php_version" id="x_php_version" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($portal_list->php_version->getPlaceHolder()) ?>" value="<?php echo $portal_list->php_version->EditValue ?>"<?php echo $portal_list->php_version->editAttributes() ?>>
</span>
<?php echo $portal_list->php_version->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_list_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_list_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $portal_list_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_list_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_list_edit->terminate();
?>