<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_list_view = new portal_list_view();

// Run the page
$portal_list_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_list_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$portal_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fportal_listview = currentForm = new ew.Form("fportal_listview", "view");

// Form_CustomValidate event
fportal_listview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_listview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_listview.lists["x_category"] = <?php echo $portal_list_view->category->Lookup->toClientList() ?>;
fportal_listview.lists["x_category"].options = <?php echo JsonEncode($portal_list_view->category->lookupOptions()) ?>;
fportal_listview.autoSuggests["x_category"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$portal_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $portal_list_view->ExportOptions->render("body") ?>
<?php $portal_list_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $portal_list_view->showPageHeader(); ?>
<?php
$portal_list_view->showMessage();
?>
<form name="fportal_listview" id="fportal_listview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_list_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_list_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_list">
<input type="hidden" name="modal" value="<?php echo (int)$portal_list_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($portal_list->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_id"><?php echo $portal_list->id->caption() ?></span></td>
		<td data-name="id"<?php echo $portal_list->id->cellAttributes() ?>>
<span id="el_portal_list_id">
<span<?php echo $portal_list->id->viewAttributes() ?>>
<?php echo $portal_list->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_list->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_url"><?php echo $portal_list->url->caption() ?></span></td>
		<td data-name="url"<?php echo $portal_list->url->cellAttributes() ?>>
<span id="el_portal_list_url">
<span<?php echo $portal_list->url->viewAttributes() ?>>
<?php echo $portal_list->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_list->db->Visible) { // db ?>
	<tr id="r_db">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_db"><?php echo $portal_list->db->caption() ?></span></td>
		<td data-name="db"<?php echo $portal_list->db->cellAttributes() ?>>
<span id="el_portal_list_db">
<span<?php echo $portal_list->db->viewAttributes() ?>>
<?php echo $portal_list->db->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_list->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_category"><?php echo $portal_list->category->caption() ?></span></td>
		<td data-name="category"<?php echo $portal_list->category->cellAttributes() ?>>
<span id="el_portal_list_category">
<span<?php echo $portal_list->category->viewAttributes() ?>>
<?php echo $portal_list->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_list->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_status"><?php echo $portal_list->status->caption() ?></span></td>
		<td data-name="status"<?php echo $portal_list->status->cellAttributes() ?>>
<span id="el_portal_list_status">
<span<?php echo $portal_list->status->viewAttributes() ?>>
<?php echo $portal_list->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_list->php_version->Visible) { // php_version ?>
	<tr id="r_php_version">
		<td class="<?php echo $portal_list_view->TableLeftColumnClass ?>"><span id="elh_portal_list_php_version"><?php echo $portal_list->php_version->caption() ?></span></td>
		<td data-name="php_version"<?php echo $portal_list->php_version->cellAttributes() ?>>
<span id="el_portal_list_php_version">
<span<?php echo $portal_list->php_version->viewAttributes() ?>>
<?php echo $portal_list->php_version->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$portal_list_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$portal_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$portal_list_view->terminate();
?>