<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_setup_edit = new portal_setup_edit();

// Run the page
$portal_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fportal_setupedit = currentForm = new ew.Form("fportal_setupedit", "edit");

// Validate form
fportal_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($portal_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->id->caption(), $portal_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->url->caption(), $portal_setup->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->admin_url->Required) { ?>
			elm = this.getElements("x" + infix + "_admin_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->admin_url->caption(), $portal_setup->admin_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->mail_code->Required) { ?>
			elm = this.getElements("x" + infix + "_mail_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->mail_code->caption(), $portal_setup->mail_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->footer_line->Required) { ?>
			elm = this.getElements("x" + infix + "_footer_line");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->footer_line->caption(), $portal_setup->footer_line->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->portal_category->Required) { ?>
			elm = this.getElements("x" + infix + "_portal_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->portal_category->caption(), $portal_setup->portal_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->mcu->Required) { ?>
			elm = this.getElements("x" + infix + "_mcu");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->mcu->caption(), $portal_setup->mcu->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mcu");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->mcu->errorMessage()) ?>");
		<?php if ($portal_setup_edit->fcm_server_key->Required) { ?>
			elm = this.getElements("x" + infix + "_fcm_server_key");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->fcm_server_key->caption(), $portal_setup->fcm_server_key->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->app_version->Required) { ?>
			elm = this.getElements("x" + infix + "_app_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->app_version->caption(), $portal_setup->app_version->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_app_version");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->app_version->errorMessage()) ?>");
		<?php if ($portal_setup_edit->pd_byepass->Required) { ?>
			elm = this.getElements("x" + infix + "_pd_byepass");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->pd_byepass->caption(), $portal_setup->pd_byepass->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->operator->caption(), $portal_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->operator->errorMessage()) ?>");
		<?php if ($portal_setup_edit->google_map_api->Required) { ?>
			elm = this.getElements("x" + infix + "_google_map_api");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->google_map_api->caption(), $portal_setup->google_map_api->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->material_payment_type->Required) { ?>
			elm = this.getElements("x" + infix + "_material_payment_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->material_payment_type->caption(), $portal_setup->material_payment_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_material_payment_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->material_payment_type->errorMessage()) ?>");
		<?php if ($portal_setup_edit->material_payment_varient->Required) { ?>
			elm = this.getElements("x" + infix + "_material_payment_varient");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->material_payment_varient->caption(), $portal_setup->material_payment_varient->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_material_payment_varient");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->material_payment_varient->errorMessage()) ?>");
		<?php if ($portal_setup_edit->footer_line_be->Required) { ?>
			elm = this.getElements("x" + infix + "_footer_line_be");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->footer_line_be->caption(), $portal_setup->footer_line_be->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->allow_reg->Required) { ?>
			elm = this.getElements("x" + infix + "_allow_reg");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->allow_reg->caption(), $portal_setup->allow_reg->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_allow_reg");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->allow_reg->errorMessage()) ?>");
		<?php if ($portal_setup_edit->login_remember->Required) { ?>
			elm = this.getElements("x" + infix + "_login_remember");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->login_remember->caption(), $portal_setup->login_remember->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_login_remember");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->login_remember->errorMessage()) ?>");
		<?php if ($portal_setup_edit->gp_p_check->Required) { ?>
			elm = this.getElements("x" + infix + "_gp_p_check");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->gp_p_check->caption(), $portal_setup->gp_p_check->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_gp_p_check");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_setup->gp_p_check->errorMessage()) ?>");
		<?php if ($portal_setup_edit->fe_version->Required) { ?>
			elm = this.getElements("x" + infix + "_fe_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->fe_version->caption(), $portal_setup->fe_version->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->admin_version->Required) { ?>
			elm = this.getElements("x" + infix + "_admin_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->admin_version->caption(), $portal_setup->admin_version->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->dashboard->Required) { ?>
			elm = this.getElements("x" + infix + "_dashboard");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->dashboard->caption(), $portal_setup->dashboard->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->developer_upi_id->Required) { ?>
			elm = this.getElements("x" + infix + "_developer_upi_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->developer_upi_id->caption(), $portal_setup->developer_upi_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->developer_company->Required) { ?>
			elm = this.getElements("x" + infix + "_developer_company");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->developer_company->caption(), $portal_setup->developer_company->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_setup_edit->default_page->Required) { ?>
			elm = this.getElements("x" + infix + "_default_page");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_setup->default_page->caption(), $portal_setup->default_page->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportal_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_setupedit.lists["x_portal_category[]"] = <?php echo $portal_setup_edit->portal_category->Lookup->toClientList() ?>;
fportal_setupedit.lists["x_portal_category[]"].options = <?php echo JsonEncode($portal_setup_edit->portal_category->lookupOptions()) ?>;
fportal_setupedit.lists["x_pd_byepass"] = <?php echo $portal_setup_edit->pd_byepass->Lookup->toClientList() ?>;
fportal_setupedit.lists["x_pd_byepass"].options = <?php echo JsonEncode($portal_setup_edit->pd_byepass->options(FALSE, TRUE)) ?>;
fportal_setupedit.lists["x_dashboard"] = <?php echo $portal_setup_edit->dashboard->Lookup->toClientList() ?>;
fportal_setupedit.lists["x_dashboard"].options = <?php echo JsonEncode($portal_setup_edit->dashboard->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_setup_edit->showPageHeader(); ?>
<?php
$portal_setup_edit->showMessage();
?>
<form name="fportal_setupedit" id="fportal_setupedit" class="<?php echo $portal_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$portal_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($portal_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_portal_setup_id" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->id->caption() ?><?php echo ($portal_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->id->cellAttributes() ?>>
<span id="el_portal_setup_id">
<span<?php echo $portal_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($portal_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="portal_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($portal_setup->id->CurrentValue) ?>">
<?php echo $portal_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_portal_setup_url" for="x_url" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->url->caption() ?><?php echo ($portal_setup->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->url->cellAttributes() ?>>
<span id="el_portal_setup_url">
<input type="text" data-table="portal_setup" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($portal_setup->url->getPlaceHolder()) ?>" value="<?php echo $portal_setup->url->EditValue ?>"<?php echo $portal_setup->url->editAttributes() ?>>
</span>
<?php echo $portal_setup->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->admin_url->Visible) { // admin_url ?>
	<div id="r_admin_url" class="form-group row">
		<label id="elh_portal_setup_admin_url" for="x_admin_url" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->admin_url->caption() ?><?php echo ($portal_setup->admin_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->admin_url->cellAttributes() ?>>
<span id="el_portal_setup_admin_url">
<input type="text" data-table="portal_setup" data-field="x_admin_url" name="x_admin_url" id="x_admin_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($portal_setup->admin_url->getPlaceHolder()) ?>" value="<?php echo $portal_setup->admin_url->EditValue ?>"<?php echo $portal_setup->admin_url->editAttributes() ?>>
</span>
<?php echo $portal_setup->admin_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->mail_code->Visible) { // mail_code ?>
	<div id="r_mail_code" class="form-group row">
		<label id="elh_portal_setup_mail_code" for="x_mail_code" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->mail_code->caption() ?><?php echo ($portal_setup->mail_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->mail_code->cellAttributes() ?>>
<span id="el_portal_setup_mail_code">
<textarea data-table="portal_setup" data-field="x_mail_code" name="x_mail_code" id="x_mail_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($portal_setup->mail_code->getPlaceHolder()) ?>"<?php echo $portal_setup->mail_code->editAttributes() ?>><?php echo $portal_setup->mail_code->EditValue ?></textarea>
</span>
<?php echo $portal_setup->mail_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->footer_line->Visible) { // footer_line ?>
	<div id="r_footer_line" class="form-group row">
		<label id="elh_portal_setup_footer_line" for="x_footer_line" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->footer_line->caption() ?><?php echo ($portal_setup->footer_line->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->footer_line->cellAttributes() ?>>
<span id="el_portal_setup_footer_line">
<textarea data-table="portal_setup" data-field="x_footer_line" name="x_footer_line" id="x_footer_line" cols="35" rows="4" placeholder="<?php echo HtmlEncode($portal_setup->footer_line->getPlaceHolder()) ?>"<?php echo $portal_setup->footer_line->editAttributes() ?>><?php echo $portal_setup->footer_line->EditValue ?></textarea>
</span>
<?php echo $portal_setup->footer_line->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->portal_category->Visible) { // portal_category ?>
	<div id="r_portal_category" class="form-group row">
		<label id="elh_portal_setup_portal_category" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->portal_category->caption() ?><?php echo ($portal_setup->portal_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->portal_category->cellAttributes() ?>>
<span id="el_portal_setup_portal_category">
<div id="tp_x_portal_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="portal_setup" data-field="x_portal_category" data-value-separator="<?php echo $portal_setup->portal_category->displayValueSeparatorAttribute() ?>" name="x_portal_category[]" id="x_portal_category[]" value="{value}"<?php echo $portal_setup->portal_category->editAttributes() ?>></div>
<div id="dsl_x_portal_category" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $portal_setup->portal_category->checkBoxListHtml(FALSE, "x_portal_category[]") ?>
</div></div>
<?php echo $portal_setup->portal_category->Lookup->getParamTag("p_x_portal_category") ?>
</span>
<?php echo $portal_setup->portal_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->mcu->Visible) { // mcu ?>
	<div id="r_mcu" class="form-group row">
		<label id="elh_portal_setup_mcu" for="x_mcu" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->mcu->caption() ?><?php echo ($portal_setup->mcu->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->mcu->cellAttributes() ?>>
<span id="el_portal_setup_mcu">
<input type="text" data-table="portal_setup" data-field="x_mcu" name="x_mcu" id="x_mcu" size="30" placeholder="<?php echo HtmlEncode($portal_setup->mcu->getPlaceHolder()) ?>" value="<?php echo $portal_setup->mcu->EditValue ?>"<?php echo $portal_setup->mcu->editAttributes() ?>>
</span>
<?php echo $portal_setup->mcu->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->fcm_server_key->Visible) { // fcm_server_key ?>
	<div id="r_fcm_server_key" class="form-group row">
		<label id="elh_portal_setup_fcm_server_key" for="x_fcm_server_key" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->fcm_server_key->caption() ?><?php echo ($portal_setup->fcm_server_key->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->fcm_server_key->cellAttributes() ?>>
<span id="el_portal_setup_fcm_server_key">
<input type="text" data-table="portal_setup" data-field="x_fcm_server_key" name="x_fcm_server_key" id="x_fcm_server_key" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($portal_setup->fcm_server_key->getPlaceHolder()) ?>" value="<?php echo $portal_setup->fcm_server_key->EditValue ?>"<?php echo $portal_setup->fcm_server_key->editAttributes() ?>>
</span>
<?php echo $portal_setup->fcm_server_key->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->app_version->Visible) { // app_version ?>
	<div id="r_app_version" class="form-group row">
		<label id="elh_portal_setup_app_version" for="x_app_version" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->app_version->caption() ?><?php echo ($portal_setup->app_version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->app_version->cellAttributes() ?>>
<span id="el_portal_setup_app_version">
<input type="text" data-table="portal_setup" data-field="x_app_version" name="x_app_version" id="x_app_version" size="30" placeholder="<?php echo HtmlEncode($portal_setup->app_version->getPlaceHolder()) ?>" value="<?php echo $portal_setup->app_version->EditValue ?>"<?php echo $portal_setup->app_version->editAttributes() ?>>
</span>
<?php echo $portal_setup->app_version->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->pd_byepass->Visible) { // pd_byepass ?>
	<div id="r_pd_byepass" class="form-group row">
		<label id="elh_portal_setup_pd_byepass" for="x_pd_byepass" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->pd_byepass->caption() ?><?php echo ($portal_setup->pd_byepass->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->pd_byepass->cellAttributes() ?>>
<span id="el_portal_setup_pd_byepass">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="portal_setup" data-field="x_pd_byepass" data-value-separator="<?php echo $portal_setup->pd_byepass->displayValueSeparatorAttribute() ?>" id="x_pd_byepass" name="x_pd_byepass"<?php echo $portal_setup->pd_byepass->editAttributes() ?>>
		<?php echo $portal_setup->pd_byepass->selectOptionListHtml("x_pd_byepass") ?>
	</select>
</div>
</span>
<?php echo $portal_setup->pd_byepass->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_portal_setup_operator" for="x_operator" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->operator->caption() ?><?php echo ($portal_setup->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->operator->cellAttributes() ?>>
<span id="el_portal_setup_operator">
<input type="text" data-table="portal_setup" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($portal_setup->operator->getPlaceHolder()) ?>" value="<?php echo $portal_setup->operator->EditValue ?>"<?php echo $portal_setup->operator->editAttributes() ?>>
</span>
<?php echo $portal_setup->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->google_map_api->Visible) { // google_map_api ?>
	<div id="r_google_map_api" class="form-group row">
		<label id="elh_portal_setup_google_map_api" for="x_google_map_api" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->google_map_api->caption() ?><?php echo ($portal_setup->google_map_api->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->google_map_api->cellAttributes() ?>>
<span id="el_portal_setup_google_map_api">
<input type="text" data-table="portal_setup" data-field="x_google_map_api" name="x_google_map_api" id="x_google_map_api" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($portal_setup->google_map_api->getPlaceHolder()) ?>" value="<?php echo $portal_setup->google_map_api->EditValue ?>"<?php echo $portal_setup->google_map_api->editAttributes() ?>>
</span>
<?php echo $portal_setup->google_map_api->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->material_payment_type->Visible) { // material_payment_type ?>
	<div id="r_material_payment_type" class="form-group row">
		<label id="elh_portal_setup_material_payment_type" for="x_material_payment_type" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->material_payment_type->caption() ?><?php echo ($portal_setup->material_payment_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->material_payment_type->cellAttributes() ?>>
<span id="el_portal_setup_material_payment_type">
<input type="text" data-table="portal_setup" data-field="x_material_payment_type" name="x_material_payment_type" id="x_material_payment_type" size="30" placeholder="<?php echo HtmlEncode($portal_setup->material_payment_type->getPlaceHolder()) ?>" value="<?php echo $portal_setup->material_payment_type->EditValue ?>"<?php echo $portal_setup->material_payment_type->editAttributes() ?>>
</span>
<?php echo $portal_setup->material_payment_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->material_payment_varient->Visible) { // material_payment_varient ?>
	<div id="r_material_payment_varient" class="form-group row">
		<label id="elh_portal_setup_material_payment_varient" for="x_material_payment_varient" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->material_payment_varient->caption() ?><?php echo ($portal_setup->material_payment_varient->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->material_payment_varient->cellAttributes() ?>>
<span id="el_portal_setup_material_payment_varient">
<input type="text" data-table="portal_setup" data-field="x_material_payment_varient" name="x_material_payment_varient" id="x_material_payment_varient" size="30" placeholder="<?php echo HtmlEncode($portal_setup->material_payment_varient->getPlaceHolder()) ?>" value="<?php echo $portal_setup->material_payment_varient->EditValue ?>"<?php echo $portal_setup->material_payment_varient->editAttributes() ?>>
</span>
<?php echo $portal_setup->material_payment_varient->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->footer_line_be->Visible) { // footer_line_be ?>
	<div id="r_footer_line_be" class="form-group row">
		<label id="elh_portal_setup_footer_line_be" for="x_footer_line_be" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->footer_line_be->caption() ?><?php echo ($portal_setup->footer_line_be->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->footer_line_be->cellAttributes() ?>>
<span id="el_portal_setup_footer_line_be">
<input type="text" data-table="portal_setup" data-field="x_footer_line_be" name="x_footer_line_be" id="x_footer_line_be" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($portal_setup->footer_line_be->getPlaceHolder()) ?>" value="<?php echo $portal_setup->footer_line_be->EditValue ?>"<?php echo $portal_setup->footer_line_be->editAttributes() ?>>
</span>
<?php echo $portal_setup->footer_line_be->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->allow_reg->Visible) { // allow_reg ?>
	<div id="r_allow_reg" class="form-group row">
		<label id="elh_portal_setup_allow_reg" for="x_allow_reg" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->allow_reg->caption() ?><?php echo ($portal_setup->allow_reg->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->allow_reg->cellAttributes() ?>>
<span id="el_portal_setup_allow_reg">
<input type="text" data-table="portal_setup" data-field="x_allow_reg" name="x_allow_reg" id="x_allow_reg" size="30" placeholder="<?php echo HtmlEncode($portal_setup->allow_reg->getPlaceHolder()) ?>" value="<?php echo $portal_setup->allow_reg->EditValue ?>"<?php echo $portal_setup->allow_reg->editAttributes() ?>>
</span>
<?php echo $portal_setup->allow_reg->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->login_remember->Visible) { // login_remember ?>
	<div id="r_login_remember" class="form-group row">
		<label id="elh_portal_setup_login_remember" for="x_login_remember" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->login_remember->caption() ?><?php echo ($portal_setup->login_remember->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->login_remember->cellAttributes() ?>>
<span id="el_portal_setup_login_remember">
<input type="text" data-table="portal_setup" data-field="x_login_remember" name="x_login_remember" id="x_login_remember" size="30" placeholder="<?php echo HtmlEncode($portal_setup->login_remember->getPlaceHolder()) ?>" value="<?php echo $portal_setup->login_remember->EditValue ?>"<?php echo $portal_setup->login_remember->editAttributes() ?>>
</span>
<?php echo $portal_setup->login_remember->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->gp_p_check->Visible) { // gp_p_check ?>
	<div id="r_gp_p_check" class="form-group row">
		<label id="elh_portal_setup_gp_p_check" for="x_gp_p_check" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->gp_p_check->caption() ?><?php echo ($portal_setup->gp_p_check->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->gp_p_check->cellAttributes() ?>>
<span id="el_portal_setup_gp_p_check">
<input type="text" data-table="portal_setup" data-field="x_gp_p_check" name="x_gp_p_check" id="x_gp_p_check" size="30" placeholder="<?php echo HtmlEncode($portal_setup->gp_p_check->getPlaceHolder()) ?>" value="<?php echo $portal_setup->gp_p_check->EditValue ?>"<?php echo $portal_setup->gp_p_check->editAttributes() ?>>
</span>
<?php echo $portal_setup->gp_p_check->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->fe_version->Visible) { // fe_version ?>
	<div id="r_fe_version" class="form-group row">
		<label id="elh_portal_setup_fe_version" for="x_fe_version" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->fe_version->caption() ?><?php echo ($portal_setup->fe_version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->fe_version->cellAttributes() ?>>
<span id="el_portal_setup_fe_version">
<input type="text" data-table="portal_setup" data-field="x_fe_version" name="x_fe_version" id="x_fe_version" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_setup->fe_version->getPlaceHolder()) ?>" value="<?php echo $portal_setup->fe_version->EditValue ?>"<?php echo $portal_setup->fe_version->editAttributes() ?>>
</span>
<?php echo $portal_setup->fe_version->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->admin_version->Visible) { // admin_version ?>
	<div id="r_admin_version" class="form-group row">
		<label id="elh_portal_setup_admin_version" for="x_admin_version" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->admin_version->caption() ?><?php echo ($portal_setup->admin_version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->admin_version->cellAttributes() ?>>
<span id="el_portal_setup_admin_version">
<input type="text" data-table="portal_setup" data-field="x_admin_version" name="x_admin_version" id="x_admin_version" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_setup->admin_version->getPlaceHolder()) ?>" value="<?php echo $portal_setup->admin_version->EditValue ?>"<?php echo $portal_setup->admin_version->editAttributes() ?>>
</span>
<?php echo $portal_setup->admin_version->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->dashboard->Visible) { // dashboard ?>
	<div id="r_dashboard" class="form-group row">
		<label id="elh_portal_setup_dashboard" for="x_dashboard" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->dashboard->caption() ?><?php echo ($portal_setup->dashboard->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->dashboard->cellAttributes() ?>>
<span id="el_portal_setup_dashboard">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="portal_setup" data-field="x_dashboard" data-value-separator="<?php echo $portal_setup->dashboard->displayValueSeparatorAttribute() ?>" id="x_dashboard" name="x_dashboard"<?php echo $portal_setup->dashboard->editAttributes() ?>>
		<?php echo $portal_setup->dashboard->selectOptionListHtml("x_dashboard") ?>
	</select>
</div>
</span>
<?php echo $portal_setup->dashboard->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->developer_upi_id->Visible) { // developer_upi_id ?>
	<div id="r_developer_upi_id" class="form-group row">
		<label id="elh_portal_setup_developer_upi_id" for="x_developer_upi_id" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->developer_upi_id->caption() ?><?php echo ($portal_setup->developer_upi_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->developer_upi_id->cellAttributes() ?>>
<span id="el_portal_setup_developer_upi_id">
<input type="text" data-table="portal_setup" data-field="x_developer_upi_id" name="x_developer_upi_id" id="x_developer_upi_id" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($portal_setup->developer_upi_id->getPlaceHolder()) ?>" value="<?php echo $portal_setup->developer_upi_id->EditValue ?>"<?php echo $portal_setup->developer_upi_id->editAttributes() ?>>
</span>
<?php echo $portal_setup->developer_upi_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->developer_company->Visible) { // developer_company ?>
	<div id="r_developer_company" class="form-group row">
		<label id="elh_portal_setup_developer_company" for="x_developer_company" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->developer_company->caption() ?><?php echo ($portal_setup->developer_company->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->developer_company->cellAttributes() ?>>
<span id="el_portal_setup_developer_company">
<input type="text" data-table="portal_setup" data-field="x_developer_company" name="x_developer_company" id="x_developer_company" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($portal_setup->developer_company->getPlaceHolder()) ?>" value="<?php echo $portal_setup->developer_company->EditValue ?>"<?php echo $portal_setup->developer_company->editAttributes() ?>>
</span>
<?php echo $portal_setup->developer_company->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_setup->default_page->Visible) { // default_page ?>
	<div id="r_default_page" class="form-group row">
		<label id="elh_portal_setup_default_page" for="x_default_page" class="<?php echo $portal_setup_edit->LeftColumnClass ?>"><?php echo $portal_setup->default_page->caption() ?><?php echo ($portal_setup->default_page->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_setup_edit->RightColumnClass ?>"><div<?php echo $portal_setup->default_page->cellAttributes() ?>>
<span id="el_portal_setup_default_page">
<input type="text" data-table="portal_setup" data-field="x_default_page" name="x_default_page" id="x_default_page" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($portal_setup->default_page->getPlaceHolder()) ?>" value="<?php echo $portal_setup->default_page->EditValue ?>"<?php echo $portal_setup->default_page->editAttributes() ?>>
</span>
<?php echo $portal_setup->default_page->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $portal_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_setup_edit->terminate();
?>