<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_setup_list = new portal_setup_list();

// Run the page
$portal_setup_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_setup_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$portal_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fportal_setuplist = currentForm = new ew.Form("fportal_setuplist", "list");
fportal_setuplist.formKeyCountName = '<?php echo $portal_setup_list->FormKeyCountName ?>';

// Form_CustomValidate event
fportal_setuplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_setuplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_setuplist.lists["x_portal_category[]"] = <?php echo $portal_setup_list->portal_category->Lookup->toClientList() ?>;
fportal_setuplist.lists["x_portal_category[]"].options = <?php echo JsonEncode($portal_setup_list->portal_category->lookupOptions()) ?>;
fportal_setuplist.lists["x_pd_byepass"] = <?php echo $portal_setup_list->pd_byepass->Lookup->toClientList() ?>;
fportal_setuplist.lists["x_pd_byepass"].options = <?php echo JsonEncode($portal_setup_list->pd_byepass->options(FALSE, TRUE)) ?>;
fportal_setuplist.lists["x_dashboard"] = <?php echo $portal_setup_list->dashboard->Lookup->toClientList() ?>;
fportal_setuplist.lists["x_dashboard"].options = <?php echo JsonEncode($portal_setup_list->dashboard->options(FALSE, TRUE)) ?>;

// Form object for search
var fportal_setuplistsrch = currentSearchForm = new ew.Form("fportal_setuplistsrch");

// Filters
fportal_setuplistsrch.filterList = <?php echo $portal_setup_list->getFilterList() ?>;

// Init search panel as collapsed
fportal_setuplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$portal_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($portal_setup_list->TotalRecs > 0 && $portal_setup_list->ExportOptions->visible()) { ?>
<?php $portal_setup_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_setup_list->ImportOptions->visible()) { ?>
<?php $portal_setup_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_setup_list->SearchOptions->visible()) { ?>
<?php $portal_setup_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($portal_setup_list->FilterOptions->visible()) { ?>
<?php $portal_setup_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$portal_setup_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$portal_setup->isExport() && !$portal_setup->CurrentAction) { ?>
<form name="fportal_setuplistsrch" id="fportal_setuplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($portal_setup_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fportal_setuplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="portal_setup">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($portal_setup_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($portal_setup_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $portal_setup_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($portal_setup_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($portal_setup_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($portal_setup_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($portal_setup_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $portal_setup_list->showPageHeader(); ?>
<?php
$portal_setup_list->showMessage();
?>
<?php if ($portal_setup_list->TotalRecs > 0 || $portal_setup->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($portal_setup_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> portal_setup">
<?php if (!$portal_setup->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$portal_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_setup_list->Pager)) $portal_setup_list->Pager = new PrevNextPager($portal_setup_list->StartRec, $portal_setup_list->DisplayRecs, $portal_setup_list->TotalRecs, $portal_setup_list->AutoHidePager) ?>
<?php if ($portal_setup_list->Pager->RecordCount > 0 && $portal_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_setup_list->TotalRecs > 0 && (!$portal_setup_list->AutoHidePageSizeSelector || $portal_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fportal_setuplist" id="fportal_setuplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_setup_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_setup_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_setup">
<div id="gmp_portal_setup" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($portal_setup_list->TotalRecs > 0 || $portal_setup->isGridEdit()) { ?>
<table id="tbl_portal_setuplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$portal_setup_list->RowType = ROWTYPE_HEADER;

// Render list options
$portal_setup_list->renderListOptions();

// Render list options (header, left)
$portal_setup_list->ListOptions->render("header", "left");
?>
<?php if ($portal_setup->id->Visible) { // id ?>
	<?php if ($portal_setup->sortUrl($portal_setup->id) == "") { ?>
		<th data-name="id" class="<?php echo $portal_setup->id->headerCellClass() ?>"><div id="elh_portal_setup_id" class="portal_setup_id"><div class="ew-table-header-caption"><?php echo $portal_setup->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $portal_setup->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->id) ?>',2);"><div id="elh_portal_setup_id" class="portal_setup_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->url->Visible) { // url ?>
	<?php if ($portal_setup->sortUrl($portal_setup->url) == "") { ?>
		<th data-name="url" class="<?php echo $portal_setup->url->headerCellClass() ?>"><div id="elh_portal_setup_url" class="portal_setup_url"><div class="ew-table-header-caption"><?php echo $portal_setup->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $portal_setup->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->url) ?>',2);"><div id="elh_portal_setup_url" class="portal_setup_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->admin_url->Visible) { // admin_url ?>
	<?php if ($portal_setup->sortUrl($portal_setup->admin_url) == "") { ?>
		<th data-name="admin_url" class="<?php echo $portal_setup->admin_url->headerCellClass() ?>"><div id="elh_portal_setup_admin_url" class="portal_setup_admin_url"><div class="ew-table-header-caption"><?php echo $portal_setup->admin_url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="admin_url" class="<?php echo $portal_setup->admin_url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->admin_url) ?>',2);"><div id="elh_portal_setup_admin_url" class="portal_setup_admin_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->admin_url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->admin_url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->admin_url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->portal_category->Visible) { // portal_category ?>
	<?php if ($portal_setup->sortUrl($portal_setup->portal_category) == "") { ?>
		<th data-name="portal_category" class="<?php echo $portal_setup->portal_category->headerCellClass() ?>"><div id="elh_portal_setup_portal_category" class="portal_setup_portal_category"><div class="ew-table-header-caption"><?php echo $portal_setup->portal_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_category" class="<?php echo $portal_setup->portal_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->portal_category) ?>',2);"><div id="elh_portal_setup_portal_category" class="portal_setup_portal_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->portal_category->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->portal_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->portal_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->mcu->Visible) { // mcu ?>
	<?php if ($portal_setup->sortUrl($portal_setup->mcu) == "") { ?>
		<th data-name="mcu" class="<?php echo $portal_setup->mcu->headerCellClass() ?>"><div id="elh_portal_setup_mcu" class="portal_setup_mcu"><div class="ew-table-header-caption"><?php echo $portal_setup->mcu->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mcu" class="<?php echo $portal_setup->mcu->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->mcu) ?>',2);"><div id="elh_portal_setup_mcu" class="portal_setup_mcu">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->mcu->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->mcu->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->mcu->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->fcm_server_key->Visible) { // fcm_server_key ?>
	<?php if ($portal_setup->sortUrl($portal_setup->fcm_server_key) == "") { ?>
		<th data-name="fcm_server_key" class="<?php echo $portal_setup->fcm_server_key->headerCellClass() ?>"><div id="elh_portal_setup_fcm_server_key" class="portal_setup_fcm_server_key"><div class="ew-table-header-caption"><?php echo $portal_setup->fcm_server_key->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fcm_server_key" class="<?php echo $portal_setup->fcm_server_key->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->fcm_server_key) ?>',2);"><div id="elh_portal_setup_fcm_server_key" class="portal_setup_fcm_server_key">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->fcm_server_key->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->fcm_server_key->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->fcm_server_key->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->app_version->Visible) { // app_version ?>
	<?php if ($portal_setup->sortUrl($portal_setup->app_version) == "") { ?>
		<th data-name="app_version" class="<?php echo $portal_setup->app_version->headerCellClass() ?>"><div id="elh_portal_setup_app_version" class="portal_setup_app_version"><div class="ew-table-header-caption"><?php echo $portal_setup->app_version->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_version" class="<?php echo $portal_setup->app_version->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->app_version) ?>',2);"><div id="elh_portal_setup_app_version" class="portal_setup_app_version">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->app_version->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->app_version->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->app_version->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->pd_byepass->Visible) { // pd_byepass ?>
	<?php if ($portal_setup->sortUrl($portal_setup->pd_byepass) == "") { ?>
		<th data-name="pd_byepass" class="<?php echo $portal_setup->pd_byepass->headerCellClass() ?>"><div id="elh_portal_setup_pd_byepass" class="portal_setup_pd_byepass"><div class="ew-table-header-caption"><?php echo $portal_setup->pd_byepass->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pd_byepass" class="<?php echo $portal_setup->pd_byepass->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->pd_byepass) ?>',2);"><div id="elh_portal_setup_pd_byepass" class="portal_setup_pd_byepass">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->pd_byepass->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->pd_byepass->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->pd_byepass->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->operator->Visible) { // operator ?>
	<?php if ($portal_setup->sortUrl($portal_setup->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $portal_setup->operator->headerCellClass() ?>"><div id="elh_portal_setup_operator" class="portal_setup_operator"><div class="ew-table-header-caption"><?php echo $portal_setup->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $portal_setup->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->operator) ?>',2);"><div id="elh_portal_setup_operator" class="portal_setup_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->google_map_api->Visible) { // google_map_api ?>
	<?php if ($portal_setup->sortUrl($portal_setup->google_map_api) == "") { ?>
		<th data-name="google_map_api" class="<?php echo $portal_setup->google_map_api->headerCellClass() ?>"><div id="elh_portal_setup_google_map_api" class="portal_setup_google_map_api"><div class="ew-table-header-caption"><?php echo $portal_setup->google_map_api->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="google_map_api" class="<?php echo $portal_setup->google_map_api->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->google_map_api) ?>',2);"><div id="elh_portal_setup_google_map_api" class="portal_setup_google_map_api">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->google_map_api->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->google_map_api->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->google_map_api->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->material_payment_type->Visible) { // material_payment_type ?>
	<?php if ($portal_setup->sortUrl($portal_setup->material_payment_type) == "") { ?>
		<th data-name="material_payment_type" class="<?php echo $portal_setup->material_payment_type->headerCellClass() ?>"><div id="elh_portal_setup_material_payment_type" class="portal_setup_material_payment_type"><div class="ew-table-header-caption"><?php echo $portal_setup->material_payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_payment_type" class="<?php echo $portal_setup->material_payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->material_payment_type) ?>',2);"><div id="elh_portal_setup_material_payment_type" class="portal_setup_material_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->material_payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->material_payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->material_payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->material_payment_varient->Visible) { // material_payment_varient ?>
	<?php if ($portal_setup->sortUrl($portal_setup->material_payment_varient) == "") { ?>
		<th data-name="material_payment_varient" class="<?php echo $portal_setup->material_payment_varient->headerCellClass() ?>"><div id="elh_portal_setup_material_payment_varient" class="portal_setup_material_payment_varient"><div class="ew-table-header-caption"><?php echo $portal_setup->material_payment_varient->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_payment_varient" class="<?php echo $portal_setup->material_payment_varient->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->material_payment_varient) ?>',2);"><div id="elh_portal_setup_material_payment_varient" class="portal_setup_material_payment_varient">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->material_payment_varient->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->material_payment_varient->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->material_payment_varient->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->footer_line_be->Visible) { // footer_line_be ?>
	<?php if ($portal_setup->sortUrl($portal_setup->footer_line_be) == "") { ?>
		<th data-name="footer_line_be" class="<?php echo $portal_setup->footer_line_be->headerCellClass() ?>"><div id="elh_portal_setup_footer_line_be" class="portal_setup_footer_line_be"><div class="ew-table-header-caption"><?php echo $portal_setup->footer_line_be->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="footer_line_be" class="<?php echo $portal_setup->footer_line_be->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->footer_line_be) ?>',2);"><div id="elh_portal_setup_footer_line_be" class="portal_setup_footer_line_be">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->footer_line_be->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->footer_line_be->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->footer_line_be->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->allow_reg->Visible) { // allow_reg ?>
	<?php if ($portal_setup->sortUrl($portal_setup->allow_reg) == "") { ?>
		<th data-name="allow_reg" class="<?php echo $portal_setup->allow_reg->headerCellClass() ?>"><div id="elh_portal_setup_allow_reg" class="portal_setup_allow_reg"><div class="ew-table-header-caption"><?php echo $portal_setup->allow_reg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="allow_reg" class="<?php echo $portal_setup->allow_reg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->allow_reg) ?>',2);"><div id="elh_portal_setup_allow_reg" class="portal_setup_allow_reg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->allow_reg->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->allow_reg->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->allow_reg->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->login_remember->Visible) { // login_remember ?>
	<?php if ($portal_setup->sortUrl($portal_setup->login_remember) == "") { ?>
		<th data-name="login_remember" class="<?php echo $portal_setup->login_remember->headerCellClass() ?>"><div id="elh_portal_setup_login_remember" class="portal_setup_login_remember"><div class="ew-table-header-caption"><?php echo $portal_setup->login_remember->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="login_remember" class="<?php echo $portal_setup->login_remember->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->login_remember) ?>',2);"><div id="elh_portal_setup_login_remember" class="portal_setup_login_remember">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->login_remember->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->login_remember->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->login_remember->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->gp_p_check->Visible) { // gp_p_check ?>
	<?php if ($portal_setup->sortUrl($portal_setup->gp_p_check) == "") { ?>
		<th data-name="gp_p_check" class="<?php echo $portal_setup->gp_p_check->headerCellClass() ?>"><div id="elh_portal_setup_gp_p_check" class="portal_setup_gp_p_check"><div class="ew-table-header-caption"><?php echo $portal_setup->gp_p_check->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gp_p_check" class="<?php echo $portal_setup->gp_p_check->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->gp_p_check) ?>',2);"><div id="elh_portal_setup_gp_p_check" class="portal_setup_gp_p_check">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->gp_p_check->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->gp_p_check->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->gp_p_check->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->fe_version->Visible) { // fe_version ?>
	<?php if ($portal_setup->sortUrl($portal_setup->fe_version) == "") { ?>
		<th data-name="fe_version" class="<?php echo $portal_setup->fe_version->headerCellClass() ?>"><div id="elh_portal_setup_fe_version" class="portal_setup_fe_version"><div class="ew-table-header-caption"><?php echo $portal_setup->fe_version->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fe_version" class="<?php echo $portal_setup->fe_version->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->fe_version) ?>',2);"><div id="elh_portal_setup_fe_version" class="portal_setup_fe_version">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->fe_version->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->fe_version->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->fe_version->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->admin_version->Visible) { // admin_version ?>
	<?php if ($portal_setup->sortUrl($portal_setup->admin_version) == "") { ?>
		<th data-name="admin_version" class="<?php echo $portal_setup->admin_version->headerCellClass() ?>"><div id="elh_portal_setup_admin_version" class="portal_setup_admin_version"><div class="ew-table-header-caption"><?php echo $portal_setup->admin_version->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="admin_version" class="<?php echo $portal_setup->admin_version->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->admin_version) ?>',2);"><div id="elh_portal_setup_admin_version" class="portal_setup_admin_version">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->admin_version->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->admin_version->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->admin_version->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->dashboard->Visible) { // dashboard ?>
	<?php if ($portal_setup->sortUrl($portal_setup->dashboard) == "") { ?>
		<th data-name="dashboard" class="<?php echo $portal_setup->dashboard->headerCellClass() ?>"><div id="elh_portal_setup_dashboard" class="portal_setup_dashboard"><div class="ew-table-header-caption"><?php echo $portal_setup->dashboard->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dashboard" class="<?php echo $portal_setup->dashboard->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->dashboard) ?>',2);"><div id="elh_portal_setup_dashboard" class="portal_setup_dashboard">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->dashboard->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->dashboard->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->dashboard->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->developer_upi_id->Visible) { // developer_upi_id ?>
	<?php if ($portal_setup->sortUrl($portal_setup->developer_upi_id) == "") { ?>
		<th data-name="developer_upi_id" class="<?php echo $portal_setup->developer_upi_id->headerCellClass() ?>"><div id="elh_portal_setup_developer_upi_id" class="portal_setup_developer_upi_id"><div class="ew-table-header-caption"><?php echo $portal_setup->developer_upi_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="developer_upi_id" class="<?php echo $portal_setup->developer_upi_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->developer_upi_id) ?>',2);"><div id="elh_portal_setup_developer_upi_id" class="portal_setup_developer_upi_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->developer_upi_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->developer_upi_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->developer_upi_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->developer_company->Visible) { // developer_company ?>
	<?php if ($portal_setup->sortUrl($portal_setup->developer_company) == "") { ?>
		<th data-name="developer_company" class="<?php echo $portal_setup->developer_company->headerCellClass() ?>"><div id="elh_portal_setup_developer_company" class="portal_setup_developer_company"><div class="ew-table-header-caption"><?php echo $portal_setup->developer_company->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="developer_company" class="<?php echo $portal_setup->developer_company->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->developer_company) ?>',2);"><div id="elh_portal_setup_developer_company" class="portal_setup_developer_company">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->developer_company->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->developer_company->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->developer_company->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_setup->default_page->Visible) { // default_page ?>
	<?php if ($portal_setup->sortUrl($portal_setup->default_page) == "") { ?>
		<th data-name="default_page" class="<?php echo $portal_setup->default_page->headerCellClass() ?>"><div id="elh_portal_setup_default_page" class="portal_setup_default_page"><div class="ew-table-header-caption"><?php echo $portal_setup->default_page->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="default_page" class="<?php echo $portal_setup->default_page->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_setup->SortUrl($portal_setup->default_page) ?>',2);"><div id="elh_portal_setup_default_page" class="portal_setup_default_page">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_setup->default_page->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_setup->default_page->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_setup->default_page->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$portal_setup_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($portal_setup->ExportAll && $portal_setup->isExport()) {
	$portal_setup_list->StopRec = $portal_setup_list->TotalRecs;
} else {

	// Set the last record to display
	if ($portal_setup_list->TotalRecs > $portal_setup_list->StartRec + $portal_setup_list->DisplayRecs - 1)
		$portal_setup_list->StopRec = $portal_setup_list->StartRec + $portal_setup_list->DisplayRecs - 1;
	else
		$portal_setup_list->StopRec = $portal_setup_list->TotalRecs;
}
$portal_setup_list->RecCnt = $portal_setup_list->StartRec - 1;
if ($portal_setup_list->Recordset && !$portal_setup_list->Recordset->EOF) {
	$portal_setup_list->Recordset->moveFirst();
	$selectLimit = $portal_setup_list->UseSelectLimit;
	if (!$selectLimit && $portal_setup_list->StartRec > 1)
		$portal_setup_list->Recordset->move($portal_setup_list->StartRec - 1);
} elseif (!$portal_setup->AllowAddDeleteRow && $portal_setup_list->StopRec == 0) {
	$portal_setup_list->StopRec = $portal_setup->GridAddRowCount;
}

// Initialize aggregate
$portal_setup->RowType = ROWTYPE_AGGREGATEINIT;
$portal_setup->resetAttributes();
$portal_setup_list->renderRow();
while ($portal_setup_list->RecCnt < $portal_setup_list->StopRec) {
	$portal_setup_list->RecCnt++;
	if ($portal_setup_list->RecCnt >= $portal_setup_list->StartRec) {
		$portal_setup_list->RowCnt++;

		// Set up key count
		$portal_setup_list->KeyCount = $portal_setup_list->RowIndex;

		// Init row class and style
		$portal_setup->resetAttributes();
		$portal_setup->CssClass = "";
		if ($portal_setup->isGridAdd()) {
		} else {
			$portal_setup_list->loadRowValues($portal_setup_list->Recordset); // Load row values
		}
		$portal_setup->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$portal_setup->RowAttrs = array_merge($portal_setup->RowAttrs, array('data-rowindex'=>$portal_setup_list->RowCnt, 'id'=>'r' . $portal_setup_list->RowCnt . '_portal_setup', 'data-rowtype'=>$portal_setup->RowType));

		// Render row
		$portal_setup_list->renderRow();

		// Render list options
		$portal_setup_list->renderListOptions();
?>
	<tr<?php echo $portal_setup->rowAttributes() ?>>
<?php

// Render list options (body, left)
$portal_setup_list->ListOptions->render("body", "left", $portal_setup_list->RowCnt);
?>
	<?php if ($portal_setup->id->Visible) { // id ?>
		<td data-name="id"<?php echo $portal_setup->id->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_id" class="portal_setup_id">
<span<?php echo $portal_setup->id->viewAttributes() ?>>
<?php echo $portal_setup->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->url->Visible) { // url ?>
		<td data-name="url"<?php echo $portal_setup->url->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_url" class="portal_setup_url">
<span<?php echo $portal_setup->url->viewAttributes() ?>>
<?php echo $portal_setup->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->admin_url->Visible) { // admin_url ?>
		<td data-name="admin_url"<?php echo $portal_setup->admin_url->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_admin_url" class="portal_setup_admin_url">
<span<?php echo $portal_setup->admin_url->viewAttributes() ?>>
<?php echo $portal_setup->admin_url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->portal_category->Visible) { // portal_category ?>
		<td data-name="portal_category"<?php echo $portal_setup->portal_category->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_portal_category" class="portal_setup_portal_category">
<span<?php echo $portal_setup->portal_category->viewAttributes() ?>>
<?php echo $portal_setup->portal_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->mcu->Visible) { // mcu ?>
		<td data-name="mcu"<?php echo $portal_setup->mcu->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_mcu" class="portal_setup_mcu">
<span<?php echo $portal_setup->mcu->viewAttributes() ?>>
<?php echo $portal_setup->mcu->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->fcm_server_key->Visible) { // fcm_server_key ?>
		<td data-name="fcm_server_key"<?php echo $portal_setup->fcm_server_key->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_fcm_server_key" class="portal_setup_fcm_server_key">
<span<?php echo $portal_setup->fcm_server_key->viewAttributes() ?>>
<?php echo $portal_setup->fcm_server_key->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->app_version->Visible) { // app_version ?>
		<td data-name="app_version"<?php echo $portal_setup->app_version->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_app_version" class="portal_setup_app_version">
<span<?php echo $portal_setup->app_version->viewAttributes() ?>>
<?php echo $portal_setup->app_version->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->pd_byepass->Visible) { // pd_byepass ?>
		<td data-name="pd_byepass"<?php echo $portal_setup->pd_byepass->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_pd_byepass" class="portal_setup_pd_byepass">
<span<?php echo $portal_setup->pd_byepass->viewAttributes() ?>>
<?php echo $portal_setup->pd_byepass->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $portal_setup->operator->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_operator" class="portal_setup_operator">
<span<?php echo $portal_setup->operator->viewAttributes() ?>>
<?php echo $portal_setup->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->google_map_api->Visible) { // google_map_api ?>
		<td data-name="google_map_api"<?php echo $portal_setup->google_map_api->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_google_map_api" class="portal_setup_google_map_api">
<span<?php echo $portal_setup->google_map_api->viewAttributes() ?>>
<?php echo $portal_setup->google_map_api->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->material_payment_type->Visible) { // material_payment_type ?>
		<td data-name="material_payment_type"<?php echo $portal_setup->material_payment_type->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_material_payment_type" class="portal_setup_material_payment_type">
<span<?php echo $portal_setup->material_payment_type->viewAttributes() ?>>
<?php echo $portal_setup->material_payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->material_payment_varient->Visible) { // material_payment_varient ?>
		<td data-name="material_payment_varient"<?php echo $portal_setup->material_payment_varient->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_material_payment_varient" class="portal_setup_material_payment_varient">
<span<?php echo $portal_setup->material_payment_varient->viewAttributes() ?>>
<?php echo $portal_setup->material_payment_varient->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->footer_line_be->Visible) { // footer_line_be ?>
		<td data-name="footer_line_be"<?php echo $portal_setup->footer_line_be->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_footer_line_be" class="portal_setup_footer_line_be">
<span<?php echo $portal_setup->footer_line_be->viewAttributes() ?>>
<?php echo $portal_setup->footer_line_be->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->allow_reg->Visible) { // allow_reg ?>
		<td data-name="allow_reg"<?php echo $portal_setup->allow_reg->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_allow_reg" class="portal_setup_allow_reg">
<span<?php echo $portal_setup->allow_reg->viewAttributes() ?>>
<?php echo $portal_setup->allow_reg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->login_remember->Visible) { // login_remember ?>
		<td data-name="login_remember"<?php echo $portal_setup->login_remember->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_login_remember" class="portal_setup_login_remember">
<span<?php echo $portal_setup->login_remember->viewAttributes() ?>>
<?php echo $portal_setup->login_remember->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->gp_p_check->Visible) { // gp_p_check ?>
		<td data-name="gp_p_check"<?php echo $portal_setup->gp_p_check->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_gp_p_check" class="portal_setup_gp_p_check">
<span<?php echo $portal_setup->gp_p_check->viewAttributes() ?>>
<?php echo $portal_setup->gp_p_check->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->fe_version->Visible) { // fe_version ?>
		<td data-name="fe_version"<?php echo $portal_setup->fe_version->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_fe_version" class="portal_setup_fe_version">
<span<?php echo $portal_setup->fe_version->viewAttributes() ?>>
<?php echo $portal_setup->fe_version->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->admin_version->Visible) { // admin_version ?>
		<td data-name="admin_version"<?php echo $portal_setup->admin_version->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_admin_version" class="portal_setup_admin_version">
<span<?php echo $portal_setup->admin_version->viewAttributes() ?>>
<?php echo $portal_setup->admin_version->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->dashboard->Visible) { // dashboard ?>
		<td data-name="dashboard"<?php echo $portal_setup->dashboard->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_dashboard" class="portal_setup_dashboard">
<span<?php echo $portal_setup->dashboard->viewAttributes() ?>>
<?php echo $portal_setup->dashboard->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->developer_upi_id->Visible) { // developer_upi_id ?>
		<td data-name="developer_upi_id"<?php echo $portal_setup->developer_upi_id->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_developer_upi_id" class="portal_setup_developer_upi_id">
<span<?php echo $portal_setup->developer_upi_id->viewAttributes() ?>>
<?php echo $portal_setup->developer_upi_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->developer_company->Visible) { // developer_company ?>
		<td data-name="developer_company"<?php echo $portal_setup->developer_company->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_developer_company" class="portal_setup_developer_company">
<span<?php echo $portal_setup->developer_company->viewAttributes() ?>>
<?php echo $portal_setup->developer_company->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_setup->default_page->Visible) { // default_page ?>
		<td data-name="default_page"<?php echo $portal_setup->default_page->cellAttributes() ?>>
<span id="el<?php echo $portal_setup_list->RowCnt ?>_portal_setup_default_page" class="portal_setup_default_page">
<span<?php echo $portal_setup->default_page->viewAttributes() ?>>
<?php echo $portal_setup->default_page->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$portal_setup_list->ListOptions->render("body", "right", $portal_setup_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$portal_setup->isGridAdd())
		$portal_setup_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$portal_setup->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($portal_setup_list->Recordset)
	$portal_setup_list->Recordset->Close();
?>
<?php if (!$portal_setup->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$portal_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_setup_list->Pager)) $portal_setup_list->Pager = new PrevNextPager($portal_setup_list->StartRec, $portal_setup_list->DisplayRecs, $portal_setup_list->TotalRecs, $portal_setup_list->AutoHidePager) ?>
<?php if ($portal_setup_list->Pager->RecordCount > 0 && $portal_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_setup_list->pageUrl() ?>start=<?php echo $portal_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_setup_list->TotalRecs > 0 && (!$portal_setup_list->AutoHidePageSizeSelector || $portal_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_setup_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($portal_setup_list->TotalRecs == 0 && !$portal_setup->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $portal_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$portal_setup_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$portal_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$portal_setup->isExport()) { ?>
<script>
ew.scrollableTable("gmp_portal_setup", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$portal_setup_list->terminate();
?>