<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_updates_edit = new portal_updates_edit();

// Run the page
$portal_updates_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_updates_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fportal_updatesedit = currentForm = new ew.Form("fportal_updatesedit", "edit");

// Validate form
fportal_updatesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($portal_updates_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->id->caption(), $portal_updates->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->category->caption(), $portal_updates->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->date->Required) { ?>
			elm = this.getElements("x" + infix + "_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->date->caption(), $portal_updates->date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($portal_updates->date->errorMessage()) ?>");
		<?php if ($portal_updates_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->description->caption(), $portal_updates->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->type->caption(), $portal_updates->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->url->caption(), $portal_updates->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->operator->caption(), $portal_updates->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_updates_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_updates->datetime->caption(), $portal_updates->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportal_updatesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_updatesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_updatesedit.lists["x_category[]"] = <?php echo $portal_updates_edit->category->Lookup->toClientList() ?>;
fportal_updatesedit.lists["x_category[]"].options = <?php echo JsonEncode($portal_updates_edit->category->lookupOptions()) ?>;
fportal_updatesedit.lists["x_type"] = <?php echo $portal_updates_edit->type->Lookup->toClientList() ?>;
fportal_updatesedit.lists["x_type"].options = <?php echo JsonEncode($portal_updates_edit->type->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_updates_edit->showPageHeader(); ?>
<?php
$portal_updates_edit->showMessage();
?>
<form name="fportal_updatesedit" id="fportal_updatesedit" class="<?php echo $portal_updates_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_updates_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_updates_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_updates">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$portal_updates_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($portal_updates->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_portal_updates_id" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->id->caption() ?><?php echo ($portal_updates->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->id->cellAttributes() ?>>
<span id="el_portal_updates_id">
<span<?php echo $portal_updates->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($portal_updates->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="portal_updates" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($portal_updates->id->CurrentValue) ?>">
<?php echo $portal_updates->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_updates->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_portal_updates_category" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->category->caption() ?><?php echo ($portal_updates->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->category->cellAttributes() ?>>
<span id="el_portal_updates_category">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($portal_updates->category->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $portal_updates->category->ViewValue ?></button>
		<div id="dsl_x_category" data-repeatcolumn="5" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $portal_updates->category->checkBoxListHtml(TRUE, "x_category[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="portal_updates" data-field="x_category" data-value-separator="<?php echo $portal_updates->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $portal_updates->category->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$portal_updates->category->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $portal_updates->category->Lookup->getParamTag("p_x_category") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php echo $portal_updates->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_updates->date->Visible) { // date ?>
	<div id="r_date" class="form-group row">
		<label id="elh_portal_updates_date" for="x_date" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->date->caption() ?><?php echo ($portal_updates->date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->date->cellAttributes() ?>>
<span id="el_portal_updates_date">
<input type="text" data-table="portal_updates" data-field="x_date" name="x_date" id="x_date" placeholder="<?php echo HtmlEncode($portal_updates->date->getPlaceHolder()) ?>" value="<?php echo $portal_updates->date->EditValue ?>"<?php echo $portal_updates->date->editAttributes() ?>>
<?php if (!$portal_updates->date->ReadOnly && !$portal_updates->date->Disabled && !isset($portal_updates->date->EditAttrs["readonly"]) && !isset($portal_updates->date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fportal_updatesedit", "x_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $portal_updates->date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_updates->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_portal_updates_description" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->description->caption() ?><?php echo ($portal_updates->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->description->cellAttributes() ?>>
<span id="el_portal_updates_description">
<?php AppendClass($portal_updates->description->EditAttrs["class"], "editor"); ?>
<textarea data-table="portal_updates" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($portal_updates->description->getPlaceHolder()) ?>"<?php echo $portal_updates->description->editAttributes() ?>><?php echo $portal_updates->description->EditValue ?></textarea>
<script>
ew.createEditor("fportal_updatesedit", "x_description", 35, 4, <?php echo ($portal_updates->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $portal_updates->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_updates->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_portal_updates_type" for="x_type" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->type->caption() ?><?php echo ($portal_updates->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->type->cellAttributes() ?>>
<span id="el_portal_updates_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="portal_updates" data-field="x_type" data-value-separator="<?php echo $portal_updates->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $portal_updates->type->editAttributes() ?>>
		<?php echo $portal_updates->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $portal_updates->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_updates->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_portal_updates_url" for="x_url" class="<?php echo $portal_updates_edit->LeftColumnClass ?>"><?php echo $portal_updates->url->caption() ?><?php echo ($portal_updates->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_updates_edit->RightColumnClass ?>"><div<?php echo $portal_updates->url->cellAttributes() ?>>
<span id="el_portal_updates_url">
<input type="text" data-table="portal_updates" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($portal_updates->url->getPlaceHolder()) ?>" value="<?php echo $portal_updates->url->EditValue ?>"<?php echo $portal_updates->url->editAttributes() ?>>
</span>
<?php echo $portal_updates->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_updates_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_updates_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $portal_updates_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_updates_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_updates_edit->terminate();
?>