<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_updates_view = new portal_updates_view();

// Run the page
$portal_updates_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_updates_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$portal_updates->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fportal_updatesview = currentForm = new ew.Form("fportal_updatesview", "view");

// Form_CustomValidate event
fportal_updatesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_updatesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_updatesview.lists["x_category[]"] = <?php echo $portal_updates_view->category->Lookup->toClientList() ?>;
fportal_updatesview.lists["x_category[]"].options = <?php echo JsonEncode($portal_updates_view->category->lookupOptions()) ?>;
fportal_updatesview.lists["x_type"] = <?php echo $portal_updates_view->type->Lookup->toClientList() ?>;
fportal_updatesview.lists["x_type"].options = <?php echo JsonEncode($portal_updates_view->type->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$portal_updates->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $portal_updates_view->ExportOptions->render("body") ?>
<?php $portal_updates_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $portal_updates_view->showPageHeader(); ?>
<?php
$portal_updates_view->showMessage();
?>
<form name="fportal_updatesview" id="fportal_updatesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_updates_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_updates_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_updates">
<input type="hidden" name="modal" value="<?php echo (int)$portal_updates_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($portal_updates->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_id"><?php echo $portal_updates->id->caption() ?></span></td>
		<td data-name="id"<?php echo $portal_updates->id->cellAttributes() ?>>
<span id="el_portal_updates_id">
<span<?php echo $portal_updates->id->viewAttributes() ?>>
<?php echo $portal_updates->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_category"><?php echo $portal_updates->category->caption() ?></span></td>
		<td data-name="category"<?php echo $portal_updates->category->cellAttributes() ?>>
<span id="el_portal_updates_category">
<span<?php echo $portal_updates->category->viewAttributes() ?>>
<?php echo $portal_updates->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->date->Visible) { // date ?>
	<tr id="r_date">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_date"><?php echo $portal_updates->date->caption() ?></span></td>
		<td data-name="date"<?php echo $portal_updates->date->cellAttributes() ?>>
<span id="el_portal_updates_date">
<span<?php echo $portal_updates->date->viewAttributes() ?>>
<?php echo $portal_updates->date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_description"><?php echo $portal_updates->description->caption() ?></span></td>
		<td data-name="description"<?php echo $portal_updates->description->cellAttributes() ?>>
<span id="el_portal_updates_description">
<span<?php echo $portal_updates->description->viewAttributes() ?>>
<?php echo $portal_updates->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_type"><?php echo $portal_updates->type->caption() ?></span></td>
		<td data-name="type"<?php echo $portal_updates->type->cellAttributes() ?>>
<span id="el_portal_updates_type">
<span<?php echo $portal_updates->type->viewAttributes() ?>>
<?php echo $portal_updates->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_url"><?php echo $portal_updates->url->caption() ?></span></td>
		<td data-name="url"<?php echo $portal_updates->url->cellAttributes() ?>>
<span id="el_portal_updates_url">
<span<?php echo $portal_updates->url->viewAttributes() ?>>
<?php echo $portal_updates->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_operator"><?php echo $portal_updates->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $portal_updates->operator->cellAttributes() ?>>
<span id="el_portal_updates_operator">
<span<?php echo $portal_updates->operator->viewAttributes() ?>>
<?php echo $portal_updates->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($portal_updates->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $portal_updates_view->TableLeftColumnClass ?>"><span id="elh_portal_updates_datetime"><?php echo $portal_updates->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $portal_updates->datetime->cellAttributes() ?>>
<span id="el_portal_updates_datetime">
<span<?php echo $portal_updates->datetime->viewAttributes() ?>>
<?php echo $portal_updates->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$portal_updates_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$portal_updates->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$portal_updates_view->terminate();
?>