<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_version_edit = new portal_version_edit();

// Run the page
$portal_version_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_version_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fportal_versionedit = currentForm = new ew.Form("fportal_versionedit", "edit");

// Validate form
fportal_versionedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($portal_version_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->id->caption(), $portal_version->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_version_edit->mysql_query->Required) { ?>
			elm = this.getElements("x" + infix + "_mysql_query");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->mysql_query->caption(), $portal_version->mysql_query->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_version_edit->sp_query->Required) { ?>
			elm = this.getElements("x" + infix + "_sp_query");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->sp_query->caption(), $portal_version->sp_query->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_version_edit->php_code->Required) { ?>
			elm = this.getElements("x" + infix + "_php_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->php_code->caption(), $portal_version->php_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_version_edit->version->Required) { ?>
			elm = this.getElements("x" + infix + "_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->version->caption(), $portal_version->version->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($portal_version_edit->php_version->Required) { ?>
			elm = this.getElements("x" + infix + "_php_version");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $portal_version->php_version->caption(), $portal_version->php_version->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fportal_versionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_versionedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_version_edit->showPageHeader(); ?>
<?php
$portal_version_edit->showMessage();
?>
<form name="fportal_versionedit" id="fportal_versionedit" class="<?php echo $portal_version_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_version_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_version_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_version">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$portal_version_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($portal_version->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_portal_version_id" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->id->caption() ?><?php echo ($portal_version->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->id->cellAttributes() ?>>
<span id="el_portal_version_id">
<span<?php echo $portal_version->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($portal_version->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="portal_version" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($portal_version->id->CurrentValue) ?>">
<?php echo $portal_version->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_version->mysql_query->Visible) { // mysql_query ?>
	<div id="r_mysql_query" class="form-group row">
		<label id="elh_portal_version_mysql_query" for="x_mysql_query" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->mysql_query->caption() ?><?php echo ($portal_version->mysql_query->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->mysql_query->cellAttributes() ?>>
<span id="el_portal_version_mysql_query">
<span<?php echo $portal_version->mysql_query->viewAttributes() ?>>
<?php echo $portal_version->mysql_query->EditValue ?></span>
</span>
<input type="hidden" data-table="portal_version" data-field="x_mysql_query" name="x_mysql_query" id="x_mysql_query" value="<?php echo HtmlEncode($portal_version->mysql_query->CurrentValue) ?>">
<?php echo $portal_version->mysql_query->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_version->sp_query->Visible) { // sp_query ?>
	<div id="r_sp_query" class="form-group row">
		<label id="elh_portal_version_sp_query" for="x_sp_query" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->sp_query->caption() ?><?php echo ($portal_version->sp_query->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->sp_query->cellAttributes() ?>>
<span id="el_portal_version_sp_query">
<span<?php echo $portal_version->sp_query->viewAttributes() ?>>
<?php echo $portal_version->sp_query->EditValue ?></span>
</span>
<input type="hidden" data-table="portal_version" data-field="x_sp_query" name="x_sp_query" id="x_sp_query" value="<?php echo HtmlEncode($portal_version->sp_query->CurrentValue) ?>">
<?php echo $portal_version->sp_query->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_version->php_code->Visible) { // php_code ?>
	<div id="r_php_code" class="form-group row">
		<label id="elh_portal_version_php_code" for="x_php_code" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->php_code->caption() ?><?php echo ($portal_version->php_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->php_code->cellAttributes() ?>>
<span id="el_portal_version_php_code">
<span<?php echo $portal_version->php_code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($portal_version->php_code->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="portal_version" data-field="x_php_code" name="x_php_code" id="x_php_code" value="<?php echo HtmlEncode($portal_version->php_code->CurrentValue) ?>">
<?php echo $portal_version->php_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_version->version->Visible) { // version ?>
	<div id="r_version" class="form-group row">
		<label id="elh_portal_version_version" for="x_version" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->version->caption() ?><?php echo ($portal_version->version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->version->cellAttributes() ?>>
<span id="el_portal_version_version">
<input type="text" data-table="portal_version" data-field="x_version" name="x_version" id="x_version" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_version->version->getPlaceHolder()) ?>" value="<?php echo $portal_version->version->EditValue ?>"<?php echo $portal_version->version->editAttributes() ?>>
</span>
<?php echo $portal_version->version->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($portal_version->php_version->Visible) { // php_version ?>
	<div id="r_php_version" class="form-group row">
		<label id="elh_portal_version_php_version" for="x_php_version" class="<?php echo $portal_version_edit->LeftColumnClass ?>"><?php echo $portal_version->php_version->caption() ?><?php echo ($portal_version->php_version->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $portal_version_edit->RightColumnClass ?>"><div<?php echo $portal_version->php_version->cellAttributes() ?>>
<span id="el_portal_version_php_version">
<input type="text" data-table="portal_version" data-field="x_php_version" name="x_php_version" id="x_php_version" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($portal_version->php_version->getPlaceHolder()) ?>" value="<?php echo $portal_version->php_version->EditValue ?>"<?php echo $portal_version->php_version->editAttributes() ?>>
</span>
<?php echo $portal_version->php_version->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_version_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_version_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $portal_version_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_version_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_version_edit->terminate();
?>