<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_version_list = new portal_version_list();

// Run the page
$portal_version_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_version_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$portal_version->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fportal_versionlist = currentForm = new ew.Form("fportal_versionlist", "list");
fportal_versionlist.formKeyCountName = '<?php echo $portal_version_list->FormKeyCountName ?>';

// Form_CustomValidate event
fportal_versionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_versionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_versionlist.lists["x_portal_c_php_code"] = <?php echo $portal_version_list->portal_c_php_code->Lookup->toClientList() ?>;
fportal_versionlist.lists["x_portal_c_php_code"].options = <?php echo JsonEncode($portal_version_list->portal_c_php_code->lookupOptions()) ?>;
fportal_versionlist.autoSuggests["x_portal_c_php_code"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fportal_versionlist.lists["x_portal_c_mysql_query"] = <?php echo $portal_version_list->portal_c_mysql_query->Lookup->toClientList() ?>;
fportal_versionlist.lists["x_portal_c_mysql_query"].options = <?php echo JsonEncode($portal_version_list->portal_c_mysql_query->lookupOptions()) ?>;
fportal_versionlist.autoSuggests["x_portal_c_mysql_query"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fportal_versionlist.lists["x_portal_c_sp_query"] = <?php echo $portal_version_list->portal_c_sp_query->Lookup->toClientList() ?>;
fportal_versionlist.lists["x_portal_c_sp_query"].options = <?php echo JsonEncode($portal_version_list->portal_c_sp_query->lookupOptions()) ?>;
fportal_versionlist.autoSuggests["x_portal_c_sp_query"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fportal_versionlistsrch = currentSearchForm = new ew.Form("fportal_versionlistsrch");

// Validate function for search
fportal_versionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fportal_versionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_versionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fportal_versionlistsrch.filterList = <?php echo $portal_version_list->getFilterList() ?>;

// Init search panel as collapsed
fportal_versionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
function ctoc(id,url)
{
	$.getJSON("apcajax_2.php?Y3RvY3NwcQ="+id+'&url='+url,function(data){
		Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h2 class="modal-title">'+url+'</h2><button type="button" class="close" data-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body">'+data+'</div><!-- Modal footer --><div class="modal-footer"><button type="button" class="btn btn-danger" data-dismiss="modal">Close</button></div></div></div></div></div>';
 		   		$("body").prepend(Obj);
 		   		$("#myModal").modal("show");
 		   		navigator.clipboard.writeText(data);
	});
	$.getJSON("apcajaxes.php?dXJs="+url+"&id="+id);
}
</script>
<?php } ?>
<?php if (!$portal_version->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($portal_version_list->TotalRecs > 0 && $portal_version_list->ExportOptions->visible()) { ?>
<?php $portal_version_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_version_list->ImportOptions->visible()) { ?>
<?php $portal_version_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($portal_version_list->SearchOptions->visible()) { ?>
<?php $portal_version_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($portal_version_list->FilterOptions->visible()) { ?>
<?php $portal_version_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$portal_version_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$portal_version->isExport() && !$portal_version->CurrentAction) { ?>
<form name="fportal_versionlistsrch" id="fportal_versionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($portal_version_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fportal_versionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="portal_version">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$portal_version_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$portal_version->RowType = ROWTYPE_SEARCH;

// Render row
$portal_version->resetAttributes();
$portal_version_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($portal_version->version->Visible) { // version ?>
	<div id="xsc_version" class="ew-cell form-group">
		<label for="x_version" class="ew-search-caption ew-label"><?php echo $portal_version->version->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_version" id="z_version" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="portal_version" data-field="x_version" name="x_version" id="x_version" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_version->version->getPlaceHolder()) ?>" value="<?php echo $portal_version->version->EditValue ?>"<?php echo $portal_version->version->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($portal_version_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($portal_version_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $portal_version_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($portal_version_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($portal_version_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($portal_version_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($portal_version_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $portal_version_list->showPageHeader(); ?>
<?php
$portal_version_list->showMessage();
?>
<?php if ($portal_version_list->TotalRecs > 0 || $portal_version->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($portal_version_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> portal_version">
<?php if (!$portal_version->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$portal_version->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_version_list->Pager)) $portal_version_list->Pager = new PrevNextPager($portal_version_list->StartRec, $portal_version_list->DisplayRecs, $portal_version_list->TotalRecs, $portal_version_list->AutoHidePager) ?>
<?php if ($portal_version_list->Pager->RecordCount > 0 && $portal_version_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_version_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_version_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_version_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_version_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_version_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_version_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_version_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_version_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_version_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_version_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_version_list->TotalRecs > 0 && (!$portal_version_list->AutoHidePageSizeSelector || $portal_version_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_version">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_version_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_version_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_version_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_version_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_version_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_version->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_version_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fportal_versionlist" id="fportal_versionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_version_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_version_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_version">
<div id="gmp_portal_version" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($portal_version_list->TotalRecs > 0 || $portal_version->isGridEdit()) { ?>
<table id="tbl_portal_versionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$portal_version_list->RowType = ROWTYPE_HEADER;

// Render list options
$portal_version_list->renderListOptions();

// Render list options (header, left)
$portal_version_list->ListOptions->render("header", "left");
?>
<?php if ($portal_version->id->Visible) { // id ?>
	<?php if ($portal_version->sortUrl($portal_version->id) == "") { ?>
		<th data-name="id" class="<?php echo $portal_version->id->headerCellClass() ?>"><div id="elh_portal_version_id" class="portal_version_id"><div class="ew-table-header-caption"><?php echo $portal_version->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $portal_version->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->id) ?>',2);"><div id="elh_portal_version_id" class="portal_version_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($portal_version->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->php_code->Visible) { // php_code ?>
	<?php if ($portal_version->sortUrl($portal_version->php_code) == "") { ?>
		<th data-name="php_code" class="<?php echo $portal_version->php_code->headerCellClass() ?>"><div id="elh_portal_version_php_code" class="portal_version_php_code"><div class="ew-table-header-caption"><?php echo $portal_version->php_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="php_code" class="<?php echo $portal_version->php_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->php_code) ?>',2);"><div id="elh_portal_version_php_code" class="portal_version_php_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->php_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->php_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->php_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_d_url_link->Visible) { // portal_d_url_link ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_d_url_link) == "") { ?>
		<th data-name="portal_d_url_link" class="<?php echo $portal_version->portal_d_url_link->headerCellClass() ?>"><div id="elh_portal_version_portal_d_url_link" class="portal_version_portal_d_url_link"><div class="ew-table-header-caption"><?php echo $portal_version->portal_d_url_link->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_d_url_link" class="<?php echo $portal_version->portal_d_url_link->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_d_url_link) ?>',2);"><div id="elh_portal_version_portal_d_url_link" class="portal_version_portal_d_url_link">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_d_url_link->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_d_url_link->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_d_url_link->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_d_php_code->Visible) { // portal_d_php_code ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_d_php_code) == "") { ?>
		<th data-name="portal_d_php_code" class="<?php echo $portal_version->portal_d_php_code->headerCellClass() ?>"><div id="elh_portal_version_portal_d_php_code" class="portal_version_portal_d_php_code"><div class="ew-table-header-caption"><?php echo $portal_version->portal_d_php_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_d_php_code" class="<?php echo $portal_version->portal_d_php_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_d_php_code) ?>',2);"><div id="elh_portal_version_portal_d_php_code" class="portal_version_portal_d_php_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_d_php_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_d_php_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_d_php_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_d_mysql_query->Visible) { // portal_d_mysql_query ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_d_mysql_query) == "") { ?>
		<th data-name="portal_d_mysql_query" class="<?php echo $portal_version->portal_d_mysql_query->headerCellClass() ?>"><div id="elh_portal_version_portal_d_mysql_query" class="portal_version_portal_d_mysql_query"><div class="ew-table-header-caption"><?php echo $portal_version->portal_d_mysql_query->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_d_mysql_query" class="<?php echo $portal_version->portal_d_mysql_query->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_d_mysql_query) ?>',2);"><div id="elh_portal_version_portal_d_mysql_query" class="portal_version_portal_d_mysql_query">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_d_mysql_query->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_d_mysql_query->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_d_mysql_query->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_d_sp_query->Visible) { // portal_d_sp_query ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_d_sp_query) == "") { ?>
		<th data-name="portal_d_sp_query" class="<?php echo $portal_version->portal_d_sp_query->headerCellClass() ?>"><div id="elh_portal_version_portal_d_sp_query" class="portal_version_portal_d_sp_query"><div class="ew-table-header-caption"><?php echo $portal_version->portal_d_sp_query->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_d_sp_query" class="<?php echo $portal_version->portal_d_sp_query->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_d_sp_query) ?>',2);"><div id="elh_portal_version_portal_d_sp_query" class="portal_version_portal_d_sp_query">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_d_sp_query->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_d_sp_query->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_d_sp_query->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_c_php_code->Visible) { // portal_c_php_code ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_c_php_code) == "") { ?>
		<th data-name="portal_c_php_code" class="<?php echo $portal_version->portal_c_php_code->headerCellClass() ?>"><div id="elh_portal_version_portal_c_php_code" class="portal_version_portal_c_php_code"><div class="ew-table-header-caption"><?php echo $portal_version->portal_c_php_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_c_php_code" class="<?php echo $portal_version->portal_c_php_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_c_php_code) ?>',2);"><div id="elh_portal_version_portal_c_php_code" class="portal_version_portal_c_php_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_c_php_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_c_php_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_c_php_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_c_mysql_query->Visible) { // portal_c_mysql_query ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_c_mysql_query) == "") { ?>
		<th data-name="portal_c_mysql_query" class="<?php echo $portal_version->portal_c_mysql_query->headerCellClass() ?>"><div id="elh_portal_version_portal_c_mysql_query" class="portal_version_portal_c_mysql_query"><div class="ew-table-header-caption"><?php echo $portal_version->portal_c_mysql_query->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_c_mysql_query" class="<?php echo $portal_version->portal_c_mysql_query->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_c_mysql_query) ?>',2);"><div id="elh_portal_version_portal_c_mysql_query" class="portal_version_portal_c_mysql_query">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_c_mysql_query->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_c_mysql_query->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_c_mysql_query->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->portal_c_sp_query->Visible) { // portal_c_sp_query ?>
	<?php if ($portal_version->sortUrl($portal_version->portal_c_sp_query) == "") { ?>
		<th data-name="portal_c_sp_query" class="<?php echo $portal_version->portal_c_sp_query->headerCellClass() ?>"><div id="elh_portal_version_portal_c_sp_query" class="portal_version_portal_c_sp_query"><div class="ew-table-header-caption"><?php echo $portal_version->portal_c_sp_query->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="portal_c_sp_query" class="<?php echo $portal_version->portal_c_sp_query->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->portal_c_sp_query) ?>',2);"><div id="elh_portal_version_portal_c_sp_query" class="portal_version_portal_c_sp_query">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->portal_c_sp_query->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->portal_c_sp_query->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->portal_c_sp_query->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->version->Visible) { // version ?>
	<?php if ($portal_version->sortUrl($portal_version->version) == "") { ?>
		<th data-name="version" class="<?php echo $portal_version->version->headerCellClass() ?>"><div id="elh_portal_version_version" class="portal_version_version"><div class="ew-table-header-caption"><?php echo $portal_version->version->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="version" class="<?php echo $portal_version->version->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->version) ?>',2);"><div id="elh_portal_version_version" class="portal_version_version">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->version->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->version->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->version->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($portal_version->php_version->Visible) { // php_version ?>
	<?php if ($portal_version->sortUrl($portal_version->php_version) == "") { ?>
		<th data-name="php_version" class="<?php echo $portal_version->php_version->headerCellClass() ?>"><div id="elh_portal_version_php_version" class="portal_version_php_version"><div class="ew-table-header-caption"><?php echo $portal_version->php_version->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="php_version" class="<?php echo $portal_version->php_version->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $portal_version->SortUrl($portal_version->php_version) ?>',2);"><div id="elh_portal_version_php_version" class="portal_version_php_version">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $portal_version->php_version->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($portal_version->php_version->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($portal_version->php_version->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$portal_version_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($portal_version->ExportAll && $portal_version->isExport()) {
	$portal_version_list->StopRec = $portal_version_list->TotalRecs;
} else {

	// Set the last record to display
	if ($portal_version_list->TotalRecs > $portal_version_list->StartRec + $portal_version_list->DisplayRecs - 1)
		$portal_version_list->StopRec = $portal_version_list->StartRec + $portal_version_list->DisplayRecs - 1;
	else
		$portal_version_list->StopRec = $portal_version_list->TotalRecs;
}
$portal_version_list->RecCnt = $portal_version_list->StartRec - 1;
if ($portal_version_list->Recordset && !$portal_version_list->Recordset->EOF) {
	$portal_version_list->Recordset->moveFirst();
	$selectLimit = $portal_version_list->UseSelectLimit;
	if (!$selectLimit && $portal_version_list->StartRec > 1)
		$portal_version_list->Recordset->move($portal_version_list->StartRec - 1);
} elseif (!$portal_version->AllowAddDeleteRow && $portal_version_list->StopRec == 0) {
	$portal_version_list->StopRec = $portal_version->GridAddRowCount;
}

// Initialize aggregate
$portal_version->RowType = ROWTYPE_AGGREGATEINIT;
$portal_version->resetAttributes();
$portal_version_list->renderRow();
while ($portal_version_list->RecCnt < $portal_version_list->StopRec) {
	$portal_version_list->RecCnt++;
	if ($portal_version_list->RecCnt >= $portal_version_list->StartRec) {
		$portal_version_list->RowCnt++;

		// Set up key count
		$portal_version_list->KeyCount = $portal_version_list->RowIndex;

		// Init row class and style
		$portal_version->resetAttributes();
		$portal_version->CssClass = "";
		if ($portal_version->isGridAdd()) {
		} else {
			$portal_version_list->loadRowValues($portal_version_list->Recordset); // Load row values
		}
		$portal_version->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$portal_version->RowAttrs = array_merge($portal_version->RowAttrs, array('data-rowindex'=>$portal_version_list->RowCnt, 'id'=>'r' . $portal_version_list->RowCnt . '_portal_version', 'data-rowtype'=>$portal_version->RowType));

		// Render row
		$portal_version_list->renderRow();

		// Render list options
		$portal_version_list->renderListOptions();
?>
	<tr<?php echo $portal_version->rowAttributes() ?>>
<?php

// Render list options (body, left)
$portal_version_list->ListOptions->render("body", "left", $portal_version_list->RowCnt);
?>
	<?php if ($portal_version->id->Visible) { // id ?>
		<td data-name="id"<?php echo $portal_version->id->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_id" class="portal_version_id">
<span<?php echo $portal_version->id->viewAttributes() ?>>
<?php echo $portal_version->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->php_code->Visible) { // php_code ?>
		<td data-name="php_code"<?php echo $portal_version->php_code->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_php_code" class="portal_version_php_code">
<span<?php echo $portal_version->php_code->viewAttributes() ?>>
<?php echo $portal_version->php_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_d_url_link->Visible) { // portal_d_url_link ?>
		<td data-name="portal_d_url_link"<?php echo $portal_version->portal_d_url_link->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_d_url_link" class="portal_version_portal_d_url_link">
<span<?php echo $portal_version->portal_d_url_link->viewAttributes() ?>>
<?php echo $portal_version->portal_d_url_link->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_d_php_code->Visible) { // portal_d_php_code ?>
		<td data-name="portal_d_php_code"<?php echo $portal_version->portal_d_php_code->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_d_php_code" class="portal_version_portal_d_php_code">
<span<?php echo $portal_version->portal_d_php_code->viewAttributes() ?>>
<?php echo $portal_version->portal_d_php_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_d_mysql_query->Visible) { // portal_d_mysql_query ?>
		<td data-name="portal_d_mysql_query"<?php echo $portal_version->portal_d_mysql_query->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_d_mysql_query" class="portal_version_portal_d_mysql_query">
<span<?php echo $portal_version->portal_d_mysql_query->viewAttributes() ?>>
<?php echo $portal_version->portal_d_mysql_query->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_d_sp_query->Visible) { // portal_d_sp_query ?>
		<td data-name="portal_d_sp_query"<?php echo $portal_version->portal_d_sp_query->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_d_sp_query" class="portal_version_portal_d_sp_query">
<span<?php echo $portal_version->portal_d_sp_query->viewAttributes() ?>>
<?php echo $portal_version->portal_d_sp_query->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_c_php_code->Visible) { // portal_c_php_code ?>
		<td data-name="portal_c_php_code"<?php echo $portal_version->portal_c_php_code->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_c_php_code" class="portal_version_portal_c_php_code">
<span<?php echo $portal_version->portal_c_php_code->viewAttributes() ?>>
<?php echo $portal_version->portal_c_php_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_c_mysql_query->Visible) { // portal_c_mysql_query ?>
		<td data-name="portal_c_mysql_query"<?php echo $portal_version->portal_c_mysql_query->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_c_mysql_query" class="portal_version_portal_c_mysql_query">
<span<?php echo $portal_version->portal_c_mysql_query->viewAttributes() ?>>
<?php echo $portal_version->portal_c_mysql_query->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->portal_c_sp_query->Visible) { // portal_c_sp_query ?>
		<td data-name="portal_c_sp_query"<?php echo $portal_version->portal_c_sp_query->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_portal_c_sp_query" class="portal_version_portal_c_sp_query">
<span<?php echo $portal_version->portal_c_sp_query->viewAttributes() ?>>
<?php echo $portal_version->portal_c_sp_query->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->version->Visible) { // version ?>
		<td data-name="version"<?php echo $portal_version->version->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_version" class="portal_version_version">
<span<?php echo $portal_version->version->viewAttributes() ?>>
<?php echo $portal_version->version->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($portal_version->php_version->Visible) { // php_version ?>
		<td data-name="php_version"<?php echo $portal_version->php_version->cellAttributes() ?>>
<span id="el<?php echo $portal_version_list->RowCnt ?>_portal_version_php_version" class="portal_version_php_version">
<span<?php echo $portal_version->php_version->viewAttributes() ?>>
<?php echo $portal_version->php_version->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$portal_version_list->ListOptions->render("body", "right", $portal_version_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$portal_version->isGridAdd())
		$portal_version_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$portal_version->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($portal_version_list->Recordset)
	$portal_version_list->Recordset->Close();
?>
<?php if (!$portal_version->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$portal_version->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($portal_version_list->Pager)) $portal_version_list->Pager = new PrevNextPager($portal_version_list->StartRec, $portal_version_list->DisplayRecs, $portal_version_list->TotalRecs, $portal_version_list->AutoHidePager) ?>
<?php if ($portal_version_list->Pager->RecordCount > 0 && $portal_version_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($portal_version_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($portal_version_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $portal_version_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($portal_version_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($portal_version_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $portal_version_list->pageUrl() ?>start=<?php echo $portal_version_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $portal_version_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($portal_version_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $portal_version_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $portal_version_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $portal_version_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($portal_version_list->TotalRecs > 0 && (!$portal_version_list->AutoHidePageSizeSelector || $portal_version_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="portal_version">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($portal_version_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($portal_version_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($portal_version_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($portal_version_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($portal_version_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($portal_version->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $portal_version_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($portal_version_list->TotalRecs == 0 && !$portal_version->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $portal_version_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$portal_version_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$portal_version->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$portal_version->isExport()) { ?>
<script>
ew.scrollableTable("gmp_portal_version", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$portal_version_list->terminate();
?>