<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$portal_version_search = new portal_version_search();

// Run the page
$portal_version_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$portal_version_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($portal_version_search->IsModal) { ?>
var fportal_versionsearch = currentAdvancedSearchForm = new ew.Form("fportal_versionsearch", "search");
<?php } else { ?>
var fportal_versionsearch = currentForm = new ew.Form("fportal_versionsearch", "search");
<?php } ?>

// Form_CustomValidate event
fportal_versionsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportal_versionsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportal_versionsearch.lists["x_portal_c_php_code"] = <?php echo $portal_version_search->portal_c_php_code->Lookup->toClientList() ?>;
fportal_versionsearch.lists["x_portal_c_php_code"].options = <?php echo JsonEncode($portal_version_search->portal_c_php_code->lookupOptions()) ?>;
fportal_versionsearch.autoSuggests["x_portal_c_php_code"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fportal_versionsearch.lists["x_portal_c_mysql_query"] = <?php echo $portal_version_search->portal_c_mysql_query->Lookup->toClientList() ?>;
fportal_versionsearch.lists["x_portal_c_mysql_query"].options = <?php echo JsonEncode($portal_version_search->portal_c_mysql_query->lookupOptions()) ?>;
fportal_versionsearch.autoSuggests["x_portal_c_mysql_query"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fportal_versionsearch.lists["x_portal_c_sp_query"] = <?php echo $portal_version_search->portal_c_sp_query->Lookup->toClientList() ?>;
fportal_versionsearch.lists["x_portal_c_sp_query"].options = <?php echo JsonEncode($portal_version_search->portal_c_sp_query->lookupOptions()) ?>;
fportal_versionsearch.autoSuggests["x_portal_c_sp_query"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fportal_versionsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($portal_version->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $portal_version_search->showPageHeader(); ?>
<?php
$portal_version_search->showMessage();
?>
<form name="fportal_versionsearch" id="fportal_versionsearch" class="<?php echo $portal_version_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($portal_version_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $portal_version_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="portal_version">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$portal_version_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($portal_version->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_id"><?php echo $portal_version->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->id->cellAttributes() ?>>
			<span id="el_portal_version_id">
<input type="text" data-table="portal_version" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($portal_version->id->getPlaceHolder()) ?>" value="<?php echo $portal_version->id->EditValue ?>"<?php echo $portal_version->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->mysql_query->Visible) { // mysql_query ?>
	<div id="r_mysql_query" class="form-group row">
		<label for="x_mysql_query" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_mysql_query"><?php echo $portal_version->mysql_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mysql_query" id="z_mysql_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->mysql_query->cellAttributes() ?>>
			<span id="el_portal_version_mysql_query">
<input type="text" data-table="portal_version" data-field="x_mysql_query" name="x_mysql_query" id="x_mysql_query" size="35" placeholder="<?php echo HtmlEncode($portal_version->mysql_query->getPlaceHolder()) ?>" value="<?php echo $portal_version->mysql_query->EditValue ?>"<?php echo $portal_version->mysql_query->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->sp_query->Visible) { // sp_query ?>
	<div id="r_sp_query" class="form-group row">
		<label for="x_sp_query" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_sp_query"><?php echo $portal_version->sp_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sp_query" id="z_sp_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->sp_query->cellAttributes() ?>>
			<span id="el_portal_version_sp_query">
<input type="text" data-table="portal_version" data-field="x_sp_query" name="x_sp_query" id="x_sp_query" size="35" placeholder="<?php echo HtmlEncode($portal_version->sp_query->getPlaceHolder()) ?>" value="<?php echo $portal_version->sp_query->EditValue ?>"<?php echo $portal_version->sp_query->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->php_code->Visible) { // php_code ?>
	<div id="r_php_code" class="form-group row">
		<label for="x_php_code" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_php_code"><?php echo $portal_version->php_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_php_code" id="z_php_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->php_code->cellAttributes() ?>>
			<span id="el_portal_version_php_code">
<input type="text" data-table="portal_version" data-field="x_php_code" name="x_php_code" id="x_php_code" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($portal_version->php_code->getPlaceHolder()) ?>" value="<?php echo $portal_version->php_code->EditValue ?>"<?php echo $portal_version->php_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->url_link->Visible) { // url_link ?>
	<div id="r_url_link" class="form-group row">
		<label for="x_url_link" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_url_link"><?php echo $portal_version->url_link->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url_link" id="z_url_link" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->url_link->cellAttributes() ?>>
			<span id="el_portal_version_url_link">
<input type="text" data-table="portal_version" data-field="x_url_link" name="x_url_link" id="x_url_link" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($portal_version->url_link->getPlaceHolder()) ?>" value="<?php echo $portal_version->url_link->EditValue ?>"<?php echo $portal_version->url_link->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_d_url_link->Visible) { // portal_d_url_link ?>
	<div id="r_portal_d_url_link" class="form-group row">
		<label for="x_portal_d_url_link" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_url_link"><?php echo $portal_version->portal_d_url_link->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_d_url_link" id="z_portal_d_url_link" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_d_url_link->cellAttributes() ?>>
			<span id="el_portal_version_portal_d_url_link">
<input type="text" data-table="portal_version" data-field="x_portal_d_url_link" name="x_portal_d_url_link" id="x_portal_d_url_link" size="35" placeholder="<?php echo HtmlEncode($portal_version->portal_d_url_link->getPlaceHolder()) ?>" value="<?php echo $portal_version->portal_d_url_link->EditValue ?>"<?php echo $portal_version->portal_d_url_link->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_d_php_code->Visible) { // portal_d_php_code ?>
	<div id="r_portal_d_php_code" class="form-group row">
		<label for="x_portal_d_php_code" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_php_code"><?php echo $portal_version->portal_d_php_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_d_php_code" id="z_portal_d_php_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_d_php_code->cellAttributes() ?>>
			<span id="el_portal_version_portal_d_php_code">
<input type="text" data-table="portal_version" data-field="x_portal_d_php_code" name="x_portal_d_php_code" id="x_portal_d_php_code" placeholder="<?php echo HtmlEncode($portal_version->portal_d_php_code->getPlaceHolder()) ?>" value="<?php echo $portal_version->portal_d_php_code->EditValue ?>"<?php echo $portal_version->portal_d_php_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_d_mysql_query->Visible) { // portal_d_mysql_query ?>
	<div id="r_portal_d_mysql_query" class="form-group row">
		<label for="x_portal_d_mysql_query" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_mysql_query"><?php echo $portal_version->portal_d_mysql_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_d_mysql_query" id="z_portal_d_mysql_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_d_mysql_query->cellAttributes() ?>>
			<span id="el_portal_version_portal_d_mysql_query">
<input type="text" data-table="portal_version" data-field="x_portal_d_mysql_query" name="x_portal_d_mysql_query" id="x_portal_d_mysql_query" placeholder="<?php echo HtmlEncode($portal_version->portal_d_mysql_query->getPlaceHolder()) ?>" value="<?php echo $portal_version->portal_d_mysql_query->EditValue ?>"<?php echo $portal_version->portal_d_mysql_query->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_d_sp_query->Visible) { // portal_d_sp_query ?>
	<div id="r_portal_d_sp_query" class="form-group row">
		<label for="x_portal_d_sp_query" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_d_sp_query"><?php echo $portal_version->portal_d_sp_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_d_sp_query" id="z_portal_d_sp_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_d_sp_query->cellAttributes() ?>>
			<span id="el_portal_version_portal_d_sp_query">
<input type="text" data-table="portal_version" data-field="x_portal_d_sp_query" name="x_portal_d_sp_query" id="x_portal_d_sp_query" placeholder="<?php echo HtmlEncode($portal_version->portal_d_sp_query->getPlaceHolder()) ?>" value="<?php echo $portal_version->portal_d_sp_query->EditValue ?>"<?php echo $portal_version->portal_d_sp_query->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_c_php_code->Visible) { // portal_c_php_code ?>
	<div id="r_portal_c_php_code" class="form-group row">
		<label class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_php_code"><?php echo $portal_version->portal_c_php_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_c_php_code" id="z_portal_c_php_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_c_php_code->cellAttributes() ?>>
			<span id="el_portal_version_portal_c_php_code">
<?php
$wrkonchange = "" . trim(@$portal_version->portal_c_php_code->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$portal_version->portal_c_php_code->EditAttrs["onchange"] = "";
?>
<span id="as_x_portal_c_php_code" class="text-nowrap" style="z-index: 8900">
	<input type="text" class="form-control" name="sv_x_portal_c_php_code" id="sv_x_portal_c_php_code" value="<?php echo RemoveHtml($portal_version->portal_c_php_code->EditValue) ?>" placeholder="<?php echo HtmlEncode($portal_version->portal_c_php_code->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($portal_version->portal_c_php_code->getPlaceHolder()) ?>"<?php echo $portal_version->portal_c_php_code->editAttributes() ?>>
</span>
<input type="hidden" data-table="portal_version" data-field="x_portal_c_php_code" data-value-separator="<?php echo $portal_version->portal_c_php_code->displayValueSeparatorAttribute() ?>" name="x_portal_c_php_code" id="x_portal_c_php_code" value="<?php echo HtmlEncode($portal_version->portal_c_php_code->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fportal_versionsearch.createAutoSuggest({"id":"x_portal_c_php_code","forceSelect":false});
</script>
<?php echo $portal_version->portal_c_php_code->Lookup->getParamTag("p_x_portal_c_php_code") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_c_mysql_query->Visible) { // portal_c_mysql_query ?>
	<div id="r_portal_c_mysql_query" class="form-group row">
		<label class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_mysql_query"><?php echo $portal_version->portal_c_mysql_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_c_mysql_query" id="z_portal_c_mysql_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_c_mysql_query->cellAttributes() ?>>
			<span id="el_portal_version_portal_c_mysql_query">
<?php
$wrkonchange = "" . trim(@$portal_version->portal_c_mysql_query->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$portal_version->portal_c_mysql_query->EditAttrs["onchange"] = "";
?>
<span id="as_x_portal_c_mysql_query" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_portal_c_mysql_query" id="sv_x_portal_c_mysql_query" value="<?php echo RemoveHtml($portal_version->portal_c_mysql_query->EditValue) ?>" placeholder="<?php echo HtmlEncode($portal_version->portal_c_mysql_query->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($portal_version->portal_c_mysql_query->getPlaceHolder()) ?>"<?php echo $portal_version->portal_c_mysql_query->editAttributes() ?>>
</span>
<input type="hidden" data-table="portal_version" data-field="x_portal_c_mysql_query" data-value-separator="<?php echo $portal_version->portal_c_mysql_query->displayValueSeparatorAttribute() ?>" name="x_portal_c_mysql_query" id="x_portal_c_mysql_query" value="<?php echo HtmlEncode($portal_version->portal_c_mysql_query->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fportal_versionsearch.createAutoSuggest({"id":"x_portal_c_mysql_query","forceSelect":false});
</script>
<?php echo $portal_version->portal_c_mysql_query->Lookup->getParamTag("p_x_portal_c_mysql_query") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->portal_c_sp_query->Visible) { // portal_c_sp_query ?>
	<div id="r_portal_c_sp_query" class="form-group row">
		<label class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_portal_c_sp_query"><?php echo $portal_version->portal_c_sp_query->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_portal_c_sp_query" id="z_portal_c_sp_query" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->portal_c_sp_query->cellAttributes() ?>>
			<span id="el_portal_version_portal_c_sp_query">
<?php
$wrkonchange = "" . trim(@$portal_version->portal_c_sp_query->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$portal_version->portal_c_sp_query->EditAttrs["onchange"] = "";
?>
<span id="as_x_portal_c_sp_query" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_portal_c_sp_query" id="sv_x_portal_c_sp_query" value="<?php echo RemoveHtml($portal_version->portal_c_sp_query->EditValue) ?>" placeholder="<?php echo HtmlEncode($portal_version->portal_c_sp_query->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($portal_version->portal_c_sp_query->getPlaceHolder()) ?>"<?php echo $portal_version->portal_c_sp_query->editAttributes() ?>>
</span>
<input type="hidden" data-table="portal_version" data-field="x_portal_c_sp_query" data-value-separator="<?php echo $portal_version->portal_c_sp_query->displayValueSeparatorAttribute() ?>" name="x_portal_c_sp_query" id="x_portal_c_sp_query" value="<?php echo HtmlEncode($portal_version->portal_c_sp_query->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fportal_versionsearch.createAutoSuggest({"id":"x_portal_c_sp_query","forceSelect":false});
</script>
<?php echo $portal_version->portal_c_sp_query->Lookup->getParamTag("p_x_portal_c_sp_query") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->version->Visible) { // version ?>
	<div id="r_version" class="form-group row">
		<label for="x_version" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_version"><?php echo $portal_version->version->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_version" id="z_version" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->version->cellAttributes() ?>>
			<span id="el_portal_version_version">
<input type="text" data-table="portal_version" data-field="x_version" name="x_version" id="x_version" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($portal_version->version->getPlaceHolder()) ?>" value="<?php echo $portal_version->version->EditValue ?>"<?php echo $portal_version->version->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($portal_version->php_version->Visible) { // php_version ?>
	<div id="r_php_version" class="form-group row">
		<label for="x_php_version" class="<?php echo $portal_version_search->LeftColumnClass ?>"><span id="elh_portal_version_php_version"><?php echo $portal_version->php_version->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_php_version" id="z_php_version" value="LIKE"></span>
		</label>
		<div class="<?php echo $portal_version_search->RightColumnClass ?>"><div<?php echo $portal_version->php_version->cellAttributes() ?>>
			<span id="el_portal_version_php_version">
<input type="text" data-table="portal_version" data-field="x_php_version" name="x_php_version" id="x_php_version" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($portal_version->php_version->getPlaceHolder()) ?>" value="<?php echo $portal_version->php_version->EditValue ?>"<?php echo $portal_version->php_version->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$portal_version_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $portal_version_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$portal_version_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$portal_version_search->terminate();
?>