<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$port_list = new port_list();

// Run the page
$port_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$port_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$port->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fportlist = currentForm = new ew.Form("fportlist", "list");
fportlist.formKeyCountName = '<?php echo $port_list->FormKeyCountName ?>';

// Form_CustomValidate event
fportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportlist.lists["x_mode"] = <?php echo $port_list->mode->Lookup->toClientList() ?>;
fportlist.lists["x_mode"].options = <?php echo JsonEncode($port_list->mode->options(FALSE, TRUE)) ?>;
fportlist.lists["x_status"] = <?php echo $port_list->status->Lookup->toClientList() ?>;
fportlist.lists["x_status"].options = <?php echo JsonEncode($port_list->status->options(FALSE, TRUE)) ?>;
fportlist.lists["x_operator"] = <?php echo $port_list->operator->Lookup->toClientList() ?>;
fportlist.lists["x_operator"].options = <?php echo JsonEncode($port_list->operator->lookupOptions()) ?>;

// Form object for search
var fportlistsrch = currentSearchForm = new ew.Form("fportlistsrch");

// Filters
fportlistsrch.filterList = <?php echo $port_list->getFilterList() ?>;

// Init search panel as collapsed
fportlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$port->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($port_list->TotalRecs > 0 && $port_list->ExportOptions->visible()) { ?>
<?php $port_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($port_list->ImportOptions->visible()) { ?>
<?php $port_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($port_list->SearchOptions->visible()) { ?>
<?php $port_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($port_list->FilterOptions->visible()) { ?>
<?php $port_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$port_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$port->isExport() && !$port->CurrentAction) { ?>
<form name="fportlistsrch" id="fportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($port_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="port">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($port_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($port_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $port_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($port_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($port_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($port_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($port_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $port_list->showPageHeader(); ?>
<?php
$port_list->showMessage();
?>
<?php if ($port_list->TotalRecs > 0 || $port->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($port_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> port">
<?php if (!$port->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$port->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($port_list->Pager)) $port_list->Pager = new PrevNextPager($port_list->StartRec, $port_list->DisplayRecs, $port_list->TotalRecs, $port_list->AutoHidePager) ?>
<?php if ($port_list->Pager->RecordCount > 0 && $port_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($port_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($port_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $port_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($port_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($port_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $port_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($port_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $port_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $port_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $port_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($port_list->TotalRecs > 0 && (!$port_list->AutoHidePageSizeSelector || $port_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="port">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($port_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($port_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($port_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($port_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($port_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($port->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $port_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fportlist" id="fportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($port_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $port_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="port">
<div id="gmp_port" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($port_list->TotalRecs > 0 || $port->isGridEdit()) { ?>
<table id="tbl_portlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$port_list->RowType = ROWTYPE_HEADER;

// Render list options
$port_list->renderListOptions();

// Render list options (header, left)
$port_list->ListOptions->render("header", "left");
?>
<?php if ($port->id->Visible) { // id ?>
	<?php if ($port->sortUrl($port->id) == "") { ?>
		<th data-name="id" class="<?php echo $port->id->headerCellClass() ?>"><div id="elh_port_id" class="port_id"><div class="ew-table-header-caption"><?php echo $port->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $port->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->id) ?>',2);"><div id="elh_port_id" class="port_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($port->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->port->Visible) { // port ?>
	<?php if ($port->sortUrl($port->port) == "") { ?>
		<th data-name="port" class="<?php echo $port->port->headerCellClass() ?>"><div id="elh_port_port" class="port_port"><div class="ew-table-header-caption"><?php echo $port->port->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port" class="<?php echo $port->port->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->port) ?>',2);"><div id="elh_port_port" class="port_port">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->port->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($port->port->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->port->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->code->Visible) { // code ?>
	<?php if ($port->sortUrl($port->code) == "") { ?>
		<th data-name="code" class="<?php echo $port->code->headerCellClass() ?>"><div id="elh_port_code" class="port_code"><div class="ew-table-header-caption"><?php echo $port->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $port->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->code) ?>',2);"><div id="elh_port_code" class="port_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($port->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->mode->Visible) { // mode ?>
	<?php if ($port->sortUrl($port->mode) == "") { ?>
		<th data-name="mode" class="<?php echo $port->mode->headerCellClass() ?>"><div id="elh_port_mode" class="port_mode"><div class="ew-table-header-caption"><?php echo $port->mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mode" class="<?php echo $port->mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->mode) ?>',2);"><div id="elh_port_mode" class="port_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($port->mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->status->Visible) { // status ?>
	<?php if ($port->sortUrl($port->status) == "") { ?>
		<th data-name="status" class="<?php echo $port->status->headerCellClass() ?>"><div id="elh_port_status" class="port_status"><div class="ew-table-header-caption"><?php echo $port->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $port->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->status) ?>',2);"><div id="elh_port_status" class="port_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($port->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->operator->Visible) { // operator ?>
	<?php if ($port->sortUrl($port->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $port->operator->headerCellClass() ?>"><div id="elh_port_operator" class="port_operator"><div class="ew-table-header-caption"><?php echo $port->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $port->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->operator) ?>',2);"><div id="elh_port_operator" class="port_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($port->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($port->datetime->Visible) { // datetime ?>
	<?php if ($port->sortUrl($port->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $port->datetime->headerCellClass() ?>"><div id="elh_port_datetime" class="port_datetime"><div class="ew-table-header-caption"><?php echo $port->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $port->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $port->SortUrl($port->datetime) ?>',2);"><div id="elh_port_datetime" class="port_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $port->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($port->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($port->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$port_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($port->ExportAll && $port->isExport()) {
	$port_list->StopRec = $port_list->TotalRecs;
} else {

	// Set the last record to display
	if ($port_list->TotalRecs > $port_list->StartRec + $port_list->DisplayRecs - 1)
		$port_list->StopRec = $port_list->StartRec + $port_list->DisplayRecs - 1;
	else
		$port_list->StopRec = $port_list->TotalRecs;
}
$port_list->RecCnt = $port_list->StartRec - 1;
if ($port_list->Recordset && !$port_list->Recordset->EOF) {
	$port_list->Recordset->moveFirst();
	$selectLimit = $port_list->UseSelectLimit;
	if (!$selectLimit && $port_list->StartRec > 1)
		$port_list->Recordset->move($port_list->StartRec - 1);
} elseif (!$port->AllowAddDeleteRow && $port_list->StopRec == 0) {
	$port_list->StopRec = $port->GridAddRowCount;
}

// Initialize aggregate
$port->RowType = ROWTYPE_AGGREGATEINIT;
$port->resetAttributes();
$port_list->renderRow();
while ($port_list->RecCnt < $port_list->StopRec) {
	$port_list->RecCnt++;
	if ($port_list->RecCnt >= $port_list->StartRec) {
		$port_list->RowCnt++;

		// Set up key count
		$port_list->KeyCount = $port_list->RowIndex;

		// Init row class and style
		$port->resetAttributes();
		$port->CssClass = "";
		if ($port->isGridAdd()) {
		} else {
			$port_list->loadRowValues($port_list->Recordset); // Load row values
		}
		$port->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$port->RowAttrs = array_merge($port->RowAttrs, array('data-rowindex'=>$port_list->RowCnt, 'id'=>'r' . $port_list->RowCnt . '_port', 'data-rowtype'=>$port->RowType));

		// Render row
		$port_list->renderRow();

		// Render list options
		$port_list->renderListOptions();
?>
	<tr<?php echo $port->rowAttributes() ?>>
<?php

// Render list options (body, left)
$port_list->ListOptions->render("body", "left", $port_list->RowCnt);
?>
	<?php if ($port->id->Visible) { // id ?>
		<td data-name="id"<?php echo $port->id->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_id" class="port_id">
<span<?php echo $port->id->viewAttributes() ?>>
<?php echo $port->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->port->Visible) { // port ?>
		<td data-name="port"<?php echo $port->port->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_port" class="port_port">
<span<?php echo $port->port->viewAttributes() ?>>
<?php echo $port->port->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->code->Visible) { // code ?>
		<td data-name="code"<?php echo $port->code->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_code" class="port_code">
<span<?php echo $port->code->viewAttributes() ?>>
<?php echo $port->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->mode->Visible) { // mode ?>
		<td data-name="mode"<?php echo $port->mode->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_mode" class="port_mode">
<span<?php echo $port->mode->viewAttributes() ?>>
<?php echo $port->mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->status->Visible) { // status ?>
		<td data-name="status"<?php echo $port->status->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_status" class="port_status">
<span<?php echo $port->status->viewAttributes() ?>>
<?php echo $port->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $port->operator->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_operator" class="port_operator">
<span<?php echo $port->operator->viewAttributes() ?>>
<?php echo $port->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($port->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $port->datetime->cellAttributes() ?>>
<span id="el<?php echo $port_list->RowCnt ?>_port_datetime" class="port_datetime">
<span<?php echo $port->datetime->viewAttributes() ?>>
<?php echo $port->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$port_list->ListOptions->render("body", "right", $port_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$port->isGridAdd())
		$port_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$port->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($port_list->Recordset)
	$port_list->Recordset->Close();
?>
<?php if (!$port->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$port->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($port_list->Pager)) $port_list->Pager = new PrevNextPager($port_list->StartRec, $port_list->DisplayRecs, $port_list->TotalRecs, $port_list->AutoHidePager) ?>
<?php if ($port_list->Pager->RecordCount > 0 && $port_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($port_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($port_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $port_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($port_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($port_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $port_list->pageUrl() ?>start=<?php echo $port_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $port_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($port_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $port_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $port_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $port_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($port_list->TotalRecs > 0 && (!$port_list->AutoHidePageSizeSelector || $port_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="port">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($port_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($port_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($port_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($port_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($port_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($port->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $port_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($port_list->TotalRecs == 0 && !$port->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $port_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$port_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$port->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$port->isExport()) { ?>
<script>
ew.scrollableTable("gmp_port", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$port_list->terminate();
?>