<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$port_search = new port_search();

// Run the page
$port_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$port_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($port_search->IsModal) { ?>
var fportsearch = currentAdvancedSearchForm = new ew.Form("fportsearch", "search");
<?php } else { ?>
var fportsearch = currentForm = new ew.Form("fportsearch", "search");
<?php } ?>

// Form_CustomValidate event
fportsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportsearch.lists["x_mode"] = <?php echo $port_search->mode->Lookup->toClientList() ?>;
fportsearch.lists["x_mode"].options = <?php echo JsonEncode($port_search->mode->options(FALSE, TRUE)) ?>;
fportsearch.lists["x_status"] = <?php echo $port_search->status->Lookup->toClientList() ?>;
fportsearch.lists["x_status"].options = <?php echo JsonEncode($port_search->status->options(FALSE, TRUE)) ?>;
fportsearch.lists["x_operator"] = <?php echo $port_search->operator->Lookup->toClientList() ?>;
fportsearch.lists["x_operator"].options = <?php echo JsonEncode($port_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fportsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($port->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
		return this.onError(elm, "<?php echo JsEncode($port->code->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $port_search->showPageHeader(); ?>
<?php
$port_search->showMessage();
?>
<form name="fportsearch" id="fportsearch" class="<?php echo $port_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($port_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $port_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="port">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$port_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($port->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_id"><?php echo $port->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->id->cellAttributes() ?>>
			<span id="el_port_id">
<input type="text" data-table="port" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($port->id->getPlaceHolder()) ?>" value="<?php echo $port->id->EditValue ?>"<?php echo $port->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->port->Visible) { // port ?>
	<div id="r_port" class="form-group row">
		<label for="x_port" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_port"><?php echo $port->port->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_port" id="z_port" value="LIKE"></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->port->cellAttributes() ?>>
			<span id="el_port_port">
<input type="text" data-table="port" data-field="x_port" name="x_port" id="x_port" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($port->port->getPlaceHolder()) ?>" value="<?php echo $port->port->EditValue ?>"<?php echo $port->port->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_code"><?php echo $port->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->code->cellAttributes() ?>>
			<span id="el_port_code">
<input type="text" data-table="port" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($port->code->getPlaceHolder()) ?>" value="<?php echo $port->code->EditValue ?>"<?php echo $port->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->mode->Visible) { // mode ?>
	<div id="r_mode" class="form-group row">
		<label for="x_mode" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_mode"><?php echo $port->mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mode" id="z_mode" value="="></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->mode->cellAttributes() ?>>
			<span id="el_port_mode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_mode" data-value-separator="<?php echo $port->mode->displayValueSeparatorAttribute() ?>" id="x_mode" name="x_mode"<?php echo $port->mode->editAttributes() ?>>
		<?php echo $port->mode->selectOptionListHtml("x_mode") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_status"><?php echo $port->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->status->cellAttributes() ?>>
			<span id="el_port_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_status" data-value-separator="<?php echo $port->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $port->status->editAttributes() ?>>
		<?php echo $port->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_operator"><?php echo $port->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->operator->cellAttributes() ?>>
			<span id="el_port_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="port" data-field="x_operator" data-value-separator="<?php echo $port->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $port->operator->editAttributes() ?>>
		<?php echo $port->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $port->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($port->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $port_search->LeftColumnClass ?>"><span id="elh_port_datetime"><?php echo $port->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $port_search->RightColumnClass ?>"><div<?php echo $port->datetime->cellAttributes() ?>>
			<span id="el_port_datetime">
<input type="text" data-table="port" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($port->datetime->getPlaceHolder()) ?>" value="<?php echo $port->datetime->EditValue ?>"<?php echo $port->datetime->editAttributes() ?>>
<?php if (!$port->datetime->ReadOnly && !$port->datetime->Disabled && !isset($port->datetime->EditAttrs["readonly"]) && !isset($port->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fportsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$port_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $port_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$port_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$port_search->terminate();
?>