<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$port_view = new port_view();

// Run the page
$port_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$port_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$port->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fportview = currentForm = new ew.Form("fportview", "view");

// Form_CustomValidate event
fportview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fportview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fportview.lists["x_mode"] = <?php echo $port_view->mode->Lookup->toClientList() ?>;
fportview.lists["x_mode"].options = <?php echo JsonEncode($port_view->mode->options(FALSE, TRUE)) ?>;
fportview.lists["x_status"] = <?php echo $port_view->status->Lookup->toClientList() ?>;
fportview.lists["x_status"].options = <?php echo JsonEncode($port_view->status->options(FALSE, TRUE)) ?>;
fportview.lists["x_operator"] = <?php echo $port_view->operator->Lookup->toClientList() ?>;
fportview.lists["x_operator"].options = <?php echo JsonEncode($port_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$port->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $port_view->ExportOptions->render("body") ?>
<?php $port_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $port_view->showPageHeader(); ?>
<?php
$port_view->showMessage();
?>
<form name="fportview" id="fportview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($port_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $port_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="port">
<input type="hidden" name="modal" value="<?php echo (int)$port_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($port->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_id"><?php echo $port->id->caption() ?></span></td>
		<td data-name="id"<?php echo $port->id->cellAttributes() ?>>
<span id="el_port_id">
<span<?php echo $port->id->viewAttributes() ?>>
<?php echo $port->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->port->Visible) { // port ?>
	<tr id="r_port">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_port"><?php echo $port->port->caption() ?></span></td>
		<td data-name="port"<?php echo $port->port->cellAttributes() ?>>
<span id="el_port_port">
<span<?php echo $port->port->viewAttributes() ?>>
<?php echo $port->port->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_code"><?php echo $port->code->caption() ?></span></td>
		<td data-name="code"<?php echo $port->code->cellAttributes() ?>>
<span id="el_port_code">
<span<?php echo $port->code->viewAttributes() ?>>
<?php echo $port->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->mode->Visible) { // mode ?>
	<tr id="r_mode">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_mode"><?php echo $port->mode->caption() ?></span></td>
		<td data-name="mode"<?php echo $port->mode->cellAttributes() ?>>
<span id="el_port_mode">
<span<?php echo $port->mode->viewAttributes() ?>>
<?php echo $port->mode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_status"><?php echo $port->status->caption() ?></span></td>
		<td data-name="status"<?php echo $port->status->cellAttributes() ?>>
<span id="el_port_status">
<span<?php echo $port->status->viewAttributes() ?>>
<?php echo $port->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_operator"><?php echo $port->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $port->operator->cellAttributes() ?>>
<span id="el_port_operator">
<span<?php echo $port->operator->viewAttributes() ?>>
<?php echo $port->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($port->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $port_view->TableLeftColumnClass ?>"><span id="elh_port_datetime"><?php echo $port->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $port->datetime->cellAttributes() ?>>
<span id="el_port_datetime">
<span<?php echo $port->datetime->viewAttributes() ?>>
<?php echo $port->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$port_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$port->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$port_view->terminate();
?>