<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_search = new po_search();

// Run the page
$po_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_search->IsModal) { ?>
var fposearch = currentAdvancedSearchForm = new ew.Form("fposearch", "search");
<?php } else { ?>
var fposearch = currentForm = new ew.Form("fposearch", "search");
<?php } ?>

// Form_CustomValidate event
fposearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fposearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fposearch.multiPage = new ew.MultiPage("fposearch");

// Dynamic selection lists
fposearch.lists["x_order_type"] = <?php echo $po_search->order_type->Lookup->toClientList() ?>;
fposearch.lists["x_order_type"].options = <?php echo JsonEncode($po_search->order_type->options(FALSE, TRUE)) ?>;
fposearch.lists["x_buyer_id"] = <?php echo $po_search->buyer_id->Lookup->toClientList() ?>;
fposearch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_search->buyer_id->lookupOptions()) ?>;
fposearch.lists["x_cart_id[]"] = <?php echo $po_search->cart_id->Lookup->toClientList() ?>;
fposearch.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_search->cart_id->lookupOptions()) ?>;
fposearch.lists["x_grp"] = <?php echo $po_search->grp->Lookup->toClientList() ?>;
fposearch.lists["x_grp"].options = <?php echo JsonEncode($po_search->grp->lookupOptions()) ?>;
fposearch.lists["x_s_grp"] = <?php echo $po_search->s_grp->Lookup->toClientList() ?>;
fposearch.lists["x_s_grp"].options = <?php echo JsonEncode($po_search->s_grp->lookupOptions()) ?>;
fposearch.lists["x_product"] = <?php echo $po_search->product->Lookup->toClientList() ?>;
fposearch.lists["x_product"].options = <?php echo JsonEncode($po_search->product->lookupOptions()) ?>;
fposearch.lists["x_rid"] = <?php echo $po_search->rid->Lookup->toClientList() ?>;
fposearch.lists["x_rid"].options = <?php echo JsonEncode($po_search->rid->lookupOptions()) ?>;
fposearch.lists["x_despatch_week"] = <?php echo $po_search->despatch_week->Lookup->toClientList() ?>;
fposearch.lists["x_despatch_week"].options = <?php echo JsonEncode($po_search->despatch_week->lookupOptions()) ?>;
fposearch.lists["x_payment_terms"] = <?php echo $po_search->payment_terms->Lookup->toClientList() ?>;
fposearch.lists["x_payment_terms"].options = <?php echo JsonEncode($po_search->payment_terms->lookupOptions()) ?>;
fposearch.lists["x_description_03"] = <?php echo $po_search->description_03->Lookup->toClientList() ?>;
fposearch.lists["x_description_03"].options = <?php echo JsonEncode($po_search->description_03->options(FALSE, TRUE)) ?>;
fposearch.lists["x_description_20"] = <?php echo $po_search->description_20->Lookup->toClientList() ?>;
fposearch.lists["x_description_20"].options = <?php echo JsonEncode($po_search->description_20->options(FALSE, TRUE)) ?>;
fposearch.lists["x_currency"] = <?php echo $po_search->currency->Lookup->toClientList() ?>;
fposearch.lists["x_currency"].options = <?php echo JsonEncode($po_search->currency->lookupOptions()) ?>;
fposearch.lists["x_description_05"] = <?php echo $po_search->description_05->Lookup->toClientList() ?>;
fposearch.lists["x_description_05"].options = <?php echo JsonEncode($po_search->description_05->lookupOptions()) ?>;
fposearch.lists["x_description_06"] = <?php echo $po_search->description_06->Lookup->toClientList() ?>;
fposearch.lists["x_description_06"].options = <?php echo JsonEncode($po_search->description_06->lookupOptions()) ?>;
fposearch.lists["x_operator"] = <?php echo $po_search->operator->Lookup->toClientList() ?>;
fposearch.lists["x_operator"].options = <?php echo JsonEncode($po_search->operator->lookupOptions()) ?>;
fposearch.lists["x_a_operator"] = <?php echo $po_search->a_operator->Lookup->toClientList() ?>;
fposearch.lists["x_a_operator"].options = <?php echo JsonEncode($po_search->a_operator->lookupOptions()) ?>;
fposearch.lists["x_d_09_head"] = <?php echo $po_search->d_09_head->Lookup->toClientList() ?>;
fposearch.lists["x_d_09_head"].options = <?php echo JsonEncode($po_search->d_09_head->lookupOptions()) ?>;
fposearch.lists["x_d_10_head"] = <?php echo $po_search->d_10_head->Lookup->toClientList() ?>;
fposearch.lists["x_d_10_head"].options = <?php echo JsonEncode($po_search->d_10_head->lookupOptions()) ?>;
fposearch.lists["x_d_11_head"] = <?php echo $po_search->d_11_head->Lookup->toClientList() ?>;
fposearch.lists["x_d_11_head"].options = <?php echo JsonEncode($po_search->d_11_head->lookupOptions()) ?>;
fposearch.lists["x_d_12_head"] = <?php echo $po_search->d_12_head->Lookup->toClientList() ?>;
fposearch.lists["x_d_12_head"].options = <?php echo JsonEncode($po_search->d_12_head->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fposearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->buyer_order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_shipping__id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->buyer_shipping__id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_07");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->description_07->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_17");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->description_17->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_18");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->description_18->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_19");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->description_19->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->cbm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_08");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po->description_08->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_search->showPageHeader(); ?>
<?php
$po_search->showMessage();
?>
<form name="fposearch" id="fposearch" class="<?php echo $po_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_search->IsModal ?>">
<?php if ($po_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($po->order_type->Visible) { // order_type ?>
	<div id="r_order_type" class="form-group row">
		<label class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_order_type"><?php echo $po->order_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_type" id="z_order_type" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->order_type->cellAttributes() ?>>
			<span id="el_po_order_type">
<div id="tp_x_order_type" class="ew-template"><input type="radio" class="form-check-input" data-table="po" data-field="x_order_type" data-page="0" data-value-separator="<?php echo $po->order_type->displayValueSeparatorAttribute() ?>" name="x_order_type" id="x_order_type" value="{value}"<?php echo $po->order_type->editAttributes() ?>></div>
<div id="dsl_x_order_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po->order_type->radioButtonListHtml(FALSE, "x_order_type", 0) ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_cart_id"><?php echo $po->cart_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cart_id" id="z_cart_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->cart_id->cellAttributes() ?>>
			<span id="el_po_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_grp"><?php echo $po->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->grp->cellAttributes() ?>>
			<span id="el_po_grp">
<?php $po->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po->grp->editAttributes() ?>>
		<?php echo $po->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_s_grp"><?php echo $po->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->s_grp->cellAttributes() ?>>
			<span id="el_po_s_grp">
<?php $po->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $po->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $po->s_grp->editAttributes() ?>>
		<?php echo $po->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $po->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_product"><?php echo $po->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->product->cellAttributes() ?>>
			<span id="el_po_product">
<?php $po->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_product" data-page="0" data-value-separator="<?php echo $po->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po->product->editAttributes() ?>>
		<?php echo $po->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $po->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_rid"><?php echo $po->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->rid->cellAttributes() ?>>
			<span id="el_po_rid">
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="po" data-field="x_rid" data-page="0" data-value-separator="<?php echo $po->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $po->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po->rid->radioButtonListHtml(FALSE, "x_rid", 0) ?>
</div></div>
<?php echo $po->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $po_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_search->MultiPages->isActive("1")) ?>" href="#tab_po1"><?php echo $po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_search->MultiPages->Parent ?>" id="tab_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_id"><?php echo $po->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->id->cellAttributes() ?>>
			<span id="el_po_id">
<input type="text" data-table="po" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po->id->getPlaceHolder()) ?>" value="<?php echo $po->id->EditValue ?>"<?php echo $po->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_id"><?php echo $po->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_id->cellAttributes() ?>>
			<span id="el_po_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_buyer_id" data-page="1" data-value-separator="<?php echo $po->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po->buyer_id->editAttributes() ?>>
		<?php echo $po->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label for="x_buyer_order_no" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_order_no"><?php echo $po->buyer_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order_no" id="z_buyer_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_order_no->cellAttributes() ?>>
			<span id="el_po_buyer_order_no">
<input type="text" data-table="po" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po->buyer_order_no->EditValue ?>"<?php echo $po->buyer_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label for="x_buyer_order_date" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_order_date"><?php echo $po->buyer_order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_order_date" id="z_buyer_order_date" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_order_date->cellAttributes() ?>>
			<span id="el_po_buyer_order_date">
<input type="text" data-table="po" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po->buyer_order_date->EditValue ?>"<?php echo $po->buyer_order_date->editAttributes() ?>>
<?php if (!$po->buyer_order_date->ReadOnly && !$po->buyer_order_date->Disabled && !isset($po->buyer_order_date->EditAttrs["readonly"]) && !isset($po->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fposearch", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label for="x_buyer_product_ref" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_product_ref"><?php echo $po->buyer_product_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_product_ref" id="z_buyer_product_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_product_ref->cellAttributes() ?>>
			<span id="el_po_buyer_product_ref">
<input type="text" data-table="po" data-field="x_buyer_product_ref" data-page="1" name="x_buyer_product_ref" id="x_buyer_product_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->buyer_product_ref->getPlaceHolder()) ?>" value="<?php echo $po->buyer_product_ref->EditValue ?>"<?php echo $po->buyer_product_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_despatch_week"><?php echo $po->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->despatch_week->cellAttributes() ?>>
			<span id="el_po_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_despatch_week" data-page="1" data-value-separator="<?php echo $po->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po->despatch_week->editAttributes() ?>>
		<?php echo $po->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_payment_terms"><?php echo $po->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->payment_terms->cellAttributes() ?>>
			<span id="el_po_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_payment_terms" data-page="1" data-value-separator="<?php echo $po->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po->payment_terms->editAttributes() ?>>
		<?php echo $po->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
</div>
<?php echo $po->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->transport_terms->Visible) { // transport_terms ?>
	<div id="r_transport_terms" class="form-group row">
		<label for="x_transport_terms" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_transport_terms"><?php echo $po->transport_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_transport_terms" id="z_transport_terms" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->transport_terms->cellAttributes() ?>>
			<span id="el_po_transport_terms">
<input type="text" data-table="po" data-field="x_transport_terms" data-page="1" name="x_transport_terms" id="x_transport_terms" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($po->transport_terms->getPlaceHolder()) ?>" value="<?php echo $po->transport_terms->EditValue ?>"<?php echo $po->transport_terms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_shipping__id->Visible) { // buyer_shipping _id ?>
	<div id="r_buyer_shipping__id" class="form-group row">
		<label for="x_buyer_shipping__id" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_shipping__id"><?php echo $po->buyer_shipping__id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_shipping__id" id="z_buyer_shipping__id" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_shipping__id->cellAttributes() ?>>
			<span id="el_po_buyer_shipping__id">
<input type="text" data-table="po" data-field="x_buyer_shipping__id" data-page="1" name="x_buyer_shipping__id" id="x_buyer_shipping__id" size="30" placeholder="<?php echo HtmlEncode($po->buyer_shipping__id->getPlaceHolder()) ?>" value="<?php echo $po->buyer_shipping__id->EditValue ?>"<?php echo $po->buyer_shipping__id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_currency"><?php echo $po->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->currency->cellAttributes() ?>>
			<span id="el_po_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_currency" data-page="1" data-value-separator="<?php echo $po->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $po->currency->editAttributes() ?>>
		<?php echo $po->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $po->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_remarks"><?php echo $po->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->remarks->cellAttributes() ?>>
			<span id="el_po_remarks">
<input type="text" data-table="po" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($po->remarks->getPlaceHolder()) ?>" value="<?php echo $po->remarks->EditValue ?>"<?php echo $po->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_instruction"><?php echo $po->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_instruction->cellAttributes() ?>>
			<span id="el_po_buyer_instruction">
<input type="text" data-table="po" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($po->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $po->buyer_instruction->EditValue ?>"<?php echo $po->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->_action->Visible) { // action ?>
	<div id="r__action" class="form-group row">
		<label for="x__action" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po__action"><?php echo $po->_action->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__action" id="z__action" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->_action->cellAttributes() ?>>
			<span id="el_po__action">
<input type="text" data-table="po" data-field="x__action" data-page="1" name="x__action" id="x__action" size="30" maxlength="45" placeholder="<?php echo HtmlEncode($po->_action->getPlaceHolder()) ?>" value="<?php echo $po->_action->EditValue ?>"<?php echo $po->_action->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_url"><?php echo $po->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->url->cellAttributes() ?>>
			<span id="el_po_url">
<input type="text" data-table="po" data-field="x_url" data-page="1" name="x_url" id="x_url" size="30" maxlength="27" placeholder="<?php echo HtmlEncode($po->url->getPlaceHolder()) ?>" value="<?php echo $po->url->EditValue ?>"<?php echo $po->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_search->MultiPages->isActive("2")) ?>" href="#tab_po2"><?php echo $po->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_search->MultiPages->Parent ?>" id="tab_po2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label for="x_description_03" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_03"><?php echo $po->description_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_03" id="z_description_03" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_03->cellAttributes() ?>>
			<span id="el_po_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_03" data-page="2" data-value-separator="<?php echo $po->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po->description_03->editAttributes() ?>>
		<?php echo $po->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label for="x_description_07" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_07"><?php echo $po->description_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_07" id="z_description_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_07->cellAttributes() ?>>
			<span id="el_po_description_07">
<input type="text" data-table="po" data-field="x_description_07" data-page="2" name="x_description_07" id="x_description_07" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->description_07->getPlaceHolder()) ?>" value="<?php echo $po->description_07->EditValue ?>"<?php echo $po->description_07->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_20->Visible) { // description_20 ?>
	<div id="r_description_20" class="form-group row">
		<label for="x_description_20" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_20"><?php echo $po->description_20->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_20" id="z_description_20" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_20->cellAttributes() ?>>
			<span id="el_po_description_20">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_20" data-page="2" data-value-separator="<?php echo $po->description_20->displayValueSeparatorAttribute() ?>" id="x_description_20" name="x_description_20"<?php echo $po->description_20->editAttributes() ?>>
		<?php echo $po->description_20->selectOptionListHtml("x_description_20") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_17->Visible) { // description_17 ?>
	<div id="r_description_17" class="form-group row">
		<label for="x_description_17" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_17"><?php echo $po->description_17->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_17" id="z_description_17" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_17->cellAttributes() ?>>
			<span id="el_po_description_17">
<input type="text" data-table="po" data-field="x_description_17" data-page="2" name="x_description_17" id="x_description_17" size="30" placeholder="<?php echo HtmlEncode($po->description_17->getPlaceHolder()) ?>" value="<?php echo $po->description_17->EditValue ?>"<?php echo $po->description_17->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_18->Visible) { // description_18 ?>
	<div id="r_description_18" class="form-group row">
		<label for="x_description_18" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_18"><?php echo $po->description_18->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_18" id="z_description_18" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_18->cellAttributes() ?>>
			<span id="el_po_description_18">
<input type="text" data-table="po" data-field="x_description_18" data-page="2" name="x_description_18" id="x_description_18" size="30" placeholder="<?php echo HtmlEncode($po->description_18->getPlaceHolder()) ?>" value="<?php echo $po->description_18->EditValue ?>"<?php echo $po->description_18->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_19->Visible) { // description_19 ?>
	<div id="r_description_19" class="form-group row">
		<label for="x_description_19" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_19"><?php echo $po->description_19->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_19" id="z_description_19" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_19->cellAttributes() ?>>
			<span id="el_po_description_19">
<input type="text" data-table="po" data-field="x_description_19" data-page="2" name="x_description_19" id="x_description_19" size="30" placeholder="<?php echo HtmlEncode($po->description_19->getPlaceHolder()) ?>" value="<?php echo $po->description_19->EditValue ?>"<?php echo $po->description_19->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_quantity"><?php echo $po->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->quantity->cellAttributes() ?>>
			<span id="el_po_quantity">
<input type="text" data-table="po" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po->quantity->getPlaceHolder()) ?>" value="<?php echo $po->quantity->EditValue ?>"<?php echo $po->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_price"><?php echo $po->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->price->cellAttributes() ?>>
			<span id="el_po_price">
<input type="text" data-table="po" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po->price->getPlaceHolder()) ?>" value="<?php echo $po->price->EditValue ?>"<?php echo $po->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_amount"><?php echo $po->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->amount->cellAttributes() ?>>
			<span id="el_po_amount">
<input type="text" data-table="po" data-field="x_amount" data-page="2" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po->amount->getPlaceHolder()) ?>" value="<?php echo $po->amount->EditValue ?>"<?php echo $po->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_cbm"><?php echo $po->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->cbm->cellAttributes() ?>>
			<span id="el_po_cbm">
<input type="text" data-table="po" data-field="x_cbm" data-page="2" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po->cbm->getPlaceHolder()) ?>" value="<?php echo $po->cbm->EditValue ?>"<?php echo $po->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->buyer_size->Visible) { // buyer_size ?>
	<div id="r_buyer_size" class="form-group row">
		<label for="x_buyer_size" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_buyer_size"><?php echo $po->buyer_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_size" id="z_buyer_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->buyer_size->cellAttributes() ?>>
			<span id="el_po_buyer_size">
<input type="text" data-table="po" data-field="x_buyer_size" data-page="2" name="x_buyer_size" id="x_buyer_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->buyer_size->getPlaceHolder()) ?>" value="<?php echo $po->buyer_size->EditValue ?>"<?php echo $po->buyer_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label for="x_description_05" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_05"><?php echo $po->description_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_05" id="z_description_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_05->cellAttributes() ?>>
			<span id="el_po_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_05" data-page="2" data-value-separator="<?php echo $po->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po->description_05->editAttributes() ?>>
		<?php echo $po->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
</div>
<?php echo $po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label for="x_description_06" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_06"><?php echo $po->description_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_06" id="z_description_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_06->cellAttributes() ?>>
			<span id="el_po_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_description_06" data-page="2" data-value-separator="<?php echo $po->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po->description_06->editAttributes() ?>>
		<?php echo $po->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
</div>
<?php echo $po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label for="x_description_08" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_08"><?php echo $po->description_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_08" id="z_description_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_08->cellAttributes() ?>>
			<span id="el_po_description_08">
<input type="text" data-table="po" data-field="x_description_08" data-page="2" name="x_description_08" id="x_description_08" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po->description_08->getPlaceHolder()) ?>" value="<?php echo $po->description_08->EditValue ?>"<?php echo $po->description_08->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_search->MultiPages->isActive("3")) ?>" href="#tab_po3"><?php echo $po->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $po_search->MultiPages->Parent ?>" id="tab_po3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label for="x_d_09_head" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_d_09_head"><?php echo $po->d_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_09_head" id="z_d_09_head" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->d_09_head->cellAttributes() ?>>
			<span id="el_po_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_09_head" data-page="3" data-value-separator="<?php echo $po->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po->d_09_head->editAttributes() ?>>
		<?php echo $po->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
</div>
<?php echo $po->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label for="x_description_09" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_09"><?php echo $po->description_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_09" id="z_description_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_09->cellAttributes() ?>>
			<span id="el_po_description_09">
<input type="text" data-table="po" data-field="x_description_09" data-page="3" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_09->getPlaceHolder()) ?>" value="<?php echo $po->description_09->EditValue ?>"<?php echo $po->description_09->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label for="x_d_10_head" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_d_10_head"><?php echo $po->d_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_10_head" id="z_d_10_head" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->d_10_head->cellAttributes() ?>>
			<span id="el_po_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_10_head" data-page="3" data-value-separator="<?php echo $po->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po->d_10_head->editAttributes() ?>>
		<?php echo $po->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
</div>
<?php echo $po->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label for="x_description_10" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_10"><?php echo $po->description_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_10" id="z_description_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_10->cellAttributes() ?>>
			<span id="el_po_description_10">
<input type="text" data-table="po" data-field="x_description_10" data-page="3" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_10->getPlaceHolder()) ?>" value="<?php echo $po->description_10->EditValue ?>"<?php echo $po->description_10->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label for="x_d_11_head" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_d_11_head"><?php echo $po->d_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_11_head" id="z_d_11_head" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->d_11_head->cellAttributes() ?>>
			<span id="el_po_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_11_head" data-page="3" data-value-separator="<?php echo $po->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po->d_11_head->editAttributes() ?>>
		<?php echo $po->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
</div>
<?php echo $po->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label for="x_description_11" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_11"><?php echo $po->description_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_11" id="z_description_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_11->cellAttributes() ?>>
			<span id="el_po_description_11">
<input type="text" data-table="po" data-field="x_description_11" data-page="3" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_11->getPlaceHolder()) ?>" value="<?php echo $po->description_11->EditValue ?>"<?php echo $po->description_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label for="x_d_12_head" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_d_12_head"><?php echo $po->d_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_12_head" id="z_d_12_head" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->d_12_head->cellAttributes() ?>>
			<span id="el_po_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_d_12_head" data-page="3" data-value-separator="<?php echo $po->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po->d_12_head->editAttributes() ?>>
		<?php echo $po->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
</div>
<?php echo $po->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label for="x_description_12" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_description_12"><?php echo $po->description_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_12" id="z_description_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->description_12->cellAttributes() ?>>
			<span id="el_po_description_12">
<input type="text" data-table="po" data-field="x_description_12" data-page="3" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po->description_12->getPlaceHolder()) ?>" value="<?php echo $po->description_12->EditValue ?>"<?php echo $po->description_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_search->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_search->MultiPages->isActive("4")) ?>" href="#tab_po4"><?php echo $po->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_search->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $po_search->MultiPages->Parent ?>" id="tab_po4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_operator"><?php echo $po->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->operator->cellAttributes() ?>>
			<span id="el_po_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_operator" data-page="4" data-value-separator="<?php echo $po->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $po->operator->editAttributes() ?>>
		<?php echo $po->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $po->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_datetime"><?php echo $po->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->datetime->cellAttributes() ?>>
			<span id="el_po_datetime">
<input type="text" data-table="po" data-field="x_datetime" data-page="4" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($po->datetime->getPlaceHolder()) ?>" value="<?php echo $po->datetime->EditValue ?>"<?php echo $po->datetime->editAttributes() ?>>
<?php if (!$po->datetime->ReadOnly && !$po->datetime->Disabled && !isset($po->datetime->EditAttrs["readonly"]) && !isset($po->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fposearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_a_operator"><?php echo $po->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->a_operator->cellAttributes() ?>>
			<span id="el_po_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po" data-field="x_a_operator" data-page="4" data-value-separator="<?php echo $po->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $po->a_operator->editAttributes() ?>>
		<?php echo $po->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $po->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_search->LeftColumnClass ?>"><span id="elh_po_a_datetime"><?php echo $po->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_search->RightColumnClass ?>"><div<?php echo $po->a_datetime->cellAttributes() ?>>
			<span id="el_po_a_datetime">
<input type="text" data-table="po" data-field="x_a_datetime" data-page="4" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po->a_datetime->EditValue ?>"<?php echo $po->a_datetime->editAttributes() ?>>
<?php if (!$po->a_datetime->ReadOnly && !$po->a_datetime->Disabled && !isset($po->a_datetime->EditAttrs["readonly"]) && !isset($po->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fposearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_search->terminate();
?>