<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_category_add = new pp_category_add();

// Run the page
$pp_category_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_category_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpp_categoryadd = currentForm = new ew.Form("fpp_categoryadd", "add");

// Validate form
fpp_categoryadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($pp_category_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->grp->caption(), $pp_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($pp_category_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->category->caption(), $pp_category->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($pp_category_add->partner_type->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_type[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->partner_type->caption(), $pp_category->partner_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($pp_category_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->status->caption(), $pp_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($pp_category_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->operator->caption(), $pp_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($pp_category_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $pp_category->datetime->caption(), $pp_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($pp_category->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpp_categoryadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_categoryadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_categoryadd.lists["x_grp"] = <?php echo $pp_category_add->grp->Lookup->toClientList() ?>;
fpp_categoryadd.lists["x_grp"].options = <?php echo JsonEncode($pp_category_add->grp->lookupOptions()) ?>;
fpp_categoryadd.lists["x_partner_type[]"] = <?php echo $pp_category_add->partner_type->Lookup->toClientList() ?>;
fpp_categoryadd.lists["x_partner_type[]"].options = <?php echo JsonEncode($pp_category_add->partner_type->options(FALSE, TRUE)) ?>;
fpp_categoryadd.lists["x_status"] = <?php echo $pp_category_add->status->Lookup->toClientList() ?>;
fpp_categoryadd.lists["x_status"].options = <?php echo JsonEncode($pp_category_add->status->options(FALSE, TRUE)) ?>;
fpp_categoryadd.lists["x_operator"] = <?php echo $pp_category_add->operator->Lookup->toClientList() ?>;
fpp_categoryadd.lists["x_operator"].options = <?php echo JsonEncode($pp_category_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $pp_category_add->showPageHeader(); ?>
<?php
$pp_category_add->showMessage();
?>
<form name="fpp_categoryadd" id="fpp_categoryadd" class="<?php echo $pp_category_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_category_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_category_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_category">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$pp_category_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($pp_category->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_pp_category_grp" for="x_grp" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->grp->caption() ?><?php echo ($pp_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->grp->cellAttributes() ?>>
<span id="el_pp_category_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_category" data-field="x_grp" data-value-separator="<?php echo $pp_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $pp_category->grp->editAttributes() ?>>
		<?php echo $pp_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $pp_category->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $pp_category->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pp_category->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_pp_category_category" for="x_category" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->category->caption() ?><?php echo ($pp_category->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->category->cellAttributes() ?>>
<span id="el_pp_category_category">
<input type="text" data-table="pp_category" data-field="x_category" name="x_category" id="x_category" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($pp_category->category->getPlaceHolder()) ?>" value="<?php echo $pp_category->category->EditValue ?>"<?php echo $pp_category->category->editAttributes() ?>>
</span>
<?php echo $pp_category->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
	<div id="r_partner_type" class="form-group row">
		<label id="elh_pp_category_partner_type" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->partner_type->caption() ?><?php echo ($pp_category->partner_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->partner_type->cellAttributes() ?>>
<span id="el_pp_category_partner_type">
<div id="tp_x_partner_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="pp_category" data-field="x_partner_type" data-value-separator="<?php echo $pp_category->partner_type->displayValueSeparatorAttribute() ?>" name="x_partner_type[]" id="x_partner_type[]" value="{value}"<?php echo $pp_category->partner_type->editAttributes() ?>></div>
<div id="dsl_x_partner_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $pp_category->partner_type->checkBoxListHtml(FALSE, "x_partner_type[]") ?>
</div></div>
</span>
<?php echo $pp_category->partner_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pp_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_pp_category_status" for="x_status" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->status->caption() ?><?php echo ($pp_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->status->cellAttributes() ?>>
<span id="el_pp_category_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_category" data-field="x_status" data-value-separator="<?php echo $pp_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $pp_category->status->editAttributes() ?>>
		<?php echo $pp_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $pp_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pp_category->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_pp_category_operator" for="x_operator" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->operator->caption() ?><?php echo ($pp_category->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->operator->cellAttributes() ?>>
<span id="el_pp_category_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_category" data-field="x_operator" data-value-separator="<?php echo $pp_category->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $pp_category->operator->editAttributes() ?>>
		<?php echo $pp_category->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $pp_category->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
<?php echo $pp_category->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($pp_category->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_pp_category_datetime" for="x_datetime" class="<?php echo $pp_category_add->LeftColumnClass ?>"><?php echo $pp_category->datetime->caption() ?><?php echo ($pp_category->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $pp_category_add->RightColumnClass ?>"><div<?php echo $pp_category->datetime->cellAttributes() ?>>
<span id="el_pp_category_datetime">
<input type="text" data-table="pp_category" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($pp_category->datetime->getPlaceHolder()) ?>" value="<?php echo $pp_category->datetime->EditValue ?>"<?php echo $pp_category->datetime->editAttributes() ?>>
<?php if (!$pp_category->datetime->ReadOnly && !$pp_category->datetime->Disabled && !isset($pp_category->datetime->EditAttrs["readonly"]) && !isset($pp_category->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpp_categoryadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $pp_category->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$pp_category_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $pp_category_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $pp_category_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$pp_category_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$pp_category_add->terminate();
?>