<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_category_delete = new pp_category_delete();

// Run the page
$pp_category_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_category_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fpp_categorydelete = currentForm = new ew.Form("fpp_categorydelete", "delete");

// Form_CustomValidate event
fpp_categorydelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_categorydelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_categorydelete.lists["x_grp"] = <?php echo $pp_category_delete->grp->Lookup->toClientList() ?>;
fpp_categorydelete.lists["x_grp"].options = <?php echo JsonEncode($pp_category_delete->grp->lookupOptions()) ?>;
fpp_categorydelete.lists["x_partner_type[]"] = <?php echo $pp_category_delete->partner_type->Lookup->toClientList() ?>;
fpp_categorydelete.lists["x_partner_type[]"].options = <?php echo JsonEncode($pp_category_delete->partner_type->options(FALSE, TRUE)) ?>;
fpp_categorydelete.lists["x_status"] = <?php echo $pp_category_delete->status->Lookup->toClientList() ?>;
fpp_categorydelete.lists["x_status"].options = <?php echo JsonEncode($pp_category_delete->status->options(FALSE, TRUE)) ?>;
fpp_categorydelete.lists["x_operator"] = <?php echo $pp_category_delete->operator->Lookup->toClientList() ?>;
fpp_categorydelete.lists["x_operator"].options = <?php echo JsonEncode($pp_category_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $pp_category_delete->showPageHeader(); ?>
<?php
$pp_category_delete->showMessage();
?>
<form name="fpp_categorydelete" id="fpp_categorydelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_category_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_category_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_category">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($pp_category_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($pp_category->id->Visible) { // id ?>
		<th class="<?php echo $pp_category->id->headerCellClass() ?>"><span id="elh_pp_category_id" class="pp_category_id"><?php echo $pp_category->id->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->grp->Visible) { // grp ?>
		<th class="<?php echo $pp_category->grp->headerCellClass() ?>"><span id="elh_pp_category_grp" class="pp_category_grp"><?php echo $pp_category->grp->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->category->Visible) { // category ?>
		<th class="<?php echo $pp_category->category->headerCellClass() ?>"><span id="elh_pp_category_category" class="pp_category_category"><?php echo $pp_category->category->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
		<th class="<?php echo $pp_category->partner_type->headerCellClass() ?>"><span id="elh_pp_category_partner_type" class="pp_category_partner_type"><?php echo $pp_category->partner_type->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->status->Visible) { // status ?>
		<th class="<?php echo $pp_category->status->headerCellClass() ?>"><span id="elh_pp_category_status" class="pp_category_status"><?php echo $pp_category->status->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->operator->Visible) { // operator ?>
		<th class="<?php echo $pp_category->operator->headerCellClass() ?>"><span id="elh_pp_category_operator" class="pp_category_operator"><?php echo $pp_category->operator->caption() ?></span></th>
<?php } ?>
<?php if ($pp_category->datetime->Visible) { // datetime ?>
		<th class="<?php echo $pp_category->datetime->headerCellClass() ?>"><span id="elh_pp_category_datetime" class="pp_category_datetime"><?php echo $pp_category->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$pp_category_delete->RecCnt = 0;
$i = 0;
while (!$pp_category_delete->Recordset->EOF) {
	$pp_category_delete->RecCnt++;
	$pp_category_delete->RowCnt++;

	// Set row properties
	$pp_category->resetAttributes();
	$pp_category->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$pp_category_delete->loadRowValues($pp_category_delete->Recordset);

	// Render row
	$pp_category_delete->renderRow();
?>
	<tr<?php echo $pp_category->rowAttributes() ?>>
<?php if ($pp_category->id->Visible) { // id ?>
		<td<?php echo $pp_category->id->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_id" class="pp_category_id">
<span<?php echo $pp_category->id->viewAttributes() ?>>
<?php echo $pp_category->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->grp->Visible) { // grp ?>
		<td<?php echo $pp_category->grp->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_grp" class="pp_category_grp">
<span<?php echo $pp_category->grp->viewAttributes() ?>>
<?php echo $pp_category->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->category->Visible) { // category ?>
		<td<?php echo $pp_category->category->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_category" class="pp_category_category">
<span<?php echo $pp_category->category->viewAttributes() ?>>
<?php echo $pp_category->category->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
		<td<?php echo $pp_category->partner_type->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_partner_type" class="pp_category_partner_type">
<span<?php echo $pp_category->partner_type->viewAttributes() ?>>
<?php echo $pp_category->partner_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->status->Visible) { // status ?>
		<td<?php echo $pp_category->status->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_status" class="pp_category_status">
<span<?php echo $pp_category->status->viewAttributes() ?>>
<?php echo $pp_category->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->operator->Visible) { // operator ?>
		<td<?php echo $pp_category->operator->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_operator" class="pp_category_operator">
<span<?php echo $pp_category->operator->viewAttributes() ?>>
<?php echo $pp_category->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($pp_category->datetime->Visible) { // datetime ?>
		<td<?php echo $pp_category->datetime->cellAttributes() ?>>
<span id="el<?php echo $pp_category_delete->RowCnt ?>_pp_category_datetime" class="pp_category_datetime">
<span<?php echo $pp_category->datetime->viewAttributes() ?>>
<?php echo $pp_category->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$pp_category_delete->Recordset->moveNext();
}
$pp_category_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $pp_category_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$pp_category_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$pp_category_delete->terminate();
?>