<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_category_list = new pp_category_list();

// Run the page
$pp_category_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_category_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$pp_category->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpp_categorylist = currentForm = new ew.Form("fpp_categorylist", "list");
fpp_categorylist.formKeyCountName = '<?php echo $pp_category_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpp_categorylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_categorylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_categorylist.lists["x_grp"] = <?php echo $pp_category_list->grp->Lookup->toClientList() ?>;
fpp_categorylist.lists["x_grp"].options = <?php echo JsonEncode($pp_category_list->grp->lookupOptions()) ?>;
fpp_categorylist.lists["x_partner_type[]"] = <?php echo $pp_category_list->partner_type->Lookup->toClientList() ?>;
fpp_categorylist.lists["x_partner_type[]"].options = <?php echo JsonEncode($pp_category_list->partner_type->options(FALSE, TRUE)) ?>;
fpp_categorylist.lists["x_status"] = <?php echo $pp_category_list->status->Lookup->toClientList() ?>;
fpp_categorylist.lists["x_status"].options = <?php echo JsonEncode($pp_category_list->status->options(FALSE, TRUE)) ?>;
fpp_categorylist.lists["x_operator"] = <?php echo $pp_category_list->operator->Lookup->toClientList() ?>;
fpp_categorylist.lists["x_operator"].options = <?php echo JsonEncode($pp_category_list->operator->lookupOptions()) ?>;

// Form object for search
var fpp_categorylistsrch = currentSearchForm = new ew.Form("fpp_categorylistsrch");

// Filters
fpp_categorylistsrch.filterList = <?php echo $pp_category_list->getFilterList() ?>;

// Init search panel as collapsed
fpp_categorylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$pp_category->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($pp_category_list->TotalRecs > 0 && $pp_category_list->ExportOptions->visible()) { ?>
<?php $pp_category_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_category_list->ImportOptions->visible()) { ?>
<?php $pp_category_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_category_list->SearchOptions->visible()) { ?>
<?php $pp_category_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($pp_category_list->FilterOptions->visible()) { ?>
<?php $pp_category_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$pp_category_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$pp_category->isExport() && !$pp_category->CurrentAction) { ?>
<form name="fpp_categorylistsrch" id="fpp_categorylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($pp_category_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpp_categorylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="pp_category">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($pp_category_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($pp_category_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $pp_category_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($pp_category_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($pp_category_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($pp_category_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($pp_category_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $pp_category_list->showPageHeader(); ?>
<?php
$pp_category_list->showMessage();
?>
<?php if ($pp_category_list->TotalRecs > 0 || $pp_category->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($pp_category_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> pp_category">
<?php if (!$pp_category->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$pp_category->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_category_list->Pager)) $pp_category_list->Pager = new PrevNextPager($pp_category_list->StartRec, $pp_category_list->DisplayRecs, $pp_category_list->TotalRecs, $pp_category_list->AutoHidePager) ?>
<?php if ($pp_category_list->Pager->RecordCount > 0 && $pp_category_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_category_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_category_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_category_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_category_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_category_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_category_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_category_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_category_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_category_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_category_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_category_list->TotalRecs > 0 && (!$pp_category_list->AutoHidePageSizeSelector || $pp_category_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_category">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_category_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_category_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_category_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_category_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_category_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_category->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_category_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpp_categorylist" id="fpp_categorylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_category_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_category_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_category">
<div id="gmp_pp_category" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($pp_category_list->TotalRecs > 0 || $pp_category->isGridEdit()) { ?>
<table id="tbl_pp_categorylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$pp_category_list->RowType = ROWTYPE_HEADER;

// Render list options
$pp_category_list->renderListOptions();

// Render list options (header, left)
$pp_category_list->ListOptions->render("header", "left");
?>
<?php if ($pp_category->id->Visible) { // id ?>
	<?php if ($pp_category->sortUrl($pp_category->id) == "") { ?>
		<th data-name="id" class="<?php echo $pp_category->id->headerCellClass() ?>"><div id="elh_pp_category_id" class="pp_category_id"><div class="ew-table-header-caption"><?php echo $pp_category->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $pp_category->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->id) ?>',2);"><div id="elh_pp_category_id" class="pp_category_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->grp->Visible) { // grp ?>
	<?php if ($pp_category->sortUrl($pp_category->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $pp_category->grp->headerCellClass() ?>"><div id="elh_pp_category_grp" class="pp_category_grp"><div class="ew-table-header-caption"><?php echo $pp_category->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $pp_category->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->grp) ?>',2);"><div id="elh_pp_category_grp" class="pp_category_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->category->Visible) { // category ?>
	<?php if ($pp_category->sortUrl($pp_category->category) == "") { ?>
		<th data-name="category" class="<?php echo $pp_category->category->headerCellClass() ?>"><div id="elh_pp_category_category" class="pp_category_category"><div class="ew-table-header-caption"><?php echo $pp_category->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $pp_category->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->category) ?>',2);"><div id="elh_pp_category_category" class="pp_category_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->category->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_category->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
	<?php if ($pp_category->sortUrl($pp_category->partner_type) == "") { ?>
		<th data-name="partner_type" class="<?php echo $pp_category->partner_type->headerCellClass() ?>"><div id="elh_pp_category_partner_type" class="pp_category_partner_type"><div class="ew-table-header-caption"><?php echo $pp_category->partner_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_type" class="<?php echo $pp_category->partner_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->partner_type) ?>',2);"><div id="elh_pp_category_partner_type" class="pp_category_partner_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->partner_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->partner_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->partner_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->status->Visible) { // status ?>
	<?php if ($pp_category->sortUrl($pp_category->status) == "") { ?>
		<th data-name="status" class="<?php echo $pp_category->status->headerCellClass() ?>"><div id="elh_pp_category_status" class="pp_category_status"><div class="ew-table-header-caption"><?php echo $pp_category->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $pp_category->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->status) ?>',2);"><div id="elh_pp_category_status" class="pp_category_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->operator->Visible) { // operator ?>
	<?php if ($pp_category->sortUrl($pp_category->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $pp_category->operator->headerCellClass() ?>"><div id="elh_pp_category_operator" class="pp_category_operator"><div class="ew-table-header-caption"><?php echo $pp_category->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $pp_category->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->operator) ?>',2);"><div id="elh_pp_category_operator" class="pp_category_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_category->datetime->Visible) { // datetime ?>
	<?php if ($pp_category->sortUrl($pp_category->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $pp_category->datetime->headerCellClass() ?>"><div id="elh_pp_category_datetime" class="pp_category_datetime"><div class="ew-table-header-caption"><?php echo $pp_category->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $pp_category->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_category->SortUrl($pp_category->datetime) ?>',2);"><div id="elh_pp_category_datetime" class="pp_category_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_category->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_category->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_category->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$pp_category_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($pp_category->ExportAll && $pp_category->isExport()) {
	$pp_category_list->StopRec = $pp_category_list->TotalRecs;
} else {

	// Set the last record to display
	if ($pp_category_list->TotalRecs > $pp_category_list->StartRec + $pp_category_list->DisplayRecs - 1)
		$pp_category_list->StopRec = $pp_category_list->StartRec + $pp_category_list->DisplayRecs - 1;
	else
		$pp_category_list->StopRec = $pp_category_list->TotalRecs;
}
$pp_category_list->RecCnt = $pp_category_list->StartRec - 1;
if ($pp_category_list->Recordset && !$pp_category_list->Recordset->EOF) {
	$pp_category_list->Recordset->moveFirst();
	$selectLimit = $pp_category_list->UseSelectLimit;
	if (!$selectLimit && $pp_category_list->StartRec > 1)
		$pp_category_list->Recordset->move($pp_category_list->StartRec - 1);
} elseif (!$pp_category->AllowAddDeleteRow && $pp_category_list->StopRec == 0) {
	$pp_category_list->StopRec = $pp_category->GridAddRowCount;
}

// Initialize aggregate
$pp_category->RowType = ROWTYPE_AGGREGATEINIT;
$pp_category->resetAttributes();
$pp_category_list->renderRow();
while ($pp_category_list->RecCnt < $pp_category_list->StopRec) {
	$pp_category_list->RecCnt++;
	if ($pp_category_list->RecCnt >= $pp_category_list->StartRec) {
		$pp_category_list->RowCnt++;

		// Set up key count
		$pp_category_list->KeyCount = $pp_category_list->RowIndex;

		// Init row class and style
		$pp_category->resetAttributes();
		$pp_category->CssClass = "";
		if ($pp_category->isGridAdd()) {
		} else {
			$pp_category_list->loadRowValues($pp_category_list->Recordset); // Load row values
		}
		$pp_category->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$pp_category->RowAttrs = array_merge($pp_category->RowAttrs, array('data-rowindex'=>$pp_category_list->RowCnt, 'id'=>'r' . $pp_category_list->RowCnt . '_pp_category', 'data-rowtype'=>$pp_category->RowType));

		// Render row
		$pp_category_list->renderRow();

		// Render list options
		$pp_category_list->renderListOptions();
?>
	<tr<?php echo $pp_category->rowAttributes() ?>>
<?php

// Render list options (body, left)
$pp_category_list->ListOptions->render("body", "left", $pp_category_list->RowCnt);
?>
	<?php if ($pp_category->id->Visible) { // id ?>
		<td data-name="id"<?php echo $pp_category->id->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_id" class="pp_category_id">
<span<?php echo $pp_category->id->viewAttributes() ?>>
<?php echo $pp_category->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $pp_category->grp->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_grp" class="pp_category_grp">
<span<?php echo $pp_category->grp->viewAttributes() ?>>
<?php echo $pp_category->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->category->Visible) { // category ?>
		<td data-name="category"<?php echo $pp_category->category->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_category" class="pp_category_category">
<span<?php echo $pp_category->category->viewAttributes() ?>>
<?php echo $pp_category->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
		<td data-name="partner_type"<?php echo $pp_category->partner_type->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_partner_type" class="pp_category_partner_type">
<span<?php echo $pp_category->partner_type->viewAttributes() ?>>
<?php echo $pp_category->partner_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->status->Visible) { // status ?>
		<td data-name="status"<?php echo $pp_category->status->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_status" class="pp_category_status">
<span<?php echo $pp_category->status->viewAttributes() ?>>
<?php echo $pp_category->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $pp_category->operator->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_operator" class="pp_category_operator">
<span<?php echo $pp_category->operator->viewAttributes() ?>>
<?php echo $pp_category->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_category->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $pp_category->datetime->cellAttributes() ?>>
<span id="el<?php echo $pp_category_list->RowCnt ?>_pp_category_datetime" class="pp_category_datetime">
<span<?php echo $pp_category->datetime->viewAttributes() ?>>
<?php echo $pp_category->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$pp_category_list->ListOptions->render("body", "right", $pp_category_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$pp_category->isGridAdd())
		$pp_category_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$pp_category->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($pp_category_list->Recordset)
	$pp_category_list->Recordset->Close();
?>
<?php if (!$pp_category->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$pp_category->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_category_list->Pager)) $pp_category_list->Pager = new PrevNextPager($pp_category_list->StartRec, $pp_category_list->DisplayRecs, $pp_category_list->TotalRecs, $pp_category_list->AutoHidePager) ?>
<?php if ($pp_category_list->Pager->RecordCount > 0 && $pp_category_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_category_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_category_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_category_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_category_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_category_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_category_list->pageUrl() ?>start=<?php echo $pp_category_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_category_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_category_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_category_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_category_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_category_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_category_list->TotalRecs > 0 && (!$pp_category_list->AutoHidePageSizeSelector || $pp_category_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_category">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_category_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_category_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_category_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_category_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_category_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_category->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_category_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($pp_category_list->TotalRecs == 0 && !$pp_category->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $pp_category_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$pp_category_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$pp_category->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$pp_category->isExport()) { ?>
<script>
ew.scrollableTable("gmp_pp_category", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$pp_category_list->terminate();
?>