<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_category_view = new pp_category_view();

// Run the page
$pp_category_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_category_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$pp_category->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpp_categoryview = currentForm = new ew.Form("fpp_categoryview", "view");

// Form_CustomValidate event
fpp_categoryview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_categoryview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_categoryview.lists["x_grp"] = <?php echo $pp_category_view->grp->Lookup->toClientList() ?>;
fpp_categoryview.lists["x_grp"].options = <?php echo JsonEncode($pp_category_view->grp->lookupOptions()) ?>;
fpp_categoryview.lists["x_partner_type[]"] = <?php echo $pp_category_view->partner_type->Lookup->toClientList() ?>;
fpp_categoryview.lists["x_partner_type[]"].options = <?php echo JsonEncode($pp_category_view->partner_type->options(FALSE, TRUE)) ?>;
fpp_categoryview.lists["x_status"] = <?php echo $pp_category_view->status->Lookup->toClientList() ?>;
fpp_categoryview.lists["x_status"].options = <?php echo JsonEncode($pp_category_view->status->options(FALSE, TRUE)) ?>;
fpp_categoryview.lists["x_operator"] = <?php echo $pp_category_view->operator->Lookup->toClientList() ?>;
fpp_categoryview.lists["x_operator"].options = <?php echo JsonEncode($pp_category_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$pp_category->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $pp_category_view->ExportOptions->render("body") ?>
<?php $pp_category_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $pp_category_view->showPageHeader(); ?>
<?php
$pp_category_view->showMessage();
?>
<form name="fpp_categoryview" id="fpp_categoryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_category_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_category_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_category">
<input type="hidden" name="modal" value="<?php echo (int)$pp_category_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($pp_category->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_id"><?php echo $pp_category->id->caption() ?></span></td>
		<td data-name="id"<?php echo $pp_category->id->cellAttributes() ?>>
<span id="el_pp_category_id">
<span<?php echo $pp_category->id->viewAttributes() ?>>
<?php echo $pp_category->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_grp"><?php echo $pp_category->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $pp_category->grp->cellAttributes() ?>>
<span id="el_pp_category_grp">
<span<?php echo $pp_category->grp->viewAttributes() ?>>
<?php echo $pp_category->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_category"><?php echo $pp_category->category->caption() ?></span></td>
		<td data-name="category"<?php echo $pp_category->category->cellAttributes() ?>>
<span id="el_pp_category_category">
<span<?php echo $pp_category->category->viewAttributes() ?>>
<?php echo $pp_category->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->partner_type->Visible) { // partner_type ?>
	<tr id="r_partner_type">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_partner_type"><?php echo $pp_category->partner_type->caption() ?></span></td>
		<td data-name="partner_type"<?php echo $pp_category->partner_type->cellAttributes() ?>>
<span id="el_pp_category_partner_type">
<span<?php echo $pp_category->partner_type->viewAttributes() ?>>
<?php echo $pp_category->partner_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_status"><?php echo $pp_category->status->caption() ?></span></td>
		<td data-name="status"<?php echo $pp_category->status->cellAttributes() ?>>
<span id="el_pp_category_status">
<span<?php echo $pp_category->status->viewAttributes() ?>>
<?php echo $pp_category->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_operator"><?php echo $pp_category->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $pp_category->operator->cellAttributes() ?>>
<span id="el_pp_category_operator">
<span<?php echo $pp_category->operator->viewAttributes() ?>>
<?php echo $pp_category->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_category->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $pp_category_view->TableLeftColumnClass ?>"><span id="elh_pp_category_datetime"><?php echo $pp_category->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $pp_category->datetime->cellAttributes() ?>>
<span id="el_pp_category_datetime">
<span<?php echo $pp_category->datetime->viewAttributes() ?>>
<?php echo $pp_category->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$pp_category_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$pp_category->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$pp_category_view->terminate();
?>