<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_verify_compiled_list = new pp_verify_compiled_list();

// Run the page
$pp_verify_compiled_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_verify_compiled_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$pp_verify_compiled->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpp_verify_compiledlist = currentForm = new ew.Form("fpp_verify_compiledlist", "list");
fpp_verify_compiledlist.formKeyCountName = '<?php echo $pp_verify_compiled_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpp_verify_compiledlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verify_compiledlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verify_compiledlist.lists["x_location[]"] = <?php echo $pp_verify_compiled_list->location->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_location[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->location->lookupOptions()) ?>;
fpp_verify_compiledlist.lists["x_product_type[]"] = <?php echo $pp_verify_compiled_list->product_type->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_product_type[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->product_type->lookupOptions()) ?>;
fpp_verify_compiledlist.lists["x_shape[]"] = <?php echo $pp_verify_compiled_list->shape->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_shape[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->shape->lookupOptions()) ?>;
fpp_verify_compiledlist.lists["x_plan_type[]"] = <?php echo $pp_verify_compiled_list->plan_type->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_plan_type[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->plan_type->options(FALSE, TRUE)) ?>;
fpp_verify_compiledlist.lists["x_design_id[]"] = <?php echo $pp_verify_compiled_list->design_id->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_design_id[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->design_id->lookupOptions()) ?>;
fpp_verify_compiledlist.lists["x_process"] = <?php echo $pp_verify_compiled_list->process->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_process"].options = <?php echo JsonEncode($pp_verify_compiled_list->process->lookupOptions()) ?>;
fpp_verify_compiledlist.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verify_compiledlist.lists["x_yes_no[]"] = <?php echo $pp_verify_compiled_list->yes_no->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_yes_no[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->yes_no->options(FALSE, TRUE)) ?>;
fpp_verify_compiledlist.lists["x_fix[]"] = <?php echo $pp_verify_compiled_list->fix->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_fix[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->fix->options(FALSE, TRUE)) ?>;
fpp_verify_compiledlist.lists["x_unit[]"] = <?php echo $pp_verify_compiled_list->unit->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_unit[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->unit->options(FALSE, TRUE)) ?>;
fpp_verify_compiledlist.lists["x_extra_plan[]"] = <?php echo $pp_verify_compiled_list->extra_plan->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_extra_plan[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->extra_plan->options(FALSE, TRUE)) ?>;
fpp_verify_compiledlist.lists["x_method[]"] = <?php echo $pp_verify_compiled_list->method->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_method[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->method->lookupOptions()) ?>;
fpp_verify_compiledlist.lists["x_category[]"] = <?php echo $pp_verify_compiled_list->category->Lookup->toClientList() ?>;
fpp_verify_compiledlist.lists["x_category[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->category->lookupOptions()) ?>;

// Form object for search
var fpp_verify_compiledlistsrch = currentSearchForm = new ew.Form("fpp_verify_compiledlistsrch");

// Validate function for search
fpp_verify_compiledlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpp_verify_compiledlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verify_compiledlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verify_compiledlistsrch.lists["x_design_id[]"] = <?php echo $pp_verify_compiled_list->design_id->Lookup->toClientList() ?>;
fpp_verify_compiledlistsrch.lists["x_design_id[]"].options = <?php echo JsonEncode($pp_verify_compiled_list->design_id->lookupOptions()) ?>;
fpp_verify_compiledlistsrch.lists["x_process"] = <?php echo $pp_verify_compiled_list->process->Lookup->toClientList() ?>;
fpp_verify_compiledlistsrch.lists["x_process"].options = <?php echo JsonEncode($pp_verify_compiled_list->process->lookupOptions()) ?>;
fpp_verify_compiledlistsrch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpp_verify_compiledlistsrch.filterList = <?php echo $pp_verify_compiled_list->getFilterList() ?>;

// Init search panel as collapsed
fpp_verify_compiledlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$pp_verify_compiled->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($pp_verify_compiled_list->TotalRecs > 0 && $pp_verify_compiled_list->ExportOptions->visible()) { ?>
<?php $pp_verify_compiled_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_compiled_list->ImportOptions->visible()) { ?>
<?php $pp_verify_compiled_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_compiled_list->SearchOptions->visible()) { ?>
<?php $pp_verify_compiled_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_compiled_list->FilterOptions->visible()) { ?>
<?php $pp_verify_compiled_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$pp_verify_compiled_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$pp_verify_compiled->isExport() && !$pp_verify_compiled->CurrentAction) { ?>
<form name="fpp_verify_compiledlistsrch" id="fpp_verify_compiledlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($pp_verify_compiled_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpp_verify_compiledlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="pp_verify_compiled">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$pp_verify_compiled_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$pp_verify_compiled->RowType = ROWTYPE_SEARCH;

// Render row
$pp_verify_compiled->resetAttributes();
$pp_verify_compiled_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($pp_verify_compiled->gcode->Visible) { // gcode ?>
	<div id="xsc_gcode" class="ew-cell form-group">
		<label for="x_gcode" class="ew-search-caption ew-label"><?php echo $pp_verify_compiled->gcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gcode" id="z_gcode" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="pp_verify_compiled" data-field="x_gcode" name="x_gcode" id="x_gcode" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($pp_verify_compiled->gcode->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->gcode->EditValue ?>"<?php echo $pp_verify_compiled->gcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label for="x_design_id" class="ew-search-caption ew-label"><?php echo $pp_verify_compiled->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_id" id="z_design_id" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="pp_verify_compiled" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->design_id->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->design_id->EditValue ?>"<?php echo $pp_verify_compiled->design_id->editAttributes() ?>>
<?php echo $pp_verify_compiled->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $pp_verify_compiled->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$pp_verify_compiled->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$pp_verify_compiled->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($pp_verify_compiled->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($pp_verify_compiled->process->getPlaceHolder()) ?>"<?php echo $pp_verify_compiled->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="pp_verify_compiled" data-field="x_process" data-value-separator="<?php echo $pp_verify_compiled->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($pp_verify_compiled->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpp_verify_compiledlistsrch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $pp_verify_compiled->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($pp_verify_compiled_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($pp_verify_compiled_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $pp_verify_compiled_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($pp_verify_compiled_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_compiled_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_compiled_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_compiled_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $pp_verify_compiled_list->showPageHeader(); ?>
<?php
$pp_verify_compiled_list->showMessage();
?>
<?php if ($pp_verify_compiled_list->TotalRecs > 0 || $pp_verify_compiled->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($pp_verify_compiled_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> pp_verify_compiled">
<?php if (!$pp_verify_compiled->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$pp_verify_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_verify_compiled_list->Pager)) $pp_verify_compiled_list->Pager = new PrevNextPager($pp_verify_compiled_list->StartRec, $pp_verify_compiled_list->DisplayRecs, $pp_verify_compiled_list->TotalRecs, $pp_verify_compiled_list->AutoHidePager) ?>
<?php if ($pp_verify_compiled_list->Pager->RecordCount > 0 && $pp_verify_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_verify_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_verify_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_verify_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_verify_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_verify_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_verify_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_verify_compiled_list->TotalRecs > 0 && (!$pp_verify_compiled_list->AutoHidePageSizeSelector || $pp_verify_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_verify_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_verify_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_verify_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_verify_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_verify_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_verify_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_verify_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_verify_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpp_verify_compiledlist" id="fpp_verify_compiledlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_verify_compiled_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_verify_compiled_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_verify_compiled">
<div id="gmp_pp_verify_compiled" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($pp_verify_compiled_list->TotalRecs > 0 || $pp_verify_compiled->isGridEdit()) { ?>
<table id="tbl_pp_verify_compiledlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$pp_verify_compiled_list->RowType = ROWTYPE_HEADER;

// Render list options
$pp_verify_compiled_list->renderListOptions();

// Render list options (header, left)
$pp_verify_compiled_list->ListOptions->render("header", "left");
?>
<?php if ($pp_verify_compiled->id->Visible) { // id ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->id) == "") { ?>
		<th data-name="id" class="<?php echo $pp_verify_compiled->id->headerCellClass() ?>"><div id="elh_pp_verify_compiled_id" class="pp_verify_compiled_id"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $pp_verify_compiled->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->id) ?>',2);"><div id="elh_pp_verify_compiled_id" class="pp_verify_compiled_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->pid->Visible) { // pid ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->pid) == "") { ?>
		<th data-name="pid" class="<?php echo $pp_verify_compiled->pid->headerCellClass() ?>"><div id="elh_pp_verify_compiled_pid" class="pp_verify_compiled_pid"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->pid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pid" class="<?php echo $pp_verify_compiled->pid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->pid) ?>',2);"><div id="elh_pp_verify_compiled_pid" class="pp_verify_compiled_pid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->pid->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->pid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->pid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->location->Visible) { // location ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->location) == "") { ?>
		<th data-name="location" class="<?php echo $pp_verify_compiled->location->headerCellClass() ?>"><div id="elh_pp_verify_compiled_location" class="pp_verify_compiled_location"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $pp_verify_compiled->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->location) ?>',2);"><div id="elh_pp_verify_compiled_location" class="pp_verify_compiled_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->product_type->Visible) { // product_type ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $pp_verify_compiled->product_type->headerCellClass() ?>"><div id="elh_pp_verify_compiled_product_type" class="pp_verify_compiled_product_type"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $pp_verify_compiled->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->product_type) ?>',2);"><div id="elh_pp_verify_compiled_product_type" class="pp_verify_compiled_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->shape->Visible) { // shape ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $pp_verify_compiled->shape->headerCellClass() ?>"><div id="elh_pp_verify_compiled_shape" class="pp_verify_compiled_shape"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $pp_verify_compiled->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->shape) ?>',2);"><div id="elh_pp_verify_compiled_shape" class="pp_verify_compiled_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->plan_type->Visible) { // plan_type ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->plan_type) == "") { ?>
		<th data-name="plan_type" class="<?php echo $pp_verify_compiled->plan_type->headerCellClass() ?>"><div id="elh_pp_verify_compiled_plan_type" class="pp_verify_compiled_plan_type"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->plan_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_type" class="<?php echo $pp_verify_compiled->plan_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->plan_type) ?>',2);"><div id="elh_pp_verify_compiled_plan_type" class="pp_verify_compiled_plan_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->plan_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->plan_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->plan_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->gcode->Visible) { // gcode ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $pp_verify_compiled->gcode->headerCellClass() ?>"><div id="elh_pp_verify_compiled_gcode" class="pp_verify_compiled_gcode"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $pp_verify_compiled->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->gcode) ?>',2);"><div id="elh_pp_verify_compiled_gcode" class="pp_verify_compiled_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->gcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->design_id->Visible) { // design_id ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $pp_verify_compiled->design_id->headerCellClass() ?>"><div id="elh_pp_verify_compiled_design_id" class="pp_verify_compiled_design_id"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $pp_verify_compiled->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->design_id) ?>',2);"><div id="elh_pp_verify_compiled_design_id" class="pp_verify_compiled_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->process->Visible) { // process ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->process) == "") { ?>
		<th data-name="process" class="<?php echo $pp_verify_compiled->process->headerCellClass() ?>"><div id="elh_pp_verify_compiled_process" class="pp_verify_compiled_process"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $pp_verify_compiled->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->process) ?>',2);"><div id="elh_pp_verify_compiled_process" class="pp_verify_compiled_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->process->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->yes_no->Visible) { // yes_no ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->yes_no) == "") { ?>
		<th data-name="yes_no" class="<?php echo $pp_verify_compiled->yes_no->headerCellClass() ?>"><div id="elh_pp_verify_compiled_yes_no" class="pp_verify_compiled_yes_no"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->yes_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yes_no" class="<?php echo $pp_verify_compiled->yes_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->yes_no) ?>',2);"><div id="elh_pp_verify_compiled_yes_no" class="pp_verify_compiled_yes_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->yes_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->yes_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->yes_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->fix->Visible) { // fix ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->fix) == "") { ?>
		<th data-name="fix" class="<?php echo $pp_verify_compiled->fix->headerCellClass() ?>"><div id="elh_pp_verify_compiled_fix" class="pp_verify_compiled_fix"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fix" class="<?php echo $pp_verify_compiled->fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->fix) ?>',2);"><div id="elh_pp_verify_compiled_fix" class="pp_verify_compiled_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->unit->Visible) { // unit ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $pp_verify_compiled->unit->headerCellClass() ?>"><div id="elh_pp_verify_compiled_unit" class="pp_verify_compiled_unit"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $pp_verify_compiled->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->unit) ?>',2);"><div id="elh_pp_verify_compiled_unit" class="pp_verify_compiled_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->_40unit->Visible) { // @unit ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->_40unit) == "") { ?>
		<th data-name="_40unit" class="<?php echo $pp_verify_compiled->_40unit->headerCellClass() ?>"><div id="elh_pp_verify_compiled__40unit" class="pp_verify_compiled__40unit"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->_40unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40unit" class="<?php echo $pp_verify_compiled->_40unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->_40unit) ?>',2);"><div id="elh_pp_verify_compiled__40unit" class="pp_verify_compiled__40unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->_40unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->_40unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->_40unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->_40->Visible) { // @ ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $pp_verify_compiled->_40->headerCellClass() ?>"><div id="elh_pp_verify_compiled__40" class="pp_verify_compiled__40"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $pp_verify_compiled->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->_40) ?>',2);"><div id="elh_pp_verify_compiled__40" class="pp_verify_compiled__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->extra_plan->Visible) { // extra_plan ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->extra_plan) == "") { ?>
		<th data-name="extra_plan" class="<?php echo $pp_verify_compiled->extra_plan->headerCellClass() ?>"><div id="elh_pp_verify_compiled_extra_plan" class="pp_verify_compiled_extra_plan"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->extra_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="extra_plan" class="<?php echo $pp_verify_compiled->extra_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->extra_plan) ?>',2);"><div id="elh_pp_verify_compiled_extra_plan" class="pp_verify_compiled_extra_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->extra_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->extra_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->extra_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->custom_size->Visible) { // custom_size ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->custom_size) == "") { ?>
		<th data-name="custom_size" class="<?php echo $pp_verify_compiled->custom_size->headerCellClass() ?>"><div id="elh_pp_verify_compiled_custom_size" class="pp_verify_compiled_custom_size"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->custom_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size" class="<?php echo $pp_verify_compiled->custom_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->custom_size) ?>',2);"><div id="elh_pp_verify_compiled_custom_size" class="pp_verify_compiled_custom_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->custom_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->custom_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->custom_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->custom_size_below_st) == "") { ?>
		<th data-name="custom_size_below_st" class="<?php echo $pp_verify_compiled->custom_size_below_st->headerCellClass() ?>"><div id="elh_pp_verify_compiled_custom_size_below_st" class="pp_verify_compiled_custom_size_below_st"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->custom_size_below_st->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size_below_st" class="<?php echo $pp_verify_compiled->custom_size_below_st->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->custom_size_below_st) ?>',2);"><div id="elh_pp_verify_compiled_custom_size_below_st" class="pp_verify_compiled_custom_size_below_st">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->custom_size_below_st->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->custom_size_below_st->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->custom_size_below_st->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->method->Visible) { // method ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->method) == "") { ?>
		<th data-name="method" class="<?php echo $pp_verify_compiled->method->headerCellClass() ?>"><div id="elh_pp_verify_compiled_method" class="pp_verify_compiled_method"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $pp_verify_compiled->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->method) ?>',2);"><div id="elh_pp_verify_compiled_method" class="pp_verify_compiled_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify_compiled->category->Visible) { // category ?>
	<?php if ($pp_verify_compiled->sortUrl($pp_verify_compiled->category) == "") { ?>
		<th data-name="category" class="<?php echo $pp_verify_compiled->category->headerCellClass() ?>"><div id="elh_pp_verify_compiled_category" class="pp_verify_compiled_category"><div class="ew-table-header-caption"><?php echo $pp_verify_compiled->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $pp_verify_compiled->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify_compiled->SortUrl($pp_verify_compiled->category) ?>',2);"><div id="elh_pp_verify_compiled_category" class="pp_verify_compiled_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify_compiled->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify_compiled->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify_compiled->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$pp_verify_compiled_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($pp_verify_compiled->ExportAll && $pp_verify_compiled->isExport()) {
	$pp_verify_compiled_list->StopRec = $pp_verify_compiled_list->TotalRecs;
} else {

	// Set the last record to display
	if ($pp_verify_compiled_list->TotalRecs > $pp_verify_compiled_list->StartRec + $pp_verify_compiled_list->DisplayRecs - 1)
		$pp_verify_compiled_list->StopRec = $pp_verify_compiled_list->StartRec + $pp_verify_compiled_list->DisplayRecs - 1;
	else
		$pp_verify_compiled_list->StopRec = $pp_verify_compiled_list->TotalRecs;
}
$pp_verify_compiled_list->RecCnt = $pp_verify_compiled_list->StartRec - 1;
if ($pp_verify_compiled_list->Recordset && !$pp_verify_compiled_list->Recordset->EOF) {
	$pp_verify_compiled_list->Recordset->moveFirst();
	$selectLimit = $pp_verify_compiled_list->UseSelectLimit;
	if (!$selectLimit && $pp_verify_compiled_list->StartRec > 1)
		$pp_verify_compiled_list->Recordset->move($pp_verify_compiled_list->StartRec - 1);
} elseif (!$pp_verify_compiled->AllowAddDeleteRow && $pp_verify_compiled_list->StopRec == 0) {
	$pp_verify_compiled_list->StopRec = $pp_verify_compiled->GridAddRowCount;
}

// Initialize aggregate
$pp_verify_compiled->RowType = ROWTYPE_AGGREGATEINIT;
$pp_verify_compiled->resetAttributes();
$pp_verify_compiled_list->renderRow();
while ($pp_verify_compiled_list->RecCnt < $pp_verify_compiled_list->StopRec) {
	$pp_verify_compiled_list->RecCnt++;
	if ($pp_verify_compiled_list->RecCnt >= $pp_verify_compiled_list->StartRec) {
		$pp_verify_compiled_list->RowCnt++;

		// Set up key count
		$pp_verify_compiled_list->KeyCount = $pp_verify_compiled_list->RowIndex;

		// Init row class and style
		$pp_verify_compiled->resetAttributes();
		$pp_verify_compiled->CssClass = "";
		if ($pp_verify_compiled->isGridAdd()) {
		} else {
			$pp_verify_compiled_list->loadRowValues($pp_verify_compiled_list->Recordset); // Load row values
		}
		$pp_verify_compiled->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$pp_verify_compiled->RowAttrs = array_merge($pp_verify_compiled->RowAttrs, array('data-rowindex'=>$pp_verify_compiled_list->RowCnt, 'id'=>'r' . $pp_verify_compiled_list->RowCnt . '_pp_verify_compiled', 'data-rowtype'=>$pp_verify_compiled->RowType));

		// Render row
		$pp_verify_compiled_list->renderRow();

		// Render list options
		$pp_verify_compiled_list->renderListOptions();
?>
	<tr<?php echo $pp_verify_compiled->rowAttributes() ?>>
<?php

// Render list options (body, left)
$pp_verify_compiled_list->ListOptions->render("body", "left", $pp_verify_compiled_list->RowCnt);
?>
	<?php if ($pp_verify_compiled->id->Visible) { // id ?>
		<td data-name="id"<?php echo $pp_verify_compiled->id->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_id" class="pp_verify_compiled_id">
<span<?php echo $pp_verify_compiled->id->viewAttributes() ?>>
<?php echo $pp_verify_compiled->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->pid->Visible) { // pid ?>
		<td data-name="pid"<?php echo $pp_verify_compiled->pid->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_pid" class="pp_verify_compiled_pid">
<span<?php echo $pp_verify_compiled->pid->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify_compiled->pid->getViewValue())) && $pp_verify_compiled->pid->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify_compiled->pid->linkAttributes() ?>><?php echo $pp_verify_compiled->pid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify_compiled->pid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->location->Visible) { // location ?>
		<td data-name="location"<?php echo $pp_verify_compiled->location->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_location" class="pp_verify_compiled_location">
<span<?php echo $pp_verify_compiled->location->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify_compiled->location->getViewValue())) && $pp_verify_compiled->location->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify_compiled->location->linkAttributes() ?>><?php echo $pp_verify_compiled->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify_compiled->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $pp_verify_compiled->product_type->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_product_type" class="pp_verify_compiled_product_type">
<span<?php echo $pp_verify_compiled->product_type->viewAttributes() ?>>
<?php echo $pp_verify_compiled->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $pp_verify_compiled->shape->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_shape" class="pp_verify_compiled_shape">
<span<?php echo $pp_verify_compiled->shape->viewAttributes() ?>>
<?php echo $pp_verify_compiled->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->plan_type->Visible) { // plan_type ?>
		<td data-name="plan_type"<?php echo $pp_verify_compiled->plan_type->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_plan_type" class="pp_verify_compiled_plan_type">
<span<?php echo $pp_verify_compiled->plan_type->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify_compiled->plan_type->getViewValue())) && $pp_verify_compiled->plan_type->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify_compiled->plan_type->linkAttributes() ?>><?php echo $pp_verify_compiled->plan_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify_compiled->plan_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $pp_verify_compiled->gcode->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_gcode" class="pp_verify_compiled_gcode">
<span<?php echo $pp_verify_compiled->gcode->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify_compiled->gcode->getViewValue())) && $pp_verify_compiled->gcode->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify_compiled->gcode->linkAttributes() ?>><?php echo $pp_verify_compiled->gcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify_compiled->gcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $pp_verify_compiled->design_id->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_design_id" class="pp_verify_compiled_design_id">
<span<?php echo $pp_verify_compiled->design_id->viewAttributes() ?>>
<?php echo $pp_verify_compiled->design_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->process->Visible) { // process ?>
		<td data-name="process"<?php echo $pp_verify_compiled->process->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_process" class="pp_verify_compiled_process">
<span<?php echo $pp_verify_compiled->process->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify_compiled->process->getViewValue())) && $pp_verify_compiled->process->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify_compiled->process->linkAttributes() ?>><?php echo $pp_verify_compiled->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify_compiled->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->yes_no->Visible) { // yes_no ?>
		<td data-name="yes_no"<?php echo $pp_verify_compiled->yes_no->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_yes_no" class="pp_verify_compiled_yes_no">
<span<?php echo $pp_verify_compiled->yes_no->viewAttributes() ?>>
<?php echo $pp_verify_compiled->yes_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->fix->Visible) { // fix ?>
		<td data-name="fix"<?php echo $pp_verify_compiled->fix->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_fix" class="pp_verify_compiled_fix">
<span<?php echo $pp_verify_compiled->fix->viewAttributes() ?>>
<?php echo $pp_verify_compiled->fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $pp_verify_compiled->unit->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_unit" class="pp_verify_compiled_unit">
<span<?php echo $pp_verify_compiled->unit->viewAttributes() ?>>
<?php echo $pp_verify_compiled->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->_40unit->Visible) { // @unit ?>
		<td data-name="_40unit"<?php echo $pp_verify_compiled->_40unit->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled__40unit" class="pp_verify_compiled__40unit">
<span<?php echo $pp_verify_compiled->_40unit->viewAttributes() ?>>
<?php echo $pp_verify_compiled->_40unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $pp_verify_compiled->_40->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled__40" class="pp_verify_compiled__40">
<span<?php echo $pp_verify_compiled->_40->viewAttributes() ?>>
<?php echo $pp_verify_compiled->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->extra_plan->Visible) { // extra_plan ?>
		<td data-name="extra_plan"<?php echo $pp_verify_compiled->extra_plan->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_extra_plan" class="pp_verify_compiled_extra_plan">
<span<?php echo $pp_verify_compiled->extra_plan->viewAttributes() ?>>
<?php echo $pp_verify_compiled->extra_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->custom_size->Visible) { // custom_size ?>
		<td data-name="custom_size"<?php echo $pp_verify_compiled->custom_size->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_custom_size" class="pp_verify_compiled_custom_size">
<span<?php echo $pp_verify_compiled->custom_size->viewAttributes() ?>>
<?php echo $pp_verify_compiled->custom_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->custom_size_below_st->Visible) { // custom_size_below_st ?>
		<td data-name="custom_size_below_st"<?php echo $pp_verify_compiled->custom_size_below_st->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_custom_size_below_st" class="pp_verify_compiled_custom_size_below_st">
<span<?php echo $pp_verify_compiled->custom_size_below_st->viewAttributes() ?>>
<?php echo $pp_verify_compiled->custom_size_below_st->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->method->Visible) { // method ?>
		<td data-name="method"<?php echo $pp_verify_compiled->method->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_method" class="pp_verify_compiled_method">
<span<?php echo $pp_verify_compiled->method->viewAttributes() ?>>
<?php echo $pp_verify_compiled->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify_compiled->category->Visible) { // category ?>
		<td data-name="category"<?php echo $pp_verify_compiled->category->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_compiled_list->RowCnt ?>_pp_verify_compiled_category" class="pp_verify_compiled_category">
<span<?php echo $pp_verify_compiled->category->viewAttributes() ?>>
<?php echo $pp_verify_compiled->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$pp_verify_compiled_list->ListOptions->render("body", "right", $pp_verify_compiled_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$pp_verify_compiled->isGridAdd())
		$pp_verify_compiled_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$pp_verify_compiled->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($pp_verify_compiled_list->Recordset)
	$pp_verify_compiled_list->Recordset->Close();
?>
<?php if (!$pp_verify_compiled->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$pp_verify_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_verify_compiled_list->Pager)) $pp_verify_compiled_list->Pager = new PrevNextPager($pp_verify_compiled_list->StartRec, $pp_verify_compiled_list->DisplayRecs, $pp_verify_compiled_list->TotalRecs, $pp_verify_compiled_list->AutoHidePager) ?>
<?php if ($pp_verify_compiled_list->Pager->RecordCount > 0 && $pp_verify_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_verify_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_verify_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_verify_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_verify_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_verify_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_verify_compiled_list->pageUrl() ?>start=<?php echo $pp_verify_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_verify_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_verify_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_verify_compiled_list->TotalRecs > 0 && (!$pp_verify_compiled_list->AutoHidePageSizeSelector || $pp_verify_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_verify_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_verify_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_verify_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_verify_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_verify_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_verify_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_verify_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_verify_compiled_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($pp_verify_compiled_list->TotalRecs == 0 && !$pp_verify_compiled->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $pp_verify_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$pp_verify_compiled_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$pp_verify_compiled->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$pp_verify_compiled->isExport()) { ?>
<script>
ew.scrollableTable("gmp_pp_verify_compiled", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$pp_verify_compiled_list->terminate();
?>