<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_verify_compiled_search = new pp_verify_compiled_search();

// Run the page
$pp_verify_compiled_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_verify_compiled_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($pp_verify_compiled_search->IsModal) { ?>
var fpp_verify_compiledsearch = currentAdvancedSearchForm = new ew.Form("fpp_verify_compiledsearch", "search");
<?php } else { ?>
var fpp_verify_compiledsearch = currentForm = new ew.Form("fpp_verify_compiledsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpp_verify_compiledsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verify_compiledsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verify_compiledsearch.lists["x_location[]"] = <?php echo $pp_verify_compiled_search->location->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_location[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->location->lookupOptions()) ?>;
fpp_verify_compiledsearch.lists["x_product_type[]"] = <?php echo $pp_verify_compiled_search->product_type->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_product_type[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->product_type->lookupOptions()) ?>;
fpp_verify_compiledsearch.lists["x_shape[]"] = <?php echo $pp_verify_compiled_search->shape->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_shape[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->shape->lookupOptions()) ?>;
fpp_verify_compiledsearch.lists["x_plan_type[]"] = <?php echo $pp_verify_compiled_search->plan_type->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_plan_type[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->plan_type->options(FALSE, TRUE)) ?>;
fpp_verify_compiledsearch.lists["x_design_id[]"] = <?php echo $pp_verify_compiled_search->design_id->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_design_id[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->design_id->lookupOptions()) ?>;
fpp_verify_compiledsearch.lists["x_process"] = <?php echo $pp_verify_compiled_search->process->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_process"].options = <?php echo JsonEncode($pp_verify_compiled_search->process->lookupOptions()) ?>;
fpp_verify_compiledsearch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verify_compiledsearch.lists["x_yes_no[]"] = <?php echo $pp_verify_compiled_search->yes_no->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_yes_no[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->yes_no->options(FALSE, TRUE)) ?>;
fpp_verify_compiledsearch.lists["x_fix[]"] = <?php echo $pp_verify_compiled_search->fix->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_fix[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->fix->options(FALSE, TRUE)) ?>;
fpp_verify_compiledsearch.lists["x_unit[]"] = <?php echo $pp_verify_compiled_search->unit->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_unit[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->unit->options(FALSE, TRUE)) ?>;
fpp_verify_compiledsearch.lists["x_extra_plan[]"] = <?php echo $pp_verify_compiled_search->extra_plan->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_extra_plan[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->extra_plan->options(FALSE, TRUE)) ?>;
fpp_verify_compiledsearch.lists["x_method[]"] = <?php echo $pp_verify_compiled_search->method->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_method[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->method->lookupOptions()) ?>;
fpp_verify_compiledsearch.lists["x_category[]"] = <?php echo $pp_verify_compiled_search->category->Lookup->toClientList() ?>;
fpp_verify_compiledsearch.lists["x_category[]"].options = <?php echo JsonEncode($pp_verify_compiled_search->category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpp_verify_compiledsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->pid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40unit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->_40unit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_size");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->custom_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_size_below_st");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($pp_verify_compiled->custom_size_below_st->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $pp_verify_compiled_search->showPageHeader(); ?>
<?php
$pp_verify_compiled_search->showMessage();
?>
<form name="fpp_verify_compiledsearch" id="fpp_verify_compiledsearch" class="<?php echo $pp_verify_compiled_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_verify_compiled_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_verify_compiled_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_verify_compiled">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$pp_verify_compiled_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($pp_verify_compiled->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_id"><?php echo $pp_verify_compiled->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->id->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_id">
<input type="text" data-table="pp_verify_compiled" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($pp_verify_compiled->id->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->id->EditValue ?>"<?php echo $pp_verify_compiled->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->pid->Visible) { // pid ?>
	<div id="r_pid" class="form-group row">
		<label for="x_pid" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_pid"><?php echo $pp_verify_compiled->pid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pid" id="z_pid" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->pid->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_pid">
<input type="text" data-table="pp_verify_compiled" data-field="x_pid" name="x_pid" id="x_pid" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->pid->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->pid->EditValue ?>"<?php echo $pp_verify_compiled->pid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_location"><?php echo $pp_verify_compiled->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->location->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_location" data-value-separator="<?php echo $pp_verify_compiled->location->displayValueSeparatorAttribute() ?>" id="x_location[]" name="x_location[]" multiple="multiple"<?php echo $pp_verify_compiled->location->editAttributes() ?>>
		<?php echo $pp_verify_compiled->location->selectOptionListHtml("x_location[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_product_type"><?php echo $pp_verify_compiled->product_type->caption() ?></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->product_type->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_product_type" id="z_product_type" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($pp_verify_compiled->product_type->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_pp_verify_compiled_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_product_type" data-value-separator="<?php echo $pp_verify_compiled->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type[]" name="x_product_type[]" multiple="multiple"<?php echo $pp_verify_compiled->product_type->editAttributes() ?>>
		<?php echo $pp_verify_compiled->product_type->selectOptionListHtml("x_product_type[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
			<span class="ew-search-cond btw1_product_type d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_pp_verify_compiled_product_type" class="btw1_product_type d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_product_type" data-value-separator="<?php echo $pp_verify_compiled->product_type->displayValueSeparatorAttribute() ?>" id="y_product_type[]" name="y_product_type[]" multiple="multiple"<?php echo $pp_verify_compiled->product_type->editAttributes() ?>>
		<?php echo $pp_verify_compiled->product_type->selectOptionListHtml("y_product_type[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->product_type->Lookup->getParamTag("p_y_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_shape"><?php echo $pp_verify_compiled->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shape" id="z_shape" value="LIKE"></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->shape->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_shape" data-value-separator="<?php echo $pp_verify_compiled->shape->displayValueSeparatorAttribute() ?>" id="x_shape[]" name="x_shape[]" multiple="multiple"<?php echo $pp_verify_compiled->shape->editAttributes() ?>>
		<?php echo $pp_verify_compiled->shape->selectOptionListHtml("x_shape[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->plan_type->Visible) { // plan_type ?>
	<div id="r_plan_type" class="form-group row">
		<label for="x_plan_type" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_plan_type"><?php echo $pp_verify_compiled->plan_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_plan_type" id="z_plan_type" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->plan_type->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_plan_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_plan_type" data-value-separator="<?php echo $pp_verify_compiled->plan_type->displayValueSeparatorAttribute() ?>" id="x_plan_type[]" name="x_plan_type[]" multiple="multiple"<?php echo $pp_verify_compiled->plan_type->editAttributes() ?>>
		<?php echo $pp_verify_compiled->plan_type->selectOptionListHtml("x_plan_type[]") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label for="x_gcode" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_gcode"><?php echo $pp_verify_compiled->gcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gcode" id="z_gcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->gcode->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_gcode">
<input type="text" data-table="pp_verify_compiled" data-field="x_gcode" name="x_gcode" id="x_gcode" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($pp_verify_compiled->gcode->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->gcode->EditValue ?>"<?php echo $pp_verify_compiled->gcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_design_id"><?php echo $pp_verify_compiled->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_id" id="z_design_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->design_id->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_design_id">
<input type="text" data-table="pp_verify_compiled" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->design_id->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->design_id->EditValue ?>"<?php echo $pp_verify_compiled->design_id->editAttributes() ?>>
<?php echo $pp_verify_compiled->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_process"><?php echo $pp_verify_compiled->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->process->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_process">
<?php
$wrkonchange = "" . trim(@$pp_verify_compiled->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$pp_verify_compiled->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($pp_verify_compiled->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($pp_verify_compiled->process->getPlaceHolder()) ?>"<?php echo $pp_verify_compiled->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="pp_verify_compiled" data-field="x_process" data-value-separator="<?php echo $pp_verify_compiled->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($pp_verify_compiled->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpp_verify_compiledsearch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $pp_verify_compiled->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->yes_no->Visible) { // yes_no ?>
	<div id="r_yes_no" class="form-group row">
		<label for="x_yes_no" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_yes_no"><?php echo $pp_verify_compiled->yes_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_yes_no" id="z_yes_no" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->yes_no->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_yes_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_yes_no" data-value-separator="<?php echo $pp_verify_compiled->yes_no->displayValueSeparatorAttribute() ?>" id="x_yes_no[]" name="x_yes_no[]" multiple="multiple"<?php echo $pp_verify_compiled->yes_no->editAttributes() ?>>
		<?php echo $pp_verify_compiled->yes_no->selectOptionListHtml("x_yes_no[]") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->fix->Visible) { // fix ?>
	<div id="r_fix" class="form-group row">
		<label for="x_fix" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_fix"><?php echo $pp_verify_compiled->fix->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fix" id="z_fix" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->fix->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_fix">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_fix" data-value-separator="<?php echo $pp_verify_compiled->fix->displayValueSeparatorAttribute() ?>" id="x_fix[]" name="x_fix[]" multiple="multiple"<?php echo $pp_verify_compiled->fix->editAttributes() ?>>
		<?php echo $pp_verify_compiled->fix->selectOptionListHtml("x_fix[]") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_unit"><?php echo $pp_verify_compiled->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->unit->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_unit" data-value-separator="<?php echo $pp_verify_compiled->unit->displayValueSeparatorAttribute() ?>" id="x_unit[]" name="x_unit[]" multiple="multiple"<?php echo $pp_verify_compiled->unit->editAttributes() ?>>
		<?php echo $pp_verify_compiled->unit->selectOptionListHtml("x_unit[]") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->_40unit->Visible) { // @unit ?>
	<div id="r__40unit" class="form-group row">
		<label for="x__40unit" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled__40unit"><?php echo $pp_verify_compiled->_40unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40unit" id="z__40unit" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->_40unit->cellAttributes() ?>>
			<span id="el_pp_verify_compiled__40unit">
<input type="text" data-table="pp_verify_compiled" data-field="x__40unit" name="x__40unit" id="x__40unit" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->_40unit->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->_40unit->EditValue ?>"<?php echo $pp_verify_compiled->_40unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled__40"><?php echo $pp_verify_compiled->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->_40->cellAttributes() ?>>
			<span id="el_pp_verify_compiled__40">
<input type="text" data-table="pp_verify_compiled" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->_40->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->_40->EditValue ?>"<?php echo $pp_verify_compiled->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->extra_plan->Visible) { // extra_plan ?>
	<div id="r_extra_plan" class="form-group row">
		<label for="x_extra_plan" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_extra_plan"><?php echo $pp_verify_compiled->extra_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_extra_plan" id="z_extra_plan" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->extra_plan->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_extra_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_extra_plan" data-value-separator="<?php echo $pp_verify_compiled->extra_plan->displayValueSeparatorAttribute() ?>" id="x_extra_plan[]" name="x_extra_plan[]" multiple="multiple"<?php echo $pp_verify_compiled->extra_plan->editAttributes() ?>>
		<?php echo $pp_verify_compiled->extra_plan->selectOptionListHtml("x_extra_plan[]") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->custom_size->Visible) { // custom_size ?>
	<div id="r_custom_size" class="form-group row">
		<label for="x_custom_size" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_custom_size"><?php echo $pp_verify_compiled->custom_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_size" id="z_custom_size" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->custom_size->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_custom_size">
<input type="text" data-table="pp_verify_compiled" data-field="x_custom_size" name="x_custom_size" id="x_custom_size" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->custom_size->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->custom_size->EditValue ?>"<?php echo $pp_verify_compiled->custom_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<div id="r_custom_size_below_st" class="form-group row">
		<label for="x_custom_size_below_st" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_custom_size_below_st"><?php echo $pp_verify_compiled->custom_size_below_st->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_size_below_st" id="z_custom_size_below_st" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->custom_size_below_st->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_custom_size_below_st">
<input type="text" data-table="pp_verify_compiled" data-field="x_custom_size_below_st" name="x_custom_size_below_st" id="x_custom_size_below_st" size="30" placeholder="<?php echo HtmlEncode($pp_verify_compiled->custom_size_below_st->getPlaceHolder()) ?>" value="<?php echo $pp_verify_compiled->custom_size_below_st->EditValue ?>"<?php echo $pp_verify_compiled->custom_size_below_st->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_method"><?php echo $pp_verify_compiled->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_method" id="z_method" value="LIKE"></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->method->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_method" data-value-separator="<?php echo $pp_verify_compiled->method->displayValueSeparatorAttribute() ?>" id="x_method[]" name="x_method[]" multiple="multiple"<?php echo $pp_verify_compiled->method->editAttributes() ?>>
		<?php echo $pp_verify_compiled->method->selectOptionListHtml("x_method[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($pp_verify_compiled->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $pp_verify_compiled_search->LeftColumnClass ?>"><span id="elh_pp_verify_compiled_category"><?php echo $pp_verify_compiled->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $pp_verify_compiled_search->RightColumnClass ?>"><div<?php echo $pp_verify_compiled->category->cellAttributes() ?>>
			<span id="el_pp_verify_compiled_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="pp_verify_compiled" data-field="x_category" data-value-separator="<?php echo $pp_verify_compiled->category->displayValueSeparatorAttribute() ?>" id="x_category[]" name="x_category[]" multiple="multiple"<?php echo $pp_verify_compiled->category->editAttributes() ?>>
		<?php echo $pp_verify_compiled->category->selectOptionListHtml("x_category[]") ?>
	</select>
</div>
<?php echo $pp_verify_compiled->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$pp_verify_compiled_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $pp_verify_compiled_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$pp_verify_compiled_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$pp_verify_compiled_search->terminate();
?>