<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_verify_list = new pp_verify_list();

// Run the page
$pp_verify_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_verify_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$pp_verify->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpp_verifylist = currentForm = new ew.Form("fpp_verifylist", "list");
fpp_verifylist.formKeyCountName = '<?php echo $pp_verify_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpp_verifylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verifylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verifylist.lists["x_location"] = <?php echo $pp_verify_list->location->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_location"].options = <?php echo JsonEncode($pp_verify_list->location->lookupOptions()) ?>;
fpp_verifylist.lists["x_product_type[]"] = <?php echo $pp_verify_list->product_type->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_product_type[]"].options = <?php echo JsonEncode($pp_verify_list->product_type->lookupOptions()) ?>;
fpp_verifylist.lists["x_shape[]"] = <?php echo $pp_verify_list->shape->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_shape[]"].options = <?php echo JsonEncode($pp_verify_list->shape->lookupOptions()) ?>;
fpp_verifylist.lists["x_plan_type"] = <?php echo $pp_verify_list->plan_type->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_plan_type"].options = <?php echo JsonEncode($pp_verify_list->plan_type->options(FALSE, TRUE)) ?>;
fpp_verifylist.lists["x_design_id"] = <?php echo $pp_verify_list->design_id->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_design_id"].options = <?php echo JsonEncode($pp_verify_list->design_id->lookupOptions()) ?>;
fpp_verifylist.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verifylist.lists["x_process"] = <?php echo $pp_verify_list->process->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_process"].options = <?php echo JsonEncode($pp_verify_list->process->lookupOptions()) ?>;
fpp_verifylist.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verifylist.lists["x_yes_no"] = <?php echo $pp_verify_list->yes_no->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_yes_no"].options = <?php echo JsonEncode($pp_verify_list->yes_no->options(FALSE, TRUE)) ?>;
fpp_verifylist.lists["x_fix"] = <?php echo $pp_verify_list->fix->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_fix"].options = <?php echo JsonEncode($pp_verify_list->fix->options(FALSE, TRUE)) ?>;
fpp_verifylist.lists["x_unit"] = <?php echo $pp_verify_list->unit->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_unit"].options = <?php echo JsonEncode($pp_verify_list->unit->options(FALSE, TRUE)) ?>;
fpp_verifylist.lists["x_extra_plan"] = <?php echo $pp_verify_list->extra_plan->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_extra_plan"].options = <?php echo JsonEncode($pp_verify_list->extra_plan->options(FALSE, TRUE)) ?>;
fpp_verifylist.lists["x_method"] = <?php echo $pp_verify_list->method->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_method"].options = <?php echo JsonEncode($pp_verify_list->method->lookupOptions()) ?>;
fpp_verifylist.lists["x_category"] = <?php echo $pp_verify_list->category->Lookup->toClientList() ?>;
fpp_verifylist.lists["x_category"].options = <?php echo JsonEncode($pp_verify_list->category->lookupOptions()) ?>;

// Form object for search
var fpp_verifylistsrch = currentSearchForm = new ew.Form("fpp_verifylistsrch");

// Validate function for search
fpp_verifylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpp_verifylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verifylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verifylistsrch.lists["x_design_id"] = <?php echo $pp_verify_list->design_id->Lookup->toClientList() ?>;
fpp_verifylistsrch.lists["x_design_id"].options = <?php echo JsonEncode($pp_verify_list->design_id->lookupOptions()) ?>;
fpp_verifylistsrch.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verifylistsrch.lists["x_process"] = <?php echo $pp_verify_list->process->Lookup->toClientList() ?>;
fpp_verifylistsrch.lists["x_process"].options = <?php echo JsonEncode($pp_verify_list->process->lookupOptions()) ?>;
fpp_verifylistsrch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpp_verifylistsrch.filterList = <?php echo $pp_verify_list->getFilterList() ?>;

// Init search panel as collapsed
fpp_verifylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$pp_verify->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($pp_verify_list->TotalRecs > 0 && $pp_verify_list->ExportOptions->visible()) { ?>
<?php $pp_verify_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_list->ImportOptions->visible()) { ?>
<?php $pp_verify_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_list->SearchOptions->visible()) { ?>
<?php $pp_verify_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($pp_verify_list->FilterOptions->visible()) { ?>
<?php $pp_verify_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$pp_verify_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$pp_verify->isExport() && !$pp_verify->CurrentAction) { ?>
<form name="fpp_verifylistsrch" id="fpp_verifylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($pp_verify_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpp_verifylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="pp_verify">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$pp_verify_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$pp_verify->RowType = ROWTYPE_SEARCH;

// Render row
$pp_verify->resetAttributes();
$pp_verify_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($pp_verify->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $pp_verify->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_id" id="z_design_id" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$pp_verify->design_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$pp_verify->design_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_design_id" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_design_id" id="sv_x_design_id" value="<?php echo RemoveHtml($pp_verify->design_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($pp_verify->design_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($pp_verify->design_id->getPlaceHolder()) ?>"<?php echo $pp_verify->design_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="pp_verify" data-field="x_design_id" data-value-separator="<?php echo $pp_verify->design_id->displayValueSeparatorAttribute() ?>" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($pp_verify->design_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpp_verifylistsrch.createAutoSuggest({"id":"x_design_id","forceSelect":false});
</script>
<?php echo $pp_verify->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($pp_verify->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $pp_verify->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$pp_verify->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$pp_verify->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($pp_verify->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($pp_verify->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($pp_verify->process->getPlaceHolder()) ?>"<?php echo $pp_verify->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="pp_verify" data-field="x_process" data-value-separator="<?php echo $pp_verify->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($pp_verify->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpp_verifylistsrch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $pp_verify->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($pp_verify_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($pp_verify_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $pp_verify_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($pp_verify_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($pp_verify_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $pp_verify_list->showPageHeader(); ?>
<?php
$pp_verify_list->showMessage();
?>
<?php if ($pp_verify_list->TotalRecs > 0 || $pp_verify->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($pp_verify_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> pp_verify">
<?php if (!$pp_verify->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$pp_verify->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_verify_list->Pager)) $pp_verify_list->Pager = new PrevNextPager($pp_verify_list->StartRec, $pp_verify_list->DisplayRecs, $pp_verify_list->TotalRecs, $pp_verify_list->AutoHidePager) ?>
<?php if ($pp_verify_list->Pager->RecordCount > 0 && $pp_verify_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_verify_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_verify_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_verify_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_verify_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_verify_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_verify_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_verify_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_verify_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_verify_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_verify_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_verify_list->TotalRecs > 0 && (!$pp_verify_list->AutoHidePageSizeSelector || $pp_verify_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_verify">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_verify_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_verify_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_verify_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_verify_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_verify_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_verify->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_verify_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpp_verifylist" id="fpp_verifylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_verify_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_verify_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_verify">
<div id="gmp_pp_verify" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($pp_verify_list->TotalRecs > 0 || $pp_verify->isGridEdit()) { ?>
<table id="tbl_pp_verifylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$pp_verify_list->RowType = ROWTYPE_HEADER;

// Render list options
$pp_verify_list->renderListOptions();

// Render list options (header, left)
$pp_verify_list->ListOptions->render("header", "left");
?>
<?php if ($pp_verify->id->Visible) { // id ?>
	<?php if ($pp_verify->sortUrl($pp_verify->id) == "") { ?>
		<th data-name="id" class="<?php echo $pp_verify->id->headerCellClass() ?>"><div id="elh_pp_verify_id" class="pp_verify_id"><div class="ew-table-header-caption"><?php echo $pp_verify->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $pp_verify->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->id) ?>',2);"><div id="elh_pp_verify_id" class="pp_verify_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->pid->Visible) { // pid ?>
	<?php if ($pp_verify->sortUrl($pp_verify->pid) == "") { ?>
		<th data-name="pid" class="<?php echo $pp_verify->pid->headerCellClass() ?>"><div id="elh_pp_verify_pid" class="pp_verify_pid"><div class="ew-table-header-caption"><?php echo $pp_verify->pid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pid" class="<?php echo $pp_verify->pid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->pid) ?>',2);"><div id="elh_pp_verify_pid" class="pp_verify_pid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->pid->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->pid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->pid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->location->Visible) { // location ?>
	<?php if ($pp_verify->sortUrl($pp_verify->location) == "") { ?>
		<th data-name="location" class="<?php echo $pp_verify->location->headerCellClass() ?>"><div id="elh_pp_verify_location" class="pp_verify_location"><div class="ew-table-header-caption"><?php echo $pp_verify->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $pp_verify->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->location) ?>',2);"><div id="elh_pp_verify_location" class="pp_verify_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->product_type->Visible) { // product_type ?>
	<?php if ($pp_verify->sortUrl($pp_verify->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $pp_verify->product_type->headerCellClass() ?>"><div id="elh_pp_verify_product_type" class="pp_verify_product_type"><div class="ew-table-header-caption"><?php echo $pp_verify->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $pp_verify->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->product_type) ?>',2);"><div id="elh_pp_verify_product_type" class="pp_verify_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->shape->Visible) { // shape ?>
	<?php if ($pp_verify->sortUrl($pp_verify->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $pp_verify->shape->headerCellClass() ?>"><div id="elh_pp_verify_shape" class="pp_verify_shape"><div class="ew-table-header-caption"><?php echo $pp_verify->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $pp_verify->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->shape) ?>',2);"><div id="elh_pp_verify_shape" class="pp_verify_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->plan_type->Visible) { // plan_type ?>
	<?php if ($pp_verify->sortUrl($pp_verify->plan_type) == "") { ?>
		<th data-name="plan_type" class="<?php echo $pp_verify->plan_type->headerCellClass() ?>"><div id="elh_pp_verify_plan_type" class="pp_verify_plan_type"><div class="ew-table-header-caption"><?php echo $pp_verify->plan_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_type" class="<?php echo $pp_verify->plan_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->plan_type) ?>',2);"><div id="elh_pp_verify_plan_type" class="pp_verify_plan_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->plan_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->plan_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->plan_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->design_id->Visible) { // design_id ?>
	<?php if ($pp_verify->sortUrl($pp_verify->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $pp_verify->design_id->headerCellClass() ?>"><div id="elh_pp_verify_design_id" class="pp_verify_design_id"><div class="ew-table-header-caption"><?php echo $pp_verify->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $pp_verify->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->design_id) ?>',2);"><div id="elh_pp_verify_design_id" class="pp_verify_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->design_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->process->Visible) { // process ?>
	<?php if ($pp_verify->sortUrl($pp_verify->process) == "") { ?>
		<th data-name="process" class="<?php echo $pp_verify->process->headerCellClass() ?>"><div id="elh_pp_verify_process" class="pp_verify_process"><div class="ew-table-header-caption"><?php echo $pp_verify->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $pp_verify->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->process) ?>',2);"><div id="elh_pp_verify_process" class="pp_verify_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->process->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->yes_no->Visible) { // yes_no ?>
	<?php if ($pp_verify->sortUrl($pp_verify->yes_no) == "") { ?>
		<th data-name="yes_no" class="<?php echo $pp_verify->yes_no->headerCellClass() ?>"><div id="elh_pp_verify_yes_no" class="pp_verify_yes_no"><div class="ew-table-header-caption"><?php echo $pp_verify->yes_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yes_no" class="<?php echo $pp_verify->yes_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->yes_no) ?>',2);"><div id="elh_pp_verify_yes_no" class="pp_verify_yes_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->yes_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->yes_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->yes_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->fix->Visible) { // fix ?>
	<?php if ($pp_verify->sortUrl($pp_verify->fix) == "") { ?>
		<th data-name="fix" class="<?php echo $pp_verify->fix->headerCellClass() ?>"><div id="elh_pp_verify_fix" class="pp_verify_fix"><div class="ew-table-header-caption"><?php echo $pp_verify->fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fix" class="<?php echo $pp_verify->fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->fix) ?>',2);"><div id="elh_pp_verify_fix" class="pp_verify_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->unit->Visible) { // unit ?>
	<?php if ($pp_verify->sortUrl($pp_verify->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $pp_verify->unit->headerCellClass() ?>"><div id="elh_pp_verify_unit" class="pp_verify_unit"><div class="ew-table-header-caption"><?php echo $pp_verify->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $pp_verify->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->unit) ?>',2);"><div id="elh_pp_verify_unit" class="pp_verify_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->_40unit->Visible) { // @unit ?>
	<?php if ($pp_verify->sortUrl($pp_verify->_40unit) == "") { ?>
		<th data-name="_40unit" class="<?php echo $pp_verify->_40unit->headerCellClass() ?>"><div id="elh_pp_verify__40unit" class="pp_verify__40unit"><div class="ew-table-header-caption"><?php echo $pp_verify->_40unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40unit" class="<?php echo $pp_verify->_40unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->_40unit) ?>',2);"><div id="elh_pp_verify__40unit" class="pp_verify__40unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->_40unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->_40unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->_40unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->_40->Visible) { // @ ?>
	<?php if ($pp_verify->sortUrl($pp_verify->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $pp_verify->_40->headerCellClass() ?>"><div id="elh_pp_verify__40" class="pp_verify__40"><div class="ew-table-header-caption"><?php echo $pp_verify->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $pp_verify->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->_40) ?>',2);"><div id="elh_pp_verify__40" class="pp_verify__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->extra_plan->Visible) { // extra_plan ?>
	<?php if ($pp_verify->sortUrl($pp_verify->extra_plan) == "") { ?>
		<th data-name="extra_plan" class="<?php echo $pp_verify->extra_plan->headerCellClass() ?>"><div id="elh_pp_verify_extra_plan" class="pp_verify_extra_plan"><div class="ew-table-header-caption"><?php echo $pp_verify->extra_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="extra_plan" class="<?php echo $pp_verify->extra_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->extra_plan) ?>',2);"><div id="elh_pp_verify_extra_plan" class="pp_verify_extra_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->extra_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->extra_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->extra_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->custom_size->Visible) { // custom_size ?>
	<?php if ($pp_verify->sortUrl($pp_verify->custom_size) == "") { ?>
		<th data-name="custom_size" class="<?php echo $pp_verify->custom_size->headerCellClass() ?>"><div id="elh_pp_verify_custom_size" class="pp_verify_custom_size"><div class="ew-table-header-caption"><?php echo $pp_verify->custom_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size" class="<?php echo $pp_verify->custom_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->custom_size) ?>',2);"><div id="elh_pp_verify_custom_size" class="pp_verify_custom_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->custom_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->custom_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->custom_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<?php if ($pp_verify->sortUrl($pp_verify->custom_size_below_st) == "") { ?>
		<th data-name="custom_size_below_st" class="<?php echo $pp_verify->custom_size_below_st->headerCellClass() ?>"><div id="elh_pp_verify_custom_size_below_st" class="pp_verify_custom_size_below_st"><div class="ew-table-header-caption"><?php echo $pp_verify->custom_size_below_st->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size_below_st" class="<?php echo $pp_verify->custom_size_below_st->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->custom_size_below_st) ?>',2);"><div id="elh_pp_verify_custom_size_below_st" class="pp_verify_custom_size_below_st">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->custom_size_below_st->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->custom_size_below_st->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->custom_size_below_st->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->method->Visible) { // method ?>
	<?php if ($pp_verify->sortUrl($pp_verify->method) == "") { ?>
		<th data-name="method" class="<?php echo $pp_verify->method->headerCellClass() ?>"><div id="elh_pp_verify_method" class="pp_verify_method"><div class="ew-table-header-caption"><?php echo $pp_verify->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $pp_verify->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->method) ?>',2);"><div id="elh_pp_verify_method" class="pp_verify_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pp_verify->category->Visible) { // category ?>
	<?php if ($pp_verify->sortUrl($pp_verify->category) == "") { ?>
		<th data-name="category" class="<?php echo $pp_verify->category->headerCellClass() ?>"><div id="elh_pp_verify_category" class="pp_verify_category"><div class="ew-table-header-caption"><?php echo $pp_verify->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $pp_verify->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $pp_verify->SortUrl($pp_verify->category) ?>',2);"><div id="elh_pp_verify_category" class="pp_verify_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pp_verify->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($pp_verify->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($pp_verify->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$pp_verify_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($pp_verify->ExportAll && $pp_verify->isExport()) {
	$pp_verify_list->StopRec = $pp_verify_list->TotalRecs;
} else {

	// Set the last record to display
	if ($pp_verify_list->TotalRecs > $pp_verify_list->StartRec + $pp_verify_list->DisplayRecs - 1)
		$pp_verify_list->StopRec = $pp_verify_list->StartRec + $pp_verify_list->DisplayRecs - 1;
	else
		$pp_verify_list->StopRec = $pp_verify_list->TotalRecs;
}
$pp_verify_list->RecCnt = $pp_verify_list->StartRec - 1;
if ($pp_verify_list->Recordset && !$pp_verify_list->Recordset->EOF) {
	$pp_verify_list->Recordset->moveFirst();
	$selectLimit = $pp_verify_list->UseSelectLimit;
	if (!$selectLimit && $pp_verify_list->StartRec > 1)
		$pp_verify_list->Recordset->move($pp_verify_list->StartRec - 1);
} elseif (!$pp_verify->AllowAddDeleteRow && $pp_verify_list->StopRec == 0) {
	$pp_verify_list->StopRec = $pp_verify->GridAddRowCount;
}

// Initialize aggregate
$pp_verify->RowType = ROWTYPE_AGGREGATEINIT;
$pp_verify->resetAttributes();
$pp_verify_list->renderRow();
while ($pp_verify_list->RecCnt < $pp_verify_list->StopRec) {
	$pp_verify_list->RecCnt++;
	if ($pp_verify_list->RecCnt >= $pp_verify_list->StartRec) {
		$pp_verify_list->RowCnt++;

		// Set up key count
		$pp_verify_list->KeyCount = $pp_verify_list->RowIndex;

		// Init row class and style
		$pp_verify->resetAttributes();
		$pp_verify->CssClass = "";
		if ($pp_verify->isGridAdd()) {
		} else {
			$pp_verify_list->loadRowValues($pp_verify_list->Recordset); // Load row values
		}
		$pp_verify->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$pp_verify->RowAttrs = array_merge($pp_verify->RowAttrs, array('data-rowindex'=>$pp_verify_list->RowCnt, 'id'=>'r' . $pp_verify_list->RowCnt . '_pp_verify', 'data-rowtype'=>$pp_verify->RowType));

		// Render row
		$pp_verify_list->renderRow();

		// Render list options
		$pp_verify_list->renderListOptions();
?>
	<tr<?php echo $pp_verify->rowAttributes() ?>>
<?php

// Render list options (body, left)
$pp_verify_list->ListOptions->render("body", "left", $pp_verify_list->RowCnt);
?>
	<?php if ($pp_verify->id->Visible) { // id ?>
		<td data-name="id"<?php echo $pp_verify->id->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_id" class="pp_verify_id">
<span<?php echo $pp_verify->id->viewAttributes() ?>>
<?php echo $pp_verify->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->pid->Visible) { // pid ?>
		<td data-name="pid"<?php echo $pp_verify->pid->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_pid" class="pp_verify_pid">
<span<?php echo $pp_verify->pid->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->pid->getViewValue())) && $pp_verify->pid->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->pid->linkAttributes() ?>><?php echo $pp_verify->pid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->pid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->location->Visible) { // location ?>
		<td data-name="location"<?php echo $pp_verify->location->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_location" class="pp_verify_location">
<span<?php echo $pp_verify->location->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->location->getViewValue())) && $pp_verify->location->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->location->linkAttributes() ?>><?php echo $pp_verify->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $pp_verify->product_type->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_product_type" class="pp_verify_product_type">
<span<?php echo $pp_verify->product_type->viewAttributes() ?>>
<?php echo $pp_verify->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $pp_verify->shape->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_shape" class="pp_verify_shape">
<span<?php echo $pp_verify->shape->viewAttributes() ?>>
<?php echo $pp_verify->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->plan_type->Visible) { // plan_type ?>
		<td data-name="plan_type"<?php echo $pp_verify->plan_type->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_plan_type" class="pp_verify_plan_type">
<span<?php echo $pp_verify->plan_type->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->plan_type->getViewValue())) && $pp_verify->plan_type->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->plan_type->linkAttributes() ?>><?php echo $pp_verify->plan_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->plan_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $pp_verify->design_id->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_design_id" class="pp_verify_design_id">
<span<?php echo $pp_verify->design_id->viewAttributes() ?>>
<?php echo $pp_verify->design_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->process->Visible) { // process ?>
		<td data-name="process"<?php echo $pp_verify->process->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_process" class="pp_verify_process">
<span<?php echo $pp_verify->process->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->process->getViewValue())) && $pp_verify->process->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->process->linkAttributes() ?>><?php echo $pp_verify->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->yes_no->Visible) { // yes_no ?>
		<td data-name="yes_no"<?php echo $pp_verify->yes_no->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_yes_no" class="pp_verify_yes_no">
<span<?php echo $pp_verify->yes_no->viewAttributes() ?>>
<?php echo $pp_verify->yes_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->fix->Visible) { // fix ?>
		<td data-name="fix"<?php echo $pp_verify->fix->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_fix" class="pp_verify_fix">
<span<?php echo $pp_verify->fix->viewAttributes() ?>>
<?php echo $pp_verify->fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $pp_verify->unit->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_unit" class="pp_verify_unit">
<span<?php echo $pp_verify->unit->viewAttributes() ?>>
<?php echo $pp_verify->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->_40unit->Visible) { // @unit ?>
		<td data-name="_40unit"<?php echo $pp_verify->_40unit->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify__40unit" class="pp_verify__40unit">
<span<?php echo $pp_verify->_40unit->viewAttributes() ?>>
<?php echo $pp_verify->_40unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $pp_verify->_40->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify__40" class="pp_verify__40">
<span<?php echo $pp_verify->_40->viewAttributes() ?>>
<?php echo $pp_verify->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->extra_plan->Visible) { // extra_plan ?>
		<td data-name="extra_plan"<?php echo $pp_verify->extra_plan->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_extra_plan" class="pp_verify_extra_plan">
<span<?php echo $pp_verify->extra_plan->viewAttributes() ?>>
<?php echo $pp_verify->extra_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->custom_size->Visible) { // custom_size ?>
		<td data-name="custom_size"<?php echo $pp_verify->custom_size->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_custom_size" class="pp_verify_custom_size">
<span<?php echo $pp_verify->custom_size->viewAttributes() ?>>
<?php echo $pp_verify->custom_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->custom_size_below_st->Visible) { // custom_size_below_st ?>
		<td data-name="custom_size_below_st"<?php echo $pp_verify->custom_size_below_st->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_custom_size_below_st" class="pp_verify_custom_size_below_st">
<span<?php echo $pp_verify->custom_size_below_st->viewAttributes() ?>>
<?php echo $pp_verify->custom_size_below_st->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->method->Visible) { // method ?>
		<td data-name="method"<?php echo $pp_verify->method->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_method" class="pp_verify_method">
<span<?php echo $pp_verify->method->viewAttributes() ?>>
<?php echo $pp_verify->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pp_verify->category->Visible) { // category ?>
		<td data-name="category"<?php echo $pp_verify->category->cellAttributes() ?>>
<span id="el<?php echo $pp_verify_list->RowCnt ?>_pp_verify_category" class="pp_verify_category">
<span<?php echo $pp_verify->category->viewAttributes() ?>>
<?php echo $pp_verify->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$pp_verify_list->ListOptions->render("body", "right", $pp_verify_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$pp_verify->isGridAdd())
		$pp_verify_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$pp_verify->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($pp_verify_list->Recordset)
	$pp_verify_list->Recordset->Close();
?>
<?php if (!$pp_verify->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$pp_verify->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($pp_verify_list->Pager)) $pp_verify_list->Pager = new PrevNextPager($pp_verify_list->StartRec, $pp_verify_list->DisplayRecs, $pp_verify_list->TotalRecs, $pp_verify_list->AutoHidePager) ?>
<?php if ($pp_verify_list->Pager->RecordCount > 0 && $pp_verify_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($pp_verify_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($pp_verify_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $pp_verify_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($pp_verify_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($pp_verify_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $pp_verify_list->pageUrl() ?>start=<?php echo $pp_verify_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pp_verify_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($pp_verify_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $pp_verify_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $pp_verify_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $pp_verify_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($pp_verify_list->TotalRecs > 0 && (!$pp_verify_list->AutoHidePageSizeSelector || $pp_verify_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="pp_verify">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($pp_verify_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($pp_verify_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($pp_verify_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($pp_verify_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($pp_verify_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($pp_verify->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pp_verify_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($pp_verify_list->TotalRecs == 0 && !$pp_verify->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $pp_verify_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$pp_verify_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$pp_verify->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$pp_verify->isExport()) { ?>
<script>
ew.scrollableTable("gmp_pp_verify", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$pp_verify_list->terminate();
?>