<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pp_verify_view = new pp_verify_view();

// Run the page
$pp_verify_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pp_verify_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$pp_verify->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpp_verifyview = currentForm = new ew.Form("fpp_verifyview", "view");

// Form_CustomValidate event
fpp_verifyview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpp_verifyview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpp_verifyview.lists["x_location"] = <?php echo $pp_verify_view->location->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_location"].options = <?php echo JsonEncode($pp_verify_view->location->lookupOptions()) ?>;
fpp_verifyview.lists["x_product_type[]"] = <?php echo $pp_verify_view->product_type->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_product_type[]"].options = <?php echo JsonEncode($pp_verify_view->product_type->lookupOptions()) ?>;
fpp_verifyview.lists["x_shape[]"] = <?php echo $pp_verify_view->shape->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_shape[]"].options = <?php echo JsonEncode($pp_verify_view->shape->lookupOptions()) ?>;
fpp_verifyview.lists["x_plan_type"] = <?php echo $pp_verify_view->plan_type->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_plan_type"].options = <?php echo JsonEncode($pp_verify_view->plan_type->options(FALSE, TRUE)) ?>;
fpp_verifyview.lists["x_design_id"] = <?php echo $pp_verify_view->design_id->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_design_id"].options = <?php echo JsonEncode($pp_verify_view->design_id->lookupOptions()) ?>;
fpp_verifyview.autoSuggests["x_design_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verifyview.lists["x_process"] = <?php echo $pp_verify_view->process->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_process"].options = <?php echo JsonEncode($pp_verify_view->process->lookupOptions()) ?>;
fpp_verifyview.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpp_verifyview.lists["x_yes_no"] = <?php echo $pp_verify_view->yes_no->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_yes_no"].options = <?php echo JsonEncode($pp_verify_view->yes_no->options(FALSE, TRUE)) ?>;
fpp_verifyview.lists["x_fix"] = <?php echo $pp_verify_view->fix->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_fix"].options = <?php echo JsonEncode($pp_verify_view->fix->options(FALSE, TRUE)) ?>;
fpp_verifyview.lists["x_unit"] = <?php echo $pp_verify_view->unit->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_unit"].options = <?php echo JsonEncode($pp_verify_view->unit->options(FALSE, TRUE)) ?>;
fpp_verifyview.lists["x_extra_plan"] = <?php echo $pp_verify_view->extra_plan->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_extra_plan"].options = <?php echo JsonEncode($pp_verify_view->extra_plan->options(FALSE, TRUE)) ?>;
fpp_verifyview.lists["x_method"] = <?php echo $pp_verify_view->method->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_method"].options = <?php echo JsonEncode($pp_verify_view->method->lookupOptions()) ?>;
fpp_verifyview.lists["x_category"] = <?php echo $pp_verify_view->category->Lookup->toClientList() ?>;
fpp_verifyview.lists["x_category"].options = <?php echo JsonEncode($pp_verify_view->category->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$pp_verify->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $pp_verify_view->ExportOptions->render("body") ?>
<?php $pp_verify_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $pp_verify_view->showPageHeader(); ?>
<?php
$pp_verify_view->showMessage();
?>
<form name="fpp_verifyview" id="fpp_verifyview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($pp_verify_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $pp_verify_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pp_verify">
<input type="hidden" name="modal" value="<?php echo (int)$pp_verify_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($pp_verify->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_id"><?php echo $pp_verify->id->caption() ?></span></td>
		<td data-name="id"<?php echo $pp_verify->id->cellAttributes() ?>>
<span id="el_pp_verify_id">
<span<?php echo $pp_verify->id->viewAttributes() ?>>
<?php echo $pp_verify->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->pid->Visible) { // pid ?>
	<tr id="r_pid">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_pid"><?php echo $pp_verify->pid->caption() ?></span></td>
		<td data-name="pid"<?php echo $pp_verify->pid->cellAttributes() ?>>
<span id="el_pp_verify_pid">
<span<?php echo $pp_verify->pid->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->pid->getViewValue())) && $pp_verify->pid->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->pid->linkAttributes() ?>><?php echo $pp_verify->pid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->pid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_location"><?php echo $pp_verify->location->caption() ?></span></td>
		<td data-name="location"<?php echo $pp_verify->location->cellAttributes() ?>>
<span id="el_pp_verify_location">
<span<?php echo $pp_verify->location->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->location->getViewValue())) && $pp_verify->location->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->location->linkAttributes() ?>><?php echo $pp_verify->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_product_type"><?php echo $pp_verify->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $pp_verify->product_type->cellAttributes() ?>>
<span id="el_pp_verify_product_type">
<span<?php echo $pp_verify->product_type->viewAttributes() ?>>
<?php echo $pp_verify->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_shape"><?php echo $pp_verify->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $pp_verify->shape->cellAttributes() ?>>
<span id="el_pp_verify_shape">
<span<?php echo $pp_verify->shape->viewAttributes() ?>>
<?php echo $pp_verify->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->plan_type->Visible) { // plan_type ?>
	<tr id="r_plan_type">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_plan_type"><?php echo $pp_verify->plan_type->caption() ?></span></td>
		<td data-name="plan_type"<?php echo $pp_verify->plan_type->cellAttributes() ?>>
<span id="el_pp_verify_plan_type">
<span<?php echo $pp_verify->plan_type->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->plan_type->getViewValue())) && $pp_verify->plan_type->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->plan_type->linkAttributes() ?>><?php echo $pp_verify->plan_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->plan_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_design_id"><?php echo $pp_verify->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $pp_verify->design_id->cellAttributes() ?>>
<span id="el_pp_verify_design_id">
<span<?php echo $pp_verify->design_id->viewAttributes() ?>>
<?php echo $pp_verify->design_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_process"><?php echo $pp_verify->process->caption() ?></span></td>
		<td data-name="process"<?php echo $pp_verify->process->cellAttributes() ?>>
<span id="el_pp_verify_process">
<span<?php echo $pp_verify->process->viewAttributes() ?>>
<?php if ((!EmptyString($pp_verify->process->getViewValue())) && $pp_verify->process->linkAttributes() <> "") { ?>
<a<?php echo $pp_verify->process->linkAttributes() ?>><?php echo $pp_verify->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $pp_verify->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->yes_no->Visible) { // yes_no ?>
	<tr id="r_yes_no">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_yes_no"><?php echo $pp_verify->yes_no->caption() ?></span></td>
		<td data-name="yes_no"<?php echo $pp_verify->yes_no->cellAttributes() ?>>
<span id="el_pp_verify_yes_no">
<span<?php echo $pp_verify->yes_no->viewAttributes() ?>>
<?php echo $pp_verify->yes_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->fix->Visible) { // fix ?>
	<tr id="r_fix">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_fix"><?php echo $pp_verify->fix->caption() ?></span></td>
		<td data-name="fix"<?php echo $pp_verify->fix->cellAttributes() ?>>
<span id="el_pp_verify_fix">
<span<?php echo $pp_verify->fix->viewAttributes() ?>>
<?php echo $pp_verify->fix->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->unit->Visible) { // unit ?>
	<tr id="r_unit">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_unit"><?php echo $pp_verify->unit->caption() ?></span></td>
		<td data-name="unit"<?php echo $pp_verify->unit->cellAttributes() ?>>
<span id="el_pp_verify_unit">
<span<?php echo $pp_verify->unit->viewAttributes() ?>>
<?php echo $pp_verify->unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->_40unit->Visible) { // @unit ?>
	<tr id="r__40unit">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify__40unit"><?php echo $pp_verify->_40unit->caption() ?></span></td>
		<td data-name="_40unit"<?php echo $pp_verify->_40unit->cellAttributes() ?>>
<span id="el_pp_verify__40unit">
<span<?php echo $pp_verify->_40unit->viewAttributes() ?>>
<?php echo $pp_verify->_40unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->_40->Visible) { // @ ?>
	<tr id="r__40">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify__40"><?php echo $pp_verify->_40->caption() ?></span></td>
		<td data-name="_40"<?php echo $pp_verify->_40->cellAttributes() ?>>
<span id="el_pp_verify__40">
<span<?php echo $pp_verify->_40->viewAttributes() ?>>
<?php echo $pp_verify->_40->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->extra_plan->Visible) { // extra_plan ?>
	<tr id="r_extra_plan">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_extra_plan"><?php echo $pp_verify->extra_plan->caption() ?></span></td>
		<td data-name="extra_plan"<?php echo $pp_verify->extra_plan->cellAttributes() ?>>
<span id="el_pp_verify_extra_plan">
<span<?php echo $pp_verify->extra_plan->viewAttributes() ?>>
<?php echo $pp_verify->extra_plan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->custom_size->Visible) { // custom_size ?>
	<tr id="r_custom_size">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_custom_size"><?php echo $pp_verify->custom_size->caption() ?></span></td>
		<td data-name="custom_size"<?php echo $pp_verify->custom_size->cellAttributes() ?>>
<span id="el_pp_verify_custom_size">
<span<?php echo $pp_verify->custom_size->viewAttributes() ?>>
<?php echo $pp_verify->custom_size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<tr id="r_custom_size_below_st">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_custom_size_below_st"><?php echo $pp_verify->custom_size_below_st->caption() ?></span></td>
		<td data-name="custom_size_below_st"<?php echo $pp_verify->custom_size_below_st->cellAttributes() ?>>
<span id="el_pp_verify_custom_size_below_st">
<span<?php echo $pp_verify->custom_size_below_st->viewAttributes() ?>>
<?php echo $pp_verify->custom_size_below_st->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->method->Visible) { // method ?>
	<tr id="r_method">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_method"><?php echo $pp_verify->method->caption() ?></span></td>
		<td data-name="method"<?php echo $pp_verify->method->cellAttributes() ?>>
<span id="el_pp_verify_method">
<span<?php echo $pp_verify->method->viewAttributes() ?>>
<?php echo $pp_verify->method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pp_verify->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $pp_verify_view->TableLeftColumnClass ?>"><span id="elh_pp_verify_category"><?php echo $pp_verify->category->caption() ?></span></td>
		<td data-name="category"<?php echo $pp_verify->category->cellAttributes() ?>>
<span id="el_pp_verify_category">
<span<?php echo $pp_verify->category->viewAttributes() ?>>
<?php echo $pp_verify->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$pp_verify_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$pp_verify->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$pp_verify_view->terminate();
?>