<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 
?>
<?php include_once "autoload.php" ?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$print_ted_c = new print_ted_c();

// Run the page
$print_ted_c->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();
?>
<?php include_once "header.php" ?>
<?php
$BatchNo = $_GET['batch_no'];

$PI =ExecuteRow("SELECT  `logo`, `name`, `address`, `email`, `mobile`, `gst`, `other` FROM `portal_info` limit 1");
$PIlogo = $PI['logo'];
$PIname = $PI['name'];
$PIaddress = $PI['address'];
$PIemail = $PI['email'];
$PImobile = $PI['mobile'];
$PIgST = $PI['gst'];
$PIother = $PI['other'];

$sql = "SELECT batch_no_c.id AS id, ref_c.`product_code` as `product_code`, product.`product` ,
  c_01_c.`name` as version , c_02_c.`name` as color,  c_03_c.`name` as construction,
  c_04_c.`name` as composition,   c_05_c.`name` as grade, batch_no_c.`batch_no`,    batch_no_c.`description`, batch_no_c.`remarks`,  admin_office.`user_name` as a_operator, batch_no_c.`a_datetime`
FROM batch_no_c 
RIGHT JOIN `ref_c` ON `ref_c`.`id` = `batch_no_c`.`rid`
LEFT JOIN c_01_c ON `c_01_c`.`id` = `ref_c`.`country`
LEFT JOIN c_02_c ON `c_02_c`.`id` = `ref_c`.`supplier`
LEFT JOIN c_03_c ON `c_03_c`.`id` = `ref_c`.`wool_type`
LEFT JOIN c_04_c ON `c_04_c`.`id` = `ref_c`.`quality`
LEFT JOIN c_05_c ON `c_05_c`.`id` = `ref_c`.`grade`
LEFT JOIN admin_office on admin_office.id = batch_no_c.a_operator
LEFT JOIN product ON `product`.`id` = `ref_c`.`product` where batch_no_c.id = $BatchNo";

$items = ExecuteRow($sql);
if (($items['a_datetime'] == '0000-00-00 00:00:00'))
{
	$auth_datetime = 'Not Authorised Yet';
} else {  
   $auth_datetime = date("d-M-Y", strtotime($items['a_datetime']));
}
$bom = "SELECT (`bom_c`.`material_name`) as Material_Name, if(warp_weft= 1, 'Warp', 'Weft') as `Warp-Weft`,  (`r`.`product_code`) as
 Material_Code, if(gross_nett= 1, 'Gross', if(gross_nett= 2, 'Nett', '--NA--')) as `Gross/Nett`, (bom_c.`quantity`) as Quantity,
 (bom_c.`quantity` - round((bom_c.`quantity` / (((100+bom_c.`bom_waste`)/100))),2)) as `Wastage`,
 
 (`method`.`item`) as Method,
 (`unit`.item) as Unit, admin_office.user_name as Operator_ID FROM `batch_no_c` LEFT JOIN bom_c on
 `bom_c`.`batch_no` = `batch_no_c`.`id` left join `misc` `unit` on unit.id = bom_c.unit left join `misc` `method` on method.id = bom_c.method left join `ref` `r` on `r`.`id`=`bom_c`.`material_id` 
  LEFT JOIN admin_office on admin_office.id = bom_c.operator
WHERE `batch_no_c`.`id` = $BatchNo
 union ALL
 SELECT 'Total' as Material_Name, '' as `Warp-Weft`,  '' as
 Material_Code, '' as `Gross/Nett`, sum(bom_c.`quantity`) as Quantity, '' as `Wastage`, '' as Method,
 '' as Unit, '' as Operator_ID FROM `batch_no_c` LEFT JOIN bom_c on
 `bom_c`.`batch_no` = `batch_no_c`.`id` left join `misc` `unit` on unit.id = bom_c.unit left join `misc` `method` on method.id = bom_c.method left join `ref` `r` on `r`.`id`=`bom_c`.`material_id`
 WHERE `batch_no_c`.`id` = $BatchNo";

$BomMaterialID = ExecuteRow("SELECT group_concat(`bom_c`.`material_id`) as Material_ID FROM `batch_no_c` LEFT JOIN bom_c on `bom_c`.`batch_no` = `batch_no_c`.`id` left join `misc` `unit` on unit.id = bom_c.unit left join `misc` `method` on method.id = bom_c.method  WHERE `batch_no_c`.`id` = $BatchNo");
$Material_ID_Payment  = $BomMaterialID['Material_ID'];

$MaterialPayment = "SELECT ptc.name,  `ref_f_fp`.`product_code`, `@`, if (`process_method`= 11, 'Machine Process', 'Manual Process') as `Process Method`, pti.packing as INPUT, pto.packing as OUTPUT FROM `payment_plan` p left join ref_f_fp on ref_f_fp.id = p.ref_f_fp left join `process_type_c` on `process_type_c`.`id` = `p`.`process` left join packing_type pti on pti.id = input_type left join packing_type pto on pto.id = output_type 
left join process_type_c ptc on ptc.id = p.process WHERE  FIND_IN_SET(p.`ref_f_fp`, '$Material_ID_Payment')";
//echo $MaterialPayment;
$MaterialPaymentHTML = ExecuteHTML($MaterialPayment);

$it=ExecuteRow($bom);

$tech = ExecuteHTML("SELECT (production_process_c.`sequence`) as Sequence, process_type_c.`name` as Process,  production_process_c.`material_name` as Material_Name, quantity as Quantity, if((`m_power`> 0), concat(`m_power`, ' rolls'), ' ') as `Rools IN`,  if((production_process_c.`out_gsm` > 0), concat(`out_gsm`, ' rolls'), ' ') as `OUT GSM`, 
 (production_process_c.`remarks`) as Remark, admin_office.user_name as Operator_ID FROM `batch_no_c` LEFT JOIN production_process_c on `production_process_c`.`batch_no` = `batch_no_c`.`id` left join `process_type_c` on `process_type_c`.`id` = production_process_c.`process`
   LEFT JOIN admin_office on admin_office.id = production_process_c.operator

WHERE `batch_no_c`.`id` = $BatchNo ORDER BY production_process_c.`sequence`, production_process_c.id");

$payment = "SELECT p.`gcode` as GCode,  p.`description` as Description, `process_type_c`.`name` AS Name, IF (p.`yes_no` = 1, 'Yes', 'No') as `Yes/No`, if(p.`fix` =0, 'Fix', 'Calculation') as Type, if (p.`extra_plan` = 0, 'No Extra Payment', if (p.`extra_plan` = 1, '200+50+50..../10+10+10....', if (p.`extra_plan` = 2, '200+50+50..../20+10+10',if (p.`extra_plan` = 3, 'Extra Payment Other','')))) as `Extra Weaving Plan`, p.`@`, 
if (p.`method` = 1, 'Square Meter', if (p.`method` = 2, '2 Side Running Meter', if (p.`method` = 3, '4 Side Running Meter', if (p.`method` = 4, 'Per KG', '')))) as Method, if (p.`status` = 0, 'Freezed', 'Active') as `Status` FROM `payment_plan` p left join `process_type_c` on `process_type_c`.`id` = `p`.`process`  left join `batch_no` on batch_no.id = $BatchNo left join ref on ref.id = batch_no.rid where ref.gcode = p.gcode";

$paymenthtml = ExecuteHTML($payment);
?>

<table width="100%" border="1" cellspacing="0" cellpadding="3
">
  <tr>
	<td colspan="3"><h4><?php echo $PIname ?></h4></td>
	<td colspan="2"><h6>Product Technical Description</h6></td>
  </tr>
  <tr>
	<td colspan="3"><h5>Product Code : <?php echo $items['product_code'];?>&nbsp;</h5></td>
	<td colspan="2"><h5>Product : <?php echo $items['product'];?>&nbsp;</h5></td>
  </tr>
  <tr>
	<td width="200">Version : <?php echo $items['version'];?></td>
	<td width="200">Color : <?php echo $items['color'];?></td>
	<td colspan="3">Composition : <?php echo $items['composition'];?></td>
  </tr>
  <td>Construction: <?php echo $items['construction'];?></td>
	<td>&nbsp;</td>
	<td width="200">&nbsp;</td>
	<td width="150">&nbsp;</td>
	<td width="150">&nbsp;</td>
  <tr>
	<td>Batch No ID: <?php echo $items['id'];?></td>
	<td>Batch No.: <?php echo $items['batch_no'];?></td>
	<td colspan="3">Batch No. Description: <?php echo $items['description'];?></td>
  </tr>
  <tr>
	<td colspan="5"><strong>Remarks : <?php echo $items['remarks'];?></strong></td>
	</tr>
  <tr>
	<td colspan="5"><h6><br>
	  Bill of Material <br>
	</h6>
	  <?php if(isset($bom))
		echo ExecuteHTML($bom); ?></td>
  </tr>
  <tr>
	<td colspan="5"><h6><br>
	  Technical Description<br>
	</h6>
	  <?php if(isset($tech))
	  echo $tech; ?></td>
  </tr>
   <tr>
	<td colspan="5"><h6><br>
	  Payment Description<br>
	</h6>
	  <?php if(isset($paymenthtml))
	  echo $paymenthtml; ?></td>
  </tr>
   <tr>
	<td colspan="5"><h6><br>
	  Material Payment Description<br>
	</h6>
	  <?php if(isset($MaterialPaymentHTML))
	  echo $MaterialPaymentHTML; ?></td>
  </tr>
  <tr>
  <td>&nbsp;</td>
	<td colspan="2">Authorized by  : <?php echo $items['a_operator'];?></td>
	<td colspan="2">Authorized Datetime : <?php echo $auth_datetime ;?></td>
	</tr>
</table>
<?php if (DEBUG_ENABLED) echo GetDebugMessage(); ?>
<?php include_once "footer.php" ?>
<?php
$print_ted_c->terminate();
?>