<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_f_list = new process_action_f_list();

// Run the page
$process_action_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_flist = currentForm = new ew.Form("fprocess_action_flist", "list");
fprocess_action_flist.formKeyCountName = '<?php echo $process_action_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fprocess_action_flistsrch = currentSearchForm = new ew.Form("fprocess_action_flistsrch");

// Filters
fprocess_action_flistsrch.filterList = <?php echo $process_action_f_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_f_list->TotalRecs > 0 && $process_action_f_list->ExportOptions->visible()) { ?>
<?php $process_action_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_f_list->ImportOptions->visible()) { ?>
<?php $process_action_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_f_list->SearchOptions->visible()) { ?>
<?php $process_action_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_f_list->FilterOptions->visible()) { ?>
<?php $process_action_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_f->isExport() && !$process_action_f->CurrentAction) { ?>
<form name="fprocess_action_flistsrch" id="fprocess_action_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_f">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_f_list->showPageHeader(); ?>
<?php
$process_action_f_list->showMessage();
?>
<?php if ($process_action_f_list->TotalRecs > 0 || $process_action_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_f">
<?php if (!$process_action_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_f_list->Pager)) $process_action_f_list->Pager = new PrevNextPager($process_action_f_list->StartRec, $process_action_f_list->DisplayRecs, $process_action_f_list->TotalRecs, $process_action_f_list->AutoHidePager) ?>
<?php if ($process_action_f_list->Pager->RecordCount > 0 && $process_action_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_f_list->TotalRecs > 0 && (!$process_action_f_list->AutoHidePageSizeSelector || $process_action_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_flist" id="fprocess_action_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_f">
<div id="gmp_process_action_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_f_list->TotalRecs > 0 || $process_action_f->isGridEdit()) { ?>
<table id="tbl_process_action_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_f_list->renderListOptions();

// Render list options (header, left)
$process_action_f_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_f->id->Visible) { // id ?>
	<?php if ($process_action_f->sortUrl($process_action_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_f->id->headerCellClass() ?>"><div id="elh_process_action_f_id" class="process_action_f_id"><div class="ew-table-header-caption"><?php echo $process_action_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->id) ?>',2);"><div id="elh_process_action_f_id" class="process_action_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->emp_name->Visible) { // emp_name ?>
	<?php if ($process_action_f->sortUrl($process_action_f->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $process_action_f->emp_name->headerCellClass() ?>"><div id="elh_process_action_f_emp_name" class="process_action_f_emp_name"><div class="ew-table-header-caption"><?php echo $process_action_f->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $process_action_f->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->emp_name) ?>',2);"><div id="elh_process_action_f_emp_name" class="process_action_f_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->emp_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->process->Visible) { // process ?>
	<?php if ($process_action_f->sortUrl($process_action_f->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_f->process->headerCellClass() ?>"><div id="elh_process_action_f_process" class="process_action_f_process"><div class="ew-table-header-caption"><?php echo $process_action_f->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_f->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->process) ?>',2);"><div id="elh_process_action_f_process" class="process_action_f_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->code->Visible) { // code ?>
	<?php if ($process_action_f->sortUrl($process_action_f->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_action_f->code->headerCellClass() ?>"><div id="elh_process_action_f_code" class="process_action_f_code"><div class="ew-table-header-caption"><?php echo $process_action_f->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_action_f->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->code) ?>',2);"><div id="elh_process_action_f_code" class="process_action_f_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->payment->Visible) { // payment ?>
	<?php if ($process_action_f->sortUrl($process_action_f->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_f->payment->headerCellClass() ?>"><div id="elh_process_action_f_payment" class="process_action_f_payment"><div class="ew-table-header-caption"><?php echo $process_action_f->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_f->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->payment) ?>',2);"><div id="elh_process_action_f_payment" class="process_action_f_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->material->Visible) { // material ?>
	<?php if ($process_action_f->sortUrl($process_action_f->material) == "") { ?>
		<th data-name="material" class="<?php echo $process_action_f->material->headerCellClass() ?>"><div id="elh_process_action_f_material" class="process_action_f_material"><div class="ew-table-header-caption"><?php echo $process_action_f->material->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material" class="<?php echo $process_action_f->material->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->material) ?>',2);"><div id="elh_process_action_f_material" class="process_action_f_material">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->material->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->material->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->material->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->packing->Visible) { // packing ?>
	<?php if ($process_action_f->sortUrl($process_action_f->packing) == "") { ?>
		<th data-name="packing" class="<?php echo $process_action_f->packing->headerCellClass() ?>"><div id="elh_process_action_f_packing" class="process_action_f_packing"><div class="ew-table-header-caption"><?php echo $process_action_f->packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing" class="<?php echo $process_action_f->packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->packing) ?>',2);"><div id="elh_process_action_f_packing" class="process_action_f_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->lot_no->Visible) { // lot_no ?>
	<?php if ($process_action_f->sortUrl($process_action_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $process_action_f->lot_no->headerCellClass() ?>"><div id="elh_process_action_f_lot_no" class="process_action_f_lot_no"><div class="ew-table-header-caption"><?php echo $process_action_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $process_action_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->lot_no) ?>',2);"><div id="elh_process_action_f_lot_no" class="process_action_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->i_quantity->Visible) { // i_quantity ?>
	<?php if ($process_action_f->sortUrl($process_action_f->i_quantity) == "") { ?>
		<th data-name="i_quantity" class="<?php echo $process_action_f->i_quantity->headerCellClass() ?>"><div id="elh_process_action_f_i_quantity" class="process_action_f_i_quantity"><div class="ew-table-header-caption"><?php echo $process_action_f->i_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="i_quantity" class="<?php echo $process_action_f->i_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->i_quantity) ?>',2);"><div id="elh_process_action_f_i_quantity" class="process_action_f_i_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->i_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->i_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->i_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->sub_process->Visible) { // sub_process ?>
	<?php if ($process_action_f->sortUrl($process_action_f->sub_process) == "") { ?>
		<th data-name="sub_process" class="<?php echo $process_action_f->sub_process->headerCellClass() ?>"><div id="elh_process_action_f_sub_process" class="process_action_f_sub_process"><div class="ew-table-header-caption"><?php echo $process_action_f->sub_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_process" class="<?php echo $process_action_f->sub_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->sub_process) ?>',2);"><div id="elh_process_action_f_sub_process" class="process_action_f_sub_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->sub_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->sub_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->sub_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->process_method->Visible) { // process_method ?>
	<?php if ($process_action_f->sortUrl($process_action_f->process_method) == "") { ?>
		<th data-name="process_method" class="<?php echo $process_action_f->process_method->headerCellClass() ?>"><div id="elh_process_action_f_process_method" class="process_action_f_process_method"><div class="ew-table-header-caption"><?php echo $process_action_f->process_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_method" class="<?php echo $process_action_f->process_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->process_method) ?>',2);"><div id="elh_process_action_f_process_method" class="process_action_f_process_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->process_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->process_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->process_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->remark->Visible) { // remark ?>
	<?php if ($process_action_f->sortUrl($process_action_f->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $process_action_f->remark->headerCellClass() ?>"><div id="elh_process_action_f_remark" class="process_action_f_remark"><div class="ew-table-header-caption"><?php echo $process_action_f->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $process_action_f->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->remark) ?>',2);"><div id="elh_process_action_f_remark" class="process_action_f_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->opeartor->Visible) { // opeartor ?>
	<?php if ($process_action_f->sortUrl($process_action_f->opeartor) == "") { ?>
		<th data-name="opeartor" class="<?php echo $process_action_f->opeartor->headerCellClass() ?>"><div id="elh_process_action_f_opeartor" class="process_action_f_opeartor"><div class="ew-table-header-caption"><?php echo $process_action_f->opeartor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="opeartor" class="<?php echo $process_action_f->opeartor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->opeartor) ?>',2);"><div id="elh_process_action_f_opeartor" class="process_action_f_opeartor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->opeartor->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->opeartor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->opeartor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->datetime->Visible) { // datetime ?>
	<?php if ($process_action_f->sortUrl($process_action_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_f->datetime->headerCellClass() ?>"><div id="elh_process_action_f_datetime" class="process_action_f_datetime"><div class="ew-table-header-caption"><?php echo $process_action_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->datetime) ?>',2);"><div id="elh_process_action_f_datetime" class="process_action_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_f->grp->Visible) { // grp ?>
	<?php if ($process_action_f->sortUrl($process_action_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_action_f->grp->headerCellClass() ?>"><div id="elh_process_action_f_grp" class="process_action_f_grp"><div class="ew-table-header-caption"><?php echo $process_action_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_action_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_f->SortUrl($process_action_f->grp) ?>',2);"><div id="elh_process_action_f_grp" class="process_action_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_f->ExportAll && $process_action_f->isExport()) {
	$process_action_f_list->StopRec = $process_action_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_f_list->TotalRecs > $process_action_f_list->StartRec + $process_action_f_list->DisplayRecs - 1)
		$process_action_f_list->StopRec = $process_action_f_list->StartRec + $process_action_f_list->DisplayRecs - 1;
	else
		$process_action_f_list->StopRec = $process_action_f_list->TotalRecs;
}
$process_action_f_list->RecCnt = $process_action_f_list->StartRec - 1;
if ($process_action_f_list->Recordset && !$process_action_f_list->Recordset->EOF) {
	$process_action_f_list->Recordset->moveFirst();
	$selectLimit = $process_action_f_list->UseSelectLimit;
	if (!$selectLimit && $process_action_f_list->StartRec > 1)
		$process_action_f_list->Recordset->move($process_action_f_list->StartRec - 1);
} elseif (!$process_action_f->AllowAddDeleteRow && $process_action_f_list->StopRec == 0) {
	$process_action_f_list->StopRec = $process_action_f->GridAddRowCount;
}

// Initialize aggregate
$process_action_f->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_f->resetAttributes();
$process_action_f_list->renderRow();
while ($process_action_f_list->RecCnt < $process_action_f_list->StopRec) {
	$process_action_f_list->RecCnt++;
	if ($process_action_f_list->RecCnt >= $process_action_f_list->StartRec) {
		$process_action_f_list->RowCnt++;

		// Set up key count
		$process_action_f_list->KeyCount = $process_action_f_list->RowIndex;

		// Init row class and style
		$process_action_f->resetAttributes();
		$process_action_f->CssClass = "";
		if ($process_action_f->isGridAdd()) {
		} else {
			$process_action_f_list->loadRowValues($process_action_f_list->Recordset); // Load row values
		}
		$process_action_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_f->RowAttrs = array_merge($process_action_f->RowAttrs, array('data-rowindex'=>$process_action_f_list->RowCnt, 'id'=>'r' . $process_action_f_list->RowCnt . '_process_action_f', 'data-rowtype'=>$process_action_f->RowType));

		// Render row
		$process_action_f_list->renderRow();

		// Render list options
		$process_action_f_list->renderListOptions();
?>
	<tr<?php echo $process_action_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_f_list->ListOptions->render("body", "left", $process_action_f_list->RowCnt);
?>
	<?php if ($process_action_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_f->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_id" class="process_action_f_id">
<span<?php echo $process_action_f->id->viewAttributes() ?>>
<?php echo $process_action_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $process_action_f->emp_name->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_emp_name" class="process_action_f_emp_name">
<span<?php echo $process_action_f->emp_name->viewAttributes() ?>>
<?php echo $process_action_f->emp_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_f->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_process" class="process_action_f_process">
<span<?php echo $process_action_f->process->viewAttributes() ?>>
<?php echo $process_action_f->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_action_f->code->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_code" class="process_action_f_code">
<span<?php echo $process_action_f->code->viewAttributes() ?>>
<?php echo $process_action_f->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_f->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_payment" class="process_action_f_payment">
<span<?php echo $process_action_f->payment->viewAttributes() ?>>
<?php echo $process_action_f->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->material->Visible) { // material ?>
		<td data-name="material"<?php echo $process_action_f->material->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_material" class="process_action_f_material">
<span<?php echo $process_action_f->material->viewAttributes() ?>>
<?php echo $process_action_f->material->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->packing->Visible) { // packing ?>
		<td data-name="packing"<?php echo $process_action_f->packing->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_packing" class="process_action_f_packing">
<span<?php echo $process_action_f->packing->viewAttributes() ?>>
<?php echo $process_action_f->packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $process_action_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_lot_no" class="process_action_f_lot_no">
<span<?php echo $process_action_f->lot_no->viewAttributes() ?>>
<?php echo $process_action_f->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->i_quantity->Visible) { // i_quantity ?>
		<td data-name="i_quantity"<?php echo $process_action_f->i_quantity->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_i_quantity" class="process_action_f_i_quantity">
<span<?php echo $process_action_f->i_quantity->viewAttributes() ?>>
<?php echo $process_action_f->i_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->sub_process->Visible) { // sub_process ?>
		<td data-name="sub_process"<?php echo $process_action_f->sub_process->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_sub_process" class="process_action_f_sub_process">
<span<?php echo $process_action_f->sub_process->viewAttributes() ?>>
<?php echo $process_action_f->sub_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->process_method->Visible) { // process_method ?>
		<td data-name="process_method"<?php echo $process_action_f->process_method->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_process_method" class="process_action_f_process_method">
<span<?php echo $process_action_f->process_method->viewAttributes() ?>>
<?php echo $process_action_f->process_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $process_action_f->remark->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_remark" class="process_action_f_remark">
<span<?php echo $process_action_f->remark->viewAttributes() ?>>
<?php echo $process_action_f->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->opeartor->Visible) { // opeartor ?>
		<td data-name="opeartor"<?php echo $process_action_f->opeartor->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_opeartor" class="process_action_f_opeartor">
<span<?php echo $process_action_f->opeartor->viewAttributes() ?>>
<?php echo $process_action_f->opeartor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_datetime" class="process_action_f_datetime">
<span<?php echo $process_action_f->datetime->viewAttributes() ?>>
<?php echo $process_action_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_action_f->grp->cellAttributes() ?>>
<span id="el<?php echo $process_action_f_list->RowCnt ?>_process_action_f_grp" class="process_action_f_grp">
<span<?php echo $process_action_f->grp->viewAttributes() ?>>
<?php echo $process_action_f->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_f_list->ListOptions->render("body", "right", $process_action_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_f->isGridAdd())
		$process_action_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_f_list->Recordset)
	$process_action_f_list->Recordset->Close();
?>
<?php if (!$process_action_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_f_list->Pager)) $process_action_f_list->Pager = new PrevNextPager($process_action_f_list->StartRec, $process_action_f_list->DisplayRecs, $process_action_f_list->TotalRecs, $process_action_f_list->AutoHidePager) ?>
<?php if ($process_action_f_list->Pager->RecordCount > 0 && $process_action_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_f_list->pageUrl() ?>start=<?php echo $process_action_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_f_list->TotalRecs > 0 && (!$process_action_f_list->AutoHidePageSizeSelector || $process_action_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_f_list->TotalRecs == 0 && !$process_action_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_f_list->terminate();
?>