<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_material_payment_list = new process_action_material_payment_list();

// Run the page
$process_action_material_payment_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_material_payment_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_material_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_material_paymentlist = currentForm = new ew.Form("fprocess_action_material_paymentlist", "list");
fprocess_action_material_paymentlist.formKeyCountName = '<?php echo $process_action_material_payment_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_material_paymentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_material_paymentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_material_paymentlist.lists["x_location"] = <?php echo $process_action_material_payment_list->location->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_location"].options = <?php echo JsonEncode($process_action_material_payment_list->location->lookupOptions()) ?>;
fprocess_action_material_paymentlist.lists["x_process"] = <?php echo $process_action_material_payment_list->process->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_process"].options = <?php echo JsonEncode($process_action_material_payment_list->process->lookupOptions()) ?>;
fprocess_action_material_paymentlist.lists["x_emp_id"] = <?php echo $process_action_material_payment_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_material_payment_list->emp_id->lookupOptions()) ?>;
fprocess_action_material_paymentlist.autoSuggests["x_emp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_material_paymentlist.lists["x_rid"] = <?php echo $process_action_material_payment_list->rid->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_payment_list->rid->lookupOptions()) ?>;
fprocess_action_material_paymentlist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_material_paymentlist.lists["x_process_from"] = <?php echo $process_action_material_payment_list->process_from->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_process_from"].options = <?php echo JsonEncode($process_action_material_payment_list->process_from->lookupOptions()) ?>;
fprocess_action_material_paymentlist.lists["x_process_to"] = <?php echo $process_action_material_payment_list->process_to->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_process_to"].options = <?php echo JsonEncode($process_action_material_payment_list->process_to->lookupOptions()) ?>;
fprocess_action_material_paymentlist.lists["x_process_method"] = <?php echo $process_action_material_payment_list->process_method->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_process_method"].options = <?php echo JsonEncode($process_action_material_payment_list->process_method->options(FALSE, TRUE)) ?>;
fprocess_action_material_paymentlist.lists["x_rid_new"] = <?php echo $process_action_material_payment_list->rid_new->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_rid_new"].options = <?php echo JsonEncode($process_action_material_payment_list->rid_new->lookupOptions()) ?>;
fprocess_action_material_paymentlist.lists["x_payment[]"] = <?php echo $process_action_material_payment_list->payment->Lookup->toClientList() ?>;
fprocess_action_material_paymentlist.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_material_payment_list->payment->lookupOptions()) ?>;

// Form object for search
var fprocess_action_material_paymentlistsrch = currentSearchForm = new ew.Form("fprocess_action_material_paymentlistsrch");

// Validate function for search
fprocess_action_material_paymentlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_material_paymentlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_material_paymentlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_material_paymentlistsrch.lists["x_location"] = <?php echo $process_action_material_payment_list->location->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_location"].options = <?php echo JsonEncode($process_action_material_payment_list->location->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.lists["x_process"] = <?php echo $process_action_material_payment_list->process->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_material_payment_list->process->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.lists["x_emp_id"] = <?php echo $process_action_material_payment_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_material_payment_list->emp_id->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.autoSuggests["x_emp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_material_paymentlistsrch.lists["x_rid"] = <?php echo $process_action_material_payment_list->rid->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_payment_list->rid->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_material_paymentlistsrch.lists["x_process_from"] = <?php echo $process_action_material_payment_list->process_from->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_process_from"].options = <?php echo JsonEncode($process_action_material_payment_list->process_from->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.lists["x_process_to"] = <?php echo $process_action_material_payment_list->process_to->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_process_to"].options = <?php echo JsonEncode($process_action_material_payment_list->process_to->lookupOptions()) ?>;
fprocess_action_material_paymentlistsrch.lists["x_payment[]"] = <?php echo $process_action_material_payment_list->payment->Lookup->toClientList() ?>;
fprocess_action_material_paymentlistsrch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_material_payment_list->payment->lookupOptions()) ?>;

// Filters
fprocess_action_material_paymentlistsrch.filterList = <?php echo $process_action_material_payment_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_material_paymentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_material_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_material_payment_list->TotalRecs > 0 && $process_action_material_payment_list->ExportOptions->visible()) { ?>
<?php $process_action_material_payment_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_payment_list->ImportOptions->visible()) { ?>
<?php $process_action_material_payment_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_payment_list->SearchOptions->visible()) { ?>
<?php $process_action_material_payment_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_payment_list->FilterOptions->visible()) { ?>
<?php $process_action_material_payment_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_material_payment_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_material_payment->isExport() && !$process_action_material_payment->CurrentAction) { ?>
<form name="fprocess_action_material_paymentlistsrch" id="fprocess_action_material_paymentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_material_payment_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_material_paymentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_material_payment">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_material_payment_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_material_payment->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_material_payment->resetAttributes();
$process_action_material_payment_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_material_payment->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action_material_payment->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_location" data-value-separator="<?php echo $process_action_material_payment->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_material_payment->location->editAttributes() ?>>
		<?php echo $process_action_material_payment->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_material_payment->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action_material_payment->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process" data-value-separator="<?php echo $process_action_material_payment->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_material_payment->process->editAttributes() ?>>
		<?php echo $process_action_material_payment->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->emp_id->Visible) { // emp_id ?>
	<div id="xsc_emp_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_material_payment->emp_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_action_material_payment->emp_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material_payment->emp_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_emp_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_emp_id" id="sv_x_emp_id" value="<?php echo RemoveHtml($process_action_material_payment->emp_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->emp_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material_payment->emp_id->getPlaceHolder()) ?>"<?php echo $process_action_material_payment->emp_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material_payment->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material_payment->emp_id->ReadOnly || $process_action_material_payment->emp_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_material_payment" data-field="x_emp_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material_payment->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id" id="x_emp_id" value="<?php echo HtmlEncode($process_action_material_payment->emp_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_material_paymentlistsrch.createAutoSuggest({"id":"x_emp_id","forceSelect":false});
</script>
<?php echo $process_action_material_payment->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action_material_payment->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_material_payment->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_action_material_payment->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material_payment->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($process_action_material_payment->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material_payment->rid->getPlaceHolder()) ?>"<?php echo $process_action_material_payment->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material_payment" data-field="x_rid" data-value-separator="<?php echo $process_action_material_payment->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($process_action_material_payment->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_material_paymentlistsrch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $process_action_material_payment->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_from->Visible) { // process_from ?>
	<div id="xsc_process_from" class="ew-cell form-group">
		<label for="x_process_from" class="ew-search-caption ew-label"><?php echo $process_action_material_payment->process_from->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_from" id="z_process_from" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process_from" data-value-separator="<?php echo $process_action_material_payment->process_from->displayValueSeparatorAttribute() ?>" id="x_process_from" name="x_process_from"<?php echo $process_action_material_payment->process_from->editAttributes() ?>>
		<?php echo $process_action_material_payment->process_from->selectOptionListHtml("x_process_from") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process_from->Lookup->getParamTag("p_x_process_from") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_to->Visible) { // process_to ?>
	<div id="xsc_process_to" class="ew-cell form-group">
		<label for="x_process_to" class="ew-search-caption ew-label"><?php echo $process_action_material_payment->process_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_to" id="z_process_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process_to" data-value-separator="<?php echo $process_action_material_payment->process_to->displayValueSeparatorAttribute() ?>" id="x_process_to" name="x_process_to"<?php echo $process_action_material_payment->process_to->editAttributes() ?>>
		<?php echo $process_action_material_payment->process_to->selectOptionListHtml("x_process_to") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process_to->Lookup->getParamTag("p_x_process_to") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($process_action_material_payment->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_material_payment->payment->caption() ?></label>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_material_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_material_payment->payment->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_payment" data-repeatcolumn="5" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_material_payment->payment->checkBoxListHtml(TRUE, "x_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_material_payment->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="{value}"<?php echo $process_action_material_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_material_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_material_payment->payment->Lookup->getParamTag("p_x_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		<span class="ew-search-cond btw1_payment style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_payment style="d-none"">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_material_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_material_payment->payment->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_payment" data-repeatcolumn="5" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_material_payment->payment->checkBoxListHtml(TRUE, "y_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_material_payment->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="{value}"<?php echo $process_action_material_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_material_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_material_payment->payment->Lookup->getParamTag("p_y_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_material_payment_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_material_payment_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_material_payment_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_material_payment_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_payment_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_payment_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_payment_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_material_payment_list->showPageHeader(); ?>
<?php
$process_action_material_payment_list->showMessage();
?>
<?php if ($process_action_material_payment_list->TotalRecs > 0 || $process_action_material_payment->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_material_payment_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_material_payment">
<?php if (!$process_action_material_payment->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_material_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_material_payment_list->Pager)) $process_action_material_payment_list->Pager = new PrevNextPager($process_action_material_payment_list->StartRec, $process_action_material_payment_list->DisplayRecs, $process_action_material_payment_list->TotalRecs, $process_action_material_payment_list->AutoHidePager) ?>
<?php if ($process_action_material_payment_list->Pager->RecordCount > 0 && $process_action_material_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_material_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_material_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_material_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_material_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_material_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_material_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_material_payment_list->TotalRecs > 0 && (!$process_action_material_payment_list->AutoHidePageSizeSelector || $process_action_material_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_material_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_material_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_material_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_material_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_material_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_material_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_material_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_material_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_material_paymentlist" id="fprocess_action_material_paymentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_material_payment_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_material_payment_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_material_payment">
<div id="gmp_process_action_material_payment" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_material_payment_list->TotalRecs > 0 || $process_action_material_payment->isGridEdit()) { ?>
<table id="tbl_process_action_material_paymentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_material_payment_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_material_payment_list->renderListOptions();

// Render list options (header, left)
$process_action_material_payment_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_material_payment->id->Visible) { // id ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_material_payment->id->headerCellClass() ?>"><div id="elh_process_action_material_payment_id" class="process_action_material_payment_id"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_material_payment->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->id) ?>',2);"><div id="elh_process_action_material_payment_id" class="process_action_material_payment_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->location->Visible) { // location ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action_material_payment->location->headerCellClass() ?>"><div id="elh_process_action_material_payment_location" class="process_action_material_payment_location"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action_material_payment->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->location) ?>',2);"><div id="elh_process_action_material_payment_location" class="process_action_material_payment_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->process->Visible) { // process ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_material_payment->process->headerCellClass() ?>"><div id="elh_process_action_material_payment_process" class="process_action_material_payment_process"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_material_payment->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->process) ?>',2);"><div id="elh_process_action_material_payment_process" class="process_action_material_payment_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->emp_id->Visible) { // emp_id ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $process_action_material_payment->emp_id->headerCellClass() ?>"><div id="elh_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $process_action_material_payment->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->emp_id) ?>',2);"><div id="elh_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->rid->Visible) { // rid ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_action_material_payment->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_payment_rid" class="process_action_material_payment_rid"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_action_material_payment->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->rid) ?>',2);"><div id="elh_process_action_material_payment_rid" class="process_action_material_payment_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->quantity->Visible) { // quantity ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $process_action_material_payment->quantity->headerCellClass() ?>"><div id="elh_process_action_material_payment_quantity" class="process_action_material_payment_quantity"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $process_action_material_payment->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->quantity) ?>',2);"><div id="elh_process_action_material_payment_quantity" class="process_action_material_payment_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->process_from->Visible) { // process_from ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->process_from) == "") { ?>
		<th data-name="process_from" class="<?php echo $process_action_material_payment->process_from->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_from" class="process_action_material_payment_process_from"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->process_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_from" class="<?php echo $process_action_material_payment->process_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->process_from) ?>',2);"><div id="elh_process_action_material_payment_process_from" class="process_action_material_payment_process_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->process_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->process_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->process_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->process_to->Visible) { // process_to ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->process_to) == "") { ?>
		<th data-name="process_to" class="<?php echo $process_action_material_payment->process_to->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_to" class="process_action_material_payment_process_to"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->process_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_to" class="<?php echo $process_action_material_payment->process_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->process_to) ?>',2);"><div id="elh_process_action_material_payment_process_to" class="process_action_material_payment_process_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->process_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->process_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->process_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->process_method->Visible) { // process_method ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->process_method) == "") { ?>
		<th data-name="process_method" class="<?php echo $process_action_material_payment->process_method->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_method" class="process_action_material_payment_process_method"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->process_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_method" class="<?php echo $process_action_material_payment->process_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->process_method) ?>',2);"><div id="elh_process_action_material_payment_process_method" class="process_action_material_payment_process_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->process_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->process_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->process_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->ply->Visible) { // ply ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->ply) == "") { ?>
		<th data-name="ply" class="<?php echo $process_action_material_payment->ply->headerCellClass() ?>"><div id="elh_process_action_material_payment_ply" class="process_action_material_payment_ply"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->ply->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply" class="<?php echo $process_action_material_payment->ply->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->ply) ?>',2);"><div id="elh_process_action_material_payment_ply" class="process_action_material_payment_ply">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->ply->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->ply->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->ply->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->rid_new->Visible) { // rid_new ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->rid_new) == "") { ?>
		<th data-name="rid_new" class="<?php echo $process_action_material_payment->rid_new->headerCellClass() ?>"><div id="elh_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->rid_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid_new" class="<?php echo $process_action_material_payment->rid_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->rid_new) ?>',2);"><div id="elh_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->rid_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->rid_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->rid_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->process_40->Visible) { // process_@ ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->process_40) == "") { ?>
		<th data-name="process_40" class="<?php echo $process_action_material_payment->process_40->headerCellClass() ?>"><div id="elh_process_action_material_payment_process_40" class="process_action_material_payment_process_40"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->process_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_40" class="<?php echo $process_action_material_payment->process_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->process_40) ?>',2);"><div id="elh_process_action_material_payment_process_40" class="process_action_material_payment_process_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->process_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->process_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->process_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->amount->Visible) { // amount ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $process_action_material_payment->amount->headerCellClass() ?>"><div id="elh_process_action_material_payment_amount" class="process_action_material_payment_amount"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $process_action_material_payment->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->amount) ?>',2);"><div id="elh_process_action_material_payment_amount" class="process_action_material_payment_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->incentive->Visible) { // incentive ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->incentive) == "") { ?>
		<th data-name="incentive" class="<?php echo $process_action_material_payment->incentive->headerCellClass() ?>"><div id="elh_process_action_material_payment_incentive" class="process_action_material_payment_incentive"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->incentive->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="incentive" class="<?php echo $process_action_material_payment->incentive->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->incentive) ?>',2);"><div id="elh_process_action_material_payment_incentive" class="process_action_material_payment_incentive">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->incentive->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->incentive->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->incentive->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->final_amount->Visible) { // final_amount ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->final_amount) == "") { ?>
		<th data-name="final_amount" class="<?php echo $process_action_material_payment->final_amount->headerCellClass() ?>"><div id="elh_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->final_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_amount" class="<?php echo $process_action_material_payment->final_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->final_amount) ?>',2);"><div id="elh_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->final_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->final_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->final_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->description->Visible) { // description ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->description) == "") { ?>
		<th data-name="description" class="<?php echo $process_action_material_payment->description->headerCellClass() ?>"><div id="elh_process_action_material_payment_description" class="process_action_material_payment_description"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $process_action_material_payment->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->description) ?>',2);"><div id="elh_process_action_material_payment_description" class="process_action_material_payment_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->remarks->Visible) { // remarks ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_action_material_payment->remarks->headerCellClass() ?>"><div id="elh_process_action_material_payment_remarks" class="process_action_material_payment_remarks"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_action_material_payment->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->remarks) ?>',2);"><div id="elh_process_action_material_payment_remarks" class="process_action_material_payment_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->payment->Visible) { // payment ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_material_payment->payment->headerCellClass() ?>"><div id="elh_process_action_material_payment_payment" class="process_action_material_payment_payment"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_material_payment->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->payment) ?>',2);"><div id="elh_process_action_material_payment_payment" class="process_action_material_payment_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->pp_id->Visible) { // pp_id ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->pp_id) == "") { ?>
		<th data-name="pp_id" class="<?php echo $process_action_material_payment->pp_id->headerCellClass() ?>"><div id="elh_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_id" class="<?php echo $process_action_material_payment->pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->pp_id) ?>',2);"><div id="elh_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material_payment->datetime->Visible) { // datetime ?>
	<?php if ($process_action_material_payment->sortUrl($process_action_material_payment->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_material_payment->datetime->headerCellClass() ?>"><div id="elh_process_action_material_payment_datetime" class="process_action_material_payment_datetime"><div class="ew-table-header-caption"><?php echo $process_action_material_payment->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_material_payment->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material_payment->SortUrl($process_action_material_payment->datetime) ?>',2);"><div id="elh_process_action_material_payment_datetime" class="process_action_material_payment_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material_payment->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material_payment->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material_payment->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_material_payment_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_material_payment->ExportAll && $process_action_material_payment->isExport()) {
	$process_action_material_payment_list->StopRec = $process_action_material_payment_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_material_payment_list->TotalRecs > $process_action_material_payment_list->StartRec + $process_action_material_payment_list->DisplayRecs - 1)
		$process_action_material_payment_list->StopRec = $process_action_material_payment_list->StartRec + $process_action_material_payment_list->DisplayRecs - 1;
	else
		$process_action_material_payment_list->StopRec = $process_action_material_payment_list->TotalRecs;
}
$process_action_material_payment_list->RecCnt = $process_action_material_payment_list->StartRec - 1;
if ($process_action_material_payment_list->Recordset && !$process_action_material_payment_list->Recordset->EOF) {
	$process_action_material_payment_list->Recordset->moveFirst();
	$selectLimit = $process_action_material_payment_list->UseSelectLimit;
	if (!$selectLimit && $process_action_material_payment_list->StartRec > 1)
		$process_action_material_payment_list->Recordset->move($process_action_material_payment_list->StartRec - 1);
} elseif (!$process_action_material_payment->AllowAddDeleteRow && $process_action_material_payment_list->StopRec == 0) {
	$process_action_material_payment_list->StopRec = $process_action_material_payment->GridAddRowCount;
}

// Initialize aggregate
$process_action_material_payment->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_material_payment->resetAttributes();
$process_action_material_payment_list->renderRow();
while ($process_action_material_payment_list->RecCnt < $process_action_material_payment_list->StopRec) {
	$process_action_material_payment_list->RecCnt++;
	if ($process_action_material_payment_list->RecCnt >= $process_action_material_payment_list->StartRec) {
		$process_action_material_payment_list->RowCnt++;

		// Set up key count
		$process_action_material_payment_list->KeyCount = $process_action_material_payment_list->RowIndex;

		// Init row class and style
		$process_action_material_payment->resetAttributes();
		$process_action_material_payment->CssClass = "";
		if ($process_action_material_payment->isGridAdd()) {
		} else {
			$process_action_material_payment_list->loadRowValues($process_action_material_payment_list->Recordset); // Load row values
		}
		$process_action_material_payment->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_material_payment->RowAttrs = array_merge($process_action_material_payment->RowAttrs, array('data-rowindex'=>$process_action_material_payment_list->RowCnt, 'id'=>'r' . $process_action_material_payment_list->RowCnt . '_process_action_material_payment', 'data-rowtype'=>$process_action_material_payment->RowType));

		// Render row
		$process_action_material_payment_list->renderRow();

		// Render list options
		$process_action_material_payment_list->renderListOptions();
?>
	<tr<?php echo $process_action_material_payment->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_material_payment_list->ListOptions->render("body", "left", $process_action_material_payment_list->RowCnt);
?>
	<?php if ($process_action_material_payment->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_material_payment->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_id" class="process_action_material_payment_id">
<span<?php echo $process_action_material_payment->id->viewAttributes() ?>>
<?php echo $process_action_material_payment->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action_material_payment->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_location" class="process_action_material_payment_location">
<span<?php echo $process_action_material_payment->location->viewAttributes() ?>>
<?php echo $process_action_material_payment->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_material_payment->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_process" class="process_action_material_payment_process">
<span<?php echo $process_action_material_payment->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_material_payment->process->getViewValue())) && $process_action_material_payment->process->linkAttributes() <> "") { ?>
<a<?php echo $process_action_material_payment->process->linkAttributes() ?>><?php echo $process_action_material_payment->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_material_payment->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $process_action_material_payment->emp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id">
<span<?php echo $process_action_material_payment->emp_id->viewAttributes() ?>>
<?php echo $process_action_material_payment->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_action_material_payment->rid->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_rid" class="process_action_material_payment_rid">
<span<?php echo $process_action_material_payment->rid->viewAttributes() ?>>
<?php echo $process_action_material_payment->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $process_action_material_payment->quantity->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_quantity" class="process_action_material_payment_quantity">
<span<?php echo $process_action_material_payment->quantity->viewAttributes() ?>>
<?php echo $process_action_material_payment->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_from->Visible) { // process_from ?>
		<td data-name="process_from"<?php echo $process_action_material_payment->process_from->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_process_from" class="process_action_material_payment_process_from">
<span<?php echo $process_action_material_payment->process_from->viewAttributes() ?>>
<?php echo $process_action_material_payment->process_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_to->Visible) { // process_to ?>
		<td data-name="process_to"<?php echo $process_action_material_payment->process_to->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_process_to" class="process_action_material_payment_process_to">
<span<?php echo $process_action_material_payment->process_to->viewAttributes() ?>>
<?php echo $process_action_material_payment->process_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_method->Visible) { // process_method ?>
		<td data-name="process_method"<?php echo $process_action_material_payment->process_method->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_process_method" class="process_action_material_payment_process_method">
<span<?php echo $process_action_material_payment->process_method->viewAttributes() ?>>
<?php echo $process_action_material_payment->process_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->ply->Visible) { // ply ?>
		<td data-name="ply"<?php echo $process_action_material_payment->ply->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_ply" class="process_action_material_payment_ply">
<span<?php echo $process_action_material_payment->ply->viewAttributes() ?>>
<?php echo $process_action_material_payment->ply->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->rid_new->Visible) { // rid_new ?>
		<td data-name="rid_new"<?php echo $process_action_material_payment->rid_new->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new">
<span<?php echo $process_action_material_payment->rid_new->viewAttributes() ?>>
<?php echo $process_action_material_payment->rid_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_40->Visible) { // process_@ ?>
		<td data-name="process_40"<?php echo $process_action_material_payment->process_40->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_process_40" class="process_action_material_payment_process_40">
<span<?php echo $process_action_material_payment->process_40->viewAttributes() ?>>
<?php echo $process_action_material_payment->process_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $process_action_material_payment->amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_amount" class="process_action_material_payment_amount">
<span<?php echo $process_action_material_payment->amount->viewAttributes() ?>>
<?php echo $process_action_material_payment->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->incentive->Visible) { // incentive ?>
		<td data-name="incentive"<?php echo $process_action_material_payment->incentive->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_incentive" class="process_action_material_payment_incentive">
<span<?php echo $process_action_material_payment->incentive->viewAttributes() ?>>
<?php echo $process_action_material_payment->incentive->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount"<?php echo $process_action_material_payment->final_amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount">
<span<?php echo $process_action_material_payment->final_amount->viewAttributes() ?>>
<?php echo $process_action_material_payment->final_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->description->Visible) { // description ?>
		<td data-name="description"<?php echo $process_action_material_payment->description->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_description" class="process_action_material_payment_description">
<span<?php echo $process_action_material_payment->description->viewAttributes() ?>>
<?php echo $process_action_material_payment->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_action_material_payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_remarks" class="process_action_material_payment_remarks">
<span<?php echo $process_action_material_payment->remarks->viewAttributes() ?>>
<?php echo $process_action_material_payment->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_material_payment->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_payment" class="process_action_material_payment_payment">
<span<?php echo $process_action_material_payment->payment->viewAttributes() ?>>
<?php echo $process_action_material_payment->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id"<?php echo $process_action_material_payment->pp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id">
<span<?php echo $process_action_material_payment->pp_id->viewAttributes() ?>>
<?php echo $process_action_material_payment->pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_material_payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_payment_list->RowCnt ?>_process_action_material_payment_datetime" class="process_action_material_payment_datetime">
<span<?php echo $process_action_material_payment->datetime->viewAttributes() ?>>
<?php echo $process_action_material_payment->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_material_payment_list->ListOptions->render("body", "right", $process_action_material_payment_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_material_payment->isGridAdd())
		$process_action_material_payment_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_action_material_payment->RowType = ROWTYPE_AGGREGATE;
$process_action_material_payment->resetAttributes();
$process_action_material_payment_list->renderRow();
?>
<?php if ($process_action_material_payment_list->TotalRecs > 0 && !$process_action_material_payment->isGridAdd() && !$process_action_material_payment->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_action_material_payment_list->renderListOptions();

// Render list options (footer, left)
$process_action_material_payment_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_action_material_payment->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $process_action_material_payment->id->footerCellClass() ?>"><span id="elf_process_action_material_payment_id" class="process_action_material_payment_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $process_action_material_payment->location->footerCellClass() ?>"><span id="elf_process_action_material_payment_location" class="process_action_material_payment_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $process_action_material_payment->process->footerCellClass() ?>"><span id="elf_process_action_material_payment_process" class="process_action_material_payment_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id" class="<?php echo $process_action_material_payment->emp_id->footerCellClass() ?>"><span id="elf_process_action_material_payment_emp_id" class="process_action_material_payment_emp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $process_action_material_payment->rid->footerCellClass() ?>"><span id="elf_process_action_material_payment_rid" class="process_action_material_payment_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $process_action_material_payment->quantity->footerCellClass() ?>"><span id="elf_process_action_material_payment_quantity" class="process_action_material_payment_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_from->Visible) { // process_from ?>
		<td data-name="process_from" class="<?php echo $process_action_material_payment->process_from->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_from" class="process_action_material_payment_process_from">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_to->Visible) { // process_to ?>
		<td data-name="process_to" class="<?php echo $process_action_material_payment->process_to->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_to" class="process_action_material_payment_process_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_method->Visible) { // process_method ?>
		<td data-name="process_method" class="<?php echo $process_action_material_payment->process_method->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_method" class="process_action_material_payment_process_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->ply->Visible) { // ply ?>
		<td data-name="ply" class="<?php echo $process_action_material_payment->ply->footerCellClass() ?>"><span id="elf_process_action_material_payment_ply" class="process_action_material_payment_ply">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->rid_new->Visible) { // rid_new ?>
		<td data-name="rid_new" class="<?php echo $process_action_material_payment->rid_new->footerCellClass() ?>"><span id="elf_process_action_material_payment_rid_new" class="process_action_material_payment_rid_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->process_40->Visible) { // process_@ ?>
		<td data-name="process_40" class="<?php echo $process_action_material_payment->process_40->footerCellClass() ?>"><span id="elf_process_action_material_payment_process_40" class="process_action_material_payment_process_40">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $process_action_material_payment->amount->footerCellClass() ?>"><span id="elf_process_action_material_payment_amount" class="process_action_material_payment_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_material_payment->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->incentive->Visible) { // incentive ?>
		<td data-name="incentive" class="<?php echo $process_action_material_payment->incentive->footerCellClass() ?>"><span id="elf_process_action_material_payment_incentive" class="process_action_material_payment_incentive">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_material_payment->incentive->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount" class="<?php echo $process_action_material_payment->final_amount->footerCellClass() ?>"><span id="elf_process_action_material_payment_final_amount" class="process_action_material_payment_final_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_material_payment->final_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->description->Visible) { // description ?>
		<td data-name="description" class="<?php echo $process_action_material_payment->description->footerCellClass() ?>"><span id="elf_process_action_material_payment_description" class="process_action_material_payment_description">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $process_action_material_payment->remarks->footerCellClass() ?>"><span id="elf_process_action_material_payment_remarks" class="process_action_material_payment_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_action_material_payment->payment->footerCellClass() ?>"><span id="elf_process_action_material_payment_payment" class="process_action_material_payment_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id" class="<?php echo $process_action_material_payment->pp_id->footerCellClass() ?>"><span id="elf_process_action_material_payment_pp_id" class="process_action_material_payment_pp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $process_action_material_payment->datetime->footerCellClass() ?>"><span id="elf_process_action_material_payment_datetime" class="process_action_material_payment_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_action_material_payment_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_material_payment->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_material_payment_list->Recordset)
	$process_action_material_payment_list->Recordset->Close();
?>
<?php if (!$process_action_material_payment->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_material_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_material_payment_list->Pager)) $process_action_material_payment_list->Pager = new PrevNextPager($process_action_material_payment_list->StartRec, $process_action_material_payment_list->DisplayRecs, $process_action_material_payment_list->TotalRecs, $process_action_material_payment_list->AutoHidePager) ?>
<?php if ($process_action_material_payment_list->Pager->RecordCount > 0 && $process_action_material_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_material_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_material_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_material_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_material_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_material_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_material_payment_list->pageUrl() ?>start=<?php echo $process_action_material_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_material_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_material_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_material_payment_list->TotalRecs > 0 && (!$process_action_material_payment_list->AutoHidePageSizeSelector || $process_action_material_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_material_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_material_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_material_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_material_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_material_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_material_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_material_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_material_payment_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_material_payment_list->TotalRecs == 0 && !$process_action_material_payment->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_material_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_material_payment_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_material_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_material_payment->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_material_payment", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_material_payment_list->terminate();
?>