<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_material_payment_search = new process_action_material_payment_search();

// Run the page
$process_action_material_payment_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_material_payment_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_action_material_payment_search->IsModal) { ?>
var fprocess_action_material_paymentsearch = currentAdvancedSearchForm = new ew.Form("fprocess_action_material_paymentsearch", "search");
<?php } else { ?>
var fprocess_action_material_paymentsearch = currentForm = new ew.Form("fprocess_action_material_paymentsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_action_material_paymentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_material_paymentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_material_paymentsearch.lists["x_location"] = <?php echo $process_action_material_payment_search->location->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_location"].options = <?php echo JsonEncode($process_action_material_payment_search->location->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.lists["x_process"] = <?php echo $process_action_material_payment_search->process->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_process"].options = <?php echo JsonEncode($process_action_material_payment_search->process->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.lists["x_emp_id"] = <?php echo $process_action_material_payment_search->emp_id->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_material_payment_search->emp_id->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.autoSuggests["x_emp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_material_paymentsearch.lists["x_process_from"] = <?php echo $process_action_material_payment_search->process_from->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_process_from"].options = <?php echo JsonEncode($process_action_material_payment_search->process_from->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.lists["x_process_to"] = <?php echo $process_action_material_payment_search->process_to->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_process_to"].options = <?php echo JsonEncode($process_action_material_payment_search->process_to->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.lists["x_process_method"] = <?php echo $process_action_material_payment_search->process_method->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_process_method"].options = <?php echo JsonEncode($process_action_material_payment_search->process_method->options(FALSE, TRUE)) ?>;
fprocess_action_material_paymentsearch.lists["x_rid_new"] = <?php echo $process_action_material_payment_search->rid_new->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_rid_new"].options = <?php echo JsonEncode($process_action_material_payment_search->rid_new->lookupOptions()) ?>;
fprocess_action_material_paymentsearch.lists["x_payment[]"] = <?php echo $process_action_material_payment_search->payment->Lookup->toClientList() ?>;
fprocess_action_material_paymentsearch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_material_payment_search->payment->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fprocess_action_material_paymentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ply");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->ply->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_40");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->process_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_incentive");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->incentive->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_final_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->final_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->pp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material_payment->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_material_payment_search->showPageHeader(); ?>
<?php
$process_action_material_payment_search->showMessage();
?>
<form name="fprocess_action_material_paymentsearch" id="fprocess_action_material_paymentsearch" class="<?php echo $process_action_material_payment_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_material_payment_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_material_payment_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_material_payment">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_material_payment_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_action_material_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_id"><?php echo $process_action_material_payment->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->id->cellAttributes() ?>>
			<span id="el_process_action_material_payment_id">
<input type="text" data-table="process_action_material_payment" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_action_material_payment->id->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->id->EditValue ?>"<?php echo $process_action_material_payment->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_location"><?php echo $process_action_material_payment->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->location->cellAttributes() ?>>
			<span id="el_process_action_material_payment_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_location" data-value-separator="<?php echo $process_action_material_payment->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_material_payment->location->editAttributes() ?>>
		<?php echo $process_action_material_payment->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_material_payment->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process"><?php echo $process_action_material_payment->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->process->cellAttributes() ?>>
			<span id="el_process_action_material_payment_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process" data-value-separator="<?php echo $process_action_material_payment->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_material_payment->process->editAttributes() ?>>
		<?php echo $process_action_material_payment->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_emp_id"><?php echo $process_action_material_payment->emp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->emp_id->cellAttributes() ?>>
			<span id="el_process_action_material_payment_emp_id">
<?php
$wrkonchange = "" . trim(@$process_action_material_payment->emp_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material_payment->emp_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_emp_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_emp_id" id="sv_x_emp_id" value="<?php echo RemoveHtml($process_action_material_payment->emp_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->emp_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material_payment->emp_id->getPlaceHolder()) ?>"<?php echo $process_action_material_payment->emp_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material_payment->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material_payment->emp_id->ReadOnly || $process_action_material_payment->emp_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_material_payment" data-field="x_emp_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material_payment->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id" id="x_emp_id" value="<?php echo HtmlEncode($process_action_material_payment->emp_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_material_paymentsearch.createAutoSuggest({"id":"x_emp_id","forceSelect":false});
</script>
<?php echo $process_action_material_payment->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_quantity"><?php echo $process_action_material_payment->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->quantity->cellAttributes() ?>>
			<span id="el_process_action_material_payment_quantity">
<input type="text" data-table="process_action_material_payment" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->quantity->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->quantity->EditValue ?>"<?php echo $process_action_material_payment->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_from->Visible) { // process_from ?>
	<div id="r_process_from" class="form-group row">
		<label for="x_process_from" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_from"><?php echo $process_action_material_payment->process_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_from" id="z_process_from" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->process_from->cellAttributes() ?>>
			<span id="el_process_action_material_payment_process_from">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process_from" data-value-separator="<?php echo $process_action_material_payment->process_from->displayValueSeparatorAttribute() ?>" id="x_process_from" name="x_process_from"<?php echo $process_action_material_payment->process_from->editAttributes() ?>>
		<?php echo $process_action_material_payment->process_from->selectOptionListHtml("x_process_from") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process_from->Lookup->getParamTag("p_x_process_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_to->Visible) { // process_to ?>
	<div id="r_process_to" class="form-group row">
		<label for="x_process_to" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_to"><?php echo $process_action_material_payment->process_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_to" id="z_process_to" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->process_to->cellAttributes() ?>>
			<span id="el_process_action_material_payment_process_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process_to" data-value-separator="<?php echo $process_action_material_payment->process_to->displayValueSeparatorAttribute() ?>" id="x_process_to" name="x_process_to"<?php echo $process_action_material_payment->process_to->editAttributes() ?>>
		<?php echo $process_action_material_payment->process_to->selectOptionListHtml("x_process_to") ?>
	</select>
</div>
<?php echo $process_action_material_payment->process_to->Lookup->getParamTag("p_x_process_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_method->Visible) { // process_method ?>
	<div id="r_process_method" class="form-group row">
		<label for="x_process_method" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_method"><?php echo $process_action_material_payment->process_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_method" id="z_process_method" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->process_method->cellAttributes() ?>>
			<span id="el_process_action_material_payment_process_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_process_method" data-value-separator="<?php echo $process_action_material_payment->process_method->displayValueSeparatorAttribute() ?>" id="x_process_method" name="x_process_method"<?php echo $process_action_material_payment->process_method->editAttributes() ?>>
		<?php echo $process_action_material_payment->process_method->selectOptionListHtml("x_process_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->ply->Visible) { // ply ?>
	<div id="r_ply" class="form-group row">
		<label for="x_ply" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_ply"><?php echo $process_action_material_payment->ply->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply" id="z_ply" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->ply->cellAttributes() ?>>
			<span id="el_process_action_material_payment_ply">
<input type="text" data-table="process_action_material_payment" data-field="x_ply" name="x_ply" id="x_ply" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->ply->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->ply->EditValue ?>"<?php echo $process_action_material_payment->ply->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->rid_new->Visible) { // rid_new ?>
	<div id="r_rid_new" class="form-group row">
		<label for="x_rid_new" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_rid_new"><?php echo $process_action_material_payment->rid_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid_new" id="z_rid_new" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->rid_new->cellAttributes() ?>>
			<span id="el_process_action_material_payment_rid_new">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material_payment" data-field="x_rid_new" data-value-separator="<?php echo $process_action_material_payment->rid_new->displayValueSeparatorAttribute() ?>" id="x_rid_new" name="x_rid_new"<?php echo $process_action_material_payment->rid_new->editAttributes() ?>>
		<?php echo $process_action_material_payment->rid_new->selectOptionListHtml("x_rid_new") ?>
	</select>
</div>
<?php echo $process_action_material_payment->rid_new->Lookup->getParamTag("p_x_rid_new") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->process_40->Visible) { // process_@ ?>
	<div id="r_process_40" class="form-group row">
		<label for="x_process_40" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_process_40"><?php echo $process_action_material_payment->process_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_40" id="z_process_40" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->process_40->cellAttributes() ?>>
			<span id="el_process_action_material_payment_process_40">
<input type="text" data-table="process_action_material_payment" data-field="x_process_40" name="x_process_40" id="x_process_40" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->process_40->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->process_40->EditValue ?>"<?php echo $process_action_material_payment->process_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_amount"><?php echo $process_action_material_payment->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->amount->cellAttributes() ?>>
			<span id="el_process_action_material_payment_amount">
<input type="text" data-table="process_action_material_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->amount->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->amount->EditValue ?>"<?php echo $process_action_material_payment->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->incentive->Visible) { // incentive ?>
	<div id="r_incentive" class="form-group row">
		<label for="x_incentive" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_incentive"><?php echo $process_action_material_payment->incentive->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_incentive" id="z_incentive" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->incentive->cellAttributes() ?>>
			<span id="el_process_action_material_payment_incentive">
<input type="text" data-table="process_action_material_payment" data-field="x_incentive" name="x_incentive" id="x_incentive" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->incentive->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->incentive->EditValue ?>"<?php echo $process_action_material_payment->incentive->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label for="x_final_amount" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_final_amount"><?php echo $process_action_material_payment->final_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_final_amount" id="z_final_amount" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->final_amount->cellAttributes() ?>>
			<span id="el_process_action_material_payment_final_amount">
<input type="text" data-table="process_action_material_payment" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->final_amount->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->final_amount->EditValue ?>"<?php echo $process_action_material_payment->final_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_description"><?php echo $process_action_material_payment->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->description->cellAttributes() ?>>
			<span id="el_process_action_material_payment_description">
<input type="text" data-table="process_action_material_payment" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($process_action_material_payment->description->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->description->EditValue ?>"<?php echo $process_action_material_payment->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_remarks"><?php echo $process_action_material_payment->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->remarks->cellAttributes() ?>>
			<span id="el_process_action_material_payment_remarks">
<input type="text" data-table="process_action_material_payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_material_payment->remarks->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->remarks->EditValue ?>"<?php echo $process_action_material_payment->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_payment"><?php echo $process_action_material_payment->payment->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->payment->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_material_payment->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_material_payment_payment">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_material_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_material_payment->payment->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_payment" data-repeatcolumn="5" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_material_payment->payment->checkBoxListHtml(TRUE, "x_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_material_payment->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="{value}"<?php echo $process_action_material_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_material_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_material_payment->payment->Lookup->getParamTag("p_x_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
			<span class="ew-search-cond btw1_payment d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_material_payment_payment" class="btw1_payment d-none">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_material_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_material_payment->payment->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_payment" data-repeatcolumn="5" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_material_payment->payment->checkBoxListHtml(TRUE, "y_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_material_payment->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="{value}"<?php echo $process_action_material_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_material_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_material_payment->payment->Lookup->getParamTag("p_y_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label for="x_pp_id" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_pp_id"><?php echo $process_action_material_payment->pp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_id" id="z_pp_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->pp_id->cellAttributes() ?>>
			<span id="el_process_action_material_payment_pp_id">
<input type="text" data-table="process_action_material_payment" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($process_action_material_payment->pp_id->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->pp_id->EditValue ?>"<?php echo $process_action_material_payment->pp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material_payment->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_action_material_payment_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment_datetime"><?php echo $process_action_material_payment->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_payment_search->RightColumnClass ?>"><div<?php echo $process_action_material_payment->datetime->cellAttributes() ?>>
			<span id="el_process_action_material_payment_datetime">
<input type="text" data-table="process_action_material_payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_material_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_material_payment->datetime->EditValue ?>"<?php echo $process_action_material_payment->datetime->editAttributes() ?>>
<?php if (!$process_action_material_payment->datetime->ReadOnly && !$process_action_material_payment->datetime->Disabled && !isset($process_action_material_payment->datetime->EditAttrs["readonly"]) && !isset($process_action_material_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_material_paymentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_material_payment_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_material_payment_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_material_payment_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_action_material_payment_search->terminate();
?>