<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_material_add = new process_action_material_add();

// Run the page
$process_action_material_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_material_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fprocess_action_materialadd = currentForm = new ew.Form("fprocess_action_materialadd", "add");

// Validate form
fprocess_action_materialadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($process_action_material_add->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->site->caption(), $process_action_material->site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->process->caption(), $process_action_material->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->sub_process->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->sub_process->caption(), $process_action_material->sub_process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->emp_name->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->emp_name->caption(), $process_action_material->emp_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->jc_no->caption(), $process_action_material->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->grp->caption(), $process_action_material->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->s_grp->caption(), $process_action_material->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->product->caption(), $process_action_material->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->rid_1->caption(), $process_action_material->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->packing->Required) { ?>
			elm = this.getElements("x" + infix + "_packing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->packing->caption(), $process_action_material->packing->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packing");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->packing->errorMessage()) ?>");
		<?php if ($process_action_material_add->rid_2->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->rid_2->caption(), $process_action_material->rid_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->rid->caption(), $process_action_material->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->godown->caption(), $process_action_material->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->godown->errorMessage()) ?>");
		<?php if ($process_action_material_add->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->avg_quantity->caption(), $process_action_material->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->avg_quantity->errorMessage()) ?>");
		<?php if ($process_action_material_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->lot_no->caption(), $process_action_material->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->avialable_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_avialable_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->avialable_qty->caption(), $process_action_material->avialable_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avialable_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->avialable_qty->errorMessage()) ?>");
		<?php if ($process_action_material_add->ply->Required) { ?>
			elm = this.getElements("x" + infix + "_ply");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->ply->caption(), $process_action_material->ply->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ply");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->ply->errorMessage()) ?>");
		<?php if ($process_action_material_add->rid_new->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->rid_new->caption(), $process_action_material->rid_new->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->rid_new_lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_new_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->rid_new_lot_no->caption(), $process_action_material->rid_new_lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->poid_new->Required) { ?>
			elm = this.getElements("x" + infix + "_poid_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->poid_new->caption(), $process_action_material->poid_new->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->poid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_poid_1[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->poid_1->caption(), $process_action_material->poid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->poid->Required) { ?>
			elm = this.getElements("x" + infix + "_poid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->poid->caption(), $process_action_material->poid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->quantity->caption(), $process_action_material->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->quantity->errorMessage()) ?>");
		<?php if ($process_action_material_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->packets->caption(), $process_action_material->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->packets->errorMessage()) ?>");
		<?php if ($process_action_material_add->process_method->Required) { ?>
			elm = this.getElements("x" + infix + "_process_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->process_method->caption(), $process_action_material->process_method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->remark->Required) { ?>
			elm = this.getElements("x" + infix + "_remark");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->remark->caption(), $process_action_material->remark->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->dated->caption(), $process_action_material->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($process_action_material->dated->errorMessage()) ?>");
		<?php if ($process_action_material_add->opeartor->Required) { ?>
			elm = this.getElements("x" + infix + "_opeartor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->opeartor->caption(), $process_action_material->opeartor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($process_action_material_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $process_action_material->datetime->caption(), $process_action_material->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fprocess_action_materialadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_materialadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_materialadd.lists["x_site"] = <?php echo $process_action_material_add->site->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_site"].options = <?php echo JsonEncode($process_action_material_add->site->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_process"] = <?php echo $process_action_material_add->process->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_process"].options = <?php echo JsonEncode($process_action_material_add->process->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_sub_process"] = <?php echo $process_action_material_add->sub_process->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_sub_process"].options = <?php echo JsonEncode($process_action_material_add->sub_process->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_emp_name"] = <?php echo $process_action_material_add->emp_name->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_emp_name"].options = <?php echo JsonEncode($process_action_material_add->emp_name->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_jc_no"] = <?php echo $process_action_material_add->jc_no->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_jc_no"].options = <?php echo JsonEncode($process_action_material_add->jc_no->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_grp"] = <?php echo $process_action_material_add->grp->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_grp"].options = <?php echo JsonEncode($process_action_material_add->grp->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_s_grp"] = <?php echo $process_action_material_add->s_grp->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_s_grp"].options = <?php echo JsonEncode($process_action_material_add->s_grp->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_product"] = <?php echo $process_action_material_add->product->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_product"].options = <?php echo JsonEncode($process_action_material_add->product->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_rid_1"] = <?php echo $process_action_material_add->rid_1->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_rid_1"].options = <?php echo JsonEncode($process_action_material_add->rid_1->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_packing"] = <?php echo $process_action_material_add->packing->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_packing"].options = <?php echo JsonEncode($process_action_material_add->packing->lookupOptions()) ?>;
fprocess_action_materialadd.autoSuggests["x_packing"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialadd.lists["x_rid_2"] = <?php echo $process_action_material_add->rid_2->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_rid_2"].options = <?php echo JsonEncode($process_action_material_add->rid_2->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_rid"] = <?php echo $process_action_material_add->rid->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_add->rid->lookupOptions()) ?>;
fprocess_action_materialadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialadd.lists["x_godown"] = <?php echo $process_action_material_add->godown->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_godown"].options = <?php echo JsonEncode($process_action_material_add->godown->lookupOptions()) ?>;
fprocess_action_materialadd.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialadd.lists["x_rid_new"] = <?php echo $process_action_material_add->rid_new->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_rid_new"].options = <?php echo JsonEncode($process_action_material_add->rid_new->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_poid_1[]"] = <?php echo $process_action_material_add->poid_1->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_poid_1[]"].options = <?php echo JsonEncode($process_action_material_add->poid_1->lookupOptions()) ?>;
fprocess_action_materialadd.lists["x_process_method"] = <?php echo $process_action_material_add->process_method->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_process_method"].options = <?php echo JsonEncode($process_action_material_add->process_method->options(FALSE, TRUE)) ?>;
fprocess_action_materialadd.lists["x_opeartor"] = <?php echo $process_action_material_add->opeartor->Lookup->toClientList() ?>;
fprocess_action_materialadd.lists["x_opeartor"].options = <?php echo JsonEncode($process_action_material_add->opeartor->lookupOptions()) ?>;
fprocess_action_materialadd.autoSuggests["x_opeartor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_material_add->showPageHeader(); ?>
<?php
$process_action_material_add->showMessage();
?>
<form name="fprocess_action_materialadd" id="fprocess_action_materialadd" class="<?php echo $process_action_material_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_material_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_material_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_material">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_material_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($process_action_material->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label id="elh_process_action_material_site" for="x_site" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->site->caption() ?><?php echo ($process_action_material->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->site->cellAttributes() ?>>
<span id="el_process_action_material_site">
<?php $process_action_material->site->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->site->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_site" data-value-separator="<?php echo $process_action_material->site->displayValueSeparatorAttribute() ?>" id="x_site" name="x_site"<?php echo $process_action_material->site->editAttributes() ?>>
		<?php echo $process_action_material->site->selectOptionListHtml("x_site") ?>
	</select>
</div>
<?php echo $process_action_material->site->Lookup->getParamTag("p_x_site") ?>
</span>
<?php echo $process_action_material->site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_process_action_material_process" for="x_process" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->process->caption() ?><?php echo ($process_action_material->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->process->cellAttributes() ?>>
<span id="el_process_action_material_process">
<?php $process_action_material->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_process" data-value-separator="<?php echo $process_action_material->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_material->process->editAttributes() ?>>
		<?php echo $process_action_material->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_material->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $process_action_material->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->sub_process->Visible) { // sub_process ?>
	<div id="r_sub_process" class="form-group row">
		<label id="elh_process_action_material_sub_process" for="x_sub_process" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->sub_process->caption() ?><?php echo ($process_action_material->sub_process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->sub_process->cellAttributes() ?>>
<span id="el_process_action_material_sub_process">
<?php $process_action_material->sub_process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->sub_process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_sub_process" data-value-separator="<?php echo $process_action_material->sub_process->displayValueSeparatorAttribute() ?>" id="x_sub_process" name="x_sub_process"<?php echo $process_action_material->sub_process->editAttributes() ?>>
		<?php echo $process_action_material->sub_process->selectOptionListHtml("x_sub_process") ?>
	</select>
</div>
<?php echo $process_action_material->sub_process->Lookup->getParamTag("p_x_sub_process") ?>
</span>
<?php echo $process_action_material->sub_process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->emp_name->Visible) { // emp_name ?>
	<div id="r_emp_name" class="form-group row">
		<label id="elh_process_action_material_emp_name" for="x_emp_name" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->emp_name->caption() ?><?php echo ($process_action_material->emp_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->emp_name->cellAttributes() ?>>
<span id="el_process_action_material_emp_name">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_emp_name" data-value-separator="<?php echo $process_action_material->emp_name->displayValueSeparatorAttribute() ?>" id="x_emp_name" name="x_emp_name"<?php echo $process_action_material->emp_name->editAttributes() ?>>
		<?php echo $process_action_material->emp_name->selectOptionListHtml("x_emp_name") ?>
	</select>
</div>
<?php echo $process_action_material->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
</span>
<?php echo $process_action_material->emp_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_process_action_material_jc_no" for="x_jc_no" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->jc_no->caption() ?><?php echo ($process_action_material->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->jc_no->cellAttributes() ?>>
<span id="el_process_action_material_jc_no">
<?php $process_action_material->jc_no->EditAttrs["onchange"] = "ew.autoFill(this);" . @$process_action_material->jc_no->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_jc_no" data-value-separator="<?php echo $process_action_material->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $process_action_material->jc_no->editAttributes() ?>>
		<?php echo $process_action_material->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $process_action_material->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
<?php echo $process_action_material->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_process_action_material_grp" for="x_grp" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->grp->caption() ?><?php echo ($process_action_material->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->grp->cellAttributes() ?>>
<span id="el_process_action_material_grp">
<?php $process_action_material->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_grp" data-value-separator="<?php echo $process_action_material->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_action_material->grp->editAttributes() ?>>
		<?php echo $process_action_material->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process_action_material->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $process_action_material->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_process_action_material_s_grp" for="x_s_grp" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->s_grp->caption() ?><?php echo ($process_action_material->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->s_grp->cellAttributes() ?>>
<span id="el_process_action_material_s_grp">
<?php $process_action_material->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_s_grp" data-value-separator="<?php echo $process_action_material->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $process_action_material->s_grp->editAttributes() ?>>
		<?php echo $process_action_material->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $process_action_material->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $process_action_material->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_process_action_material_product" for="x_product" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->product->caption() ?><?php echo ($process_action_material->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->product->cellAttributes() ?>>
<span id="el_process_action_material_product">
<?php $process_action_material->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_product" data-value-separator="<?php echo $process_action_material->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_action_material->product->editAttributes() ?>>
		<?php echo $process_action_material->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_action_material->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $process_action_material->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label id="elh_process_action_material_rid_1" for="x_rid_1" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->rid_1->caption() ?><?php echo ($process_action_material->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->rid_1->cellAttributes() ?>>
<span id="el_process_action_material_rid_1">
<?php $process_action_material->rid_1->EditAttrs["onchange"] = "ew.autoFill(this);" . @$process_action_material->rid_1->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_1"><?php echo strval($process_action_material->rid_1->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_material->rid_1->ViewValue) : $process_action_material->rid_1->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material->rid_1->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material->rid_1->ReadOnly || $process_action_material->rid_1->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_1',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_material->rid_1->Lookup->getParamTag("p_x_rid_1") ?>
<input type="hidden" data-table="process_action_material" data-field="x_rid_1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material->rid_1->displayValueSeparatorAttribute() ?>" name="x_rid_1" id="x_rid_1" value="<?php echo $process_action_material->rid_1->CurrentValue ?>"<?php echo $process_action_material->rid_1->editAttributes() ?>>
</span>
<?php echo $process_action_material->rid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->packing->Visible) { // packing ?>
	<div id="r_packing" class="form-group row">
		<label id="elh_process_action_material_packing" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->packing->caption() ?><?php echo ($process_action_material->packing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->packing->cellAttributes() ?>>
<span id="el_process_action_material_packing">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$process_action_material->packing->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->packing->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_packing" id="sv_x_packing" value="<?php echo RemoveHtml($process_action_material->packing->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->packing->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->packing->getPlaceHolder()) ?>"<?php echo $process_action_material->packing->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material->packing->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_packing',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material->packing->ReadOnly || $process_action_material->packing->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_packing" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material->packing->displayValueSeparatorAttribute() ?>" name="x_packing" id="x_packing" value="<?php echo HtmlEncode($process_action_material->packing->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialadd.createAutoSuggest({"id":"x_packing","forceSelect":true});
</script>
<?php echo $process_action_material->packing->Lookup->getParamTag("p_x_packing") ?>
</span>
<?php echo $process_action_material->packing->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_2->Visible) { // rid_2 ?>
	<div id="r_rid_2" class="form-group row">
		<label id="elh_process_action_material_rid_2" for="x_rid_2" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->rid_2->caption() ?><?php echo ($process_action_material->rid_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->rid_2->cellAttributes() ?>>
<span id="el_process_action_material_rid_2">
<?php $process_action_material->rid_2->EditAttrs["onchange"] = "ew.autoFill(this);" . @$process_action_material->rid_2->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_2"><?php echo strval($process_action_material->rid_2->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_material->rid_2->ViewValue) : $process_action_material->rid_2->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material->rid_2->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material->rid_2->ReadOnly || $process_action_material->rid_2->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_2',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_material->rid_2->Lookup->getParamTag("p_x_rid_2") ?>
<input type="hidden" data-table="process_action_material" data-field="x_rid_2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material->rid_2->displayValueSeparatorAttribute() ?>" name="x_rid_2" id="x_rid_2" value="<?php echo $process_action_material->rid_2->CurrentValue ?>"<?php echo $process_action_material->rid_2->editAttributes() ?>>
</span>
<?php echo $process_action_material->rid_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_process_action_material_rid" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->rid->caption() ?><?php echo ($process_action_material->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->rid->cellAttributes() ?>>
<span id="el_process_action_material_rid">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$process_action_material->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($process_action_material->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>"<?php echo $process_action_material->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_rid" data-value-separator="<?php echo $process_action_material->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($process_action_material->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialadd.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $process_action_material->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $process_action_material->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_process_action_material_godown" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->godown->caption() ?><?php echo ($process_action_material->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->godown->cellAttributes() ?>>
<span id="el_process_action_material_godown">
<?php
$wrkonchange = "" . trim(@$process_action_material->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8860">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($process_action_material->godown->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->godown->getPlaceHolder()) ?>"<?php echo $process_action_material->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_godown" data-value-separator="<?php echo $process_action_material->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($process_action_material->godown->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialadd.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $process_action_material->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $process_action_material->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label id="elh_process_action_material_avg_quantity" for="x_avg_quantity" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->avg_quantity->caption() ?><?php echo ($process_action_material->avg_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->avg_quantity->cellAttributes() ?>>
<span id="el_process_action_material_avg_quantity">
<input type="text" data-table="process_action_material" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($process_action_material->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $process_action_material->avg_quantity->EditValue ?>"<?php echo $process_action_material->avg_quantity->editAttributes() ?>>
</span>
<?php echo $process_action_material->avg_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_process_action_material_lot_no" for="x_lot_no" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->lot_no->caption() ?><?php echo ($process_action_material->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->lot_no->cellAttributes() ?>>
<span id="el_process_action_material_lot_no">
<input type="text" data-table="process_action_material" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($process_action_material->lot_no->getPlaceHolder()) ?>" value="<?php echo $process_action_material->lot_no->EditValue ?>"<?php echo $process_action_material->lot_no->editAttributes() ?>>
</span>
<?php echo $process_action_material->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->avialable_qty->Visible) { // avialable_qty ?>
	<div id="r_avialable_qty" class="form-group row">
		<label id="elh_process_action_material_avialable_qty" for="x_avialable_qty" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->avialable_qty->caption() ?><?php echo ($process_action_material->avialable_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->avialable_qty->cellAttributes() ?>>
<span id="el_process_action_material_avialable_qty">
<input type="text" data-table="process_action_material" data-field="x_avialable_qty" name="x_avialable_qty" id="x_avialable_qty" size="30" placeholder="<?php echo HtmlEncode($process_action_material->avialable_qty->getPlaceHolder()) ?>" value="<?php echo $process_action_material->avialable_qty->EditValue ?>"<?php echo $process_action_material->avialable_qty->editAttributes() ?>>
</span>
<?php echo $process_action_material->avialable_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->ply->Visible) { // ply ?>
	<div id="r_ply" class="form-group row">
		<label id="elh_process_action_material_ply" for="x_ply" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->ply->caption() ?><?php echo ($process_action_material->ply->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->ply->cellAttributes() ?>>
<span id="el_process_action_material_ply">
<input type="text" data-table="process_action_material" data-field="x_ply" name="x_ply" id="x_ply" size="30" placeholder="<?php echo HtmlEncode($process_action_material->ply->getPlaceHolder()) ?>" value="<?php echo $process_action_material->ply->EditValue ?>"<?php echo $process_action_material->ply->editAttributes() ?>>
</span>
<?php echo $process_action_material->ply->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_new->Visible) { // rid_new ?>
	<div id="r_rid_new" class="form-group row">
		<label id="elh_process_action_material_rid_new" for="x_rid_new" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->rid_new->caption() ?><?php echo ($process_action_material->rid_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->rid_new->cellAttributes() ?>>
<span id="el_process_action_material_rid_new">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_rid_new" data-value-separator="<?php echo $process_action_material->rid_new->displayValueSeparatorAttribute() ?>" id="x_rid_new" name="x_rid_new"<?php echo $process_action_material->rid_new->editAttributes() ?>>
		<?php echo $process_action_material->rid_new->selectOptionListHtml("x_rid_new") ?>
	</select>
</div>
<?php echo $process_action_material->rid_new->Lookup->getParamTag("p_x_rid_new") ?>
</span>
<?php echo $process_action_material->rid_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
	<div id="r_rid_new_lot_no" class="form-group row">
		<label id="elh_process_action_material_rid_new_lot_no" for="x_rid_new_lot_no" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->rid_new_lot_no->caption() ?><?php echo ($process_action_material->rid_new_lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->rid_new_lot_no->cellAttributes() ?>>
<span id="el_process_action_material_rid_new_lot_no">
<input type="text" data-table="process_action_material" data-field="x_rid_new_lot_no" name="x_rid_new_lot_no" id="x_rid_new_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action_material->rid_new_lot_no->getPlaceHolder()) ?>" value="<?php echo $process_action_material->rid_new_lot_no->EditValue ?>"<?php echo $process_action_material->rid_new_lot_no->editAttributes() ?>>
</span>
<?php echo $process_action_material->rid_new_lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid_new->Visible) { // poid_new ?>
	<div id="r_poid_new" class="form-group row">
		<label id="elh_process_action_material_poid_new" for="x_poid_new" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->poid_new->caption() ?><?php echo ($process_action_material->poid_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->poid_new->cellAttributes() ?>>
<span id="el_process_action_material_poid_new">
<input type="text" data-table="process_action_material" data-field="x_poid_new" name="x_poid_new" id="x_poid_new" placeholder="<?php echo HtmlEncode($process_action_material->poid_new->getPlaceHolder()) ?>" value="<?php echo $process_action_material->poid_new->EditValue ?>"<?php echo $process_action_material->poid_new->editAttributes() ?>>
</span>
<?php echo $process_action_material->poid_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid_1->Visible) { // poid_1 ?>
	<div id="r_poid_1" class="form-group row">
		<label id="elh_process_action_material_poid_1" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->poid_1->caption() ?><?php echo ($process_action_material->poid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->poid_1->cellAttributes() ?>>
<span id="el_process_action_material_poid_1">
<div id="tp_x_poid_1" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material" data-field="x_poid_1" data-value-separator="<?php echo $process_action_material->poid_1->displayValueSeparatorAttribute() ?>" name="x_poid_1[]" id="x_poid_1[]" value="{value}"<?php echo $process_action_material->poid_1->editAttributes() ?>></div>
<div id="dsl_x_poid_1" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $process_action_material->poid_1->checkBoxListHtml(FALSE, "x_poid_1[]") ?>
</div></div>
<?php echo $process_action_material->poid_1->Lookup->getParamTag("p_x_poid_1") ?>
</span>
<?php echo $process_action_material->poid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label id="elh_process_action_material_poid" for="x_poid" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->poid->caption() ?><?php echo ($process_action_material->poid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->poid->cellAttributes() ?>>
<span id="el_process_action_material_poid">
<input type="text" data-table="process_action_material" data-field="x_poid" name="x_poid" id="x_poid" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($process_action_material->poid->getPlaceHolder()) ?>" value="<?php echo $process_action_material->poid->EditValue ?>"<?php echo $process_action_material->poid->editAttributes() ?>>
</span>
<?php echo $process_action_material->poid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_process_action_material_quantity" for="x_quantity" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->quantity->caption() ?><?php echo ($process_action_material->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->quantity->cellAttributes() ?>>
<span id="el_process_action_material_quantity">
<input type="text" data-table="process_action_material" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_action_material->quantity->getPlaceHolder()) ?>" value="<?php echo $process_action_material->quantity->EditValue ?>"<?php echo $process_action_material->quantity->editAttributes() ?>>
</span>
<?php echo $process_action_material->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_process_action_material_packets" for="x_packets" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->packets->caption() ?><?php echo ($process_action_material->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->packets->cellAttributes() ?>>
<span id="el_process_action_material_packets">
<input type="text" data-table="process_action_material" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_action_material->packets->getPlaceHolder()) ?>" value="<?php echo $process_action_material->packets->EditValue ?>"<?php echo $process_action_material->packets->editAttributes() ?>>
</span>
<?php echo $process_action_material->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->process_method->Visible) { // process_method ?>
	<div id="r_process_method" class="form-group row">
		<label id="elh_process_action_material_process_method" for="x_process_method" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->process_method->caption() ?><?php echo ($process_action_material->process_method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->process_method->cellAttributes() ?>>
<span id="el_process_action_material_process_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_process_method" data-value-separator="<?php echo $process_action_material->process_method->displayValueSeparatorAttribute() ?>" id="x_process_method" name="x_process_method"<?php echo $process_action_material->process_method->editAttributes() ?>>
		<?php echo $process_action_material->process_method->selectOptionListHtml("x_process_method") ?>
	</select>
</div>
</span>
<?php echo $process_action_material->process_method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label id="elh_process_action_material_remark" for="x_remark" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->remark->caption() ?><?php echo ($process_action_material->remark->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->remark->cellAttributes() ?>>
<span id="el_process_action_material_remark">
<input type="text" data-table="process_action_material" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action_material->remark->getPlaceHolder()) ?>" value="<?php echo $process_action_material->remark->EditValue ?>"<?php echo $process_action_material->remark->editAttributes() ?>>
</span>
<?php echo $process_action_material->remark->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_process_action_material_dated" for="x_dated" class="<?php echo $process_action_material_add->LeftColumnClass ?>"><?php echo $process_action_material->dated->caption() ?><?php echo ($process_action_material->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $process_action_material_add->RightColumnClass ?>"><div<?php echo $process_action_material->dated->cellAttributes() ?>>
<span id="el_process_action_material_dated">
<input type="text" data-table="process_action_material" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_action_material->dated->getPlaceHolder()) ?>" value="<?php echo $process_action_material->dated->EditValue ?>"<?php echo $process_action_material->dated->editAttributes() ?>>
<?php if (!$process_action_material->dated->ReadOnly && !$process_action_material->dated->Disabled && !isset($process_action_material->dated->EditAttrs["readonly"]) && !isset($process_action_material->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materialadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $process_action_material->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_material_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_material_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $process_action_material_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_material_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

			$("#r_ply").hide();
			$("#r_rid_new").hide();
			$("#r_poid_new").hide();
			$("#r_poid_1").hide();
			$("#r_rid_new_lot_no").hide();
var PROC =  getCookie("PROC");
		if (PROC == 69)
		{
			$("#r_rid_new").show();
			$("#r_rid_new_lot_no").show();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$process_action_material_add->terminate();
?>