<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_material_list = new process_action_material_list();

// Run the page
$process_action_material_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_material_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_material->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_materiallist = currentForm = new ew.Form("fprocess_action_materiallist", "list");
fprocess_action_materiallist.formKeyCountName = '<?php echo $process_action_material_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_materiallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_materiallist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_materiallist.lists["x_site"] = <?php echo $process_action_material_list->site->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_site"].options = <?php echo JsonEncode($process_action_material_list->site->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_process"] = <?php echo $process_action_material_list->process->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_process"].options = <?php echo JsonEncode($process_action_material_list->process->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_sub_process"] = <?php echo $process_action_material_list->sub_process->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_sub_process"].options = <?php echo JsonEncode($process_action_material_list->sub_process->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_emp_name"] = <?php echo $process_action_material_list->emp_name->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_emp_name"].options = <?php echo JsonEncode($process_action_material_list->emp_name->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_jc_no"] = <?php echo $process_action_material_list->jc_no->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_jc_no"].options = <?php echo JsonEncode($process_action_material_list->jc_no->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_packing"] = <?php echo $process_action_material_list->packing->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_packing"].options = <?php echo JsonEncode($process_action_material_list->packing->lookupOptions()) ?>;
fprocess_action_materiallist.autoSuggests["x_packing"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materiallist.lists["x_rid"] = <?php echo $process_action_material_list->rid->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_list->rid->lookupOptions()) ?>;
fprocess_action_materiallist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materiallist.lists["x_rid_new"] = <?php echo $process_action_material_list->rid_new->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_rid_new"].options = <?php echo JsonEncode($process_action_material_list->rid_new->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_process_method"] = <?php echo $process_action_material_list->process_method->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_process_method"].options = <?php echo JsonEncode($process_action_material_list->process_method->options(FALSE, TRUE)) ?>;
fprocess_action_materiallist.lists["x_payment"] = <?php echo $process_action_material_list->payment->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_payment"].options = <?php echo JsonEncode($process_action_material_list->payment->lookupOptions()) ?>;
fprocess_action_materiallist.lists["x_opeartor"] = <?php echo $process_action_material_list->opeartor->Lookup->toClientList() ?>;
fprocess_action_materiallist.lists["x_opeartor"].options = <?php echo JsonEncode($process_action_material_list->opeartor->lookupOptions()) ?>;
fprocess_action_materiallist.autoSuggests["x_opeartor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fprocess_action_materiallistsrch = currentSearchForm = new ew.Form("fprocess_action_materiallistsrch");

// Validate function for search
fprocess_action_materiallistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_materiallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_materiallistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_materiallistsrch.lists["x_site"] = <?php echo $process_action_material_list->site->Lookup->toClientList() ?>;
fprocess_action_materiallistsrch.lists["x_site"].options = <?php echo JsonEncode($process_action_material_list->site->lookupOptions()) ?>;
fprocess_action_materiallistsrch.lists["x_process"] = <?php echo $process_action_material_list->process->Lookup->toClientList() ?>;
fprocess_action_materiallistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_material_list->process->lookupOptions()) ?>;
fprocess_action_materiallistsrch.lists["x_rid"] = <?php echo $process_action_material_list->rid->Lookup->toClientList() ?>;
fprocess_action_materiallistsrch.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_list->rid->lookupOptions()) ?>;
fprocess_action_materiallistsrch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materiallistsrch.lists["x_payment"] = <?php echo $process_action_material_list->payment->Lookup->toClientList() ?>;
fprocess_action_materiallistsrch.lists["x_payment"].options = <?php echo JsonEncode($process_action_material_list->payment->lookupOptions()) ?>;

// Filters
fprocess_action_materiallistsrch.filterList = <?php echo $process_action_material_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_materiallistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_material->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_material_list->TotalRecs > 0 && $process_action_material_list->ExportOptions->visible()) { ?>
<?php $process_action_material_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_list->ImportOptions->visible()) { ?>
<?php $process_action_material_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_list->SearchOptions->visible()) { ?>
<?php $process_action_material_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_material_list->FilterOptions->visible()) { ?>
<?php $process_action_material_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_material_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_material->isExport() && !$process_action_material->CurrentAction) { ?>
<form name="fprocess_action_materiallistsrch" id="fprocess_action_materiallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_material_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_materiallistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_material">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_material_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_material->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_material->resetAttributes();
$process_action_material_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_material->site->Visible) { // site ?>
	<div id="xsc_site" class="ew-cell form-group">
		<label for="x_site" class="ew-search-caption ew-label"><?php echo $process_action_material->site->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_site" id="z_site" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_site" data-value-separator="<?php echo $process_action_material->site->displayValueSeparatorAttribute() ?>" id="x_site" name="x_site"<?php echo $process_action_material->site->editAttributes() ?>>
		<?php echo $process_action_material->site->selectOptionListHtml("x_site") ?>
	</select>
</div>
<?php echo $process_action_material->site->Lookup->getParamTag("p_x_site") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action_material->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_process" data-value-separator="<?php echo $process_action_material->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_material->process->editAttributes() ?>>
		<?php echo $process_action_material->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_material->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_material->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$process_action_material->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($process_action_material->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>"<?php echo $process_action_material->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_rid" data-value-separator="<?php echo $process_action_material->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($process_action_material->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materiallistsrch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $process_action_material->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action_material->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label for="x_payment" class="ew-search-caption ew-label"><?php echo $process_action_material->payment->caption() ?></label>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_payment" data-value-separator="<?php echo $process_action_material->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $process_action_material->payment->editAttributes() ?>>
		<?php echo $process_action_material->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $process_action_material->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
		<span class="ew-search-cond btw1_payment style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_payment style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_payment" data-value-separator="<?php echo $process_action_material->payment->displayValueSeparatorAttribute() ?>" id="y_payment" name="y_payment"<?php echo $process_action_material->payment->editAttributes() ?>>
		<?php echo $process_action_material->payment->selectOptionListHtml("y_payment") ?>
	</select>
</div>
<?php echo $process_action_material->payment->Lookup->getParamTag("p_y_payment") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_material->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $process_action_material->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_material" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_material->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_material->datetime->EditValue ?>"<?php echo $process_action_material->datetime->editAttributes() ?>>
<?php if (!$process_action_material->datetime->ReadOnly && !$process_action_material->datetime->Disabled && !isset($process_action_material->datetime->EditAttrs["readonly"]) && !isset($process_action_material->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materiallistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="process_action_material" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_material->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_material->datetime->EditValue2 ?>"<?php echo $process_action_material->datetime->editAttributes() ?>>
<?php if (!$process_action_material->datetime->ReadOnly && !$process_action_material->datetime->Disabled && !isset($process_action_material->datetime->EditAttrs["readonly"]) && !isset($process_action_material->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materiallistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_material_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_material_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_material_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_material_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_material_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_material_list->showPageHeader(); ?>
<?php
$process_action_material_list->showMessage();
?>
<?php if ($process_action_material_list->TotalRecs > 0 || $process_action_material->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_material_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_material">
<?php if (!$process_action_material->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_material_list->Pager)) $process_action_material_list->Pager = new PrevNextPager($process_action_material_list->StartRec, $process_action_material_list->DisplayRecs, $process_action_material_list->TotalRecs, $process_action_material_list->AutoHidePager) ?>
<?php if ($process_action_material_list->Pager->RecordCount > 0 && $process_action_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_material_list->TotalRecs > 0 && (!$process_action_material_list->AutoHidePageSizeSelector || $process_action_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_materiallist" id="fprocess_action_materiallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_material_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_material_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_material">
<div id="gmp_process_action_material" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_material_list->TotalRecs > 0 || $process_action_material->isGridEdit()) { ?>
<table id="tbl_process_action_materiallist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_material_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_material_list->renderListOptions();

// Render list options (header, left)
$process_action_material_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_material->id->Visible) { // id ?>
	<?php if ($process_action_material->sortUrl($process_action_material->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_material->id->headerCellClass() ?>"><div id="elh_process_action_material_id" class="process_action_material_id"><div class="ew-table-header-caption"><?php echo $process_action_material->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_material->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->id) ?>',2);"><div id="elh_process_action_material_id" class="process_action_material_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->site->Visible) { // site ?>
	<?php if ($process_action_material->sortUrl($process_action_material->site) == "") { ?>
		<th data-name="site" class="<?php echo $process_action_material->site->headerCellClass() ?>"><div id="elh_process_action_material_site" class="process_action_material_site"><div class="ew-table-header-caption"><?php echo $process_action_material->site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="site" class="<?php echo $process_action_material->site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->site) ?>',2);"><div id="elh_process_action_material_site" class="process_action_material_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->site->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->process->Visible) { // process ?>
	<?php if ($process_action_material->sortUrl($process_action_material->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_material->process->headerCellClass() ?>"><div id="elh_process_action_material_process" class="process_action_material_process"><div class="ew-table-header-caption"><?php echo $process_action_material->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_material->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->process) ?>',2);"><div id="elh_process_action_material_process" class="process_action_material_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->sub_process->Visible) { // sub_process ?>
	<?php if ($process_action_material->sortUrl($process_action_material->sub_process) == "") { ?>
		<th data-name="sub_process" class="<?php echo $process_action_material->sub_process->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_sub_process" class="process_action_material_sub_process"><div class="ew-table-header-caption"><?php echo $process_action_material->sub_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_process" class="<?php echo $process_action_material->sub_process->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->sub_process) ?>',2);"><div id="elh_process_action_material_sub_process" class="process_action_material_sub_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->sub_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->sub_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->sub_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->emp_name->Visible) { // emp_name ?>
	<?php if ($process_action_material->sortUrl($process_action_material->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $process_action_material->emp_name->headerCellClass() ?>"><div id="elh_process_action_material_emp_name" class="process_action_material_emp_name"><div class="ew-table-header-caption"><?php echo $process_action_material->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $process_action_material->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->emp_name) ?>',2);"><div id="elh_process_action_material_emp_name" class="process_action_material_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->emp_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->jc_no->Visible) { // jc_no ?>
	<?php if ($process_action_material->sortUrl($process_action_material->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $process_action_material->jc_no->headerCellClass() ?>"><div id="elh_process_action_material_jc_no" class="process_action_material_jc_no"><div class="ew-table-header-caption"><?php echo $process_action_material->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $process_action_material->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->jc_no) ?>',2);"><div id="elh_process_action_material_jc_no" class="process_action_material_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->packing->Visible) { // packing ?>
	<?php if ($process_action_material->sortUrl($process_action_material->packing) == "") { ?>
		<th data-name="packing" class="<?php echo $process_action_material->packing->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_packing" class="process_action_material_packing"><div class="ew-table-header-caption"><?php echo $process_action_material->packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing" class="<?php echo $process_action_material->packing->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->packing) ?>',2);"><div id="elh_process_action_material_packing" class="process_action_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->packing->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->rid->Visible) { // rid ?>
	<?php if ($process_action_material->sortUrl($process_action_material->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $process_action_material->rid->headerCellClass() ?>"><div id="elh_process_action_material_rid" class="process_action_material_rid"><div class="ew-table-header-caption"><?php echo $process_action_material->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $process_action_material->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->rid) ?>',2);"><div id="elh_process_action_material_rid" class="process_action_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($process_action_material->sortUrl($process_action_material->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $process_action_material->avg_quantity->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_avg_quantity" class="process_action_material_avg_quantity"><div class="ew-table-header-caption"><?php echo $process_action_material->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $process_action_material->avg_quantity->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->avg_quantity) ?>',2);"><div id="elh_process_action_material_avg_quantity" class="process_action_material_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->avg_quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->lot_no->Visible) { // lot_no ?>
	<?php if ($process_action_material->sortUrl($process_action_material->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $process_action_material->lot_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_lot_no" class="process_action_material_lot_no"><div class="ew-table-header-caption"><?php echo $process_action_material->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $process_action_material->lot_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->lot_no) ?>',2);"><div id="elh_process_action_material_lot_no" class="process_action_material_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->avialable_qty->Visible) { // avialable_qty ?>
	<?php if ($process_action_material->sortUrl($process_action_material->avialable_qty) == "") { ?>
		<th data-name="avialable_qty" class="<?php echo $process_action_material->avialable_qty->headerCellClass() ?>"><div id="elh_process_action_material_avialable_qty" class="process_action_material_avialable_qty"><div class="ew-table-header-caption"><?php echo $process_action_material->avialable_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avialable_qty" class="<?php echo $process_action_material->avialable_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->avialable_qty) ?>',2);"><div id="elh_process_action_material_avialable_qty" class="process_action_material_avialable_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->avialable_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->avialable_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->avialable_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->ply->Visible) { // ply ?>
	<?php if ($process_action_material->sortUrl($process_action_material->ply) == "") { ?>
		<th data-name="ply" class="<?php echo $process_action_material->ply->headerCellClass() ?>"><div id="elh_process_action_material_ply" class="process_action_material_ply"><div class="ew-table-header-caption"><?php echo $process_action_material->ply->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply" class="<?php echo $process_action_material->ply->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->ply) ?>',2);"><div id="elh_process_action_material_ply" class="process_action_material_ply">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->ply->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->ply->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->ply->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->rid_new->Visible) { // rid_new ?>
	<?php if ($process_action_material->sortUrl($process_action_material->rid_new) == "") { ?>
		<th data-name="rid_new" class="<?php echo $process_action_material->rid_new->headerCellClass() ?>"><div id="elh_process_action_material_rid_new" class="process_action_material_rid_new"><div class="ew-table-header-caption"><?php echo $process_action_material->rid_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid_new" class="<?php echo $process_action_material->rid_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->rid_new) ?>',2);"><div id="elh_process_action_material_rid_new" class="process_action_material_rid_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->rid_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->rid_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->rid_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
	<?php if ($process_action_material->sortUrl($process_action_material->rid_new_lot_no) == "") { ?>
		<th data-name="rid_new_lot_no" class="<?php echo $process_action_material->rid_new_lot_no->headerCellClass() ?>"><div id="elh_process_action_material_rid_new_lot_no" class="process_action_material_rid_new_lot_no"><div class="ew-table-header-caption"><?php echo $process_action_material->rid_new_lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid_new_lot_no" class="<?php echo $process_action_material->rid_new_lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->rid_new_lot_no) ?>',2);"><div id="elh_process_action_material_rid_new_lot_no" class="process_action_material_rid_new_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->rid_new_lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->rid_new_lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->rid_new_lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->poid->Visible) { // poid ?>
	<?php if ($process_action_material->sortUrl($process_action_material->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $process_action_material->poid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_poid" class="process_action_material_poid"><div class="ew-table-header-caption"><?php echo $process_action_material->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $process_action_material->poid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->poid) ?>',2);"><div id="elh_process_action_material_poid" class="process_action_material_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->poid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->quantity->Visible) { // quantity ?>
	<?php if ($process_action_material->sortUrl($process_action_material->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $process_action_material->quantity->headerCellClass() ?>"><div id="elh_process_action_material_quantity" class="process_action_material_quantity"><div class="ew-table-header-caption"><?php echo $process_action_material->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $process_action_material->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->quantity) ?>',2);"><div id="elh_process_action_material_quantity" class="process_action_material_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->packets->Visible) { // packets ?>
	<?php if ($process_action_material->sortUrl($process_action_material->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $process_action_material->packets->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_packets" class="process_action_material_packets"><div class="ew-table-header-caption"><?php echo $process_action_material->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $process_action_material->packets->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->packets) ?>',2);"><div id="elh_process_action_material_packets" class="process_action_material_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->process_method->Visible) { // process_method ?>
	<?php if ($process_action_material->sortUrl($process_action_material->process_method) == "") { ?>
		<th data-name="process_method" class="<?php echo $process_action_material->process_method->headerCellClass() ?>"><div id="elh_process_action_material_process_method" class="process_action_material_process_method"><div class="ew-table-header-caption"><?php echo $process_action_material->process_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_method" class="<?php echo $process_action_material->process_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->process_method) ?>',2);"><div id="elh_process_action_material_process_method" class="process_action_material_process_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->process_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->process_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->process_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->payment->Visible) { // payment ?>
	<?php if ($process_action_material->sortUrl($process_action_material->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_material->payment->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_process_action_material_payment" class="process_action_material_payment"><div class="ew-table-header-caption"><?php echo $process_action_material->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_material->payment->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->payment) ?>',2);"><div id="elh_process_action_material_payment" class="process_action_material_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->dated->Visible) { // dated ?>
	<?php if ($process_action_material->sortUrl($process_action_material->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $process_action_material->dated->headerCellClass() ?>"><div id="elh_process_action_material_dated" class="process_action_material_dated"><div class="ew-table-header-caption"><?php echo $process_action_material->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $process_action_material->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->dated) ?>',2);"><div id="elh_process_action_material_dated" class="process_action_material_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->opeartor->Visible) { // opeartor ?>
	<?php if ($process_action_material->sortUrl($process_action_material->opeartor) == "") { ?>
		<th data-name="opeartor" class="<?php echo $process_action_material->opeartor->headerCellClass() ?>"><div id="elh_process_action_material_opeartor" class="process_action_material_opeartor"><div class="ew-table-header-caption"><?php echo $process_action_material->opeartor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="opeartor" class="<?php echo $process_action_material->opeartor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->opeartor) ?>',2);"><div id="elh_process_action_material_opeartor" class="process_action_material_opeartor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->opeartor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->opeartor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->opeartor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_material->datetime->Visible) { // datetime ?>
	<?php if ($process_action_material->sortUrl($process_action_material->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_material->datetime->headerCellClass() ?>"><div id="elh_process_action_material_datetime" class="process_action_material_datetime"><div class="ew-table-header-caption"><?php echo $process_action_material->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_material->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_material->SortUrl($process_action_material->datetime) ?>',2);"><div id="elh_process_action_material_datetime" class="process_action_material_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_material->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_material->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_material->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_material_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_material->ExportAll && $process_action_material->isExport()) {
	$process_action_material_list->StopRec = $process_action_material_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_material_list->TotalRecs > $process_action_material_list->StartRec + $process_action_material_list->DisplayRecs - 1)
		$process_action_material_list->StopRec = $process_action_material_list->StartRec + $process_action_material_list->DisplayRecs - 1;
	else
		$process_action_material_list->StopRec = $process_action_material_list->TotalRecs;
}
$process_action_material_list->RecCnt = $process_action_material_list->StartRec - 1;
if ($process_action_material_list->Recordset && !$process_action_material_list->Recordset->EOF) {
	$process_action_material_list->Recordset->moveFirst();
	$selectLimit = $process_action_material_list->UseSelectLimit;
	if (!$selectLimit && $process_action_material_list->StartRec > 1)
		$process_action_material_list->Recordset->move($process_action_material_list->StartRec - 1);
} elseif (!$process_action_material->AllowAddDeleteRow && $process_action_material_list->StopRec == 0) {
	$process_action_material_list->StopRec = $process_action_material->GridAddRowCount;
}

// Initialize aggregate
$process_action_material->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_material->resetAttributes();
$process_action_material_list->renderRow();
while ($process_action_material_list->RecCnt < $process_action_material_list->StopRec) {
	$process_action_material_list->RecCnt++;
	if ($process_action_material_list->RecCnt >= $process_action_material_list->StartRec) {
		$process_action_material_list->RowCnt++;

		// Set up key count
		$process_action_material_list->KeyCount = $process_action_material_list->RowIndex;

		// Init row class and style
		$process_action_material->resetAttributes();
		$process_action_material->CssClass = "";
		if ($process_action_material->isGridAdd()) {
		} else {
			$process_action_material_list->loadRowValues($process_action_material_list->Recordset); // Load row values
		}
		$process_action_material->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_material->RowAttrs = array_merge($process_action_material->RowAttrs, array('data-rowindex'=>$process_action_material_list->RowCnt, 'id'=>'r' . $process_action_material_list->RowCnt . '_process_action_material', 'data-rowtype'=>$process_action_material->RowType));

		// Render row
		$process_action_material_list->renderRow();

		// Render list options
		$process_action_material_list->renderListOptions();
?>
	<tr<?php echo $process_action_material->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_material_list->ListOptions->render("body", "left", $process_action_material_list->RowCnt);
?>
	<?php if ($process_action_material->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_material->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_id" class="process_action_material_id">
<span<?php echo $process_action_material->id->viewAttributes() ?>>
<?php echo $process_action_material->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->site->Visible) { // site ?>
		<td data-name="site"<?php echo $process_action_material->site->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_site" class="process_action_material_site">
<span<?php echo $process_action_material->site->viewAttributes() ?>>
<?php echo $process_action_material->site->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_material->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_process" class="process_action_material_process">
<span<?php echo $process_action_material->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_material->process->getViewValue())) && $process_action_material->process->linkAttributes() <> "") { ?>
<a<?php echo $process_action_material->process->linkAttributes() ?>><?php echo $process_action_material->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_material->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->sub_process->Visible) { // sub_process ?>
		<td data-name="sub_process"<?php echo $process_action_material->sub_process->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_sub_process" class="process_action_material_sub_process">
<span<?php echo $process_action_material->sub_process->viewAttributes() ?>>
<?php echo $process_action_material->sub_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $process_action_material->emp_name->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_emp_name" class="process_action_material_emp_name">
<span<?php echo $process_action_material->emp_name->viewAttributes() ?>>
<?php echo $process_action_material->emp_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $process_action_material->jc_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_jc_no" class="process_action_material_jc_no">
<span<?php echo $process_action_material->jc_no->viewAttributes() ?>>
<?php echo $process_action_material->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->packing->Visible) { // packing ?>
		<td data-name="packing"<?php echo $process_action_material->packing->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_packing" class="process_action_material_packing">
<span<?php echo $process_action_material->packing->viewAttributes() ?>>
<?php echo $process_action_material->packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $process_action_material->rid->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_rid" class="process_action_material_rid">
<span<?php echo $process_action_material->rid->viewAttributes() ?>>
<?php echo $process_action_material->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $process_action_material->avg_quantity->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_avg_quantity" class="process_action_material_avg_quantity">
<span<?php echo $process_action_material->avg_quantity->viewAttributes() ?>>
<?php echo $process_action_material->avg_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $process_action_material->lot_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_lot_no" class="process_action_material_lot_no">
<span<?php echo $process_action_material->lot_no->viewAttributes() ?>>
<?php echo $process_action_material->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->avialable_qty->Visible) { // avialable_qty ?>
		<td data-name="avialable_qty"<?php echo $process_action_material->avialable_qty->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_avialable_qty" class="process_action_material_avialable_qty">
<span<?php echo $process_action_material->avialable_qty->viewAttributes() ?>>
<?php echo $process_action_material->avialable_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->ply->Visible) { // ply ?>
		<td data-name="ply"<?php echo $process_action_material->ply->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_ply" class="process_action_material_ply">
<span<?php echo $process_action_material->ply->viewAttributes() ?>>
<?php echo $process_action_material->ply->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->rid_new->Visible) { // rid_new ?>
		<td data-name="rid_new"<?php echo $process_action_material->rid_new->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_rid_new" class="process_action_material_rid_new">
<span<?php echo $process_action_material->rid_new->viewAttributes() ?>>
<?php echo $process_action_material->rid_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
		<td data-name="rid_new_lot_no"<?php echo $process_action_material->rid_new_lot_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_rid_new_lot_no" class="process_action_material_rid_new_lot_no">
<span<?php echo $process_action_material->rid_new_lot_no->viewAttributes() ?>>
<?php echo $process_action_material->rid_new_lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $process_action_material->poid->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_poid" class="process_action_material_poid">
<span<?php echo $process_action_material->poid->viewAttributes() ?>>
<?php echo $process_action_material->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $process_action_material->quantity->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_quantity" class="process_action_material_quantity">
<span<?php echo $process_action_material->quantity->viewAttributes() ?>>
<?php echo $process_action_material->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $process_action_material->packets->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_packets" class="process_action_material_packets">
<span<?php echo $process_action_material->packets->viewAttributes() ?>>
<?php echo $process_action_material->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->process_method->Visible) { // process_method ?>
		<td data-name="process_method"<?php echo $process_action_material->process_method->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_process_method" class="process_action_material_process_method">
<span<?php echo $process_action_material->process_method->viewAttributes() ?>>
<?php echo $process_action_material->process_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_material->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_payment" class="process_action_material_payment">
<span<?php echo $process_action_material->payment->viewAttributes() ?>>
<?php echo $process_action_material->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $process_action_material->dated->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_dated" class="process_action_material_dated">
<span<?php echo $process_action_material->dated->viewAttributes() ?>>
<?php echo $process_action_material->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->opeartor->Visible) { // opeartor ?>
		<td data-name="opeartor"<?php echo $process_action_material->opeartor->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_opeartor" class="process_action_material_opeartor">
<span<?php echo $process_action_material->opeartor->viewAttributes() ?>>
<?php echo $process_action_material->opeartor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_material->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_material->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_material_list->RowCnt ?>_process_action_material_datetime" class="process_action_material_datetime">
<span<?php echo $process_action_material->datetime->viewAttributes() ?>>
<?php echo $process_action_material->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_material_list->ListOptions->render("body", "right", $process_action_material_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_material->isGridAdd())
		$process_action_material_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_action_material->RowType = ROWTYPE_AGGREGATE;
$process_action_material->resetAttributes();
$process_action_material_list->renderRow();
?>
<?php if ($process_action_material_list->TotalRecs > 0 && !$process_action_material->isGridAdd() && !$process_action_material->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_action_material_list->renderListOptions();

// Render list options (footer, left)
$process_action_material_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_action_material->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $process_action_material->id->footerCellClass() ?>"><span id="elf_process_action_material_id" class="process_action_material_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->site->Visible) { // site ?>
		<td data-name="site" class="<?php echo $process_action_material->site->footerCellClass() ?>"><span id="elf_process_action_material_site" class="process_action_material_site">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $process_action_material->process->footerCellClass() ?>"><span id="elf_process_action_material_process" class="process_action_material_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->sub_process->Visible) { // sub_process ?>
		<td data-name="sub_process" class="<?php echo $process_action_material->sub_process->footerCellClass() ?>"><span id="elf_process_action_material_sub_process" class="process_action_material_sub_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name" class="<?php echo $process_action_material->emp_name->footerCellClass() ?>"><span id="elf_process_action_material_emp_name" class="process_action_material_emp_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $process_action_material->jc_no->footerCellClass() ?>"><span id="elf_process_action_material_jc_no" class="process_action_material_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->packing->Visible) { // packing ?>
		<td data-name="packing" class="<?php echo $process_action_material->packing->footerCellClass() ?>"><span id="elf_process_action_material_packing" class="process_action_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $process_action_material->rid->footerCellClass() ?>"><span id="elf_process_action_material_rid" class="process_action_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity" class="<?php echo $process_action_material->avg_quantity->footerCellClass() ?>"><span id="elf_process_action_material_avg_quantity" class="process_action_material_avg_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $process_action_material->lot_no->footerCellClass() ?>"><span id="elf_process_action_material_lot_no" class="process_action_material_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->avialable_qty->Visible) { // avialable_qty ?>
		<td data-name="avialable_qty" class="<?php echo $process_action_material->avialable_qty->footerCellClass() ?>"><span id="elf_process_action_material_avialable_qty" class="process_action_material_avialable_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->ply->Visible) { // ply ?>
		<td data-name="ply" class="<?php echo $process_action_material->ply->footerCellClass() ?>"><span id="elf_process_action_material_ply" class="process_action_material_ply">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->rid_new->Visible) { // rid_new ?>
		<td data-name="rid_new" class="<?php echo $process_action_material->rid_new->footerCellClass() ?>"><span id="elf_process_action_material_rid_new" class="process_action_material_rid_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
		<td data-name="rid_new_lot_no" class="<?php echo $process_action_material->rid_new_lot_no->footerCellClass() ?>"><span id="elf_process_action_material_rid_new_lot_no" class="process_action_material_rid_new_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->poid->Visible) { // poid ?>
		<td data-name="poid" class="<?php echo $process_action_material->poid->footerCellClass() ?>"><span id="elf_process_action_material_poid" class="process_action_material_poid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $process_action_material->quantity->footerCellClass() ?>"><span id="elf_process_action_material_quantity" class="process_action_material_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_material->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $process_action_material->packets->footerCellClass() ?>"><span id="elf_process_action_material_packets" class="process_action_material_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->process_method->Visible) { // process_method ?>
		<td data-name="process_method" class="<?php echo $process_action_material->process_method->footerCellClass() ?>"><span id="elf_process_action_material_process_method" class="process_action_material_process_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_action_material->payment->footerCellClass() ?>"><span id="elf_process_action_material_payment" class="process_action_material_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $process_action_material->dated->footerCellClass() ?>"><span id="elf_process_action_material_dated" class="process_action_material_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->opeartor->Visible) { // opeartor ?>
		<td data-name="opeartor" class="<?php echo $process_action_material->opeartor->footerCellClass() ?>"><span id="elf_process_action_material_opeartor" class="process_action_material_opeartor">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_material->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $process_action_material->datetime->footerCellClass() ?>"><span id="elf_process_action_material_datetime" class="process_action_material_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_action_material_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_material->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_material_list->Recordset)
	$process_action_material_list->Recordset->Close();
?>
<?php if (!$process_action_material->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_material_list->Pager)) $process_action_material_list->Pager = new PrevNextPager($process_action_material_list->StartRec, $process_action_material_list->DisplayRecs, $process_action_material_list->TotalRecs, $process_action_material_list->AutoHidePager) ?>
<?php if ($process_action_material_list->Pager->RecordCount > 0 && $process_action_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_material_list->pageUrl() ?>start=<?php echo $process_action_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_material_list->TotalRecs > 0 && (!$process_action_material_list->AutoHidePageSizeSelector || $process_action_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_material_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_material_list->TotalRecs == 0 && !$process_action_material->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_material_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_material->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_material->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_material", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_material_list->terminate();
?>