<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_material_search = new process_action_material_search();

// Run the page
$process_action_material_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_material_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($process_action_material_search->IsModal) { ?>
var fprocess_action_materialsearch = currentAdvancedSearchForm = new ew.Form("fprocess_action_materialsearch", "search");
<?php } else { ?>
var fprocess_action_materialsearch = currentForm = new ew.Form("fprocess_action_materialsearch", "search");
<?php } ?>

// Form_CustomValidate event
fprocess_action_materialsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_materialsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_materialsearch.lists["x_site"] = <?php echo $process_action_material_search->site->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_site"].options = <?php echo JsonEncode($process_action_material_search->site->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_process"] = <?php echo $process_action_material_search->process->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_process"].options = <?php echo JsonEncode($process_action_material_search->process->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_sub_process"] = <?php echo $process_action_material_search->sub_process->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_sub_process"].options = <?php echo JsonEncode($process_action_material_search->sub_process->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_emp_name"] = <?php echo $process_action_material_search->emp_name->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_emp_name"].options = <?php echo JsonEncode($process_action_material_search->emp_name->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_jc_no"] = <?php echo $process_action_material_search->jc_no->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_jc_no"].options = <?php echo JsonEncode($process_action_material_search->jc_no->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_grp"] = <?php echo $process_action_material_search->grp->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_grp"].options = <?php echo JsonEncode($process_action_material_search->grp->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_s_grp"] = <?php echo $process_action_material_search->s_grp->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_s_grp"].options = <?php echo JsonEncode($process_action_material_search->s_grp->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_product"] = <?php echo $process_action_material_search->product->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_product"].options = <?php echo JsonEncode($process_action_material_search->product->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_packing"] = <?php echo $process_action_material_search->packing->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_packing"].options = <?php echo JsonEncode($process_action_material_search->packing->lookupOptions()) ?>;
fprocess_action_materialsearch.autoSuggests["x_packing"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialsearch.lists["x_rid"] = <?php echo $process_action_material_search->rid->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_rid"].options = <?php echo JsonEncode($process_action_material_search->rid->lookupOptions()) ?>;
fprocess_action_materialsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialsearch.lists["x_godown"] = <?php echo $process_action_material_search->godown->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_godown"].options = <?php echo JsonEncode($process_action_material_search->godown->lookupOptions()) ?>;
fprocess_action_materialsearch.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fprocess_action_materialsearch.lists["x_rid_new"] = <?php echo $process_action_material_search->rid_new->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_rid_new"].options = <?php echo JsonEncode($process_action_material_search->rid_new->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_poid_1[]"] = <?php echo $process_action_material_search->poid_1->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_poid_1[]"].options = <?php echo JsonEncode($process_action_material_search->poid_1->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_process_method"] = <?php echo $process_action_material_search->process_method->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_process_method"].options = <?php echo JsonEncode($process_action_material_search->process_method->options(FALSE, TRUE)) ?>;
fprocess_action_materialsearch.lists["x_payment"] = <?php echo $process_action_material_search->payment->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_payment"].options = <?php echo JsonEncode($process_action_material_search->payment->lookupOptions()) ?>;
fprocess_action_materialsearch.lists["x_opeartor"] = <?php echo $process_action_material_search->opeartor->Lookup->toClientList() ?>;
fprocess_action_materialsearch.lists["x_opeartor"].options = <?php echo JsonEncode($process_action_material_search->opeartor->lookupOptions()) ?>;
fprocess_action_materialsearch.autoSuggests["x_opeartor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fprocess_action_materialsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->packing->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_godown");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->godown->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->avg_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avialable_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->avialable_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ply");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->ply->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_opeartor");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->opeartor->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_material->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $process_action_material_search->showPageHeader(); ?>
<?php
$process_action_material_search->showMessage();
?>
<form name="fprocess_action_materialsearch" id="fprocess_action_materialsearch" class="<?php echo $process_action_material_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_material_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_material_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_material">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$process_action_material_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($process_action_material->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_id"><?php echo $process_action_material->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->id->cellAttributes() ?>>
			<span id="el_process_action_material_id">
<input type="text" data-table="process_action_material" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($process_action_material->id->getPlaceHolder()) ?>" value="<?php echo $process_action_material->id->EditValue ?>"<?php echo $process_action_material->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label for="x_site" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_site"><?php echo $process_action_material->site->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_site" id="z_site" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->site->cellAttributes() ?>>
			<span id="el_process_action_material_site">
<?php $process_action_material->site->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->site->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_site" data-value-separator="<?php echo $process_action_material->site->displayValueSeparatorAttribute() ?>" id="x_site" name="x_site"<?php echo $process_action_material->site->editAttributes() ?>>
		<?php echo $process_action_material->site->selectOptionListHtml("x_site") ?>
	</select>
</div>
<?php echo $process_action_material->site->Lookup->getParamTag("p_x_site") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_process"><?php echo $process_action_material->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->process->cellAttributes() ?>>
			<span id="el_process_action_material_process">
<?php $process_action_material->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_process" data-value-separator="<?php echo $process_action_material->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_material->process->editAttributes() ?>>
		<?php echo $process_action_material->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_material->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->sub_process->Visible) { // sub_process ?>
	<div id="r_sub_process" class="form-group row">
		<label for="x_sub_process" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_sub_process"><?php echo $process_action_material->sub_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_process" id="z_sub_process" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->sub_process->cellAttributes() ?>>
			<span id="el_process_action_material_sub_process">
<?php $process_action_material->sub_process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->sub_process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_sub_process" data-value-separator="<?php echo $process_action_material->sub_process->displayValueSeparatorAttribute() ?>" id="x_sub_process" name="x_sub_process"<?php echo $process_action_material->sub_process->editAttributes() ?>>
		<?php echo $process_action_material->sub_process->selectOptionListHtml("x_sub_process") ?>
	</select>
</div>
<?php echo $process_action_material->sub_process->Lookup->getParamTag("p_x_sub_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->emp_name->Visible) { // emp_name ?>
	<div id="r_emp_name" class="form-group row">
		<label for="x_emp_name" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_emp_name"><?php echo $process_action_material->emp_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_emp_name" id="z_emp_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->emp_name->cellAttributes() ?>>
			<span id="el_process_action_material_emp_name">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_emp_name" data-value-separator="<?php echo $process_action_material->emp_name->displayValueSeparatorAttribute() ?>" id="x_emp_name" name="x_emp_name"<?php echo $process_action_material->emp_name->editAttributes() ?>>
		<?php echo $process_action_material->emp_name->selectOptionListHtml("x_emp_name") ?>
	</select>
</div>
<?php echo $process_action_material->emp_name->Lookup->getParamTag("p_x_emp_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_jc_no"><?php echo $process_action_material->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->jc_no->cellAttributes() ?>>
			<span id="el_process_action_material_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_jc_no" data-value-separator="<?php echo $process_action_material->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $process_action_material->jc_no->editAttributes() ?>>
		<?php echo $process_action_material->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $process_action_material->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_grp"><?php echo $process_action_material->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->grp->cellAttributes() ?>>
			<span id="el_process_action_material_grp">
<?php $process_action_material->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_grp" data-value-separator="<?php echo $process_action_material->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $process_action_material->grp->editAttributes() ?>>
		<?php echo $process_action_material->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $process_action_material->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_s_grp"><?php echo $process_action_material->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->s_grp->cellAttributes() ?>>
			<span id="el_process_action_material_s_grp">
<?php $process_action_material->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$process_action_material->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_s_grp" data-value-separator="<?php echo $process_action_material->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $process_action_material->s_grp->editAttributes() ?>>
		<?php echo $process_action_material->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $process_action_material->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_product"><?php echo $process_action_material->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->product->cellAttributes() ?>>
			<span id="el_process_action_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_product" data-value-separator="<?php echo $process_action_material->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $process_action_material->product->editAttributes() ?>>
		<?php echo $process_action_material->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $process_action_material->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->packing->Visible) { // packing ?>
	<div id="r_packing" class="form-group row">
		<label class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_packing"><?php echo $process_action_material->packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing" id="z_packing" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->packing->cellAttributes() ?>>
			<span id="el_process_action_material_packing">
<?php
$wrkonchange = "" . trim(@$process_action_material->packing->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->packing->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_packing" id="sv_x_packing" value="<?php echo RemoveHtml($process_action_material->packing->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->packing->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->packing->getPlaceHolder()) ?>"<?php echo $process_action_material->packing->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_material->packing->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_packing',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_material->packing->ReadOnly || $process_action_material->packing->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_packing" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_material->packing->displayValueSeparatorAttribute() ?>" name="x_packing" id="x_packing" value="<?php echo HtmlEncode($process_action_material->packing->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialsearch.createAutoSuggest({"id":"x_packing","forceSelect":true});
</script>
<?php echo $process_action_material->packing->Lookup->getParamTag("p_x_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_rid"><?php echo $process_action_material->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->rid->cellAttributes() ?>>
			<span id="el_process_action_material_rid">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$process_action_material->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($process_action_material->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->rid->getPlaceHolder()) ?>"<?php echo $process_action_material->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_rid" data-value-separator="<?php echo $process_action_material->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($process_action_material->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $process_action_material->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_godown"><?php echo $process_action_material->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->godown->cellAttributes() ?>>
			<span id="el_process_action_material_godown">
<?php
$wrkonchange = "" . trim(@$process_action_material->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8860">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($process_action_material->godown->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->godown->getPlaceHolder()) ?>"<?php echo $process_action_material->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_godown" data-value-separator="<?php echo $process_action_material->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($process_action_material->godown->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialsearch.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $process_action_material->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label for="x_avg_quantity" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_avg_quantity"><?php echo $process_action_material->avg_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->avg_quantity->cellAttributes() ?>>
			<span id="el_process_action_material_avg_quantity">
<input type="text" data-table="process_action_material" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($process_action_material->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $process_action_material->avg_quantity->EditValue ?>"<?php echo $process_action_material->avg_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_lot_no"><?php echo $process_action_material->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->lot_no->cellAttributes() ?>>
			<span id="el_process_action_material_lot_no">
<input type="text" data-table="process_action_material" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($process_action_material->lot_no->getPlaceHolder()) ?>" value="<?php echo $process_action_material->lot_no->EditValue ?>"<?php echo $process_action_material->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->avialable_qty->Visible) { // avialable_qty ?>
	<div id="r_avialable_qty" class="form-group row">
		<label for="x_avialable_qty" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_avialable_qty"><?php echo $process_action_material->avialable_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avialable_qty" id="z_avialable_qty" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->avialable_qty->cellAttributes() ?>>
			<span id="el_process_action_material_avialable_qty">
<input type="text" data-table="process_action_material" data-field="x_avialable_qty" name="x_avialable_qty" id="x_avialable_qty" size="30" placeholder="<?php echo HtmlEncode($process_action_material->avialable_qty->getPlaceHolder()) ?>" value="<?php echo $process_action_material->avialable_qty->EditValue ?>"<?php echo $process_action_material->avialable_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->ply->Visible) { // ply ?>
	<div id="r_ply" class="form-group row">
		<label for="x_ply" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_ply"><?php echo $process_action_material->ply->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply" id="z_ply" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->ply->cellAttributes() ?>>
			<span id="el_process_action_material_ply">
<input type="text" data-table="process_action_material" data-field="x_ply" name="x_ply" id="x_ply" size="30" placeholder="<?php echo HtmlEncode($process_action_material->ply->getPlaceHolder()) ?>" value="<?php echo $process_action_material->ply->EditValue ?>"<?php echo $process_action_material->ply->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_new->Visible) { // rid_new ?>
	<div id="r_rid_new" class="form-group row">
		<label for="x_rid_new" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_rid_new"><?php echo $process_action_material->rid_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid_new" id="z_rid_new" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->rid_new->cellAttributes() ?>>
			<span id="el_process_action_material_rid_new">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_rid_new" data-value-separator="<?php echo $process_action_material->rid_new->displayValueSeparatorAttribute() ?>" id="x_rid_new" name="x_rid_new"<?php echo $process_action_material->rid_new->editAttributes() ?>>
		<?php echo $process_action_material->rid_new->selectOptionListHtml("x_rid_new") ?>
	</select>
</div>
<?php echo $process_action_material->rid_new->Lookup->getParamTag("p_x_rid_new") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->rid_new_lot_no->Visible) { // rid_new_lot_no ?>
	<div id="r_rid_new_lot_no" class="form-group row">
		<label for="x_rid_new_lot_no" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_rid_new_lot_no"><?php echo $process_action_material->rid_new_lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_new_lot_no" id="z_rid_new_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->rid_new_lot_no->cellAttributes() ?>>
			<span id="el_process_action_material_rid_new_lot_no">
<input type="text" data-table="process_action_material" data-field="x_rid_new_lot_no" name="x_rid_new_lot_no" id="x_rid_new_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($process_action_material->rid_new_lot_no->getPlaceHolder()) ?>" value="<?php echo $process_action_material->rid_new_lot_no->EditValue ?>"<?php echo $process_action_material->rid_new_lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid_new->Visible) { // poid_new ?>
	<div id="r_poid_new" class="form-group row">
		<label for="x_poid_new" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_poid_new"><?php echo $process_action_material->poid_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_poid_new" id="z_poid_new" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->poid_new->cellAttributes() ?>>
			<span id="el_process_action_material_poid_new">
<input type="text" data-table="process_action_material" data-field="x_poid_new" name="x_poid_new" id="x_poid_new" placeholder="<?php echo HtmlEncode($process_action_material->poid_new->getPlaceHolder()) ?>" value="<?php echo $process_action_material->poid_new->EditValue ?>"<?php echo $process_action_material->poid_new->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid_1->Visible) { // poid_1 ?>
	<div id="r_poid_1" class="form-group row">
		<label class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_poid_1"><?php echo $process_action_material->poid_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_poid_1" id="z_poid_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->poid_1->cellAttributes() ?>>
			<span id="el_process_action_material_poid_1">
<div id="tp_x_poid_1" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_material" data-field="x_poid_1" data-value-separator="<?php echo $process_action_material->poid_1->displayValueSeparatorAttribute() ?>" name="x_poid_1[]" id="x_poid_1[]" value="{value}"<?php echo $process_action_material->poid_1->editAttributes() ?>></div>
<div id="dsl_x_poid_1" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $process_action_material->poid_1->checkBoxListHtml(FALSE, "x_poid_1[]") ?>
</div></div>
<?php echo $process_action_material->poid_1->Lookup->getParamTag("p_x_poid_1") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_poid"><?php echo $process_action_material->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_poid" id="z_poid" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->poid->cellAttributes() ?>>
			<span id="el_process_action_material_poid">
<input type="text" data-table="process_action_material" data-field="x_poid" name="x_poid" id="x_poid" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($process_action_material->poid->getPlaceHolder()) ?>" value="<?php echo $process_action_material->poid->EditValue ?>"<?php echo $process_action_material->poid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_quantity"><?php echo $process_action_material->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->quantity->cellAttributes() ?>>
			<span id="el_process_action_material_quantity">
<input type="text" data-table="process_action_material" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($process_action_material->quantity->getPlaceHolder()) ?>" value="<?php echo $process_action_material->quantity->EditValue ?>"<?php echo $process_action_material->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_packets"><?php echo $process_action_material->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->packets->cellAttributes() ?>>
			<span id="el_process_action_material_packets">
<input type="text" data-table="process_action_material" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($process_action_material->packets->getPlaceHolder()) ?>" value="<?php echo $process_action_material->packets->EditValue ?>"<?php echo $process_action_material->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->process_method->Visible) { // process_method ?>
	<div id="r_process_method" class="form-group row">
		<label for="x_process_method" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_process_method"><?php echo $process_action_material->process_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_method" id="z_process_method" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->process_method->cellAttributes() ?>>
			<span id="el_process_action_material_process_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_process_method" data-value-separator="<?php echo $process_action_material->process_method->displayValueSeparatorAttribute() ?>" id="x_process_method" name="x_process_method"<?php echo $process_action_material->process_method->editAttributes() ?>>
		<?php echo $process_action_material->process_method->selectOptionListHtml("x_process_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label for="x_payment" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_payment"><?php echo $process_action_material->payment->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->payment->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_material->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_material_payment">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_payment" data-value-separator="<?php echo $process_action_material->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $process_action_material->payment->editAttributes() ?>>
		<?php echo $process_action_material->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $process_action_material->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
			<span class="ew-search-cond btw1_payment d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_material_payment" class="btw1_payment d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_material" data-field="x_payment" data-value-separator="<?php echo $process_action_material->payment->displayValueSeparatorAttribute() ?>" id="y_payment" name="y_payment"<?php echo $process_action_material->payment->editAttributes() ?>>
		<?php echo $process_action_material->payment->selectOptionListHtml("y_payment") ?>
	</select>
</div>
<?php echo $process_action_material->payment->Lookup->getParamTag("p_y_payment") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label for="x_remark" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_remark"><?php echo $process_action_material->remark->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remark" id="z_remark" value="LIKE"></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->remark->cellAttributes() ?>>
			<span id="el_process_action_material_remark">
<input type="text" data-table="process_action_material" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="225" placeholder="<?php echo HtmlEncode($process_action_material->remark->getPlaceHolder()) ?>" value="<?php echo $process_action_material->remark->EditValue ?>"<?php echo $process_action_material->remark->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_dated"><?php echo $process_action_material->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->dated->cellAttributes() ?>>
			<span id="el_process_action_material_dated">
<input type="text" data-table="process_action_material" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($process_action_material->dated->getPlaceHolder()) ?>" value="<?php echo $process_action_material->dated->EditValue ?>"<?php echo $process_action_material->dated->editAttributes() ?>>
<?php if (!$process_action_material->dated->ReadOnly && !$process_action_material->dated->Disabled && !isset($process_action_material->dated->EditAttrs["readonly"]) && !isset($process_action_material->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materialsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->opeartor->Visible) { // opeartor ?>
	<div id="r_opeartor" class="form-group row">
		<label class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_opeartor"><?php echo $process_action_material->opeartor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_opeartor" id="z_opeartor" value="="></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->opeartor->cellAttributes() ?>>
			<span id="el_process_action_material_opeartor">
<?php
$wrkonchange = "" . trim(@$process_action_material->opeartor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$process_action_material->opeartor->EditAttrs["onchange"] = "";
?>
<span id="as_x_opeartor" class="text-nowrap" style="z-index: 8700">
	<input type="text" class="form-control" name="sv_x_opeartor" id="sv_x_opeartor" value="<?php echo RemoveHtml($process_action_material->opeartor->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($process_action_material->opeartor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($process_action_material->opeartor->getPlaceHolder()) ?>"<?php echo $process_action_material->opeartor->editAttributes() ?>>
</span>
<input type="hidden" data-table="process_action_material" data-field="x_opeartor" data-value-separator="<?php echo $process_action_material->opeartor->displayValueSeparatorAttribute() ?>" name="x_opeartor" id="x_opeartor" value="<?php echo HtmlEncode($process_action_material->opeartor->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fprocess_action_materialsearch.createAutoSuggest({"id":"x_opeartor","forceSelect":false});
</script>
<?php echo $process_action_material->opeartor->Lookup->getParamTag("p_x_opeartor") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($process_action_material->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $process_action_material_search->LeftColumnClass ?>"><span id="elh_process_action_material_datetime"><?php echo $process_action_material->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $process_action_material_search->RightColumnClass ?>"><div<?php echo $process_action_material->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_material->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_process_action_material_datetime">
<input type="text" data-table="process_action_material" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_material->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_material->datetime->EditValue ?>"<?php echo $process_action_material->datetime->editAttributes() ?>>
<?php if (!$process_action_material->datetime->ReadOnly && !$process_action_material->datetime->Disabled && !isset($process_action_material->datetime->EditAttrs["readonly"]) && !isset($process_action_material->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materialsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_process_action_material_datetime" class="btw1_datetime d-none">
<input type="text" data-table="process_action_material" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_material->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_material->datetime->EditValue2 ?>"<?php echo $process_action_material->datetime->editAttributes() ?>>
<?php if (!$process_action_material->datetime->ReadOnly && !$process_action_material->datetime->Disabled && !isset($process_action_material->datetime->EditAttrs["readonly"]) && !isset($process_action_material->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_materialsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$process_action_material_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $process_action_material_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$process_action_material_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$process_action_material_search->terminate();
?>