<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_payment_c_list = new process_action_payment_c_list();

// Run the page
$process_action_payment_c_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_payment_c_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_payment_c->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_payment_clist = currentForm = new ew.Form("fprocess_action_payment_clist", "list");
fprocess_action_payment_clist.formKeyCountName = '<?php echo $process_action_payment_c_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_payment_clist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_payment_clist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_payment_clist.lists["x_grp"] = <?php echo $process_action_payment_c_list->grp->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_grp"].options = <?php echo JsonEncode($process_action_payment_c_list->grp->options(FALSE, TRUE)) ?>;
fprocess_action_payment_clist.lists["x_emp_id"] = <?php echo $process_action_payment_c_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_c_list->emp_id->lookupOptions()) ?>;
fprocess_action_payment_clist.lists["x_payment_type"] = <?php echo $process_action_payment_c_list->payment_type->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_payment_type"].options = <?php echo JsonEncode($process_action_payment_c_list->payment_type->options(FALSE, TRUE)) ?>;
fprocess_action_payment_clist.lists["x_process"] = <?php echo $process_action_payment_c_list->process->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_c_list->process->lookupOptions()) ?>;
fprocess_action_payment_clist.lists["x_process_fix"] = <?php echo $process_action_payment_c_list->process_fix->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_process_fix"].options = <?php echo JsonEncode($process_action_payment_c_list->process_fix->options(FALSE, TRUE)) ?>;
fprocess_action_payment_clist.lists["x_method"] = <?php echo $process_action_payment_c_list->method->Lookup->toClientList() ?>;
fprocess_action_payment_clist.lists["x_method"].options = <?php echo JsonEncode($process_action_payment_c_list->method->options(FALSE, TRUE)) ?>;

// Form object for search
var fprocess_action_payment_clistsrch = currentSearchForm = new ew.Form("fprocess_action_payment_clistsrch");

// Filters
fprocess_action_payment_clistsrch.filterList = <?php echo $process_action_payment_c_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_payment_clistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_payment_c->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_payment_c_list->TotalRecs > 0 && $process_action_payment_c_list->ExportOptions->visible()) { ?>
<?php $process_action_payment_c_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_c_list->ImportOptions->visible()) { ?>
<?php $process_action_payment_c_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_c_list->SearchOptions->visible()) { ?>
<?php $process_action_payment_c_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_c_list->FilterOptions->visible()) { ?>
<?php $process_action_payment_c_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_payment_c_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_payment_c->isExport() && !$process_action_payment_c->CurrentAction) { ?>
<form name="fprocess_action_payment_clistsrch" id="fprocess_action_payment_clistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_payment_c_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_payment_clistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_payment_c">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_payment_c_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_payment_c_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_payment_c_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_payment_c_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_c_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_c_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_c_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_payment_c_list->showPageHeader(); ?>
<?php
$process_action_payment_c_list->showMessage();
?>
<?php if ($process_action_payment_c_list->TotalRecs > 0 || $process_action_payment_c->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_payment_c_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_payment_c">
<?php if (!$process_action_payment_c->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_payment_c->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_c_list->Pager)) $process_action_payment_c_list->Pager = new PrevNextPager($process_action_payment_c_list->StartRec, $process_action_payment_c_list->DisplayRecs, $process_action_payment_c_list->TotalRecs, $process_action_payment_c_list->AutoHidePager) ?>
<?php if ($process_action_payment_c_list->Pager->RecordCount > 0 && $process_action_payment_c_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_c_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_c_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_c_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_c_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_c_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_c_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_c_list->TotalRecs > 0 && (!$process_action_payment_c_list->AutoHidePageSizeSelector || $process_action_payment_c_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_c">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_c_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_c_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_c_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_c_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_c_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_c->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_c_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_payment_clist" id="fprocess_action_payment_clist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_payment_c_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_payment_c_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_payment_c">
<div id="gmp_process_action_payment_c" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_payment_c_list->TotalRecs > 0 || $process_action_payment_c->isGridEdit()) { ?>
<table id="tbl_process_action_payment_clist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_payment_c_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_payment_c_list->renderListOptions();

// Render list options (header, left)
$process_action_payment_c_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_payment_c->id->Visible) { // id ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_payment_c->id->headerCellClass() ?>"><div id="elh_process_action_payment_c_id" class="process_action_payment_c_id"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_payment_c->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->id) ?>',2);"><div id="elh_process_action_payment_c_id" class="process_action_payment_c_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->grp->Visible) { // grp ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $process_action_payment_c->grp->headerCellClass() ?>"><div id="elh_process_action_payment_c_grp" class="process_action_payment_c_grp"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $process_action_payment_c->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->grp) ?>',2);"><div id="elh_process_action_payment_c_grp" class="process_action_payment_c_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->emp_id->Visible) { // emp_id ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_c->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_c_emp_id" class="process_action_payment_c_emp_id"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_c->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->emp_id) ?>',2);"><div id="elh_process_action_payment_c_emp_id" class="process_action_payment_c_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->code->Visible) { // code ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_action_payment_c->code->headerCellClass() ?>"><div id="elh_process_action_payment_c_code" class="process_action_payment_c_code"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_action_payment_c->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->code) ?>',2);"><div id="elh_process_action_payment_c_code" class="process_action_payment_c_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->ref->Visible) { // ref ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_action_payment_c->ref->headerCellClass() ?>"><div id="elh_process_action_payment_c_ref" class="process_action_payment_c_ref"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_action_payment_c->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->ref) ?>',2);"><div id="elh_process_action_payment_c_ref" class="process_action_payment_c_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->payment_type->Visible) { // payment_type ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->payment_type) == "") { ?>
		<th data-name="payment_type" class="<?php echo $process_action_payment_c->payment_type->headerCellClass() ?>"><div id="elh_process_action_payment_c_payment_type" class="process_action_payment_c_payment_type"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_type" class="<?php echo $process_action_payment_c->payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->payment_type) ?>',2);"><div id="elh_process_action_payment_c_payment_type" class="process_action_payment_c_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->size_wl->Visible) { // size_wl ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->size_wl) == "") { ?>
		<th data-name="size_wl" class="<?php echo $process_action_payment_c->size_wl->headerCellClass() ?>"><div id="elh_process_action_payment_c_size_wl" class="process_action_payment_c_size_wl"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_wl" class="<?php echo $process_action_payment_c->size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->size_wl) ?>',2);"><div id="elh_process_action_payment_c_size_wl" class="process_action_payment_c_size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->size_wl->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->_2_srm->Visible) { // 2_srm ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->_2_srm) == "") { ?>
		<th data-name="_2_srm" class="<?php echo $process_action_payment_c->_2_srm->headerCellClass() ?>"><div id="elh_process_action_payment_c__2_srm" class="process_action_payment_c__2_srm"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->_2_srm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2_srm" class="<?php echo $process_action_payment_c->_2_srm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->_2_srm) ?>',2);"><div id="elh_process_action_payment_c__2_srm" class="process_action_payment_c__2_srm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->_2_srm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->_2_srm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->_2_srm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->_4_srm->Visible) { // 4_srm ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->_4_srm) == "") { ?>
		<th data-name="_4_srm" class="<?php echo $process_action_payment_c->_4_srm->headerCellClass() ?>"><div id="elh_process_action_payment_c__4_srm" class="process_action_payment_c__4_srm"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->_4_srm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_4_srm" class="<?php echo $process_action_payment_c->_4_srm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->_4_srm) ?>',2);"><div id="elh_process_action_payment_c__4_srm" class="process_action_payment_c__4_srm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->_4_srm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->_4_srm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->_4_srm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->sqm->Visible) { // sqm ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment_c->sqm->headerCellClass() ?>"><div id="elh_process_action_payment_c_sqm" class="process_action_payment_c_sqm"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment_c->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->sqm) ?>',2);"><div id="elh_process_action_payment_c_sqm" class="process_action_payment_c_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->process->Visible) { // process ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_payment_c->process->headerCellClass() ?>"><div id="elh_process_action_payment_c_process" class="process_action_payment_c_process"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_payment_c->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->process) ?>',2);"><div id="elh_process_action_payment_c_process" class="process_action_payment_c_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->process_fix->Visible) { // process_fix ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->process_fix) == "") { ?>
		<th data-name="process_fix" class="<?php echo $process_action_payment_c->process_fix->headerCellClass() ?>"><div id="elh_process_action_payment_c_process_fix" class="process_action_payment_c_process_fix"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->process_fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_fix" class="<?php echo $process_action_payment_c->process_fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->process_fix) ?>',2);"><div id="elh_process_action_payment_c_process_fix" class="process_action_payment_c_process_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->process_fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->process_fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->process_fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->method->Visible) { // method ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->method) == "") { ?>
		<th data-name="method" class="<?php echo $process_action_payment_c->method->headerCellClass() ?>"><div id="elh_process_action_payment_c_method" class="process_action_payment_c_method"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $process_action_payment_c->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->method) ?>',2);"><div id="elh_process_action_payment_c_method" class="process_action_payment_c_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->process_40->Visible) { // process_@ ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->process_40) == "") { ?>
		<th data-name="process_40" class="<?php echo $process_action_payment_c->process_40->headerCellClass() ?>"><div id="elh_process_action_payment_c_process_40" class="process_action_payment_c_process_40"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->process_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_40" class="<?php echo $process_action_payment_c->process_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->process_40) ?>',2);"><div id="elh_process_action_payment_c_process_40" class="process_action_payment_c_process_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->process_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->process_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->process_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->amount->Visible) { // amount ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_c->amount->headerCellClass() ?>"><div id="elh_process_action_payment_c_amount" class="process_action_payment_c_amount"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_c->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->amount) ?>',2);"><div id="elh_process_action_payment_c_amount" class="process_action_payment_c_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->datetime->Visible) { // datetime ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_payment_c->datetime->headerCellClass() ?>"><div id="elh_process_action_payment_c_datetime" class="process_action_payment_c_datetime"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_payment_c->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->datetime) ?>',2);"><div id="elh_process_action_payment_c_datetime" class="process_action_payment_c_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->payment->Visible) { // payment ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_c->payment->headerCellClass() ?>"><div id="elh_process_action_payment_c_payment" class="process_action_payment_c_payment"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_c->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->payment) ?>',2);"><div id="elh_process_action_payment_c_payment" class="process_action_payment_c_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_c->remark->Visible) { // remark ?>
	<?php if ($process_action_payment_c->sortUrl($process_action_payment_c->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $process_action_payment_c->remark->headerCellClass() ?>"><div id="elh_process_action_payment_c_remark" class="process_action_payment_c_remark"><div class="ew-table-header-caption"><?php echo $process_action_payment_c->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $process_action_payment_c->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_c->SortUrl($process_action_payment_c->remark) ?>',2);"><div id="elh_process_action_payment_c_remark" class="process_action_payment_c_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_c->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_c->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_c->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_payment_c_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_payment_c->ExportAll && $process_action_payment_c->isExport()) {
	$process_action_payment_c_list->StopRec = $process_action_payment_c_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_payment_c_list->TotalRecs > $process_action_payment_c_list->StartRec + $process_action_payment_c_list->DisplayRecs - 1)
		$process_action_payment_c_list->StopRec = $process_action_payment_c_list->StartRec + $process_action_payment_c_list->DisplayRecs - 1;
	else
		$process_action_payment_c_list->StopRec = $process_action_payment_c_list->TotalRecs;
}
$process_action_payment_c_list->RecCnt = $process_action_payment_c_list->StartRec - 1;
if ($process_action_payment_c_list->Recordset && !$process_action_payment_c_list->Recordset->EOF) {
	$process_action_payment_c_list->Recordset->moveFirst();
	$selectLimit = $process_action_payment_c_list->UseSelectLimit;
	if (!$selectLimit && $process_action_payment_c_list->StartRec > 1)
		$process_action_payment_c_list->Recordset->move($process_action_payment_c_list->StartRec - 1);
} elseif (!$process_action_payment_c->AllowAddDeleteRow && $process_action_payment_c_list->StopRec == 0) {
	$process_action_payment_c_list->StopRec = $process_action_payment_c->GridAddRowCount;
}

// Initialize aggregate
$process_action_payment_c->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_payment_c->resetAttributes();
$process_action_payment_c_list->renderRow();
while ($process_action_payment_c_list->RecCnt < $process_action_payment_c_list->StopRec) {
	$process_action_payment_c_list->RecCnt++;
	if ($process_action_payment_c_list->RecCnt >= $process_action_payment_c_list->StartRec) {
		$process_action_payment_c_list->RowCnt++;

		// Set up key count
		$process_action_payment_c_list->KeyCount = $process_action_payment_c_list->RowIndex;

		// Init row class and style
		$process_action_payment_c->resetAttributes();
		$process_action_payment_c->CssClass = "";
		if ($process_action_payment_c->isGridAdd()) {
		} else {
			$process_action_payment_c_list->loadRowValues($process_action_payment_c_list->Recordset); // Load row values
		}
		$process_action_payment_c->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_payment_c->RowAttrs = array_merge($process_action_payment_c->RowAttrs, array('data-rowindex'=>$process_action_payment_c_list->RowCnt, 'id'=>'r' . $process_action_payment_c_list->RowCnt . '_process_action_payment_c', 'data-rowtype'=>$process_action_payment_c->RowType));

		// Render row
		$process_action_payment_c_list->renderRow();

		// Render list options
		$process_action_payment_c_list->renderListOptions();
?>
	<tr<?php echo $process_action_payment_c->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_payment_c_list->ListOptions->render("body", "left", $process_action_payment_c_list->RowCnt);
?>
	<?php if ($process_action_payment_c->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_payment_c->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_id" class="process_action_payment_c_id">
<span<?php echo $process_action_payment_c->id->viewAttributes() ?>>
<?php echo $process_action_payment_c->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $process_action_payment_c->grp->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_grp" class="process_action_payment_c_grp">
<span<?php echo $process_action_payment_c->grp->viewAttributes() ?>>
<?php echo $process_action_payment_c->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $process_action_payment_c->emp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_emp_id" class="process_action_payment_c_emp_id">
<span<?php echo $process_action_payment_c->emp_id->viewAttributes() ?>>
<?php echo $process_action_payment_c->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_action_payment_c->code->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_code" class="process_action_payment_c_code">
<span<?php echo $process_action_payment_c->code->viewAttributes() ?>>
<?php echo $process_action_payment_c->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_action_payment_c->ref->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_ref" class="process_action_payment_c_ref">
<span<?php echo $process_action_payment_c->ref->viewAttributes() ?>>
<?php echo $process_action_payment_c->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type"<?php echo $process_action_payment_c->payment_type->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_payment_type" class="process_action_payment_c_payment_type">
<span<?php echo $process_action_payment_c->payment_type->viewAttributes() ?>>
<?php echo $process_action_payment_c->payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->size_wl->Visible) { // size_wl ?>
		<td data-name="size_wl"<?php echo $process_action_payment_c->size_wl->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_size_wl" class="process_action_payment_c_size_wl">
<span<?php echo $process_action_payment_c->size_wl->viewAttributes() ?>>
<?php echo $process_action_payment_c->size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->_2_srm->Visible) { // 2_srm ?>
		<td data-name="_2_srm"<?php echo $process_action_payment_c->_2_srm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c__2_srm" class="process_action_payment_c__2_srm">
<span<?php echo $process_action_payment_c->_2_srm->viewAttributes() ?>>
<?php echo $process_action_payment_c->_2_srm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->_4_srm->Visible) { // 4_srm ?>
		<td data-name="_4_srm"<?php echo $process_action_payment_c->_4_srm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c__4_srm" class="process_action_payment_c__4_srm">
<span<?php echo $process_action_payment_c->_4_srm->viewAttributes() ?>>
<?php echo $process_action_payment_c->_4_srm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $process_action_payment_c->sqm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_sqm" class="process_action_payment_c_sqm">
<span<?php echo $process_action_payment_c->sqm->viewAttributes() ?>>
<?php echo $process_action_payment_c->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_payment_c->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_process" class="process_action_payment_c_process">
<span<?php echo $process_action_payment_c->process->viewAttributes() ?>>
<?php echo $process_action_payment_c->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->process_fix->Visible) { // process_fix ?>
		<td data-name="process_fix"<?php echo $process_action_payment_c->process_fix->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_process_fix" class="process_action_payment_c_process_fix">
<span<?php echo $process_action_payment_c->process_fix->viewAttributes() ?>>
<?php echo $process_action_payment_c->process_fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->method->Visible) { // method ?>
		<td data-name="method"<?php echo $process_action_payment_c->method->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_method" class="process_action_payment_c_method">
<span<?php echo $process_action_payment_c->method->viewAttributes() ?>>
<?php echo $process_action_payment_c->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->process_40->Visible) { // process_@ ?>
		<td data-name="process_40"<?php echo $process_action_payment_c->process_40->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_process_40" class="process_action_payment_c_process_40">
<span<?php echo $process_action_payment_c->process_40->viewAttributes() ?>>
<?php echo $process_action_payment_c->process_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $process_action_payment_c->amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_amount" class="process_action_payment_c_amount">
<span<?php echo $process_action_payment_c->amount->viewAttributes() ?>>
<?php echo $process_action_payment_c->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_payment_c->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_datetime" class="process_action_payment_c_datetime">
<span<?php echo $process_action_payment_c->datetime->viewAttributes() ?>>
<?php echo $process_action_payment_c->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_payment_c->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_payment" class="process_action_payment_c_payment">
<span<?php echo $process_action_payment_c->payment->viewAttributes() ?>>
<?php echo $process_action_payment_c->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_c->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $process_action_payment_c->remark->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_c_list->RowCnt ?>_process_action_payment_c_remark" class="process_action_payment_c_remark">
<span<?php echo $process_action_payment_c->remark->viewAttributes() ?>>
<?php echo $process_action_payment_c->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_payment_c_list->ListOptions->render("body", "right", $process_action_payment_c_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_payment_c->isGridAdd())
		$process_action_payment_c_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_payment_c->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_payment_c_list->Recordset)
	$process_action_payment_c_list->Recordset->Close();
?>
<?php if (!$process_action_payment_c->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_payment_c->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_c_list->Pager)) $process_action_payment_c_list->Pager = new PrevNextPager($process_action_payment_c_list->StartRec, $process_action_payment_c_list->DisplayRecs, $process_action_payment_c_list->TotalRecs, $process_action_payment_c_list->AutoHidePager) ?>
<?php if ($process_action_payment_c_list->Pager->RecordCount > 0 && $process_action_payment_c_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_c_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_c_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_c_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_c_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_c_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_c_list->pageUrl() ?>start=<?php echo $process_action_payment_c_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_c_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_c_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_c_list->TotalRecs > 0 && (!$process_action_payment_c_list->AutoHidePageSizeSelector || $process_action_payment_c_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_c">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_c_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_c_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_c_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_c_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_c_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_c->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_c_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_payment_c_list->TotalRecs == 0 && !$process_action_payment_c->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_payment_c_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_payment_c_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_payment_c->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_payment_c->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_payment_c", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_payment_c_list->terminate();
?>