<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_payment_e_list = new process_action_payment_e_list();

// Run the page
$process_action_payment_e_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_payment_e_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_payment_e->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_payment_elist = currentForm = new ew.Form("fprocess_action_payment_elist", "list");
fprocess_action_payment_elist.formKeyCountName = '<?php echo $process_action_payment_e_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_payment_elist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_payment_elist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_payment_elist.lists["x_location[]"] = <?php echo $process_action_payment_e_list->location->Lookup->toClientList() ?>;
fprocess_action_payment_elist.lists["x_location[]"].options = <?php echo JsonEncode($process_action_payment_e_list->location->lookupOptions()) ?>;
fprocess_action_payment_elist.lists["x_emp_id"] = <?php echo $process_action_payment_e_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_payment_elist.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_e_list->emp_id->lookupOptions()) ?>;
fprocess_action_payment_elist.lists["x_payment"] = <?php echo $process_action_payment_e_list->payment->Lookup->toClientList() ?>;
fprocess_action_payment_elist.lists["x_payment"].options = <?php echo JsonEncode($process_action_payment_e_list->payment->lookupOptions()) ?>;

// Form object for search
var fprocess_action_payment_elistsrch = currentSearchForm = new ew.Form("fprocess_action_payment_elistsrch");

// Validate function for search
fprocess_action_payment_elistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_payment_elistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_payment_elistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_payment_elistsrch.lists["x_location[]"] = <?php echo $process_action_payment_e_list->location->Lookup->toClientList() ?>;
fprocess_action_payment_elistsrch.lists["x_location[]"].options = <?php echo JsonEncode($process_action_payment_e_list->location->lookupOptions()) ?>;
fprocess_action_payment_elistsrch.lists["x_emp_id"] = <?php echo $process_action_payment_e_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_payment_elistsrch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_e_list->emp_id->lookupOptions()) ?>;
fprocess_action_payment_elistsrch.lists["x_payment"] = <?php echo $process_action_payment_e_list->payment->Lookup->toClientList() ?>;
fprocess_action_payment_elistsrch.lists["x_payment"].options = <?php echo JsonEncode($process_action_payment_e_list->payment->lookupOptions()) ?>;

// Filters
fprocess_action_payment_elistsrch.filterList = <?php echo $process_action_payment_e_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_payment_elistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_payment_e->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_payment_e_list->TotalRecs > 0 && $process_action_payment_e_list->ExportOptions->visible()) { ?>
<?php $process_action_payment_e_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_e_list->ImportOptions->visible()) { ?>
<?php $process_action_payment_e_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_e_list->SearchOptions->visible()) { ?>
<?php $process_action_payment_e_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_e_list->FilterOptions->visible()) { ?>
<?php $process_action_payment_e_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_payment_e_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_payment_e->isExport() && !$process_action_payment_e->CurrentAction) { ?>
<form name="fprocess_action_payment_elistsrch" id="fprocess_action_payment_elistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_payment_e_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_payment_elistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_payment_e">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_payment_e_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_payment_e->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_payment_e->resetAttributes();
$process_action_payment_e_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_payment_e->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action_payment_e->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment_e" data-field="x_location" data-value-separator="<?php echo $process_action_payment_e->location->displayValueSeparatorAttribute() ?>" id="x_location[]" name="x_location[]" multiple="multiple"<?php echo $process_action_payment_e->location->editAttributes() ?>>
		<?php echo $process_action_payment_e->location->selectOptionListHtml("x_location[]") ?>
	</select>
</div>
<?php echo $process_action_payment_e->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment_e->emp_id->Visible) { // emp_id ?>
	<div id="xsc_emp_id" class="ew-cell form-group">
		<label for="x_emp_id" class="ew-search-caption ew-label"><?php echo $process_action_payment_e->emp_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_payment_e" data-field="x_emp_id" name="x_emp_id" id="x_emp_id" size="30" placeholder="<?php echo HtmlEncode($process_action_payment_e->emp_id->getPlaceHolder()) ?>" value="<?php echo $process_action_payment_e->emp_id->EditValue ?>"<?php echo $process_action_payment_e->emp_id->editAttributes() ?>>
<?php echo $process_action_payment_e->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment_e->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label for="x_payment" class="ew-search-caption ew-label"><?php echo $process_action_payment_e->payment->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment_e" data-field="x_payment" data-value-separator="<?php echo $process_action_payment_e->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $process_action_payment_e->payment->editAttributes() ?>>
		<?php echo $process_action_payment_e->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $process_action_payment_e->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_payment_e_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_payment_e_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_payment_e_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_payment_e_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_e_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_e_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_e_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_payment_e_list->showPageHeader(); ?>
<?php
$process_action_payment_e_list->showMessage();
?>
<?php if ($process_action_payment_e_list->TotalRecs > 0 || $process_action_payment_e->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_payment_e_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_payment_e">
<?php if (!$process_action_payment_e->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_payment_e->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_e_list->Pager)) $process_action_payment_e_list->Pager = new PrevNextPager($process_action_payment_e_list->StartRec, $process_action_payment_e_list->DisplayRecs, $process_action_payment_e_list->TotalRecs, $process_action_payment_e_list->AutoHidePager) ?>
<?php if ($process_action_payment_e_list->Pager->RecordCount > 0 && $process_action_payment_e_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_e_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_e_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_e_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_e_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_e_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_e_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_e_list->TotalRecs > 0 && (!$process_action_payment_e_list->AutoHidePageSizeSelector || $process_action_payment_e_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_e">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_e_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_e_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_e_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_e_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_e_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_e->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_e_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_payment_elist" id="fprocess_action_payment_elist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_payment_e_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_payment_e_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_payment_e">
<div id="gmp_process_action_payment_e" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_payment_e_list->TotalRecs > 0 || $process_action_payment_e->isGridEdit()) { ?>
<table id="tbl_process_action_payment_elist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_payment_e_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_payment_e_list->renderListOptions();

// Render list options (header, left)
$process_action_payment_e_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_payment_e->location->Visible) { // location ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action_payment_e->location->headerCellClass() ?>"><div id="elh_process_action_payment_e_location" class="process_action_payment_e_location"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action_payment_e->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->location) ?>',2);"><div id="elh_process_action_payment_e_location" class="process_action_payment_e_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->emp_id->Visible) { // emp_id ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_e->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_e_emp_id" class="process_action_payment_e_emp_id"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_e->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->emp_id) ?>',2);"><div id="elh_process_action_payment_e_emp_id" class="process_action_payment_e_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->employee_name->Visible) { // employee_name ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->employee_name) == "") { ?>
		<th data-name="employee_name" class="<?php echo $process_action_payment_e->employee_name->headerCellClass() ?>"><div id="elh_process_action_payment_e_employee_name" class="process_action_payment_e_employee_name"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->employee_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_name" class="<?php echo $process_action_payment_e->employee_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->employee_name) ?>',2);"><div id="elh_process_action_payment_e_employee_name" class="process_action_payment_e_employee_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->employee_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->employee_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->employee_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->amount->Visible) { // amount ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_e->amount->headerCellClass() ?>"><div id="elh_process_action_payment_e_amount" class="process_action_payment_e_amount"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_e->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->amount) ?>',2);"><div id="elh_process_action_payment_e_amount" class="process_action_payment_e_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->payment->Visible) { // payment ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_e->payment->headerCellClass() ?>"><div id="elh_process_action_payment_e_payment" class="process_action_payment_e_payment"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_e->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->payment) ?>',2);"><div id="elh_process_action_payment_e_payment" class="process_action_payment_e_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->bank_name->Visible) { // bank_name ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->bank_name) == "") { ?>
		<th data-name="bank_name" class="<?php echo $process_action_payment_e->bank_name->headerCellClass() ?>"><div id="elh_process_action_payment_e_bank_name" class="process_action_payment_e_bank_name"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_name" class="<?php echo $process_action_payment_e->bank_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->bank_name) ?>',2);"><div id="elh_process_action_payment_e_bank_name" class="process_action_payment_e_bank_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->bank_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->bank_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->bank_ifsc_code) == "") { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $process_action_payment_e->bank_ifsc_code->headerCellClass() ?>"><div id="elh_process_action_payment_e_bank_ifsc_code" class="process_action_payment_e_bank_ifsc_code"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_ifsc_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_ifsc_code" class="<?php echo $process_action_payment_e->bank_ifsc_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->bank_ifsc_code) ?>',2);"><div id="elh_process_action_payment_e_bank_ifsc_code" class="process_action_payment_e_bank_ifsc_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_ifsc_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->bank_ifsc_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->bank_ifsc_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->bank_account_no->Visible) { // bank_account_no ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->bank_account_no) == "") { ?>
		<th data-name="bank_account_no" class="<?php echo $process_action_payment_e->bank_account_no->headerCellClass() ?>"><div id="elh_process_action_payment_e_bank_account_no" class="process_action_payment_e_bank_account_no"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_account_no" class="<?php echo $process_action_payment_e->bank_account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->bank_account_no) ?>',2);"><div id="elh_process_action_payment_e_bank_account_no" class="process_action_payment_e_bank_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->bank_account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->bank_account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->bank_account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_e->contractor->Visible) { // contractor ?>
	<?php if ($process_action_payment_e->sortUrl($process_action_payment_e->contractor) == "") { ?>
		<th data-name="contractor" class="<?php echo $process_action_payment_e->contractor->headerCellClass() ?>"><div id="elh_process_action_payment_e_contractor" class="process_action_payment_e_contractor"><div class="ew-table-header-caption"><?php echo $process_action_payment_e->contractor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contractor" class="<?php echo $process_action_payment_e->contractor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_e->SortUrl($process_action_payment_e->contractor) ?>',2);"><div id="elh_process_action_payment_e_contractor" class="process_action_payment_e_contractor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_e->contractor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_e->contractor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_e->contractor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_payment_e_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_payment_e->ExportAll && $process_action_payment_e->isExport()) {
	$process_action_payment_e_list->StopRec = $process_action_payment_e_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_payment_e_list->TotalRecs > $process_action_payment_e_list->StartRec + $process_action_payment_e_list->DisplayRecs - 1)
		$process_action_payment_e_list->StopRec = $process_action_payment_e_list->StartRec + $process_action_payment_e_list->DisplayRecs - 1;
	else
		$process_action_payment_e_list->StopRec = $process_action_payment_e_list->TotalRecs;
}
$process_action_payment_e_list->RecCnt = $process_action_payment_e_list->StartRec - 1;
if ($process_action_payment_e_list->Recordset && !$process_action_payment_e_list->Recordset->EOF) {
	$process_action_payment_e_list->Recordset->moveFirst();
	$selectLimit = $process_action_payment_e_list->UseSelectLimit;
	if (!$selectLimit && $process_action_payment_e_list->StartRec > 1)
		$process_action_payment_e_list->Recordset->move($process_action_payment_e_list->StartRec - 1);
} elseif (!$process_action_payment_e->AllowAddDeleteRow && $process_action_payment_e_list->StopRec == 0) {
	$process_action_payment_e_list->StopRec = $process_action_payment_e->GridAddRowCount;
}

// Initialize aggregate
$process_action_payment_e->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_payment_e->resetAttributes();
$process_action_payment_e_list->renderRow();
while ($process_action_payment_e_list->RecCnt < $process_action_payment_e_list->StopRec) {
	$process_action_payment_e_list->RecCnt++;
	if ($process_action_payment_e_list->RecCnt >= $process_action_payment_e_list->StartRec) {
		$process_action_payment_e_list->RowCnt++;

		// Set up key count
		$process_action_payment_e_list->KeyCount = $process_action_payment_e_list->RowIndex;

		// Init row class and style
		$process_action_payment_e->resetAttributes();
		$process_action_payment_e->CssClass = "";
		if ($process_action_payment_e->isGridAdd()) {
		} else {
			$process_action_payment_e_list->loadRowValues($process_action_payment_e_list->Recordset); // Load row values
		}
		$process_action_payment_e->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_payment_e->RowAttrs = array_merge($process_action_payment_e->RowAttrs, array('data-rowindex'=>$process_action_payment_e_list->RowCnt, 'id'=>'r' . $process_action_payment_e_list->RowCnt . '_process_action_payment_e', 'data-rowtype'=>$process_action_payment_e->RowType));

		// Render row
		$process_action_payment_e_list->renderRow();

		// Render list options
		$process_action_payment_e_list->renderListOptions();
?>
	<tr<?php echo $process_action_payment_e->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_payment_e_list->ListOptions->render("body", "left", $process_action_payment_e_list->RowCnt);
?>
	<?php if ($process_action_payment_e->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action_payment_e->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_location" class="process_action_payment_e_location">
<span<?php echo $process_action_payment_e->location->viewAttributes() ?>>
<?php echo $process_action_payment_e->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $process_action_payment_e->emp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_emp_id" class="process_action_payment_e_emp_id">
<span<?php echo $process_action_payment_e->emp_id->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_e->emp_id->getViewValue())) && $process_action_payment_e->emp_id->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_e->emp_id->linkAttributes() ?>><?php echo $process_action_payment_e->emp_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_e->emp_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->employee_name->Visible) { // employee_name ?>
		<td data-name="employee_name"<?php echo $process_action_payment_e->employee_name->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_employee_name" class="process_action_payment_e_employee_name">
<span<?php echo $process_action_payment_e->employee_name->viewAttributes() ?>>
<?php echo $process_action_payment_e->employee_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $process_action_payment_e->amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_amount" class="process_action_payment_e_amount">
<span<?php echo $process_action_payment_e->amount->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_e->amount->getViewValue())) && $process_action_payment_e->amount->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_e->amount->linkAttributes() ?>><?php echo $process_action_payment_e->amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_e->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_payment_e->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_payment" class="process_action_payment_e_payment">
<span<?php echo $process_action_payment_e->payment->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_e->payment->getViewValue())) && $process_action_payment_e->payment->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_e->payment->linkAttributes() ?>><?php echo $process_action_payment_e->payment->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_e->payment->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_name->Visible) { // bank_name ?>
		<td data-name="bank_name"<?php echo $process_action_payment_e->bank_name->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_bank_name" class="process_action_payment_e_bank_name">
<span<?php echo $process_action_payment_e->bank_name->viewAttributes() ?>>
<?php echo $process_action_payment_e->bank_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
		<td data-name="bank_ifsc_code"<?php echo $process_action_payment_e->bank_ifsc_code->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_bank_ifsc_code" class="process_action_payment_e_bank_ifsc_code">
<span<?php echo $process_action_payment_e->bank_ifsc_code->viewAttributes() ?>>
<?php echo $process_action_payment_e->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_account_no->Visible) { // bank_account_no ?>
		<td data-name="bank_account_no"<?php echo $process_action_payment_e->bank_account_no->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_bank_account_no" class="process_action_payment_e_bank_account_no">
<span<?php echo $process_action_payment_e->bank_account_no->viewAttributes() ?>>
<?php echo $process_action_payment_e->bank_account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_e->contractor->Visible) { // contractor ?>
		<td data-name="contractor"<?php echo $process_action_payment_e->contractor->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_e_list->RowCnt ?>_process_action_payment_e_contractor" class="process_action_payment_e_contractor">
<span<?php echo $process_action_payment_e->contractor->viewAttributes() ?>>
<?php echo $process_action_payment_e->contractor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_payment_e_list->ListOptions->render("body", "right", $process_action_payment_e_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_payment_e->isGridAdd())
		$process_action_payment_e_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_action_payment_e->RowType = ROWTYPE_AGGREGATE;
$process_action_payment_e->resetAttributes();
$process_action_payment_e_list->renderRow();
?>
<?php if ($process_action_payment_e_list->TotalRecs > 0 && !$process_action_payment_e->isGridAdd() && !$process_action_payment_e->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_action_payment_e_list->renderListOptions();

// Render list options (footer, left)
$process_action_payment_e_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_action_payment_e->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $process_action_payment_e->location->footerCellClass() ?>"><span id="elf_process_action_payment_e_location" class="process_action_payment_e_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id" class="<?php echo $process_action_payment_e->emp_id->footerCellClass() ?>"><span id="elf_process_action_payment_e_emp_id" class="process_action_payment_e_emp_id">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_e->emp_id->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->employee_name->Visible) { // employee_name ?>
		<td data-name="employee_name" class="<?php echo $process_action_payment_e->employee_name->footerCellClass() ?>"><span id="elf_process_action_payment_e_employee_name" class="process_action_payment_e_employee_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $process_action_payment_e->amount->footerCellClass() ?>"><span id="elf_process_action_payment_e_amount" class="process_action_payment_e_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_e->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_action_payment_e->payment->footerCellClass() ?>"><span id="elf_process_action_payment_e_payment" class="process_action_payment_e_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_name->Visible) { // bank_name ?>
		<td data-name="bank_name" class="<?php echo $process_action_payment_e->bank_name->footerCellClass() ?>"><span id="elf_process_action_payment_e_bank_name" class="process_action_payment_e_bank_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
		<td data-name="bank_ifsc_code" class="<?php echo $process_action_payment_e->bank_ifsc_code->footerCellClass() ?>"><span id="elf_process_action_payment_e_bank_ifsc_code" class="process_action_payment_e_bank_ifsc_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->bank_account_no->Visible) { // bank_account_no ?>
		<td data-name="bank_account_no" class="<?php echo $process_action_payment_e->bank_account_no->footerCellClass() ?>"><span id="elf_process_action_payment_e_bank_account_no" class="process_action_payment_e_bank_account_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_e->contractor->Visible) { // contractor ?>
		<td data-name="contractor" class="<?php echo $process_action_payment_e->contractor->footerCellClass() ?>"><span id="elf_process_action_payment_e_contractor" class="process_action_payment_e_contractor">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_action_payment_e_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_payment_e->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_payment_e_list->Recordset)
	$process_action_payment_e_list->Recordset->Close();
?>
<?php if (!$process_action_payment_e->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_payment_e->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_e_list->Pager)) $process_action_payment_e_list->Pager = new PrevNextPager($process_action_payment_e_list->StartRec, $process_action_payment_e_list->DisplayRecs, $process_action_payment_e_list->TotalRecs, $process_action_payment_e_list->AutoHidePager) ?>
<?php if ($process_action_payment_e_list->Pager->RecordCount > 0 && $process_action_payment_e_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_e_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_e_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_e_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_e_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_e_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_e_list->pageUrl() ?>start=<?php echo $process_action_payment_e_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_e_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_e_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_e_list->TotalRecs > 0 && (!$process_action_payment_e_list->AutoHidePageSizeSelector || $process_action_payment_e_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_e">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_e_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_e_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_e_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_e_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_e_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_e->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_e_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_payment_e_list->TotalRecs == 0 && !$process_action_payment_e->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_payment_e_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_payment_e_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_payment_e->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_payment_e->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_payment_e", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_payment_e_list->terminate();
?>