<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_payment_pe_list = new process_action_payment_pe_list();

// Run the page
$process_action_payment_pe_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_payment_pe_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_payment_pe->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_payment_pelist = currentForm = new ew.Form("fprocess_action_payment_pelist", "list");
fprocess_action_payment_pelist.formKeyCountName = '<?php echo $process_action_payment_pe_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_payment_pelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_payment_pelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_payment_pelist.lists["x_location"] = <?php echo $process_action_payment_pe_list->location->Lookup->toClientList() ?>;
fprocess_action_payment_pelist.lists["x_location"].options = <?php echo JsonEncode($process_action_payment_pe_list->location->lookupOptions()) ?>;
fprocess_action_payment_pelist.lists["x_process"] = <?php echo $process_action_payment_pe_list->process->Lookup->toClientList() ?>;
fprocess_action_payment_pelist.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_pe_list->process->lookupOptions()) ?>;
fprocess_action_payment_pelist.lists["x_emp_id"] = <?php echo $process_action_payment_pe_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_payment_pelist.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_pe_list->emp_id->lookupOptions()) ?>;
fprocess_action_payment_pelist.lists["x_payment"] = <?php echo $process_action_payment_pe_list->payment->Lookup->toClientList() ?>;
fprocess_action_payment_pelist.lists["x_payment"].options = <?php echo JsonEncode($process_action_payment_pe_list->payment->lookupOptions()) ?>;

// Form object for search
var fprocess_action_payment_pelistsrch = currentSearchForm = new ew.Form("fprocess_action_payment_pelistsrch");

// Validate function for search
fprocess_action_payment_pelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_payment_pelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_payment_pelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_payment_pelistsrch.lists["x_location"] = <?php echo $process_action_payment_pe_list->location->Lookup->toClientList() ?>;
fprocess_action_payment_pelistsrch.lists["x_location"].options = <?php echo JsonEncode($process_action_payment_pe_list->location->lookupOptions()) ?>;
fprocess_action_payment_pelistsrch.lists["x_process"] = <?php echo $process_action_payment_pe_list->process->Lookup->toClientList() ?>;
fprocess_action_payment_pelistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_pe_list->process->lookupOptions()) ?>;
fprocess_action_payment_pelistsrch.lists["x_emp_id"] = <?php echo $process_action_payment_pe_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_payment_pelistsrch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_pe_list->emp_id->lookupOptions()) ?>;
fprocess_action_payment_pelistsrch.lists["x_payment"] = <?php echo $process_action_payment_pe_list->payment->Lookup->toClientList() ?>;
fprocess_action_payment_pelistsrch.lists["x_payment"].options = <?php echo JsonEncode($process_action_payment_pe_list->payment->lookupOptions()) ?>;

// Filters
fprocess_action_payment_pelistsrch.filterList = <?php echo $process_action_payment_pe_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_payment_pelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_payment_pe->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_payment_pe_list->TotalRecs > 0 && $process_action_payment_pe_list->ExportOptions->visible()) { ?>
<?php $process_action_payment_pe_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_pe_list->ImportOptions->visible()) { ?>
<?php $process_action_payment_pe_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_pe_list->SearchOptions->visible()) { ?>
<?php $process_action_payment_pe_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_pe_list->FilterOptions->visible()) { ?>
<?php $process_action_payment_pe_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_payment_pe_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_payment_pe->isExport() && !$process_action_payment_pe->CurrentAction) { ?>
<form name="fprocess_action_payment_pelistsrch" id="fprocess_action_payment_pelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_payment_pe_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_payment_pelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_payment_pe">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_payment_pe_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_payment_pe->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_payment_pe->resetAttributes();
$process_action_payment_pe_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_payment_pe->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action_payment_pe->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment_pe" data-field="x_location" data-value-separator="<?php echo $process_action_payment_pe->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_payment_pe->location->editAttributes() ?>>
		<?php echo $process_action_payment_pe->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_payment_pe->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment_pe->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action_payment_pe->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment_pe" data-field="x_process" data-value-separator="<?php echo $process_action_payment_pe->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_payment_pe->process->editAttributes() ?>>
		<?php echo $process_action_payment_pe->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_payment_pe->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment_pe->emp_id->Visible) { // emp_id ?>
	<div id="xsc_emp_id" class="ew-cell form-group">
		<label for="x_emp_id" class="ew-search-caption ew-label"><?php echo $process_action_payment_pe->emp_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_emp_id" id="z_emp_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_payment_pe->emp_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_emp_id"><?php echo strval($process_action_payment_pe->emp_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_payment_pe->emp_id->AdvancedSearch->ViewValue) : $process_action_payment_pe->emp_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_payment_pe->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_payment_pe->emp_id->ReadOnly || $process_action_payment_pe->emp_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_payment_pe->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
<input type="hidden" data-table="process_action_payment_pe" data-field="x_emp_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_payment_pe->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id" id="x_emp_id" value="<?php echo $process_action_payment_pe->emp_id->AdvancedSearch->SearchValue ?>"<?php echo $process_action_payment_pe->emp_id->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_emp_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_emp_id style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_emp_id"><?php echo strval($process_action_payment_pe->emp_id->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($process_action_payment_pe->emp_id->AdvancedSearch->ViewValue2) : $process_action_payment_pe->emp_id->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($process_action_payment_pe->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($process_action_payment_pe->emp_id->ReadOnly || $process_action_payment_pe->emp_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_emp_id',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $process_action_payment_pe->emp_id->Lookup->getParamTag("p_y_emp_id") ?>
<input type="hidden" data-table="process_action_payment_pe" data-field="x_emp_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $process_action_payment_pe->emp_id->displayValueSeparatorAttribute() ?>" name="y_emp_id" id="y_emp_id" value="<?php echo $process_action_payment_pe->emp_id->AdvancedSearch->SearchValue2 ?>"<?php echo $process_action_payment_pe->emp_id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action_payment_pe->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label for="x_payment" class="ew-search-caption ew-label"><?php echo $process_action_payment_pe->payment->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment_pe" data-field="x_payment" data-value-separator="<?php echo $process_action_payment_pe->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $process_action_payment_pe->payment->editAttributes() ?>>
		<?php echo $process_action_payment_pe->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $process_action_payment_pe->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_payment_pe_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_payment_pe_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_payment_pe_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_payment_pe_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_pe_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_pe_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_pe_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_payment_pe_list->showPageHeader(); ?>
<?php
$process_action_payment_pe_list->showMessage();
?>
<?php if ($process_action_payment_pe_list->TotalRecs > 0 || $process_action_payment_pe->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_payment_pe_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_payment_pe">
<?php if (!$process_action_payment_pe->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_payment_pe->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_pe_list->Pager)) $process_action_payment_pe_list->Pager = new PrevNextPager($process_action_payment_pe_list->StartRec, $process_action_payment_pe_list->DisplayRecs, $process_action_payment_pe_list->TotalRecs, $process_action_payment_pe_list->AutoHidePager) ?>
<?php if ($process_action_payment_pe_list->Pager->RecordCount > 0 && $process_action_payment_pe_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_pe_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_pe_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_pe_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_pe_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_pe_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_pe_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_pe_list->TotalRecs > 0 && (!$process_action_payment_pe_list->AutoHidePageSizeSelector || $process_action_payment_pe_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_pe">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_pe_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_pe_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_pe_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_pe_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_pe_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_pe->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_pe_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_payment_pelist" id="fprocess_action_payment_pelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_payment_pe_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_payment_pe_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_payment_pe">
<div id="gmp_process_action_payment_pe" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_payment_pe_list->TotalRecs > 0 || $process_action_payment_pe->isGridEdit()) { ?>
<table id="tbl_process_action_payment_pelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_payment_pe_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_payment_pe_list->renderListOptions();

// Render list options (header, left)
$process_action_payment_pe_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_payment_pe->location->Visible) { // location ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action_payment_pe->location->headerCellClass() ?>"><div id="elh_process_action_payment_pe_location" class="process_action_payment_pe_location"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action_payment_pe->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->location) ?>',2);"><div id="elh_process_action_payment_pe_location" class="process_action_payment_pe_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->process->Visible) { // process ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_payment_pe->process->headerCellClass() ?>"><div id="elh_process_action_payment_pe_process" class="process_action_payment_pe_process"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_payment_pe->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->process) ?>',2);"><div id="elh_process_action_payment_pe_process" class="process_action_payment_pe_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->emp_id->Visible) { // emp_id ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_pe->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment_pe->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->emp_id) ?>',2);"><div id="elh_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->qty->Visible) { // qty ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $process_action_payment_pe->qty->headerCellClass() ?>"><div id="elh_process_action_payment_pe_qty" class="process_action_payment_pe_qty"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $process_action_payment_pe->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->qty) ?>',2);"><div id="elh_process_action_payment_pe_qty" class="process_action_payment_pe_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->sqm->Visible) { // sqm ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment_pe->sqm->headerCellClass() ?>"><div id="elh_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment_pe->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->sqm) ?>',2);"><div id="elh_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->amount->Visible) { // amount ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_pe->amount->headerCellClass() ?>"><div id="elh_process_action_payment_pe_amount" class="process_action_payment_pe_amount"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $process_action_payment_pe->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->amount) ?>',2);"><div id="elh_process_action_payment_pe_amount" class="process_action_payment_pe_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->payment->Visible) { // payment ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_pe->payment->headerCellClass() ?>"><div id="elh_process_action_payment_pe_payment" class="process_action_payment_pe_payment"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_payment_pe->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->payment) ?>',2);"><div id="elh_process_action_payment_pe_payment" class="process_action_payment_pe_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->remarks->Visible) { // remarks ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $process_action_payment_pe->remarks->headerCellClass() ?>"><div id="elh_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $process_action_payment_pe->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->remarks) ?>',2);"><div id="elh_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment_pe->contractor->Visible) { // contractor ?>
	<?php if ($process_action_payment_pe->sortUrl($process_action_payment_pe->contractor) == "") { ?>
		<th data-name="contractor" class="<?php echo $process_action_payment_pe->contractor->headerCellClass() ?>"><div id="elh_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor"><div class="ew-table-header-caption"><?php echo $process_action_payment_pe->contractor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contractor" class="<?php echo $process_action_payment_pe->contractor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment_pe->SortUrl($process_action_payment_pe->contractor) ?>',2);"><div id="elh_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment_pe->contractor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment_pe->contractor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment_pe->contractor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_payment_pe_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_payment_pe->ExportAll && $process_action_payment_pe->isExport()) {
	$process_action_payment_pe_list->StopRec = $process_action_payment_pe_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_payment_pe_list->TotalRecs > $process_action_payment_pe_list->StartRec + $process_action_payment_pe_list->DisplayRecs - 1)
		$process_action_payment_pe_list->StopRec = $process_action_payment_pe_list->StartRec + $process_action_payment_pe_list->DisplayRecs - 1;
	else
		$process_action_payment_pe_list->StopRec = $process_action_payment_pe_list->TotalRecs;
}
$process_action_payment_pe_list->RecCnt = $process_action_payment_pe_list->StartRec - 1;
if ($process_action_payment_pe_list->Recordset && !$process_action_payment_pe_list->Recordset->EOF) {
	$process_action_payment_pe_list->Recordset->moveFirst();
	$selectLimit = $process_action_payment_pe_list->UseSelectLimit;
	if (!$selectLimit && $process_action_payment_pe_list->StartRec > 1)
		$process_action_payment_pe_list->Recordset->move($process_action_payment_pe_list->StartRec - 1);
} elseif (!$process_action_payment_pe->AllowAddDeleteRow && $process_action_payment_pe_list->StopRec == 0) {
	$process_action_payment_pe_list->StopRec = $process_action_payment_pe->GridAddRowCount;
}

// Initialize aggregate
$process_action_payment_pe->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_payment_pe->resetAttributes();
$process_action_payment_pe_list->renderRow();
while ($process_action_payment_pe_list->RecCnt < $process_action_payment_pe_list->StopRec) {
	$process_action_payment_pe_list->RecCnt++;
	if ($process_action_payment_pe_list->RecCnt >= $process_action_payment_pe_list->StartRec) {
		$process_action_payment_pe_list->RowCnt++;

		// Set up key count
		$process_action_payment_pe_list->KeyCount = $process_action_payment_pe_list->RowIndex;

		// Init row class and style
		$process_action_payment_pe->resetAttributes();
		$process_action_payment_pe->CssClass = "";
		if ($process_action_payment_pe->isGridAdd()) {
		} else {
			$process_action_payment_pe_list->loadRowValues($process_action_payment_pe_list->Recordset); // Load row values
		}
		$process_action_payment_pe->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_payment_pe->RowAttrs = array_merge($process_action_payment_pe->RowAttrs, array('data-rowindex'=>$process_action_payment_pe_list->RowCnt, 'id'=>'r' . $process_action_payment_pe_list->RowCnt . '_process_action_payment_pe', 'data-rowtype'=>$process_action_payment_pe->RowType));

		// Render row
		$process_action_payment_pe_list->renderRow();

		// Render list options
		$process_action_payment_pe_list->renderListOptions();
?>
	<tr<?php echo $process_action_payment_pe->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_payment_pe_list->ListOptions->render("body", "left", $process_action_payment_pe_list->RowCnt);
?>
	<?php if ($process_action_payment_pe->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action_payment_pe->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_location" class="process_action_payment_pe_location">
<span<?php echo $process_action_payment_pe->location->viewAttributes() ?>>
<?php echo $process_action_payment_pe->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_payment_pe->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_process" class="process_action_payment_pe_process">
<span<?php echo $process_action_payment_pe->process->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_pe->process->getViewValue())) && $process_action_payment_pe->process->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_pe->process->linkAttributes() ?>><?php echo $process_action_payment_pe->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_pe->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $process_action_payment_pe->emp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id">
<span<?php echo $process_action_payment_pe->emp_id->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_pe->emp_id->getViewValue())) && $process_action_payment_pe->emp_id->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_pe->emp_id->linkAttributes() ?>><?php echo $process_action_payment_pe->emp_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_pe->emp_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $process_action_payment_pe->qty->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_qty" class="process_action_payment_pe_qty">
<span<?php echo $process_action_payment_pe->qty->viewAttributes() ?>>
<?php echo $process_action_payment_pe->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $process_action_payment_pe->sqm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm">
<span<?php echo $process_action_payment_pe->sqm->viewAttributes() ?>>
<?php echo $process_action_payment_pe->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $process_action_payment_pe->amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_amount" class="process_action_payment_pe_amount">
<span<?php echo $process_action_payment_pe->amount->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_pe->amount->getViewValue())) && $process_action_payment_pe->amount->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_pe->amount->linkAttributes() ?>><?php echo $process_action_payment_pe->amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_pe->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_payment_pe->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_payment" class="process_action_payment_pe_payment">
<span<?php echo $process_action_payment_pe->payment->viewAttributes() ?>>
<?php if ((!EmptyString($process_action_payment_pe->payment->getViewValue())) && $process_action_payment_pe->payment->linkAttributes() <> "") { ?>
<a<?php echo $process_action_payment_pe->payment->linkAttributes() ?>><?php echo $process_action_payment_pe->payment->getViewValue() ?></a>
<?php } else { ?>
<?php echo $process_action_payment_pe->payment->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $process_action_payment_pe->remarks->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks">
<span<?php echo $process_action_payment_pe->remarks->viewAttributes() ?>>
<?php echo $process_action_payment_pe->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment_pe->contractor->Visible) { // contractor ?>
		<td data-name="contractor"<?php echo $process_action_payment_pe->contractor->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_pe_list->RowCnt ?>_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor">
<span<?php echo $process_action_payment_pe->contractor->viewAttributes() ?>>
<?php echo $process_action_payment_pe->contractor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_payment_pe_list->ListOptions->render("body", "right", $process_action_payment_pe_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_payment_pe->isGridAdd())
		$process_action_payment_pe_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_action_payment_pe->RowType = ROWTYPE_AGGREGATE;
$process_action_payment_pe->resetAttributes();
$process_action_payment_pe_list->renderRow();
?>
<?php if ($process_action_payment_pe_list->TotalRecs > 0 && !$process_action_payment_pe->isGridAdd() && !$process_action_payment_pe->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_action_payment_pe_list->renderListOptions();

// Render list options (footer, left)
$process_action_payment_pe_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_action_payment_pe->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $process_action_payment_pe->location->footerCellClass() ?>"><span id="elf_process_action_payment_pe_location" class="process_action_payment_pe_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $process_action_payment_pe->process->footerCellClass() ?>"><span id="elf_process_action_payment_pe_process" class="process_action_payment_pe_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id" class="<?php echo $process_action_payment_pe->emp_id->footerCellClass() ?>"><span id="elf_process_action_payment_pe_emp_id" class="process_action_payment_pe_emp_id">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_pe->emp_id->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $process_action_payment_pe->qty->footerCellClass() ?>"><span id="elf_process_action_payment_pe_qty" class="process_action_payment_pe_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_pe->qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $process_action_payment_pe->sqm->footerCellClass() ?>"><span id="elf_process_action_payment_pe_sqm" class="process_action_payment_pe_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_pe->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $process_action_payment_pe->amount->footerCellClass() ?>"><span id="elf_process_action_payment_pe_amount" class="process_action_payment_pe_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment_pe->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_action_payment_pe->payment->footerCellClass() ?>"><span id="elf_process_action_payment_pe_payment" class="process_action_payment_pe_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $process_action_payment_pe->remarks->footerCellClass() ?>"><span id="elf_process_action_payment_pe_remarks" class="process_action_payment_pe_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment_pe->contractor->Visible) { // contractor ?>
		<td data-name="contractor" class="<?php echo $process_action_payment_pe->contractor->footerCellClass() ?>"><span id="elf_process_action_payment_pe_contractor" class="process_action_payment_pe_contractor">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_action_payment_pe_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_payment_pe->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_payment_pe_list->Recordset)
	$process_action_payment_pe_list->Recordset->Close();
?>
<?php if (!$process_action_payment_pe->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_payment_pe->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_pe_list->Pager)) $process_action_payment_pe_list->Pager = new PrevNextPager($process_action_payment_pe_list->StartRec, $process_action_payment_pe_list->DisplayRecs, $process_action_payment_pe_list->TotalRecs, $process_action_payment_pe_list->AutoHidePager) ?>
<?php if ($process_action_payment_pe_list->Pager->RecordCount > 0 && $process_action_payment_pe_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_pe_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_pe_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_pe_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_pe_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_pe_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_pe_list->pageUrl() ?>start=<?php echo $process_action_payment_pe_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_pe_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_pe_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_pe_list->TotalRecs > 0 && (!$process_action_payment_pe_list->AutoHidePageSizeSelector || $process_action_payment_pe_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment_pe">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_pe_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_pe_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_pe_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_pe_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_pe_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment_pe->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_pe_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_payment_pe_list->TotalRecs == 0 && !$process_action_payment_pe->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_payment_pe_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_payment_pe_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_payment_pe->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_payment_pe->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_payment_pe", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_payment_pe_list->terminate();
?>