<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$process_action_payment_list = new process_action_payment_list();

// Run the page
$process_action_payment_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$process_action_payment_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$process_action_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fprocess_action_paymentlist = currentForm = new ew.Form("fprocess_action_paymentlist", "list");
fprocess_action_paymentlist.formKeyCountName = '<?php echo $process_action_payment_list->FormKeyCountName ?>';

// Form_CustomValidate event
fprocess_action_paymentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_paymentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_paymentlist.lists["x_location"] = <?php echo $process_action_payment_list->location->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_location"].options = <?php echo JsonEncode($process_action_payment_list->location->lookupOptions()) ?>;
fprocess_action_paymentlist.lists["x_process"] = <?php echo $process_action_payment_list->process->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_list->process->lookupOptions()) ?>;
fprocess_action_paymentlist.lists["x_emp_id"] = <?php echo $process_action_payment_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_list->emp_id->lookupOptions()) ?>;
fprocess_action_paymentlist.lists["x_ref"] = <?php echo $process_action_payment_list->ref->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_ref"].options = <?php echo JsonEncode($process_action_payment_list->ref->lookupOptions()) ?>;
fprocess_action_paymentlist.lists["x_c_id"] = <?php echo $process_action_payment_list->c_id->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_c_id"].options = <?php echo JsonEncode($process_action_payment_list->c_id->lookupOptions()) ?>;
fprocess_action_paymentlist.lists["x_payment_type"] = <?php echo $process_action_payment_list->payment_type->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_payment_type"].options = <?php echo JsonEncode($process_action_payment_list->payment_type->options(FALSE, TRUE)) ?>;
fprocess_action_paymentlist.lists["x_process_fix"] = <?php echo $process_action_payment_list->process_fix->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_process_fix"].options = <?php echo JsonEncode($process_action_payment_list->process_fix->options(FALSE, TRUE)) ?>;
fprocess_action_paymentlist.lists["x_method"] = <?php echo $process_action_payment_list->method->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_method"].options = <?php echo JsonEncode($process_action_payment_list->method->options(FALSE, TRUE)) ?>;
fprocess_action_paymentlist.lists["x_payment[]"] = <?php echo $process_action_payment_list->payment->Lookup->toClientList() ?>;
fprocess_action_paymentlist.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_payment_list->payment->lookupOptions()) ?>;

// Form object for search
var fprocess_action_paymentlistsrch = currentSearchForm = new ew.Form("fprocess_action_paymentlistsrch");

// Validate function for search
fprocess_action_paymentlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($process_action_payment->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fprocess_action_paymentlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fprocess_action_paymentlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fprocess_action_paymentlistsrch.lists["x_location"] = <?php echo $process_action_payment_list->location->Lookup->toClientList() ?>;
fprocess_action_paymentlistsrch.lists["x_location"].options = <?php echo JsonEncode($process_action_payment_list->location->lookupOptions()) ?>;
fprocess_action_paymentlistsrch.lists["x_process"] = <?php echo $process_action_payment_list->process->Lookup->toClientList() ?>;
fprocess_action_paymentlistsrch.lists["x_process"].options = <?php echo JsonEncode($process_action_payment_list->process->lookupOptions()) ?>;
fprocess_action_paymentlistsrch.lists["x_emp_id"] = <?php echo $process_action_payment_list->emp_id->Lookup->toClientList() ?>;
fprocess_action_paymentlistsrch.lists["x_emp_id"].options = <?php echo JsonEncode($process_action_payment_list->emp_id->lookupOptions()) ?>;
fprocess_action_paymentlistsrch.lists["x_payment[]"] = <?php echo $process_action_payment_list->payment->Lookup->toClientList() ?>;
fprocess_action_paymentlistsrch.lists["x_payment[]"].options = <?php echo JsonEncode($process_action_payment_list->payment->lookupOptions()) ?>;

// Filters
fprocess_action_paymentlistsrch.filterList = <?php echo $process_action_payment_list->getFilterList() ?>;

// Init search panel as collapsed
fprocess_action_paymentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$process_action_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($process_action_payment_list->TotalRecs > 0 && $process_action_payment_list->ExportOptions->visible()) { ?>
<?php $process_action_payment_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_list->ImportOptions->visible()) { ?>
<?php $process_action_payment_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_list->SearchOptions->visible()) { ?>
<?php $process_action_payment_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($process_action_payment_list->FilterOptions->visible()) { ?>
<?php $process_action_payment_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$process_action_payment_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$process_action_payment->isExport() && !$process_action_payment->CurrentAction) { ?>
<form name="fprocess_action_paymentlistsrch" id="fprocess_action_paymentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($process_action_payment_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fprocess_action_paymentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="process_action_payment">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$process_action_payment_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$process_action_payment->RowType = ROWTYPE_SEARCH;

// Render row
$process_action_payment->resetAttributes();
$process_action_payment_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($process_action_payment->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $process_action_payment->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_location" data-value-separator="<?php echo $process_action_payment->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $process_action_payment->location->editAttributes() ?>>
		<?php echo $process_action_payment->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $process_action_payment->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $process_action_payment->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_process" data-value-separator="<?php echo $process_action_payment->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $process_action_payment->process->editAttributes() ?>>
		<?php echo $process_action_payment->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $process_action_payment->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($process_action_payment->emp_id->Visible) { // emp_id ?>
	<div id="xsc_emp_id" class="ew-cell form-group">
		<label for="x_emp_id" class="ew-search-caption ew-label"><?php echo $process_action_payment->emp_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="process_action_payment" data-field="x_emp_id" data-value-separator="<?php echo $process_action_payment->emp_id->displayValueSeparatorAttribute() ?>" id="x_emp_id" name="x_emp_id"<?php echo $process_action_payment->emp_id->editAttributes() ?>>
		<?php echo $process_action_payment->emp_id->selectOptionListHtml("x_emp_id") ?>
	</select>
</div>
<?php echo $process_action_payment->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment->code->Visible) { // code ?>
	<div id="xsc_code" class="ew-cell form-group">
		<label for="x_code" class="ew-search-caption ew-label"><?php echo $process_action_payment->code->caption() ?></label>
		<span class="ew-search-operator"><select name="z_code" id="z_code" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->code->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_payment" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_payment->code->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->code->EditValue ?>"<?php echo $process_action_payment->code->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_code style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_code style="d-none"">
<input type="text" data-table="process_action_payment" data-field="x_code" name="y_code" id="y_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($process_action_payment->code->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->code->EditValue2 ?>"<?php echo $process_action_payment->code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($process_action_payment->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $process_action_payment->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="process_action_payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($process_action_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->datetime->EditValue ?>"<?php echo $process_action_payment->datetime->editAttributes() ?>>
<?php if (!$process_action_payment->datetime->ReadOnly && !$process_action_payment->datetime->Disabled && !isset($process_action_payment->datetime->EditAttrs["readonly"]) && !isset($process_action_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_paymentlistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="process_action_payment" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($process_action_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $process_action_payment->datetime->EditValue2 ?>"<?php echo $process_action_payment->datetime->editAttributes() ?>>
<?php if (!$process_action_payment->datetime->ReadOnly && !$process_action_payment->datetime->Disabled && !isset($process_action_payment->datetime->EditAttrs["readonly"]) && !isset($process_action_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fprocess_action_paymentlistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($process_action_payment->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $process_action_payment->payment->caption() ?></label>
		<span class="ew-search-operator"><select name="z_payment" id="z_payment" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($process_action_payment->payment->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_payment->payment->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_payment" data-repeatcolumn="4" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_payment->payment->checkBoxListHtml(TRUE, "x_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_payment->payment->displayValueSeparatorAttribute() ?>" name="x_payment[]" id="x_payment[]" value="{value}"<?php echo $process_action_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_payment->payment->Lookup->getParamTag("p_x_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		<span class="ew-search-cond btw1_payment style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_payment style="d-none"">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($process_action_payment->payment->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $process_action_payment->payment->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_payment" data-repeatcolumn="4" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $process_action_payment->payment->checkBoxListHtml(TRUE, "y_payment[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_payment" class="ew-template"><input type="checkbox" class="form-check-input" data-table="process_action_payment" data-field="x_payment" data-value-separator="<?php echo $process_action_payment->payment->displayValueSeparatorAttribute() ?>" name="y_payment[]" id="y_payment[]" value="{value}"<?php echo $process_action_payment->payment->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$process_action_payment->payment->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $process_action_payment->payment->Lookup->getParamTag("p_y_payment") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($process_action_payment_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($process_action_payment_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $process_action_payment_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($process_action_payment_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($process_action_payment_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $process_action_payment_list->showPageHeader(); ?>
<?php
$process_action_payment_list->showMessage();
?>
<?php if ($process_action_payment_list->TotalRecs > 0 || $process_action_payment->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($process_action_payment_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> process_action_payment">
<?php if (!$process_action_payment->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$process_action_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_list->Pager)) $process_action_payment_list->Pager = new PrevNextPager($process_action_payment_list->StartRec, $process_action_payment_list->DisplayRecs, $process_action_payment_list->TotalRecs, $process_action_payment_list->AutoHidePager) ?>
<?php if ($process_action_payment_list->Pager->RecordCount > 0 && $process_action_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_list->TotalRecs > 0 && (!$process_action_payment_list->AutoHidePageSizeSelector || $process_action_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fprocess_action_paymentlist" id="fprocess_action_paymentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($process_action_payment_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $process_action_payment_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="process_action_payment">
<div id="gmp_process_action_payment" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($process_action_payment_list->TotalRecs > 0 || $process_action_payment->isGridEdit()) { ?>
<table id="tbl_process_action_paymentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$process_action_payment_list->RowType = ROWTYPE_HEADER;

// Render list options
$process_action_payment_list->renderListOptions();

// Render list options (header, left)
$process_action_payment_list->ListOptions->render("header", "left");
?>
<?php if ($process_action_payment->id->Visible) { // id ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->id) == "") { ?>
		<th data-name="id" class="<?php echo $process_action_payment->id->headerCellClass() ?>"><div id="elh_process_action_payment_id" class="process_action_payment_id"><div class="ew-table-header-caption"><?php echo $process_action_payment->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $process_action_payment->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->id) ?>',2);"><div id="elh_process_action_payment_id" class="process_action_payment_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->location->Visible) { // location ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->location) == "") { ?>
		<th data-name="location" class="<?php echo $process_action_payment->location->headerCellClass() ?>"><div id="elh_process_action_payment_location" class="process_action_payment_location"><div class="ew-table-header-caption"><?php echo $process_action_payment->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $process_action_payment->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->location) ?>',2);"><div id="elh_process_action_payment_location" class="process_action_payment_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->process->Visible) { // process ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->process) == "") { ?>
		<th data-name="process" class="<?php echo $process_action_payment->process->headerCellClass() ?>"><div id="elh_process_action_payment_process" class="process_action_payment_process"><div class="ew-table-header-caption"><?php echo $process_action_payment->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $process_action_payment->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->process) ?>',2);"><div id="elh_process_action_payment_process" class="process_action_payment_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->emp_id->Visible) { // emp_id ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment->emp_id->headerCellClass() ?>"><div id="elh_process_action_payment_emp_id" class="process_action_payment_emp_id"><div class="ew-table-header-caption"><?php echo $process_action_payment->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $process_action_payment->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->emp_id) ?>',2);"><div id="elh_process_action_payment_emp_id" class="process_action_payment_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->emp_grp->Visible) { // emp_grp ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->emp_grp) == "") { ?>
		<th data-name="emp_grp" class="<?php echo $process_action_payment->emp_grp->headerCellClass() ?>"><div id="elh_process_action_payment_emp_grp" class="process_action_payment_emp_grp"><div class="ew-table-header-caption"><?php echo $process_action_payment->emp_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_grp" class="<?php echo $process_action_payment->emp_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->emp_grp) ?>',2);"><div id="elh_process_action_payment_emp_grp" class="process_action_payment_emp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->emp_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->emp_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->emp_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->code->Visible) { // code ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->code) == "") { ?>
		<th data-name="code" class="<?php echo $process_action_payment->code->headerCellClass() ?>"><div id="elh_process_action_payment_code" class="process_action_payment_code"><div class="ew-table-header-caption"><?php echo $process_action_payment->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $process_action_payment->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->code) ?>',2);"><div id="elh_process_action_payment_code" class="process_action_payment_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->ref->Visible) { // ref ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $process_action_payment->ref->headerCellClass() ?>"><div id="elh_process_action_payment_ref" class="process_action_payment_ref"><div class="ew-table-header-caption"><?php echo $process_action_payment->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $process_action_payment->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->ref) ?>',2);"><div id="elh_process_action_payment_ref" class="process_action_payment_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->size_wl->Visible) { // size_wl ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->size_wl) == "") { ?>
		<th data-name="size_wl" class="<?php echo $process_action_payment->size_wl->headerCellClass() ?>"><div id="elh_process_action_payment_size_wl" class="process_action_payment_size_wl"><div class="ew-table-header-caption"><?php echo $process_action_payment->size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_wl" class="<?php echo $process_action_payment->size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->size_wl) ?>',2);"><div id="elh_process_action_payment_size_wl" class="process_action_payment_size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->size_wl->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->process_40->Visible) { // process_@ ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->process_40) == "") { ?>
		<th data-name="process_40" class="<?php echo $process_action_payment->process_40->headerCellClass() ?>"><div id="elh_process_action_payment_process_40" class="process_action_payment_process_40"><div class="ew-table-header-caption"><?php echo $process_action_payment->process_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_40" class="<?php echo $process_action_payment->process_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->process_40) ?>',2);"><div id="elh_process_action_payment_process_40" class="process_action_payment_process_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->process_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->process_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->process_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->final_amount->Visible) { // final_amount ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->final_amount) == "") { ?>
		<th data-name="final_amount" class="<?php echo $process_action_payment->final_amount->headerCellClass() ?>"><div id="elh_process_action_payment_final_amount" class="process_action_payment_final_amount"><div class="ew-table-header-caption"><?php echo $process_action_payment->final_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_amount" class="<?php echo $process_action_payment->final_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->final_amount) ?>',2);"><div id="elh_process_action_payment_final_amount" class="process_action_payment_final_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->final_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->final_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->final_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->amount->Visible) { // amount ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $process_action_payment->amount->headerCellClass() ?>"><div id="elh_process_action_payment_amount" class="process_action_payment_amount"><div class="ew-table-header-caption"><?php echo $process_action_payment->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $process_action_payment->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->amount) ?>',2);"><div id="elh_process_action_payment_amount" class="process_action_payment_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->c_charge->Visible) { // c_charge ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->c_charge) == "") { ?>
		<th data-name="c_charge" class="<?php echo $process_action_payment->c_charge->headerCellClass() ?>"><div id="elh_process_action_payment_c_charge" class="process_action_payment_c_charge"><div class="ew-table-header-caption"><?php echo $process_action_payment->c_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_charge" class="<?php echo $process_action_payment->c_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->c_charge) ?>',2);"><div id="elh_process_action_payment_c_charge" class="process_action_payment_c_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->c_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->c_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->c_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->custom_size->Visible) { // custom_size ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->custom_size) == "") { ?>
		<th data-name="custom_size" class="<?php echo $process_action_payment->custom_size->headerCellClass() ?>"><div id="elh_process_action_payment_custom_size" class="process_action_payment_custom_size"><div class="ew-table-header-caption"><?php echo $process_action_payment->custom_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size" class="<?php echo $process_action_payment->custom_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->custom_size) ?>',2);"><div id="elh_process_action_payment_custom_size" class="process_action_payment_custom_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->custom_size->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->custom_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->custom_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->ded_jc->Visible) { // ded_jc ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->ded_jc) == "") { ?>
		<th data-name="ded_jc" class="<?php echo $process_action_payment->ded_jc->headerCellClass() ?>"><div id="elh_process_action_payment_ded_jc" class="process_action_payment_ded_jc"><div class="ew-table-header-caption"><?php echo $process_action_payment->ded_jc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_jc" class="<?php echo $process_action_payment->ded_jc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->ded_jc) ?>',2);"><div id="elh_process_action_payment_ded_jc" class="process_action_payment_ded_jc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->ded_jc->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->ded_jc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->ded_jc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->ded_pa->Visible) { // ded_pa ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->ded_pa) == "") { ?>
		<th data-name="ded_pa" class="<?php echo $process_action_payment->ded_pa->headerCellClass() ?>"><div id="elh_process_action_payment_ded_pa" class="process_action_payment_ded_pa"><div class="ew-table-header-caption"><?php echo $process_action_payment->ded_pa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_pa" class="<?php echo $process_action_payment->ded_pa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->ded_pa) ?>',2);"><div id="elh_process_action_payment_ded_pa" class="process_action_payment_ded_pa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->ded_pa->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->ded_pa->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->ded_pa->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->c_id->Visible) { // c_id ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->c_id) == "") { ?>
		<th data-name="c_id" class="<?php echo $process_action_payment->c_id->headerCellClass() ?>"><div id="elh_process_action_payment_c_id" class="process_action_payment_c_id"><div class="ew-table-header-caption"><?php echo $process_action_payment->c_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_id" class="<?php echo $process_action_payment->c_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->c_id) ?>',2);"><div id="elh_process_action_payment_c_id" class="process_action_payment_c_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->c_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->c_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->c_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->payment_type->Visible) { // payment_type ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->payment_type) == "") { ?>
		<th data-name="payment_type" class="<?php echo $process_action_payment->payment_type->headerCellClass() ?>"><div id="elh_process_action_payment_payment_type" class="process_action_payment_payment_type"><div class="ew-table-header-caption"><?php echo $process_action_payment->payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_type" class="<?php echo $process_action_payment->payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->payment_type) ?>',2);"><div id="elh_process_action_payment_payment_type" class="process_action_payment_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->sqm->Visible) { // sqm ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment->sqm->headerCellClass() ?>"><div id="elh_process_action_payment_sqm" class="process_action_payment_sqm"><div class="ew-table-header-caption"><?php echo $process_action_payment->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $process_action_payment->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->sqm) ?>',2);"><div id="elh_process_action_payment_sqm" class="process_action_payment_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->sqm_grp->Visible) { // sqm_grp ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->sqm_grp) == "") { ?>
		<th data-name="sqm_grp" class="<?php echo $process_action_payment->sqm_grp->headerCellClass() ?>"><div id="elh_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp"><div class="ew-table-header-caption"><?php echo $process_action_payment->sqm_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_grp" class="<?php echo $process_action_payment->sqm_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->sqm_grp) ?>',2);"><div id="elh_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->sqm_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->sqm_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->sqm_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->_2_srm->Visible) { // 2_srm ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->_2_srm) == "") { ?>
		<th data-name="_2_srm" class="<?php echo $process_action_payment->_2_srm->headerCellClass() ?>"><div id="elh_process_action_payment__2_srm" class="process_action_payment__2_srm"><div class="ew-table-header-caption"><?php echo $process_action_payment->_2_srm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2_srm" class="<?php echo $process_action_payment->_2_srm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->_2_srm) ?>',2);"><div id="elh_process_action_payment__2_srm" class="process_action_payment__2_srm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->_2_srm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->_2_srm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->_2_srm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->_4_srm->Visible) { // 4_srm ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->_4_srm) == "") { ?>
		<th data-name="_4_srm" class="<?php echo $process_action_payment->_4_srm->headerCellClass() ?>"><div id="elh_process_action_payment__4_srm" class="process_action_payment__4_srm"><div class="ew-table-header-caption"><?php echo $process_action_payment->_4_srm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_4_srm" class="<?php echo $process_action_payment->_4_srm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->_4_srm) ?>',2);"><div id="elh_process_action_payment__4_srm" class="process_action_payment__4_srm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->_4_srm->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->_4_srm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->_4_srm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->process_fix->Visible) { // process_fix ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->process_fix) == "") { ?>
		<th data-name="process_fix" class="<?php echo $process_action_payment->process_fix->headerCellClass() ?>"><div id="elh_process_action_payment_process_fix" class="process_action_payment_process_fix"><div class="ew-table-header-caption"><?php echo $process_action_payment->process_fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_fix" class="<?php echo $process_action_payment->process_fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->process_fix) ?>',2);"><div id="elh_process_action_payment_process_fix" class="process_action_payment_process_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->process_fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->process_fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->process_fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->method->Visible) { // method ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->method) == "") { ?>
		<th data-name="method" class="<?php echo $process_action_payment->method->headerCellClass() ?>"><div id="elh_process_action_payment_method" class="process_action_payment_method"><div class="ew-table-header-caption"><?php echo $process_action_payment->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $process_action_payment->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->method) ?>',2);"><div id="elh_process_action_payment_method" class="process_action_payment_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->datetime->Visible) { // datetime ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $process_action_payment->datetime->headerCellClass() ?>"><div id="elh_process_action_payment_datetime" class="process_action_payment_datetime"><div class="ew-table-header-caption"><?php echo $process_action_payment->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $process_action_payment->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->datetime) ?>',2);"><div id="elh_process_action_payment_datetime" class="process_action_payment_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->payment->Visible) { // payment ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $process_action_payment->payment->headerCellClass() ?>"><div id="elh_process_action_payment_payment" class="process_action_payment_payment"><div class="ew-table-header-caption"><?php echo $process_action_payment->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $process_action_payment->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->payment) ?>',2);"><div id="elh_process_action_payment_payment" class="process_action_payment_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->remark->Visible) { // remark ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $process_action_payment->remark->headerCellClass() ?>"><div id="elh_process_action_payment_remark" class="process_action_payment_remark"><div class="ew-table-header-caption"><?php echo $process_action_payment->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $process_action_payment->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->remark) ?>',2);"><div id="elh_process_action_payment_remark" class="process_action_payment_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->c_method->Visible) { // c_method ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->c_method) == "") { ?>
		<th data-name="c_method" class="<?php echo $process_action_payment->c_method->headerCellClass() ?>"><div id="elh_process_action_payment_c_method" class="process_action_payment_c_method"><div class="ew-table-header-caption"><?php echo $process_action_payment->c_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_method" class="<?php echo $process_action_payment->c_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->c_method) ?>',2);"><div id="elh_process_action_payment_c_method" class="process_action_payment_c_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->c_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->c_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->c_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($process_action_payment->category->Visible) { // category ?>
	<?php if ($process_action_payment->sortUrl($process_action_payment->category) == "") { ?>
		<th data-name="category" class="<?php echo $process_action_payment->category->headerCellClass() ?>"><div id="elh_process_action_payment_category" class="process_action_payment_category"><div class="ew-table-header-caption"><?php echo $process_action_payment->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $process_action_payment->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $process_action_payment->SortUrl($process_action_payment->category) ?>',2);"><div id="elh_process_action_payment_category" class="process_action_payment_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $process_action_payment->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($process_action_payment->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($process_action_payment->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$process_action_payment_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($process_action_payment->ExportAll && $process_action_payment->isExport()) {
	$process_action_payment_list->StopRec = $process_action_payment_list->TotalRecs;
} else {

	// Set the last record to display
	if ($process_action_payment_list->TotalRecs > $process_action_payment_list->StartRec + $process_action_payment_list->DisplayRecs - 1)
		$process_action_payment_list->StopRec = $process_action_payment_list->StartRec + $process_action_payment_list->DisplayRecs - 1;
	else
		$process_action_payment_list->StopRec = $process_action_payment_list->TotalRecs;
}
$process_action_payment_list->RecCnt = $process_action_payment_list->StartRec - 1;
if ($process_action_payment_list->Recordset && !$process_action_payment_list->Recordset->EOF) {
	$process_action_payment_list->Recordset->moveFirst();
	$selectLimit = $process_action_payment_list->UseSelectLimit;
	if (!$selectLimit && $process_action_payment_list->StartRec > 1)
		$process_action_payment_list->Recordset->move($process_action_payment_list->StartRec - 1);
} elseif (!$process_action_payment->AllowAddDeleteRow && $process_action_payment_list->StopRec == 0) {
	$process_action_payment_list->StopRec = $process_action_payment->GridAddRowCount;
}

// Initialize aggregate
$process_action_payment->RowType = ROWTYPE_AGGREGATEINIT;
$process_action_payment->resetAttributes();
$process_action_payment_list->renderRow();
while ($process_action_payment_list->RecCnt < $process_action_payment_list->StopRec) {
	$process_action_payment_list->RecCnt++;
	if ($process_action_payment_list->RecCnt >= $process_action_payment_list->StartRec) {
		$process_action_payment_list->RowCnt++;

		// Set up key count
		$process_action_payment_list->KeyCount = $process_action_payment_list->RowIndex;

		// Init row class and style
		$process_action_payment->resetAttributes();
		$process_action_payment->CssClass = "";
		if ($process_action_payment->isGridAdd()) {
		} else {
			$process_action_payment_list->loadRowValues($process_action_payment_list->Recordset); // Load row values
		}
		$process_action_payment->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$process_action_payment->RowAttrs = array_merge($process_action_payment->RowAttrs, array('data-rowindex'=>$process_action_payment_list->RowCnt, 'id'=>'r' . $process_action_payment_list->RowCnt . '_process_action_payment', 'data-rowtype'=>$process_action_payment->RowType));

		// Render row
		$process_action_payment_list->renderRow();

		// Render list options
		$process_action_payment_list->renderListOptions();
?>
	<tr<?php echo $process_action_payment->rowAttributes() ?>>
<?php

// Render list options (body, left)
$process_action_payment_list->ListOptions->render("body", "left", $process_action_payment_list->RowCnt);
?>
	<?php if ($process_action_payment->id->Visible) { // id ?>
		<td data-name="id"<?php echo $process_action_payment->id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_id" class="process_action_payment_id">
<span<?php echo $process_action_payment->id->viewAttributes() ?>>
<?php echo $process_action_payment->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->location->Visible) { // location ?>
		<td data-name="location"<?php echo $process_action_payment->location->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_location" class="process_action_payment_location">
<span<?php echo $process_action_payment->location->viewAttributes() ?>>
<?php echo $process_action_payment->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->process->Visible) { // process ?>
		<td data-name="process"<?php echo $process_action_payment->process->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_process" class="process_action_payment_process">
<span<?php echo $process_action_payment->process->viewAttributes() ?>>
<?php echo $process_action_payment->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $process_action_payment->emp_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_emp_id" class="process_action_payment_emp_id">
<span<?php echo $process_action_payment->emp_id->viewAttributes() ?>>
<?php echo $process_action_payment->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->emp_grp->Visible) { // emp_grp ?>
		<td data-name="emp_grp"<?php echo $process_action_payment->emp_grp->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_emp_grp" class="process_action_payment_emp_grp">
<span<?php echo $process_action_payment->emp_grp->viewAttributes() ?>>
<?php echo $process_action_payment->emp_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->code->Visible) { // code ?>
		<td data-name="code"<?php echo $process_action_payment->code->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_code" class="process_action_payment_code">
<span<?php echo $process_action_payment->code->viewAttributes() ?>>
<?php echo $process_action_payment->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $process_action_payment->ref->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_ref" class="process_action_payment_ref">
<span<?php echo $process_action_payment->ref->viewAttributes() ?>>
<?php echo $process_action_payment->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->size_wl->Visible) { // size_wl ?>
		<td data-name="size_wl"<?php echo $process_action_payment->size_wl->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_size_wl" class="process_action_payment_size_wl">
<span<?php echo $process_action_payment->size_wl->viewAttributes() ?>>
<?php echo $process_action_payment->size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->process_40->Visible) { // process_@ ?>
		<td data-name="process_40"<?php echo $process_action_payment->process_40->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_process_40" class="process_action_payment_process_40">
<span<?php echo $process_action_payment->process_40->viewAttributes() ?>>
<?php echo $process_action_payment->process_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount"<?php echo $process_action_payment->final_amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_final_amount" class="process_action_payment_final_amount">
<span<?php echo $process_action_payment->final_amount->viewAttributes() ?>>
<?php echo $process_action_payment->final_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $process_action_payment->amount->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_amount" class="process_action_payment_amount">
<span<?php echo $process_action_payment->amount->viewAttributes() ?>>
<?php echo $process_action_payment->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->c_charge->Visible) { // c_charge ?>
		<td data-name="c_charge"<?php echo $process_action_payment->c_charge->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_c_charge" class="process_action_payment_c_charge">
<span<?php echo $process_action_payment->c_charge->viewAttributes() ?>>
<?php echo $process_action_payment->c_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->custom_size->Visible) { // custom_size ?>
		<td data-name="custom_size"<?php echo $process_action_payment->custom_size->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_custom_size" class="process_action_payment_custom_size">
<span<?php echo $process_action_payment->custom_size->viewAttributes() ?>>
<?php echo $process_action_payment->custom_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->ded_jc->Visible) { // ded_jc ?>
		<td data-name="ded_jc"<?php echo $process_action_payment->ded_jc->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_ded_jc" class="process_action_payment_ded_jc">
<span<?php echo $process_action_payment->ded_jc->viewAttributes() ?>>
<?php echo $process_action_payment->ded_jc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->ded_pa->Visible) { // ded_pa ?>
		<td data-name="ded_pa"<?php echo $process_action_payment->ded_pa->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_ded_pa" class="process_action_payment_ded_pa">
<span<?php echo $process_action_payment->ded_pa->viewAttributes() ?>>
<?php echo $process_action_payment->ded_pa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->c_id->Visible) { // c_id ?>
		<td data-name="c_id"<?php echo $process_action_payment->c_id->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_c_id" class="process_action_payment_c_id">
<span<?php echo $process_action_payment->c_id->viewAttributes() ?>>
<?php echo $process_action_payment->c_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type"<?php echo $process_action_payment->payment_type->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_payment_type" class="process_action_payment_payment_type">
<span<?php echo $process_action_payment->payment_type->viewAttributes() ?>>
<?php echo $process_action_payment->payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $process_action_payment->sqm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_sqm" class="process_action_payment_sqm">
<span<?php echo $process_action_payment->sqm->viewAttributes() ?>>
<?php echo $process_action_payment->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->sqm_grp->Visible) { // sqm_grp ?>
		<td data-name="sqm_grp"<?php echo $process_action_payment->sqm_grp->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp">
<span<?php echo $process_action_payment->sqm_grp->viewAttributes() ?>>
<?php echo $process_action_payment->sqm_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->_2_srm->Visible) { // 2_srm ?>
		<td data-name="_2_srm"<?php echo $process_action_payment->_2_srm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment__2_srm" class="process_action_payment__2_srm">
<span<?php echo $process_action_payment->_2_srm->viewAttributes() ?>>
<?php echo $process_action_payment->_2_srm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->_4_srm->Visible) { // 4_srm ?>
		<td data-name="_4_srm"<?php echo $process_action_payment->_4_srm->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment__4_srm" class="process_action_payment__4_srm">
<span<?php echo $process_action_payment->_4_srm->viewAttributes() ?>>
<?php echo $process_action_payment->_4_srm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->process_fix->Visible) { // process_fix ?>
		<td data-name="process_fix"<?php echo $process_action_payment->process_fix->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_process_fix" class="process_action_payment_process_fix">
<span<?php echo $process_action_payment->process_fix->viewAttributes() ?>>
<?php echo $process_action_payment->process_fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->method->Visible) { // method ?>
		<td data-name="method"<?php echo $process_action_payment->method->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_method" class="process_action_payment_method">
<span<?php echo $process_action_payment->method->viewAttributes() ?>>
<?php echo $process_action_payment->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $process_action_payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_datetime" class="process_action_payment_datetime">
<span<?php echo $process_action_payment->datetime->viewAttributes() ?>>
<?php echo $process_action_payment->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $process_action_payment->payment->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_payment" class="process_action_payment_payment">
<span<?php echo $process_action_payment->payment->viewAttributes() ?>>
<?php echo $process_action_payment->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $process_action_payment->remark->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_remark" class="process_action_payment_remark">
<span<?php echo $process_action_payment->remark->viewAttributes() ?>>
<?php echo $process_action_payment->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->c_method->Visible) { // c_method ?>
		<td data-name="c_method"<?php echo $process_action_payment->c_method->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_c_method" class="process_action_payment_c_method">
<span<?php echo $process_action_payment->c_method->viewAttributes() ?>>
<?php echo $process_action_payment->c_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($process_action_payment->category->Visible) { // category ?>
		<td data-name="category"<?php echo $process_action_payment->category->cellAttributes() ?>>
<span id="el<?php echo $process_action_payment_list->RowCnt ?>_process_action_payment_category" class="process_action_payment_category">
<span<?php echo $process_action_payment->category->viewAttributes() ?>>
<?php echo $process_action_payment->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$process_action_payment_list->ListOptions->render("body", "right", $process_action_payment_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$process_action_payment->isGridAdd())
		$process_action_payment_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$process_action_payment->RowType = ROWTYPE_AGGREGATE;
$process_action_payment->resetAttributes();
$process_action_payment_list->renderRow();
?>
<?php if ($process_action_payment_list->TotalRecs > 0 && !$process_action_payment->isGridAdd() && !$process_action_payment->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$process_action_payment_list->renderListOptions();

// Render list options (footer, left)
$process_action_payment_list->ListOptions->render("footer", "left");
?>
	<?php if ($process_action_payment->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $process_action_payment->id->footerCellClass() ?>"><span id="elf_process_action_payment_id" class="process_action_payment_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $process_action_payment->location->footerCellClass() ?>"><span id="elf_process_action_payment_location" class="process_action_payment_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $process_action_payment->process->footerCellClass() ?>"><span id="elf_process_action_payment_process" class="process_action_payment_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id" class="<?php echo $process_action_payment->emp_id->footerCellClass() ?>"><span id="elf_process_action_payment_emp_id" class="process_action_payment_emp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->emp_grp->Visible) { // emp_grp ?>
		<td data-name="emp_grp" class="<?php echo $process_action_payment->emp_grp->footerCellClass() ?>"><span id="elf_process_action_payment_emp_grp" class="process_action_payment_emp_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->code->Visible) { // code ?>
		<td data-name="code" class="<?php echo $process_action_payment->code->footerCellClass() ?>"><span id="elf_process_action_payment_code" class="process_action_payment_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $process_action_payment->ref->footerCellClass() ?>"><span id="elf_process_action_payment_ref" class="process_action_payment_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->size_wl->Visible) { // size_wl ?>
		<td data-name="size_wl" class="<?php echo $process_action_payment->size_wl->footerCellClass() ?>"><span id="elf_process_action_payment_size_wl" class="process_action_payment_size_wl">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->process_40->Visible) { // process_@ ?>
		<td data-name="process_40" class="<?php echo $process_action_payment->process_40->footerCellClass() ?>"><span id="elf_process_action_payment_process_40" class="process_action_payment_process_40">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount" class="<?php echo $process_action_payment->final_amount->footerCellClass() ?>"><span id="elf_process_action_payment_final_amount" class="process_action_payment_final_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $process_action_payment->final_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $process_action_payment->amount->footerCellClass() ?>"><span id="elf_process_action_payment_amount" class="process_action_payment_amount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->c_charge->Visible) { // c_charge ?>
		<td data-name="c_charge" class="<?php echo $process_action_payment->c_charge->footerCellClass() ?>"><span id="elf_process_action_payment_c_charge" class="process_action_payment_c_charge">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->custom_size->Visible) { // custom_size ?>
		<td data-name="custom_size" class="<?php echo $process_action_payment->custom_size->footerCellClass() ?>"><span id="elf_process_action_payment_custom_size" class="process_action_payment_custom_size">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->ded_jc->Visible) { // ded_jc ?>
		<td data-name="ded_jc" class="<?php echo $process_action_payment->ded_jc->footerCellClass() ?>"><span id="elf_process_action_payment_ded_jc" class="process_action_payment_ded_jc">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->ded_pa->Visible) { // ded_pa ?>
		<td data-name="ded_pa" class="<?php echo $process_action_payment->ded_pa->footerCellClass() ?>"><span id="elf_process_action_payment_ded_pa" class="process_action_payment_ded_pa">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->c_id->Visible) { // c_id ?>
		<td data-name="c_id" class="<?php echo $process_action_payment->c_id->footerCellClass() ?>"><span id="elf_process_action_payment_c_id" class="process_action_payment_c_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type" class="<?php echo $process_action_payment->payment_type->footerCellClass() ?>"><span id="elf_process_action_payment_payment_type" class="process_action_payment_payment_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $process_action_payment->sqm->footerCellClass() ?>"><span id="elf_process_action_payment_sqm" class="process_action_payment_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->sqm_grp->Visible) { // sqm_grp ?>
		<td data-name="sqm_grp" class="<?php echo $process_action_payment->sqm_grp->footerCellClass() ?>"><span id="elf_process_action_payment_sqm_grp" class="process_action_payment_sqm_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->_2_srm->Visible) { // 2_srm ?>
		<td data-name="_2_srm" class="<?php echo $process_action_payment->_2_srm->footerCellClass() ?>"><span id="elf_process_action_payment__2_srm" class="process_action_payment__2_srm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->_4_srm->Visible) { // 4_srm ?>
		<td data-name="_4_srm" class="<?php echo $process_action_payment->_4_srm->footerCellClass() ?>"><span id="elf_process_action_payment__4_srm" class="process_action_payment__4_srm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->process_fix->Visible) { // process_fix ?>
		<td data-name="process_fix" class="<?php echo $process_action_payment->process_fix->footerCellClass() ?>"><span id="elf_process_action_payment_process_fix" class="process_action_payment_process_fix">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $process_action_payment->method->footerCellClass() ?>"><span id="elf_process_action_payment_method" class="process_action_payment_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $process_action_payment->datetime->footerCellClass() ?>"><span id="elf_process_action_payment_datetime" class="process_action_payment_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->payment->Visible) { // payment ?>
		<td data-name="payment" class="<?php echo $process_action_payment->payment->footerCellClass() ?>"><span id="elf_process_action_payment_payment" class="process_action_payment_payment">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->remark->Visible) { // remark ?>
		<td data-name="remark" class="<?php echo $process_action_payment->remark->footerCellClass() ?>"><span id="elf_process_action_payment_remark" class="process_action_payment_remark">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->c_method->Visible) { // c_method ?>
		<td data-name="c_method" class="<?php echo $process_action_payment->c_method->footerCellClass() ?>"><span id="elf_process_action_payment_c_method" class="process_action_payment_c_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($process_action_payment->category->Visible) { // category ?>
		<td data-name="category" class="<?php echo $process_action_payment->category->footerCellClass() ?>"><span id="elf_process_action_payment_category" class="process_action_payment_category">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$process_action_payment_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$process_action_payment->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($process_action_payment_list->Recordset)
	$process_action_payment_list->Recordset->Close();
?>
<?php if (!$process_action_payment->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$process_action_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($process_action_payment_list->Pager)) $process_action_payment_list->Pager = new PrevNextPager($process_action_payment_list->StartRec, $process_action_payment_list->DisplayRecs, $process_action_payment_list->TotalRecs, $process_action_payment_list->AutoHidePager) ?>
<?php if ($process_action_payment_list->Pager->RecordCount > 0 && $process_action_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($process_action_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($process_action_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $process_action_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($process_action_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($process_action_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $process_action_payment_list->pageUrl() ?>start=<?php echo $process_action_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $process_action_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($process_action_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $process_action_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $process_action_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $process_action_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($process_action_payment_list->TotalRecs > 0 && (!$process_action_payment_list->AutoHidePageSizeSelector || $process_action_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="process_action_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($process_action_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($process_action_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($process_action_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($process_action_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($process_action_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($process_action_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $process_action_payment_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($process_action_payment_list->TotalRecs == 0 && !$process_action_payment->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $process_action_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$process_action_payment_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$process_action_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$process_action_payment->isExport()) { ?>
<script>
ew.scrollableTable("gmp_process_action_payment", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$process_action_payment_list->terminate();
?>